package org.bidib.wizard.mvc.common.view.text;

import java.awt.event.ActionEvent;

import javax.swing.text.JTextComponent;
import javax.swing.text.TextAction;

public class CopyAllAction extends TextAction {

    private static final long serialVersionUID = 1L;

    public static final String copyAllAction = "copy-all-to-clipboard";

    /** Create this object with the appropriate identifier. */
    public CopyAllAction() {
        super(copyAllAction);
    }

    /**
     * The operation to perform when this action is triggered.
     *
     * @param e
     *            the action event
     */
    @Override
    public void actionPerformed(ActionEvent e) {
        JTextComponent target = getTextComponent(e);
        if (target != null) {

            target.selectAll();
            target.copy();
        }
    }
}
