package org.bidib.wizard.mvc.main.view.table;

import java.text.DecimalFormat;

import javax.swing.JTable;
import javax.swing.table.TableModel;

import org.bidib.wizard.client.common.view.slider.SliderRenderer;
import org.bidib.wizard.model.ports.ServoPort;
import org.bidib.wizard.client.common.model.ServoPortTableModel;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import com.jidesoft.grid.SortableTableModel;

@Deprecated
public class ServoSliderRenderer extends SliderRenderer {

    private static final Logger LOGGER = LoggerFactory.getLogger(ServoSliderRenderer.class);

    private final DecimalFormat format = new DecimalFormat("##0");

    public ServoSliderRenderer(int min, int max, int value) {
        super(min, max, value);
    }

    @Override
    protected void updateSliderTextValue(JTable table, int value, boolean isSelected, int row, int column) {
        LOGGER.trace("updateSliderTextValue, value: {}, isSelected: {}", value, isSelected);

        String newValue = format.format(value);
        LOGGER.trace("Set the new value: {}", newValue);

        Integer targetAbsolute = null;
        if (table != null) {

            final TableModel tableModel = table.getModel();
            if (tableModel instanceof SortableTableModel) {
                SortableTableModel stm = (SortableTableModel) tableModel;
                final ServoPortTableModel servoTableModel = (ServoPortTableModel) stm.getActualModel();

                // final ServoPortTableModel tableModel = (ServoPortTableModel) table.getModel();
                final ServoPort port =
                    (ServoPort) servoTableModel.getValueAt(row, ServoPortTableModel.COLUMN_PORT_INSTANCE);

                int range = port.getTrimUp() - port.getTrimDown();
                float factor = (float) range / 100;
                float targetValue = (factor * value) + port.getTrimDown();
                LOGGER.trace("Calculated range: {}, factor: {}, targetValue: {}", range, factor, targetValue);
                targetAbsolute = Integer.valueOf(Math.round(targetValue));
            }
        }

        StringBuilder sb = new StringBuilder("<html>");
        sb.append(newValue).append("% ");
        if (targetAbsolute != null) {
            sb.append("<FONT COLOR=");
            if (isSelected) {
                sb.append("WHITE");
            }
            else {
                sb.append("GRAY");
            }
            sb.append(">(").append(targetAbsolute.intValue()).append(")</FONT>");
        }
        sb.append("</html>");

        sliderValue.setText(sb.toString());
    }

}
