package org.bidib.wizard.mvc.preferences.model;

import java.time.DayOfWeek;
import java.util.LinkedHashSet;
import java.util.Set;

import org.apache.commons.lang3.SystemUtils;
import org.bidib.jbidibc.netbidib.pairingstore.PairingStore;
import org.bidib.wizard.api.model.common.CommPort;
import org.bidib.wizard.api.model.common.NetBidibServiceInfo;
import org.bidib.wizard.common.model.settings.ExperimentalSettingsInterface;
import org.bidib.wizard.common.model.settings.GlobalSettingsInterface;
import org.bidib.wizard.common.model.settings.Misc2SettingsInterface;
import org.bidib.wizard.common.model.settings.MiscSettingsInterface;
import org.bidib.wizard.common.model.settings.NetBidibSettingsInterface;
import org.bidib.wizard.common.model.settings.WizardSettingsInterface;

import com.jgoodies.binding.beans.Model;
import com.jgoodies.common.collect.ArrayListModel;

public class PreferencesModel extends Model {
    private static final long serialVersionUID = 1L;

    public static final String PROPERTY_COMM_PORTS = "commPorts";

    public static final String PROPERTY_DETECTED_NETBIDIB_SERVICES = "detectedNetBidibServices";

    private final Set<CommPort> commPorts = new LinkedHashSet<CommPort>();

    private ArrayListModel<String> serialProviderList = new ArrayListModel<>();

    private ArrayListModel<DayOfWeek> dayOfWeekList = new ArrayListModel<>();

    private ArrayListModel<String> languageList = new ArrayListModel<>();

    private final Set<NetBidibServiceInfo> detectedNetBidibServices = new LinkedHashSet<>();

    private final GlobalSettingsInterface globalSettings;

    private final WizardSettingsInterface wizardSettings;

    private final MiscSettingsInterface miscSettings;

    private final Misc2SettingsInterface misc2Settings;

    private final ExperimentalSettingsInterface experimentalSettings;

    private final NetBidibSettingsInterface netBidibSettings;

    private final PairingStore pairingStore;

    public PreferencesModel(final GlobalSettingsInterface globalSettings, final WizardSettingsInterface wizardSettings,
        final MiscSettingsInterface miscSettings, final Misc2SettingsInterface misc2Settings,
        final ExperimentalSettingsInterface experimentalSettings, final NetBidibSettingsInterface netBidibSettings,
        final PairingStore pairingStore) {
        serialProviderList.add("RXTX");
        serialProviderList.add("SCM");
        serialProviderList.add("SPSW");
        serialProviderList.add("JSerialComm");
        serialProviderList.add("PureJavaComm");

        // FTDI is currently only supported on Windows
        if (SystemUtils.IS_OS_WINDOWS || SystemUtils.IS_OS_LINUX || SystemUtils.IS_OS_MAC_OSX) {
            serialProviderList.add("FTDI");
        }

        // TODO add days of week
        dayOfWeekList.add(DayOfWeek.SUNDAY);
        dayOfWeekList.add(DayOfWeek.MONDAY);
        dayOfWeekList.add(DayOfWeek.TUESDAY);
        dayOfWeekList.add(DayOfWeek.WEDNESDAY);
        dayOfWeekList.add(DayOfWeek.THURSDAY);
        dayOfWeekList.add(DayOfWeek.FRIDAY);
        dayOfWeekList.add(DayOfWeek.SATURDAY);

        languageList.add("de");
        languageList.add("en");
        languageList.add("nl");

        this.globalSettings = globalSettings;
        this.wizardSettings = wizardSettings;
        this.miscSettings = miscSettings;
        this.misc2Settings = misc2Settings;
        this.experimentalSettings = experimentalSettings;
        this.netBidibSettings = netBidibSettings;
        this.pairingStore = pairingStore;
    }

    public Set<CommPort> getAvailableCommPorts() {
        return commPorts;
    }

    /**
     * Set the commPorts and notify the listeners
     * 
     * @param commPorts
     *            the commPorts to set
     */
    public void setAvailableCommPorts(final Set<CommPort> commPorts) {
        final Set<CommPort> oldValue = new LinkedHashSet<>();
        oldValue.addAll(this.commPorts);

        this.commPorts.clear();
        this.commPorts.addAll(commPorts);

        firePropertyChange(PROPERTY_COMM_PORTS, oldValue, this.commPorts);
    }

    public void setDetectedNetBidibServices(final Set<NetBidibServiceInfo> detectedNetBidibServices) {

        final Set<NetBidibServiceInfo> oldValue = new LinkedHashSet<>();
        oldValue.addAll(this.detectedNetBidibServices);

        this.detectedNetBidibServices.clear();
        this.detectedNetBidibServices.addAll(detectedNetBidibServices);

        firePropertyChange(PROPERTY_DETECTED_NETBIDIB_SERVICES, oldValue, this.detectedNetBidibServices);
    }

    public Set<NetBidibServiceInfo> getDetectedNetBidibServices() {
        return this.detectedNetBidibServices;
    }

    /**
     * @return the serial provider list
     */
    public ArrayListModel<String> getSerialProviderList() {
        return serialProviderList;
    }

    /**
     * @return the day of week list
     */
    public ArrayListModel<DayOfWeek> getDayOfWeekList() {
        return dayOfWeekList;
    }

    public ArrayListModel<String> getLanguageList() {
        return languageList;
    }

    /**
     * @return the globalSettings
     */
    public GlobalSettingsInterface getGlobalSettings() {
        return globalSettings;
    }

    /**
     * @return the wizardSettings
     */
    public WizardSettingsInterface getWizardSettings() {
        return wizardSettings;
    }

    /**
     * @return the miscSettings
     */
    public MiscSettingsInterface getMiscSettings() {
        return miscSettings;
    }

    /**
     * @return the misc2Settings
     */
    public Misc2SettingsInterface getMisc2Settings() {
        return misc2Settings;
    }

    /**
     * @return the experimentalSettings
     */
    public ExperimentalSettingsInterface getExperimentalSettings() {
        return experimentalSettings;
    }

    /**
     * @return the netBidibSettings
     */
    public NetBidibSettingsInterface getNetBidibSettings() {
        return netBidibSettings;
    }

    /**
     * @return the pairingStore
     */
    public PairingStore getPairingStore() {
        return pairingStore;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder("PreferencesModel, commPorts: ").append(commPorts);
        return sb.toString();
    }
}
