/*
 * Decompiled with CFR 0.152.
 */
package org.bidib.wizard.mvc.features.controller;

import java.awt.Component;
import java.util.Collection;
import java.util.HashSet;
import javax.swing.JFrame;
import org.bidib.jbidibc.messages.Feature;
import org.bidib.wizard.api.model.NodeInterface;
import org.bidib.wizard.client.common.view.WindowUtils;
import org.bidib.wizard.common.model.settings.WizardSettingsInterface;
import org.bidib.wizard.mvc.features.controller.listener.FeaturesControllerListener;
import org.bidib.wizard.mvc.features.model.FeaturesModel;
import org.bidib.wizard.mvc.features.view.FeaturesView;
import org.bidib.wizard.mvc.features.view.listener.FeaturesViewListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FeaturesController {
    private static final Logger LOGGER = LoggerFactory.getLogger(FeaturesController.class);
    private final Collection<FeaturesControllerListener> listeners = new HashSet();
    private final JFrame parent;
    private final NodeInterface node;
    private final WizardSettingsInterface wizardSettings;
    private final FeaturesModel model;
    private FeaturesView view;

    public FeaturesController(JFrame parent, NodeInterface node, WizardSettingsInterface wizardSettings) {
        this.parent = parent;
        this.node = node;
        this.wizardSettings = wizardSettings;
        this.model = new FeaturesModel(node);
    }

    public void addFeaturesControllerListener(FeaturesControllerListener listener) {
        this.listeners.add(listener);
    }

    private void fireClose() {
        for (FeaturesControllerListener listener : this.listeners) {
            listener.close();
        }
    }

    private void fireReadAll() {
        LOGGER.debug("Read all features.");
        for (FeaturesControllerListener listener : this.listeners) {
            listener.readAll(this.node);
        }
    }

    private void fireWrite(Feature feature) {
        LOGGER.debug("Write feature to node, feature: {}", (Object)feature);
        for (FeaturesControllerListener listener : this.listeners) {
            listener.write(this.node, feature);
        }
    }

    public void start() {
        this.view = new FeaturesView(this.parent, this.model, this.wizardSettings);
        this.view.addFeaturesViewListener((FeaturesViewListener)new /* Unavailable Anonymous Inner Class!! */);
        this.fireReadAll();
        WindowUtils.centerOnCurrentScreen((Component)this.parent, (Component)this.view);
        this.view.setVisible(true);
    }

    public void setFeatures(Collection<Feature> features) {
        LOGGER.info("Set the features in the model.");
        this.model.setFeatures(features);
    }
}

