/*
 * Decompiled with CFR 0.152.
 */
package org.bidib.wizard.mvc.loco.model.command;

import io.reactivex.rxjava3.core.SingleObserver;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeListener;
import java.util.List;
import javax.swing.Timer;
import org.bidib.jbidibc.messages.PomAddressData;
import org.bidib.jbidibc.messages.enums.PomOperation;
import org.bidib.jbidibc.messages.enums.PomProgState;
import org.bidib.wizard.common.service.SettingsService;
import org.bidib.wizard.model.loco.LocoModel;
import org.bidib.wizard.mvc.loco.model.SpeedometerProgBeanModel;
import org.bidib.wizard.mvc.loco.model.command.PomRequestProcessor;
import org.bidib.wizard.mvc.loco.view.PomProgrammerRequestListener;
import org.bidib.wizard.mvc.loco.view.command.PomProgResultListener;
import org.bidib.wizard.mvc.pom.model.PomProgrammerModel;
import org.bidib.wizard.mvc.pom.model.ProgCommandAwareBeanModel;
import org.bidib.wizard.mvc.pom.model.command.PomOperationCommand;
import org.bidib.wizard.mvc.pom.model.listener.ProgCommandListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PomRequestProcessor<M extends ProgCommandAwareBeanModel> {
    private static final Logger LOGGER = LoggerFactory.getLogger(PomRequestProcessor.class);
    public static final int DEFAULT_TIMEOUT = 1000;
    private int timeout = 1000;
    private final SpeedometerProgBeanModel speedoProgBeanModel;
    private final PomProgrammerModel cvProgrammerModel;
    private final PomProgrammerRequestListener pomProgrammerRequestListener;
    private final PomProgResultListener pomProgResultListener;
    private Timer readTimeout;
    private Object readTimeoutLock = new Object();
    private final SettingsService settingsService;

    public PomRequestProcessor(SpeedometerProgBeanModel speedoProgBeanModel, LocoModel locoModel, PomProgrammerModel cvProgrammerModel, PomProgrammerRequestListener pomProgrammerRequestListener, PomProgResultListener pomProgResultListener, SettingsService settingsService) {
        this.speedoProgBeanModel = speedoProgBeanModel;
        this.cvProgrammerModel = cvProgrammerModel;
        this.pomProgrammerRequestListener = pomProgrammerRequestListener;
        this.pomProgResultListener = pomProgResultListener;
        this.settingsService = settingsService;
    }

    public void submitProgCommands(List<PomOperationCommand<? extends ProgCommandAwareBeanModel>> pomProgCommands, SingleObserver<String> finishAction) {
        LOGGER.info("Submit the new commands for execution: {}", pomProgCommands);
        List progCommands = this.speedoProgBeanModel.getProgCommands();
        progCommands.clear();
        progCommands.addAll(pomProgCommands);
        LOGGER.info("Set the finish action in the speedoProgBeanModel: {}", finishAction);
        this.speedoProgBeanModel.setFinishAction(finishAction);
        this.speedoProgBeanModel.getExecutedProgCommands().clear();
        this.timeout = this.settingsService.getExperimentalSettings().getSpeedometerTimeout();
        LOGGER.info("Current value of speedometer timeout: {}", (Object)this.timeout);
        this.startTimeoutControl(this.timeout);
        this.fireNextCommand();
    }

    protected void sendRequest(PomAddressData decoderAddress, PomOperation operation, int cvNumber, int cvValue) {
        LOGGER.info("Send the POM request, cvNumber: {}, cvValue: {}", (Object)cvNumber, (Object)cvValue);
        this.cvProgrammerModel.setCvNumber(Integer.valueOf(cvNumber));
        this.cvProgrammerModel.setCvValue(null);
        this.cvProgrammerModel.setPomProgState(PomProgState.POM_PROG_START);
        this.pomProgrammerRequestListener.sendRequest(decoderAddress, operation, cvNumber, cvValue);
    }

    protected void fireNextCommand() {
        this.pomProgResultListener.disableInputElements();
        List progCommands = this.speedoProgBeanModel.getProgCommands();
        LOGGER.info("Prepared commands for addressing the decoder: {}", (Object)progCommands);
        PomOperationCommand progCommand = (PomOperationCommand)progCommands.remove(0);
        this.speedoProgBeanModel.setCurrentOperation(progCommand.getPomOperation());
        LOGGER.info("Updated current operation: {}", (Object)this.speedoProgBeanModel.getCurrentOperation());
        switch (4.$SwitchMap$org$bidib$jbidibc$messages$enums$PomOperation[progCommand.getPomOperation().ordinal()]) {
            case 1: 
            case 2: {
                this.speedoProgBeanModel.setExecution(ProgCommandAwareBeanModel.ExecutionType.WRITE);
                break;
            }
            default: {
                this.speedoProgBeanModel.setExecution(ProgCommandAwareBeanModel.ExecutionType.READ);
            }
        }
        this.speedoProgBeanModel.setExecutingProgCommand(progCommand);
        this.publishLogText("Prog write request: {}", new Object[]{progCommand});
        this.sendRequest(progCommand.getDecoderAddress(), progCommand.getPomOperation(), progCommand.getCvNumber(), progCommand.getCvValue());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void startTimeoutControl(int timeout) {
        LOGGER.info("Timeout control is started, timeout: {}.", (Object)timeout);
        Object object = this.readTimeoutLock;
        synchronized (object) {
            if (this.readTimeout != null) {
                LOGGER.info("The timeout control is already assigned: {}", (Object)this.readTimeout);
                if (this.readTimeout.isRunning()) {
                    LOGGER.info("The timeout control is already running and will be stopped.");
                    this.readTimeout.stop();
                }
                this.readTimeout = null;
            }
            this.readTimeout = new Timer(timeout, (ActionListener)new /* Unavailable Anonymous Inner Class!! */);
            this.readTimeout.setRepeats(false);
            this.readTimeout.start();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void stopTimeoutControl() {
        LOGGER.info("Timeout control is stopped.");
        Object object = this.readTimeoutLock;
        synchronized (object) {
            if (this.readTimeout != null) {
                LOGGER.info("The timeout control is assigned and will be stopped: {}", (Object)this.readTimeout);
                this.readTimeout.stop();
                this.readTimeout = null;
            }
        }
    }

    private void publishLogText(String logLine, Object ... args) {
        this.pomProgResultListener.addLogText(logLine, args);
    }

    public void addPomProgrammerModelListeners() {
        LOGGER.info("Add the pom programmer model listeners.");
        this.cvProgrammerModel.addProgCommandListener((ProgCommandListener)new /* Unavailable Anonymous Inner Class!! */);
        this.cvProgrammerModel.addPropertyChangeListener("cvValue", (PropertyChangeListener)new /* Unavailable Anonymous Inner Class!! */);
    }
}

