/*
 * Decompiled with CFR 0.152.
 */
package org.bidib.wizard.mvc.main.view.panel;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.LayoutManager;
import java.awt.event.ActionListener;
import java.awt.event.ItemListener;
import java.util.Calendar;
import javax.swing.BorderFactory;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JPanel;
import javax.swing.JSpinner;
import javax.swing.SpinnerDateModel;
import javax.swing.event.ChangeListener;
import org.bidib.wizard.api.locale.Resources;
import org.bidib.wizard.api.model.Macro;
import org.bidib.wizard.api.model.MacroRepeatDay;
import org.bidib.wizard.api.model.MacroRepeatTime;
import org.bidib.wizard.api.model.StartCondition;
import org.bidib.wizard.api.model.TimeStartCondition;
import org.bidib.wizard.api.model.function.Function;
import org.bidib.wizard.api.model.listener.MacroListener;
import org.bidib.wizard.model.status.BidibStatus;
import org.bidib.wizard.mvc.common.view.panel.DisabledPanel;
import org.bidib.wizard.mvc.main.model.MainModel;
import org.bidib.wizard.mvc.main.model.listener.MacroSelectionListener;
import org.bidib.wizard.mvc.main.view.panel.MacroParameterPanel;
import org.bidib.wizard.mvc.main.view.panel.SliderPanel;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MacroParameterPanel
extends JPanel
implements MacroListener {
    private static final long serialVersionUID = 1L;
    private static final Logger LOGGER = LoggerFactory.getLogger(MacroParameterPanel.class);
    private final JSpinner timeSpinner = new JSpinner(new SpinnerDateModel());
    private final DisabledPanel disabledRepeatPanel;
    private boolean silentUpdate;
    private Macro macro;
    private final SliderPanel cyclesPanel;
    private final SliderPanel slowdownPanel;
    private final JCheckBox timeButton;
    private final JComboBox<MacroRepeatTime> repeatTime;
    private final JComboBox<MacroRepeatDay> repeatDay;

    public MacroParameterPanel(MainModel model) {
        this.setLayout((LayoutManager)new GridBagLayout());
        JPanel repeatPanel = new JPanel(new GridLayout(2, 1));
        this.repeatTime = new JComboBox();
        this.repeatTime.setRenderer(new MacroRepeatTimeRenderer());
        this.repeatTime.setModel(new DefaultComboBoxModel<MacroRepeatTime>(MacroRepeatTime.values()));
        this.repeatDay = new JComboBox();
        this.repeatDay.setRenderer(new MacroRepeatDayRenderer());
        this.repeatDay.setModel(new DefaultComboBoxModel<MacroRepeatDay>(MacroRepeatDay.values()));
        this.timeSpinner.addChangeListener((ChangeListener)new /* Unavailable Anonymous Inner Class!! */);
        this.timeButton = new JCheckBox(Resources.getString(this.getClass(), (String)"time") + ":");
        this.timeButton.addItemListener((ItemListener)new /* Unavailable Anonymous Inner Class!! */);
        JPanel startConditionPanel = new JPanel(new BorderLayout());
        startConditionPanel.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), Resources.getString(this.getClass(), (String)"condition") + ":"));
        FlowLayout leftLayout = new FlowLayout();
        leftLayout.setAlignment(0);
        this.timeSpinner.setEditor(new JSpinner.DateEditor(this.timeSpinner, "HH:mm"));
        JPanel timePanel = new JPanel(leftLayout);
        timePanel.add(this.timeButton);
        timePanel.add(this.timeSpinner);
        startConditionPanel.add((Component)timePanel, "North");
        this.repeatTime.addActionListener((ActionListener)new /* Unavailable Anonymous Inner Class!! */);
        repeatPanel.add(this.repeatTime);
        this.repeatDay.addActionListener((ActionListener)new /* Unavailable Anonymous Inner Class!! */);
        repeatPanel.add(this.repeatDay);
        repeatPanel.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), Resources.getString(this.getClass(), (String)"repetition") + ":"));
        this.disabledRepeatPanel = new DisabledPanel((Container)repeatPanel);
        startConditionPanel.add((Component)this.disabledRepeatPanel, "Center");
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 0;
        this.add((Component)startConditionPanel, (Object)gbc);
        this.slowdownPanel = new /* Unavailable Anonymous Inner Class!! */;
        ++gbc.gridx;
        gbc.weightx = 1.0;
        gbc.fill = 1;
        this.add((Component)this.slowdownPanel, (Object)gbc);
        this.cyclesPanel = new /* Unavailable Anonymous Inner Class!! */;
        ++gbc.gridx;
        gbc.weightx = 1.0;
        gbc.fill = 1;
        this.add((Component)this.cyclesPanel, (Object)gbc);
        model.addMacroSelectionListener((MacroSelectionListener)new /* Unavailable Anonymous Inner Class!! */);
    }

    private void processMacroChanged(MainModel model) {
        Macro macro = model.getSelectedMacro();
        LOGGER.info("The selected macro has changed: {}", (Object)macro);
        if (this.macro != null) {
            this.macro.removeMacroListener((MacroListener)this);
        }
        this.macro = macro;
        if (macro != null) {
            this.macro.addMacroListener((MacroListener)this);
        }
        this.setValueSilently();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setValueSilently() {
        this.silentUpdate = true;
        try {
            if (this.macro != null) {
                this.slowdownPanel.setValueSilently(this.macro.getSpeed());
                int cycles = this.macro.getCycles();
                if (cycles == 0) {
                    cycles = 251;
                }
                this.cyclesPanel.setValueSilently(cycles);
                boolean hasTimeCondition = false;
                for (StartCondition startCondition : this.macro.getStartConditions()) {
                    if (!(startCondition instanceof TimeStartCondition)) continue;
                    hasTimeCondition = true;
                    Calendar time = ((TimeStartCondition)startCondition).getTime();
                    if (time != null) {
                        this.timeSpinner.setValue(time.getTime());
                    }
                    this.repeatDay.setSelectedIndex(((TimeStartCondition)startCondition).getRepeatDay().ordinal());
                    this.repeatTime.setSelectedIndex(((TimeStartCondition)startCondition).getRepeatTime().ordinal());
                }
                this.timeButton.setSelected(hasTimeCondition);
                this.timeSpinner.setEnabled(hasTimeCondition);
                this.disabledRepeatPanel.setEnabled(hasTimeCondition);
            }
        }
        finally {
            this.silentUpdate = false;
        }
    }

    public void functionsAdded(int macroId, int row, Function<? extends BidibStatus>[] functions) {
    }

    public void functionRemoved(int macroId, int row) {
    }

    public void functionMoved(int macroId, int fromIndex, int toIndex, Function<? extends BidibStatus> fromFunction) {
    }

    public void functionsRemoved(int macroId) {
    }

    public void labelChanged(String label) {
    }

    public void startConditionChanged() {
        LOGGER.debug("The start condition has changed.");
        this.setValueSilently();
    }

    public void slowdownFactorChanged() {
        LOGGER.debug("The slowdown factor has changed.");
        this.setValueSilently();
    }

    public void cyclesChanged() {
        LOGGER.debug("The cycles have changed.");
        this.setValueSilently();
    }
}

