/*
 * Decompiled with CFR 0.152.
 */
package org.bidib.wizard.mvc.worklist.controller.actions;

import com.vlsolutions.swing.docking.DockingDesktop;
import java.awt.Window;
import java.util.Collection;
import javax.swing.JOptionPane;
import org.apache.commons.collections4.CollectionUtils;
import org.bidib.jbidibc.core.schema.bidibbase.DefaultLabelsActionType;
import org.bidib.jbidibc.core.schema.bidiblabels.AccessoryLabel;
import org.bidib.jbidibc.core.schema.bidiblabels.NodeLabels;
import org.bidib.jbidibc.core.schema.exception.InvalidContentException;
import org.bidib.jbidibc.core.schema.exception.InvalidSchemaException;
import org.bidib.jbidibc.messages.Node;
import org.bidib.jbidibc.messages.enums.PortModelEnum;
import org.bidib.jbidibc.messages.exception.UnexpectedCharacterException;
import org.bidib.jbidibc.messages.utils.ByteUtils;
import org.bidib.wizard.api.event.DefaultLabelsWorkListItemEvent;
import org.bidib.wizard.api.locale.Resources;
import org.bidib.wizard.api.model.Accessory;
import org.bidib.wizard.api.model.NodeInterface;
import org.bidib.wizard.api.model.NodeProvider;
import org.bidib.wizard.api.service.console.ConsoleColor;
import org.bidib.wizard.api.service.console.ConsoleService;
import org.bidib.wizard.api.utils.XmlLocaleUtils;
import org.bidib.wizard.client.common.view.BidibNodeNameUtils;
import org.bidib.wizard.common.exception.ConnectionException;
import org.bidib.wizard.common.labels.AccessoryLabelUtils;
import org.bidib.wizard.common.labels.BidibLabelUtils;
import org.bidib.wizard.common.labels.LabelsChangedEvent;
import org.bidib.wizard.common.labels.WizardLabelWrapper;
import org.bidib.wizard.core.service.ConnectionService;
import org.bidib.wizard.mvc.console.controller.ConsoleController;
import org.bidib.wizard.mvc.worklist.controller.ActionAbortedException;
import org.bidib.wizard.mvc.worklist.controller.actions.WorkListAction;
import org.bidib.wizard.utils.NodeUtils;
import org.bushe.swing.event.EventBus;
import org.oxbow.swingbits.dialog.task.TaskDialogs;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.ApplicationEventPublisher;

public class ApplyDefaultLabelsAction
implements WorkListAction<DefaultLabelsWorkListItemEvent> {
    private static final Logger LOGGER = LoggerFactory.getLogger(ApplyDefaultLabelsAction.class);
    private final ConnectionService connectionService;
    private final WizardLabelWrapper wizardLabelWrapper;
    private final ApplicationEventPublisher applicationEventPublisher;
    private final ConsoleService consoleService;

    public ApplyDefaultLabelsAction(ConnectionService connectionService, WizardLabelWrapper wizardLabelWrapper, ApplicationEventPublisher applicationEventPublisher, ConsoleService consoleService) {
        this.connectionService = connectionService;
        this.wizardLabelWrapper = wizardLabelWrapper;
        this.applicationEventPublisher = applicationEventPublisher;
        this.consoleService = consoleService;
    }

    public void apply(DockingDesktop desktop, DefaultLabelsWorkListItemEvent event) throws ActionAbortedException {
        Long uniqueId = event.getUniqueId();
        String connectionId = event.getConnectionId();
        LOGGER.info("Apply the default labels for node with uniqueId: {}, connectionId: {}", (Object)ByteUtils.getUniqueIdAsString((Long)uniqueId), (Object)connectionId);
        try {
            NodeProvider nodeProvider = this.connectionService.find(connectionId).getNodeProvider();
            NodeLabels nodeLabels = this.wizardLabelWrapper.loadLabels(uniqueId);
            this.askApplyDefaultLabels(desktop, nodeProvider, uniqueId, nodeLabels);
        }
        catch (ConnectionException ex) {
            LOGGER.warn("No connection available.");
            TaskDialogs.error((Window)JOptionPane.getFrameForComponent(desktop.getRootPane()), (String)Resources.getString(ApplyDefaultLabelsAction.class, (String)"error-connection-not-available"), (String)Resources.getString(ApplyDefaultLabelsAction.class, (String)"action-not-performed"));
            throw new ActionAbortedException("The connection for the referenced node is not available: " + connectionId);
        }
        catch (UnexpectedCharacterException ex) {
            LOGGER.warn("Apply default labels failed.", (Throwable)ex);
            TaskDialogs.build((Window)JOptionPane.getFrameForComponent(desktop.getRootPane()), (String)Resources.getString(ApplyDefaultLabelsAction.class, (String)"load_from_file_failed.instruction"), (String)Resources.getString(ApplyDefaultLabelsAction.class, (String)"load_from_file_failed.text", (Object[])new Object[]{ex.getMessage()})).title(Resources.getString(ApplyDefaultLabelsAction.class, (String)"load_from_file_failed.title")).showException((Throwable)ex);
            throw new ActionAbortedException("Apply default labels failed.");
        }
        catch (InvalidContentException | InvalidSchemaException ex) {
            LOGGER.warn("Apply default labels failed.", ex);
            TaskDialogs.build((Window)JOptionPane.getFrameForComponent(desktop.getRootPane()), (String)Resources.getString(ApplyDefaultLabelsAction.class, (String)"load_from_file_failed.instruction"), (String)Resources.getString(ApplyDefaultLabelsAction.class, (String)"load_from_file_failed.text", (Object[])new Object[]{ex.getMessage()})).title(Resources.getString(ApplyDefaultLabelsAction.class, (String)"load_from_file_failed.title")).showException(ex);
            throw new ActionAbortedException("Apply default labels failed.");
        }
    }

    private void askApplyDefaultLabels(DockingDesktop desktop, NodeProvider nodeProvider, Long uniqueId, NodeLabels nodeLabels) throws ActionAbortedException {
        NodeInterface node = NodeUtils.findNodeByUuid((Iterable)nodeProvider.getNodes(), (long)uniqueId);
        if (node == null) {
            LOGGER.warn("The referenced node is not available.");
            TaskDialogs.error((Window)JOptionPane.getFrameForComponent(desktop.getRootPane()), (String)Resources.getString(ApplyDefaultLabelsAction.class, (String)"error-node-not-available"), (String)Resources.getString(ApplyDefaultLabelsAction.class, (String)"action-not-performed"));
            throw new ActionAbortedException("The referenced node is not available: " + ByteUtils.getUniqueIdAsString((Long)uniqueId));
        }
        int relevantPidBits = node.getNode().getRelevantPidBits();
        BidibNodeNameUtils.NodeLabelData labelData = BidibNodeNameUtils.prepareLabel((NodeInterface)node, (NodeLabels)nodeLabels, (boolean)true, (boolean)false);
        StringBuilder sb = new StringBuilder(Resources.getString(ApplyDefaultLabelsAction.class, (String)"apply-default-labels.text"));
        sb.append(" ").append(labelData.getNodeLabel());
        int result = JOptionPane.showConfirmDialog(JOptionPane.getFrameForComponent(desktop.getRootPane()), sb.toString(), Resources.getString(ApplyDefaultLabelsAction.class, (String)"apply-default-labels.title"), 1);
        String lang = XmlLocaleUtils.getXmlLocaleVendorCV();
        PortModelEnum portModel = PortModelEnum.getPortModel((Node)node.getNode());
        if (result == 0) {
            LOGGER.info("Apply the default labels on node: {}", (Object)node);
            this.wizardLabelWrapper.setDefaultLabelsApplied(lang, uniqueId, relevantPidBits, portModel, DefaultLabelsActionType.APPLIED);
            try {
                this.reloadLabels(node);
            }
            catch (Exception ex) {
                LOGGER.warn("Load labels from BiDiB failed.", (Throwable)ex);
                ConsoleController.ensureConsoleVisible();
                this.consoleService.addConsoleLine(ConsoleColor.red, String.format("Load lables failed for node with uniqueId: %s", ByteUtils.getUniqueIdAsString((Long)uniqueId)));
            }
            node.setLabel(BidibLabelUtils.getNodeLabel((NodeLabels)nodeLabels));
            if (CollectionUtils.isNotEmpty((Collection)node.getAccessories())) {
                for (Accessory accessory : node.getAccessories()) {
                    AccessoryLabel labelType = AccessoryLabelUtils.getAccessoryLabel((NodeLabels)nodeLabels, (int)accessory.getId());
                    String accessoryLabel = labelType.getLabel();
                    LOGGER.info("Set the label of accessory id: {}, label: {}", (Object)accessory.getId(), (Object)accessoryLabel);
                    accessory.setLabel(accessoryLabel);
                }
            }
            LabelsChangedEvent labelsChangedEvent = new LabelsChangedEvent(uniqueId.longValue());
            LOGGER.info("Publish the labelsChangedEvent: {}", (Object)labelsChangedEvent);
            EventBus.publish((Object)labelsChangedEvent);
            this.applicationEventPublisher.publishEvent((Object)labelsChangedEvent);
        } else if (result == 1) {
            LOGGER.info("User declined to apply the default labels on node: {}", (Object)node);
            this.wizardLabelWrapper.setDefaultLabelsApplied(lang, uniqueId, relevantPidBits, portModel, DefaultLabelsActionType.IGNORED);
        } else {
            LOGGER.info("Apply the default labels dialog was cancelled.");
            throw new ActionAbortedException("Apply the default labels dialog was cancelled.");
        }
    }

    private void reloadLabels(NodeInterface node) {
        LOGGER.info("Load labels for node: {}", (Object)node);
        if (node == null) {
            LOGGER.info("No node selected to load the labels.");
            return;
        }
        this.wizardLabelWrapper.loadLabels(Long.valueOf(node.getUniqueId()));
        LOGGER.info("Finished load labels for node: {}", (Object)node);
    }
}

