package org.bidib.wizard.mvc.main.view.panel;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

import javax.swing.JPanel;

import org.bidib.wizard.api.locale.Resources;
import org.bidib.wizard.api.model.NodeInterface;
import org.bidib.wizard.api.model.listener.PortValueListener;
import org.bidib.wizard.client.common.controller.NodeSelectionProvider;
import org.bidib.wizard.client.common.table.AbstractHierarchicalEmptyTable.PackLastColumnEnum;
import org.bidib.wizard.client.common.table.AbstractPortHierarchicalTable;
import org.bidib.wizard.client.common.view.TabPanelProvider;
import org.bidib.wizard.client.common.view.menu.listener.PortListMenuListener;
import org.bidib.wizard.model.ports.MotorPort;
import org.bidib.wizard.model.ports.event.PortConfigChangeEvent;
import org.bidib.wizard.model.status.MotorPortStatus;
import org.bidib.wizard.mvc.main.controller.MotorPortPanelController;
import org.bidib.wizard.mvc.main.model.MainModel;
import org.bidib.wizard.mvc.main.model.MotorPortTableModel;
import org.bidib.wizard.mvc.main.model.listener.MotorPortModelListener;
import org.bidib.wizard.mvc.main.view.panel.listener.TabComponentCreator;
import org.bidib.wizard.mvc.main.view.panel.listener.TabVisibilityListener;
import org.bidib.wizard.mvc.main.view.panel.listener.TabVisibilityProvider;
import org.bidib.wizard.mvc.main.view.table.MotorPortTable;

import io.reactivex.rxjava3.subjects.PublishSubject;

public class MotorPortListPanel
    extends
    SimpleHierarchicalPortListPanel<MotorPortTableModel, MotorPortStatus, MotorPort, PortValueListener<MotorPort>, MotorPortModelListener>
    implements TabVisibilityProvider, TabPanelProvider, TabComponentCreator {
    private static final long serialVersionUID = 1L;

    private final MainModel mainModel;

    private final TabVisibilityListener tabVisibilityListener;

    public MotorPortListPanel(final MotorPortPanelController controller, final MotorPortTableModel tableModel,
        MainModel mainModel, final TabVisibilityListener tabVisibilityListener,
        final PublishSubject<PortConfigChangeEvent> portConfigChangeEventSubject) {
        super(tableModel, Resources.getString(MotorPortListPanel.class, "emptyTable"), portConfigChangeEventSubject,
            mainModel);

        this.mainModel = mainModel;
        this.tabVisibilityListener = tabVisibilityListener;
    }

    @Override
    protected AbstractPortHierarchicalTable<MotorPort> createPortTable(
        MotorPortTableModel tableModel, String emptyTableText) {

        return new MotorPortTable(tableModel, emptyTableText);
    }

    @Override
    protected void createTable(
        final MotorPortTableModel tableModel, String emptyTableText,
        final PublishSubject<PortConfigChangeEvent> portConfigChangeEventSubject,
        final NodeSelectionProvider nodeSelectionProvider) {

        super.createTable(tableModel, emptyTableText, portConfigChangeEventSubject, nodeSelectionProvider);

        // create the portlist menu listener to handle the port menu
        final PortListMenuListener portListMenuListener =
            createPortListMenuListener(this.table, nodeSelectionProvider, null);
        table.setPortListMenuListener(portListMenuListener);

    }

    @Override
    public JPanel getComponent() {
        return this;
    }

    @Override
    public Object getCreator() {
        return this;
    }

    @Override
    public boolean equals(Object other) {
        if (other instanceof TabComponentCreator) {
            TabComponentCreator creator = (TabComponentCreator) other;
            // TODO if more than a single instance is available this must be changed
            if (creator.getCreator() instanceof MotorPortListPanel) {
                return true;
            }
        }
        return false;
    }

    @Override
    public int hashCode() {
        return super.hashCode();
    }

    @Override
    protected PackLastColumnEnum isPackLastColumn() {
        return PackLastColumnEnum.VARIABLE;
    }

    @Override
    protected void processListChanged() {
        super.processListChanged();

        tabVisibilityListener.setTabVisible(this, isTabVisible());
    }

    @Override
    public Class<?> getPortClass() {
        return MotorPort.class;
    }

    @Override
    public boolean isTabVisible() {
        final NodeInterface node = mainModel.getSelectedNode();
        if (node != null) {
            boolean isTabVisible = node.hasMotorPorts();
            LOGGER.debug("Check if tab is visible: {}", isTabVisible);
            return isTabVisible;
        }
        return false;
    }

    @Override
    protected List<MotorPort> getPorts() {
        final NodeInterface node = mainModel.getSelectedNode();
        if (node != null) {
            List<MotorPort> ports = new ArrayList<>();
            ports.addAll(node.getMotorPorts());
            return ports;
        }
        return Collections.emptyList();
    }

    public void refreshView() {
        listChanged();
    }
}
