package org.bidib.wizard.mvc.main.view.table;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;

import javax.swing.BorderFactory;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.border.Border;
import javax.swing.table.DefaultTableCellRenderer;

import org.bidib.wizard.model.ports.InputPort;
import org.bidib.wizard.model.status.InputPortStatus;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class InputPortTableStatusCellRenderer extends DefaultTableCellRenderer {

    private static final long serialVersionUID = 1L;

    private static final Logger LOGGER = LoggerFactory.getLogger(InputPortTableStatusCellRenderer.class);

    private JPanel panel;

    private JLabel label;

    public InputPortTableStatusCellRenderer() {

        panel = new JPanel();
        // panel.setBackground(Color.CYAN);
        GridBagLayout layout = new GridBagLayout();
        GridBagConstraints c = new GridBagConstraints();

        c.anchor = GridBagConstraints.CENTER;
        c.fill = GridBagConstraints.CENTER;
        panel.setLayout(layout);

        label = new JLabel();
        Border b = BorderFactory.createRaisedBevelBorder();

        label.setBorder(b);
        label.setOpaque(true);
        label.setPreferredSize(new Dimension(15, 15));
        panel.add(label, c);
    }

    @Override
    public Component getTableCellRendererComponent(
        JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {

        // call super to set the correct color if selected
        // Component superComp = super.getTableCellRendererComponent(table, null, isSelected, hasFocus, row, column);

        // TODO check what happens here ...
        InputPortStatus status = null;
        boolean enabled = false;
        if (value instanceof InputPort) {
            InputPort inputPort = (InputPort) value;
            // status = inputPort.getStatus();
            enabled = inputPort.isEnabled();
            setEnabled(enabled);
            label.setEnabled(enabled);
            panel.setEnabled(enabled);
            if (enabled) {
                // get the status only if enabled
                status = inputPort.getStatus();
            }

        }
        else {
            LOGGER.warn("Found invalid configuration.");
            setEnabled(enabled);
            label.setEnabled(false);
            panel.setEnabled(false);
        }

        if (enabled && InputPortStatus.ON.equals(status)) {
            label.setBackground(Color.RED);
        }
        else {
            label.setBackground(Color.LIGHT_GRAY);
        }

        if (isSelected) {
            panel.setForeground(table.getSelectionForeground());
            panel.setBackground(table.getSelectionBackground());
        }
        else {
            panel.setForeground(table.getForeground());
            panel.setBackground(table.getBackground());
        }
        return panel;
    }
}