package org.bidib.wizard.mvc.stepcontrol.view;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.EventObject;

import javax.swing.AbstractCellEditor;
import javax.swing.JButton;
import javax.swing.JTable;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ActivateAspectButtonTableCellEditor extends AbstractCellEditor
    implements TableCellEditor, TableCellRenderer {

    private static final long serialVersionUID = 1L;

    private static final Logger LOGGER = LoggerFactory.getLogger(ActivateAspectButtonTableCellEditor.class);

    private TurntableAspect source;

    private AspectAwareButton button;

    public ActivateAspectButtonTableCellEditor() {
        this(new AspectAwareButton());
    }

    public ActivateAspectButtonTableCellEditor(AspectAwareButton button) {
        this.button = button;
        this.button.addActionListener(new LoadActionListener());
    }

    public ActivateAspectButtonTableCellEditor(final ActionListener actionListener) {
        this.button = new AspectAwareButton();
        this.button.addActionListener(actionListener);
        this.button.addActionListener(new LoadActionListener());
    }

    @Override
    public boolean shouldSelectCell(EventObject anEvent) {
        return true;
    }

    protected JButton prepare(JTable table, Object value, boolean isSelected, int row, int column) {
        if (!(value instanceof TurntableAspect)) {
            source = null;
            button.setEnabled(false);
            button.setTurntableAspect(null);
            return null;
        }
        source = (TurntableAspect) value;
        button.setEnabled(true);
        button.setText(source.getName());
        button.setToolTipText(source.getTooltip());
        button.setTurntableAspect((TurntableAspect) value);

        return button;
    }

    @Override
    public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
        JButton button = prepare(table, value, isSelected, row, column);

        return button;
    }

    @Override
    public Object getCellEditorValue() {
        return source;
    }

    @Override
    public Component getTableCellRendererComponent(
        JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
        return prepare(table, value, isSelected, row, column);
    }

    public class LoadActionListener implements ActionListener {

        @Override
        public void actionPerformed(ActionEvent evt) {
            // Here, you need to make some decisions about what to do...
            // You have a reference to the File instance
            LOGGER.debug("Action was performed for source: {}", source);
            stopCellEditing();
        }

    }

    public static class AspectAwareButton extends JButton {

        private static final long serialVersionUID = 1L;

        private TurntableAspect turntableAspect;

        /**
         * @return the turntableAspect
         */
        public TurntableAspect getTurntableAspect() {
            return turntableAspect;
        }

        /**
         * @param turntableAspect
         *            the turntableAspect to set
         */
        public void setTurntableAspect(TurntableAspect turntableAspect) {
            this.turntableAspect = turntableAspect;
        }

    }
}
