/*
 * Decompiled with CFR 0.152.
 */
package org.bidib.wizard.mvc.main.view;

import com.vlsolutions.swing.docking.DockingContext;
import com.vlsolutions.swing.docking.DockingDesktop;
import com.vlsolutions.swing.toolbars.ToolBarConstraints;
import com.vlsolutions.swing.toolbars.ToolBarContainer;
import com.vlsolutions.swing.toolbars.ToolBarPanel;
import com.vlsolutions.swing.toolbars.VLToolBar;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.event.ActionListener;
import java.awt.event.WindowListener;
import java.awt.event.WindowStateListener;
import java.beans.PropertyChangeListener;
import java.util.List;
import java.util.Properties;
import javax.swing.JButton;
import javax.swing.JMenuBar;
import javax.swing.UIManager;
import javax.swing.event.ListSelectionListener;
import org.apache.commons.lang3.StringUtils;
import org.bidib.api.json.types.ConnectionPhase;
import org.bidib.wizard.api.LookupService;
import org.bidib.wizard.api.context.ApplicationContext;
import org.bidib.wizard.api.locale.Resources;
import org.bidib.wizard.api.model.common.PreferencesPortType;
import org.bidib.wizard.api.model.listener.CvDefinitionRequestListener;
import org.bidib.wizard.api.model.listener.NodeListListener;
import org.bidib.wizard.client.common.uils.SwingUtils;
import org.bidib.wizard.client.common.view.BusyFrame;
import org.bidib.wizard.client.common.view.ButtonUtils;
import org.bidib.wizard.client.common.view.DefaultBusyFrame;
import org.bidib.wizard.client.common.view.WindowUtils;
import org.bidib.wizard.client.common.view.statusbar.StatusBar;
import org.bidib.wizard.common.context.DefaultApplicationContext;
import org.bidib.wizard.common.labels.WizardLabelWrapper;
import org.bidib.wizard.common.model.settings.ConnectionConfiguration;
import org.bidib.wizard.common.model.settings.GlobalSettingsInterface;
import org.bidib.wizard.common.model.settings.WizardSettingsInterface;
import org.bidib.wizard.common.model.settings.types.Frame;
import org.bidib.wizard.common.model.settings.types.Point;
import org.bidib.wizard.common.service.SettingsService;
import org.bidib.wizard.common.utils.ImageUtils;
import org.bidib.wizard.config.DebugInterfaceControllerFactory;
import org.bidib.wizard.config.SimulationControllerFactory;
import org.bidib.wizard.config.WorkListControllerFactory;
import org.bidib.wizard.core.model.settings.GlobalSettings;
import org.bidib.wizard.core.model.settings.SettingsWrapper;
import org.bidib.wizard.core.model.settings.WizardSettings;
import org.bidib.wizard.core.utils.AopUtils;
import org.bidib.wizard.mvc.debug.controller.DebugInterfaceController;
import org.bidib.wizard.mvc.main.controller.BidibPiController;
import org.bidib.wizard.mvc.main.model.ConnectionPhaseModel;
import org.bidib.wizard.mvc.main.model.MainModel;
import org.bidib.wizard.mvc.main.view.MainView;
import org.bidib.wizard.mvc.main.view.menu.MainMenuBar;
import org.bidib.wizard.mvc.main.view.menu.listener.MainMenuListener;
import org.bidib.wizard.mvc.main.view.panel.MainPanel;
import org.bidib.wizard.mvc.main.view.panel.listener.NodeListActionListener;
import org.bidib.wizard.mvc.worklist.controller.WorkListItemProvider;
import org.bidib.wizard.nodescript.script.node.NodeScriptingSupportProvider;
import org.bidib.wizard.simulation.client.controller.SimulationController;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

public class MainView
implements BusyFrame {
    private static final Logger LOGGER = LoggerFactory.getLogger(MainView.class);
    private MainMenuBar mainMenuBar;
    private MainPanel mainPanel;
    private JButton connectButton;
    private JButton disconnectButton;
    private JButton listenNetBidibButton;
    private JButton allBoosterOffButton;
    private JButton allBoosterOnButton;
    private JButton savePendingChangesButton;
    private JButton simulationButton;
    private JButton simulationExportButton;
    private JButton comparisonExportButton;
    private JButton developerDebugInterfaceButton;
    private JButton developerDebugConsoleButton;
    private JButton developerRxTxLoggerViewButton;
    private JButton bidibPiResetButton;
    private JButton firmwareRepoButton;
    private JButton backupAllNodesButton;
    private JButton nodesClientButton;
    private JButton scriptClientButton;
    private JButton nodeScriptingButton;
    private JButton preferencesButton;
    private JButton locoDialogButton;
    private JButton carDialogButton;
    private JButton workListButton;
    @Autowired
    private DockingDesktop desktop;
    @Autowired
    private DockingContext dockingContext;
    private final MainModel mainModel;
    private VLToolBar toolbarSimulation;
    private VLToolBar toolbarDeveloper;
    private VLToolBar toolbarBidibPi;
    private ToolBarPanel topToolBarPanel;
    private final ConnectionPhaseModel connectionPhaseModel;
    private final NodeScriptingSupportProvider nodeScriptingSupportProvider;
    private DefaultBusyFrame frame;
    @Autowired
    private StatusBar statusBar;
    @Autowired
    private GlobalSettingsInterface globalSettings;
    @Autowired
    private WizardSettingsInterface wizardSettings;
    @Autowired
    private SettingsWrapper settingsWrapper;
    @Autowired
    private SettingsService settingsService;
    @Autowired
    private WizardLabelWrapper wizardLabelWrapper;
    private MainMenuListener mainMenuListener;
    @Autowired
    private org.springframework.context.ApplicationContext applicationContext;
    @Autowired
    private LookupService lookupService;
    private final WorkListControllerFactory workListItemProvider;
    private WindowStateListener windowStateListener;
    private int extendedWindowState;

    public MainView(MainModel model, ConnectionPhaseModel connectionPhaseModel, NodeScriptingSupportProvider nodeScriptingSupportProvider, WorkListControllerFactory workListItemProvider) {
        this.mainModel = model;
        this.connectionPhaseModel = connectionPhaseModel;
        this.nodeScriptingSupportProvider = nodeScriptingSupportProvider;
        this.workListItemProvider = workListItemProvider;
    }

    public void setMainMenuListener(MainMenuListener mainMenuListener) {
        this.mainMenuListener = mainMenuListener;
    }

    public void createComponents() {
        this.frame = new DefaultBusyFrame();
        try {
            Properties version = new Properties();
            version.load(this.getClass().getResourceAsStream("/META-INF/build-info.properties"));
            String projectVersion = version.getProperty("build.version");
            String buildNumber = version.getProperty("build.buildnumber-and-branch-info");
            LOGGER.info("Current buildNumber: {}", (Object)buildNumber);
            StringBuilder sb = new StringBuilder(Resources.getString(this.getClass(), (String)"title"));
            sb.append(" ").append(projectVersion);
            if (!buildNumber.startsWith("${")) {
                if (buildNumber.indexOf(",") > -1) {
                    sb.append(" (").append(buildNumber.substring(0, buildNumber.indexOf(","))).append(")");
                } else {
                    sb.append(" (").append(buildNumber).append(")");
                }
            }
            this.frame.setTitle(sb.toString());
        }
        catch (Exception ex) {
            LOGGER.warn("Load version information failed.");
            this.frame.setTitle(Resources.getString(this.getClass(), (String)"title"));
        }
        this.frame.setDefaultCloseOperation(0);
        this.frame.setIconImage(ImageUtils.createImageIcon(this.getClass(), (String)"/icons/wizard-logo2-48x48.png").getImage());
        this.mainMenuBar = new MainMenuBar(this.mainModel, this.desktop, this.dockingContext, this.settingsService, this.connectionPhaseModel, this.mainMenuListener, this.wizardLabelWrapper);
        this.frame.setJMenuBar((JMenuBar)this.mainMenuBar);
        ToolBarContainer container = ToolBarContainer.createDefaultContainer((boolean)true, (boolean)false, (boolean)false, (boolean)false);
        this.topToolBarPanel = container.getToolBarPanelAt((Object)"North");
        DefaultApplicationContext.getInstance().register("topToolBarPanel", (Object)this.topToolBarPanel);
        DefaultApplicationContext.getInstance().register("desktop", (Object)this.desktop);
        VLToolBar toolbarBidib = new VLToolBar("bidib");
        this.topToolBarPanel.add(toolbarBidib, new ToolBarConstraints(0, 0));
        this.addBidibButtons(toolbarBidib);
        VLToolBar toolbarTools = new VLToolBar("tools");
        this.topToolBarPanel.add(toolbarTools, new ToolBarConstraints(0, 1));
        this.addToolsButtons(toolbarTools, this.desktop);
        this.toolbarSimulation = new VLToolBar("simulation");
        this.topToolBarPanel.add(this.toolbarSimulation, new ToolBarConstraints(0, 2));
        this.addSimulationButtons(this.toolbarSimulation, this.desktop);
        PreferencesPortType portType = ConnectionConfiguration.toPreferencesPortType((List)this.globalSettings.getConnectionConfigurations(), (String)"main");
        boolean simulationMode = PreferencesPortType.isSimulation((PreferencesPortType)portType);
        this.toolbarSimulation.setVisible(simulationMode);
        this.toolbarDeveloper = new VLToolBar("developer");
        this.topToolBarPanel.add(this.toolbarDeveloper, new ToolBarConstraints(0, 3));
        this.addDeveloperButtons(this.toolbarDeveloper, this.desktop);
        boolean powerUserMode = this.wizardSettings.isPowerUser();
        this.toolbarDeveloper.setVisible(powerUserMode);
        ApplicationContext applicationContext = DefaultApplicationContext.getInstance();
        BidibPiController bidibPiController = (BidibPiController)applicationContext.get("bidibPiController", BidibPiController.class);
        if (bidibPiController != null) {
            this.toolbarBidibPi = new VLToolBar("bidibpi");
            this.topToolBarPanel.add(this.toolbarBidibPi, new ToolBarConstraints(0, 4));
            this.addBidibPiButtons(this.toolbarBidibPi, this.desktop);
            this.toolbarBidibPi.setVisible(true);
        }
        container.add((Component)this.desktop, (Object)"Center");
        this.frame.getContentPane().add((Component)container);
        this.mainPanel = new MainPanel(this.mainModel, this.connectionPhaseModel, this.settingsService, this.wizardLabelWrapper, this.nodeScriptingSupportProvider, this.lookupService, this.statusBar);
        this.mainPanel.create(this.desktop, this.mainMenuListener, this.applicationContext, (WorkListItemProvider)this.workListItemProvider.createWorkListController(this.desktop, this.wizardSettings, this.settingsService.getMiscSettings(), this.applicationContext));
        this.frame.getContentPane().add((Component)this.statusBar.getComponent(), "Last");
        this.connectionPhaseModel.addPropertyChangeListener(evt -> {
            block3 : switch (evt.getPropertyName()) {
                case "connectionPhase": {
                    ConnectionPhase connectionPhase = this.connectionPhaseModel.getConnectionPhase();
                    switch (7.$SwitchMap$org$bidib$api$json$types$ConnectionPhase[connectionPhase.ordinal()]) {
                        case 1: {
                            LOGGER.info("The port is opening. Disable the buttons.");
                            SwingUtils.executeInEDT(() -> {
                                this.connectButton.setEnabled(false);
                                this.disconnectButton.setEnabled(false);
                                this.listenNetBidibButton.setEnabled(false);
                                this.allBoosterOffButton.setEnabled(false);
                                this.allBoosterOnButton.setEnabled(false);
                                this.savePendingChangesButton.setEnabled(false);
                                this.mainMenuBar.opening();
                                this.setStatusText(Resources.getString(ConnectionPhaseModel.class, (String)"opening-port"), -1);
                            });
                            break block3;
                        }
                        case 2: {
                            SwingUtils.executeInEDT(() -> {
                                this.connectButton.setEnabled(false);
                                this.disconnectButton.setEnabled(true);
                                this.listenNetBidibButton.setEnabled(false);
                                this.allBoosterOffButton.setEnabled(true);
                                this.allBoosterOnButton.setEnabled(true);
                                this.savePendingChangesButton.setEnabled(true);
                                this.nodesClientButton.setEnabled(true);
                                this.simulationExportButton.setEnabled(true);
                                this.backupAllNodesButton.setEnabled(true);
                                this.comparisonExportButton.setEnabled(true);
                                this.locoDialogButton.setEnabled(true);
                                this.carDialogButton.setEnabled(true);
                                this.mainMenuBar.opened(this.connectionPhaseModel.getConnectionId());
                                this.setStatusText(Resources.getString(ConnectionPhaseModel.class, (String)"open-port-passed") + " " + this.connectionPhaseModel.getConnectionId(), -1);
                            });
                            break block3;
                        }
                        case 3: {
                            SwingUtils.executeInEDT(() -> {
                                this.connectButton.setEnabled(true);
                                this.disconnectButton.setEnabled(false);
                                this.allBoosterOffButton.setEnabled(false);
                                this.allBoosterOnButton.setEnabled(false);
                                this.savePendingChangesButton.setEnabled(false);
                                this.nodesClientButton.setEnabled(false);
                                this.simulationExportButton.setEnabled(false);
                                this.backupAllNodesButton.setEnabled(false);
                                this.comparisonExportButton.setEnabled(false);
                                this.locoDialogButton.setEnabled(false);
                                this.carDialogButton.setEnabled(false);
                                this.enableListenNetBidibItem();
                                this.mainMenuBar.closed(this.connectionPhaseModel.getConnectionId());
                                if (StringUtils.isNotBlank((CharSequence)this.connectionPhaseModel.getConnectionId())) {
                                    this.setStatusText(Resources.getString(ConnectionPhaseModel.class, (String)"close-port-passed") + " " + this.connectionPhaseModel.getConnectionId(), -1);
                                } else {
                                    this.setStatusText(null, -1);
                                }
                            });
                            break block3;
                        }
                    }
                    break;
                }
            }
        });
        try {
            GlobalSettings gs = (GlobalSettings)AopUtils.getTargetObject((Object)this.globalSettings);
            gs.addPropertyChangeListener("selectedPortType", (PropertyChangeListener)new /* Unavailable Anonymous Inner Class!! */);
        }
        catch (Exception ex) {
            LOGGER.warn("Add property change listeners failed.", (Throwable)ex);
        }
        try {
            WizardSettings ws = (WizardSettings)AopUtils.getTargetObject((Object)this.wizardSettings);
            ws.addPropertyChangeListener("powerUser", (PropertyChangeListener)new /* Unavailable Anonymous Inner Class!! */);
        }
        catch (Exception ex) {
            LOGGER.warn("Add property change listeners failed.", (Throwable)ex);
        }
        this.mainModel.addNodeListListener((NodeListListener)new /* Unavailable Anonymous Inner Class!! */);
        this.windowStateListener = new /* Unavailable Anonymous Inner Class!! */;
        this.frame.addWindowStateListener(this.windowStateListener);
    }

    public DefaultBusyFrame getFrame() {
        return this.frame;
    }

    private void fireConnect() {
        this.mainMenuListener.connect();
    }

    private void fireDisconnect() {
        this.mainMenuListener.disconnect();
    }

    private void fireListenNetBidib() {
        this.mainMenuListener.listenNetBidib();
    }

    private void fireAllBoosterOff() {
        this.mainMenuListener.allBoosterOff();
    }

    private void fireAllBoosterOn() {
        this.mainMenuListener.allBoosterOn();
    }

    private void fireShowLocoDialog() {
        this.mainMenuListener.showLocoDialog();
    }

    private void fireShowCarDialog() {
        this.mainMenuListener.showCarDialog();
    }

    private void fireShowNodeScriptWizard() {
        this.mainMenuListener.showNodeScriptWizard();
    }

    private void fireShowFirmwareRepo() {
        this.mainMenuListener.showFirmwareRepo();
    }

    private void fireBackupAllNodes() {
        this.mainMenuListener.backupAllNodes();
    }

    private void fireShowNodesClient() {
        this.mainMenuListener.showNodesClient();
    }

    private void fireShowScriptClient() {
        this.mainMenuListener.showScriptClient();
    }

    private void fireShowWorkList() {
        this.mainMenuListener.showWorkItemList();
    }

    private void fireShowPreferences() {
        this.mainMenuListener.preferences();
    }

    private void fireShowRxTxLoggerView() {
        this.mainMenuListener.showRxTxLoggerView();
    }

    private void fireShowDebugConsole() {
        this.mainMenuListener.debugConsole();
    }

    private void fireSaveNodeTreeForSimulation() {
        this.mainMenuListener.saveNodeTreeForSimulation();
    }

    private void fireSaveNodeTreeForComparison() {
        this.mainMenuListener.saveNodeTreeForComparison();
    }

    private void enableListenNetBidibItem() {
        String connectionId = "main";
        ConnectionConfiguration connectionConfig = this.globalSettings.getConnectionConfigurations().stream().filter(cfg -> cfg.getId().equals(connectionId)).findFirst().orElse(null);
        if (connectionConfig != null && "NetBidibClient".equals(connectionConfig.getConnectionProvider())) {
            ConnectionPhase connectionPhase = this.connectionPhaseModel.getConnectionPhase();
            if (connectionPhase != null && ConnectionPhase.DISCONNECTED != connectionPhase) {
                this.listenNetBidibButton.setEnabled(false);
            }
        } else {
            this.listenNetBidibButton.setEnabled(false);
        }
    }

    public DockingDesktop getDesktop() {
        return this.desktop;
    }

    private void addBidibButtons(VLToolBar toolbar) {
        this.connectButton = ButtonUtils.makeNavigationButton((String)"connect.png", (String)"/32x32", (String)"", (String)Resources.getString(this.getClass(), (String)"toolbar.bidib.connect"), (String)Resources.getString(this.getClass(), (String)"toolbar.bidib.connect.alttext"));
        this.connectButton.addActionListener(e -> this.fireConnect());
        toolbar.add(this.connectButton);
        this.disconnectButton = ButtonUtils.makeNavigationButton((String)"disconnect.png", (String)"/32x32", (String)"", (String)Resources.getString(this.getClass(), (String)"toolbar.bidib.disconnect"), (String)Resources.getString(this.getClass(), (String)"toolbar.bidib.disconnect.alttext"));
        this.disconnectButton.addActionListener(e -> this.fireDisconnect());
        this.disconnectButton.setEnabled(false);
        toolbar.add(this.disconnectButton);
        this.listenNetBidibButton = ButtonUtils.makeNavigationButton((String)"socket.png", (String)"/32x32", (String)"", (String)Resources.getString(this.getClass(), (String)"toolbar.bidib.socket"), (String)Resources.getString(this.getClass(), (String)"toolbar.bidib.socket.alttext"));
        this.listenNetBidibButton.addActionListener(e -> this.fireListenNetBidib());
        this.listenNetBidibButton.setEnabled(false);
        toolbar.add(this.listenNetBidibButton);
        this.enableListenNetBidibItem();
        toolbar.addSeparator();
        this.allBoosterOffButton = ButtonUtils.makeNavigationButton((String)"boosterOff.png", (String)"/32x32", (String)"", (String)Resources.getString(this.getClass(), (String)"toolbar.bidib.all-booster-off"), (String)Resources.getString(this.getClass(), (String)"toolbar.bidib.all-booster-off.alttext"));
        this.allBoosterOffButton.addActionListener(e -> this.fireAllBoosterOff());
        this.allBoosterOffButton.setEnabled(false);
        toolbar.add(this.allBoosterOffButton);
        this.allBoosterOnButton = ButtonUtils.makeNavigationButton((String)"boosterOn.png", (String)"/32x32", (String)"", (String)Resources.getString(this.getClass(), (String)"toolbar.bidib.all-booster-on"), (String)Resources.getString(this.getClass(), (String)"toolbar.bidib.all-booster-on.alttext"));
        this.allBoosterOnButton.addActionListener(e -> this.fireAllBoosterOn());
        this.allBoosterOnButton.setEnabled(false);
        toolbar.add(this.allBoosterOnButton);
        toolbar.addSeparator();
        this.savePendingChangesButton = ButtonUtils.makeNavigationButton((String)"save.png", (String)"/32x32", (String)"", (String)Resources.getString(this.getClass(), (String)"toolbar.bidib.save-pending-changes"), (String)Resources.getString(this.getClass(), (String)"toolbar.bidib.save-pending-changes.alttext"));
        this.savePendingChangesButton.addActionListener(e -> this.savePendingChanges());
        this.savePendingChangesButton.setEnabled(false);
        toolbar.add(this.savePendingChangesButton);
        try {
            GlobalSettings gs = (GlobalSettings)AopUtils.getTargetObject((Object)this.settingsService.getGlobalSettings());
            gs.addPropertyChangeListener("selectedPortType", (PropertyChangeListener)new /* Unavailable Anonymous Inner Class!! */);
        }
        catch (Exception ex) {
            LOGGER.warn("Register for changes of selected port type failed.", (Throwable)ex);
        }
    }

    private void addToolsButtons(VLToolBar toolbar, DockingDesktop desktop) {
        this.preferencesButton = ButtonUtils.makeNavigationButton((String)"settings_32x32.png", (String)"/32x32", (String)"", (String)Resources.getString(this.getClass(), (String)"toolbar.preferences.open"), (String)Resources.getString(this.getClass(), (String)"toolbar.preferences.open.alttext"));
        this.preferencesButton.addActionListener(e -> this.fireShowPreferences());
        toolbar.add(this.preferencesButton);
        toolbar.addSeparator();
        this.locoDialogButton = ButtonUtils.makeNavigationButton((String)"toy-train.png", (String)"/32x32", (String)"", (String)Resources.getString(this.getClass(), (String)"toolbar.locodialog.open"), (String)Resources.getString(this.getClass(), (String)"toolbar.locodialog.open.alttext"));
        this.locoDialogButton.addActionListener(e -> this.fireShowLocoDialog());
        toolbar.add(this.locoDialogButton);
        this.carDialogButton = ButtonUtils.makeNavigationButton((String)"car-toy.png", (String)"/32x32", (String)"", (String)Resources.getString(this.getClass(), (String)"toolbar.cardialog.open"), (String)Resources.getString(this.getClass(), (String)"toolbar.cardialog.open.alttext"));
        this.carDialogButton.addActionListener(e -> this.fireShowCarDialog());
        toolbar.add(this.carDialogButton);
        toolbar.addSeparator();
        this.nodeScriptingButton = ButtonUtils.makeNavigationButton((String)"nodescripting.png", (String)"/32x32", (String)"", (String)Resources.getString(this.getClass(), (String)"toolbar.nodescripting.open"), (String)Resources.getString(this.getClass(), (String)"toolbar.nodescripting.open.alttext"));
        this.nodeScriptingButton.addActionListener(e -> this.fireShowNodeScriptWizard());
        toolbar.add(this.nodeScriptingButton);
        this.firmwareRepoButton = ButtonUtils.makeNavigationButton((String)"software.png", (String)"/32x32", (String)"", (String)Resources.getString(this.getClass(), (String)"toolbar.firmwarerepo.open"), (String)Resources.getString(this.getClass(), (String)"toolbar.firmwarerepo.open.alttext"));
        this.firmwareRepoButton.addActionListener(e -> this.fireShowFirmwareRepo());
        toolbar.add(this.firmwareRepoButton);
        this.backupAllNodesButton = ButtonUtils.makeNavigationButton((String)"backupnodes.png", (String)"/32x32", (String)"", (String)Resources.getString(this.getClass(), (String)"toolbar.backup-all-nodes.open"), (String)Resources.getString(this.getClass(), (String)"toolbar.backup-all-nodes.open.alttext"));
        this.backupAllNodesButton.addActionListener(e -> this.fireBackupAllNodes());
        toolbar.add(this.backupAllNodesButton);
        this.nodesClientButton = ButtonUtils.makeNavigationButton((String)"tree.png", (String)"/32x32", (String)"", (String)Resources.getString(this.getClass(), (String)"toolbar.nodesClient.open"), (String)Resources.getString(this.getClass(), (String)"toolbar.nodesClient.open.alttext"));
        this.nodesClientButton.addActionListener(e -> this.fireShowNodesClient());
        toolbar.add(this.nodesClientButton);
        this.comparisonExportButton = ButtonUtils.makeNavigationButton((String)UIManager.getString("comparison.icon.name"), (String)"/32x32", (String)"", (String)Resources.getString(this.getClass(), (String)"toolbar.comparison.export"), (String)Resources.getString(this.getClass(), (String)"toolbar.comparison.export.alttext"));
        this.comparisonExportButton.addActionListener(e -> this.fireSaveNodeTreeForComparison());
        this.comparisonExportButton.setEnabled(false);
        toolbar.add(this.comparisonExportButton);
        this.workListButton = ButtonUtils.makeNavigationButton((String)"worklist.png", (String)"/32x32", (String)"", (String)Resources.getString(this.getClass(), (String)"toolbar.worklist.open"), (String)Resources.getString(this.getClass(), (String)"toolbar.worklist.open.alttext"));
        this.workListButton.addActionListener((ActionListener)new /* Unavailable Anonymous Inner Class!! */);
        toolbar.add(this.workListButton);
        this.nodeScriptingButton.setEnabled(false);
        this.backupAllNodesButton.setEnabled(false);
        this.nodesClientButton.setEnabled(false);
        this.locoDialogButton.setEnabled(false);
        this.carDialogButton.setEnabled(false);
        this.comparisonExportButton.setEnabled(false);
    }

    private void addSimulationButtons(VLToolBar toolbar, DockingDesktop desktop) {
        this.simulationButton = ButtonUtils.makeNavigationButton((String)"sim-mode.png", (String)"/32x32", (String)"", (String)Resources.getString(this.getClass(), (String)"toolbar.simulation.open"), (String)Resources.getString(this.getClass(), (String)"toolbar.simulation.open.alttext"));
        this.simulationButton.addActionListener(e -> {
            if (this.mainModel.getSelectedNode() != null) {
                SimulationControllerFactory simulationControllerFactory = (SimulationControllerFactory)this.applicationContext.getBean(SimulationControllerFactory.class);
                SimulationController simulationController = simulationControllerFactory.createController(desktop);
                simulationController.start();
                simulationController.activate(this.mainModel.getSelectedNode());
            }
        });
        toolbar.add(this.simulationButton);
    }

    private void addDeveloperButtons(VLToolBar toolbar, DockingDesktop desktop) {
        this.developerDebugInterfaceButton = ButtonUtils.makeNavigationButton((String)"console.png", (String)"/32x32", (String)"", (String)Resources.getString(this.getClass(), (String)"toolbar.debuginterface.open"), (String)Resources.getString(this.getClass(), (String)"toolbar.debuginterface.open.alttext"));
        this.developerDebugInterfaceButton.addActionListener(e -> {
            DebugInterfaceControllerFactory debugInterfaceControllerFactory = (DebugInterfaceControllerFactory)this.applicationContext.getBean(DebugInterfaceControllerFactory.class);
            DebugInterfaceController debugInterfaceController = debugInterfaceControllerFactory.createController(desktop);
            debugInterfaceController.start();
        });
        toolbar.add(this.developerDebugInterfaceButton);
        this.developerDebugConsoleButton = ButtonUtils.makeNavigationButton((String)"debugconsole.png", (String)"/32x32", (String)"", (String)Resources.getString(this.getClass(), (String)"toolbar.debugconsole.open"), (String)Resources.getString(this.getClass(), (String)"toolbar.debugconsole.open.alttext"));
        this.developerDebugConsoleButton.addActionListener(e -> this.fireShowDebugConsole());
        toolbar.add(this.developerDebugConsoleButton);
        this.developerRxTxLoggerViewButton = ButtonUtils.makeNavigationButton((String)"loupe.png", (String)"/32x32", (String)"", (String)Resources.getString(this.getClass(), (String)"toolbar.rxtxloggerview.open"), (String)Resources.getString(this.getClass(), (String)"toolbar.rxtxloggerview.open.alttext"));
        this.developerRxTxLoggerViewButton.addActionListener(e -> this.fireShowRxTxLoggerView());
        toolbar.add(this.developerRxTxLoggerViewButton);
        this.simulationExportButton = ButtonUtils.makeNavigationButton((String)"sim-export.png", (String)"/32x32", (String)"", (String)Resources.getString(this.getClass(), (String)"toolbar.simulation.export"), (String)Resources.getString(this.getClass(), (String)"toolbar.simulation.export.alttext"));
        this.simulationExportButton.addActionListener(e -> this.fireSaveNodeTreeForSimulation());
        this.simulationExportButton.setEnabled(false);
        toolbar.add(this.simulationExportButton);
        this.scriptClientButton = ButtonUtils.makeNavigationButton((String)"script.png", (String)"/32x32", (String)"", (String)Resources.getString(this.getClass(), (String)"toolbar.scriptClient.open"), (String)Resources.getString(this.getClass(), (String)"toolbar.scriptClient.open.alttext"));
        this.scriptClientButton.addActionListener(e -> this.fireShowScriptClient());
        toolbar.add(this.scriptClientButton);
    }

    private void addBidibPiButtons(VLToolBar toolbar, DockingDesktop desktop) {
        this.bidibPiResetButton = ButtonUtils.makeNavigationButton((String)"lightning.png", (String)"/32x32", (String)"", (String)Resources.getString(this.getClass(), (String)"toolbar.bidibpi.reset"), (String)Resources.getString(this.getClass(), (String)"toolbar.bidibpi.reset.alttext"));
        this.bidibPiResetButton.addActionListener(e -> {
            BidibPiController bidibPiController = (BidibPiController)DefaultApplicationContext.getInstance().get("bidibPiController", BidibPiController.class);
            if (bidibPiController != null) {
                LOGGER.info("Call reset on the Bidib-Pi");
                bidibPiController.reset();
            } else {
                LOGGER.info("No bidib-pi available.");
            }
        });
        toolbar.add(this.bidibPiResetButton);
    }

    public void addNodeListListener(NodeListActionListener l) {
        this.mainPanel.addNodeListListener(l);
    }

    public void addNodeListSelectionListener(ListSelectionListener l) {
        this.mainPanel.addNodeListSelectionListener(l);
    }

    public void addCvDefinitionRequestListener(CvDefinitionRequestListener l) {
        this.mainPanel.addCvDefinitionRequestListener(l);
    }

    public void prepareFrame() {
        LOGGER.info("Prepare the frame.");
        this.frame.setMinimumSize(new Dimension(1024, 600));
        this.frame.pack();
    }

    private int getExtendedState() {
        return this.extendedWindowState;
    }

    private void adjustSize() {
        Frame windowPosition = this.wizardSettings.getFrame();
        Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
        Dimension size = this.frame.getSize();
        LOGGER.info("Current screenSize: {}, stored windowPosition: {}", (Object)screenSize, (Object)windowPosition);
        this.frame.setLocation((screenSize.width - size.width) / 2, (screenSize.height - size.height) / 2);
        if (windowPosition == null) {
            LOGGER.info("Set the default frame size.");
            this.frame.setPreferredSize(new Dimension(Math.min(screenSize.width, 1400), Math.min(screenSize.height, 800)));
        } else {
            java.awt.Point windowPos = new java.awt.Point(windowPosition.getPosition().getX(), windowPosition.getPosition().getY());
            Dimension windowSize = new Dimension(windowPosition.getSize().getWidth(), windowPosition.getSize().getHeight());
            int extendedState = windowPosition.getExtendedState();
            LOGGER.info("Restore frame at pos: {}, size: {}, extendedState: {}", new Object[]{windowPos, windowSize, extendedState});
            this.frame.setSize(windowSize);
            if (windowPos != null) {
                if (WindowUtils.isValidScreenLocation((Rectangle)new Rectangle(windowPos.x, windowPos.y, windowSize.width, windowSize.height))) {
                    LOGGER.info("The location on the screen is valid: {}", (Object)windowPos);
                    this.frame.setLocation(windowPos);
                } else {
                    if (windowPos.x > screenSize.width - 20) {
                        windowPos.x = screenSize.width - 20;
                    }
                    if (windowPos.y > screenSize.height - 20) {
                        windowPos.y = screenSize.height - 20;
                    }
                    if (windowPos.x < 0) {
                        windowPos.x = 0;
                    }
                    if (windowPos.y < 0) {
                        windowPos.y = 0;
                    }
                    LOGGER.info("The location on the screen is not valid. Adjusted position: {}", (Object)windowPos);
                    this.frame.setLocation(windowPos);
                }
            }
            this.frame.setExtendedState(extendedState);
        }
    }

    public void saveWindowPosition() {
        try {
            int extendedState = this.getExtendedState();
            LOGGER.info("Save the window position. Current extendedState: {}", (Object)extendedState);
            if (extendedState != 6) {
                Point position = new Point(this.frame.getLocation().x, this.frame.getLocation().y);
                Dimension frameSize = this.frame.getSize();
                org.bidib.wizard.common.model.settings.types.Dimension size = new org.bidib.wizard.common.model.settings.types.Dimension(frameSize.width, frameSize.height);
                LOGGER.info("Prepared window position: {}, size: {}, extendedState: {}", new Object[]{position, size, extendedState});
                this.wizardSettings.saveWindowPosition(position, size, extendedState);
            } else {
                LOGGER.info("In maximized state only save extended state.");
                Point position = new Point(this.frame.getLocation().x, this.frame.getLocation().y);
                this.wizardSettings.saveWindowPosition(position, this.wizardSettings.getFrame().getSize(), extendedState);
            }
            this.settingsWrapper.storeGlobalSettings(null);
        }
        catch (Exception ex) {
            LOGGER.warn("Save window position during shutdown failed.", (Throwable)ex);
        }
    }

    public void setWindowListener(WindowListener l) {
        this.frame.addWindowListener(l);
    }

    public void setStatusText(String statusText, int displayDuration) {
        if (this.statusBar != null) {
            this.statusBar.setStatusText(statusText, displayDuration);
        }
    }

    public void setVisible(boolean visible) {
        this.frame.setVisible(visible);
        if (visible) {
            this.adjustSize();
        }
    }

    public void bringWindowToFront() {
        LOGGER.info("Bring the MainView to front.");
        this.frame.setAlwaysOnTop(true);
        this.frame.toFront();
        this.frame.requestFocus();
        this.frame.setAlwaysOnTop(false);
    }

    public boolean setBusy(boolean busy) {
        return this.frame.setBusy(busy);
    }

    public void performShutdown() {
        if (this.mainPanel != null) {
            this.mainPanel.performShutdown();
        }
    }

    public void savePendingChanges() {
        if (this.mainPanel != null) {
            this.mainPanel.savePendingChanges();
        }
    }
}

