/*
 * Decompiled with CFR 0.152.
 */
package org.bidib.wizard.mvc.main.view.panel;

import com.jgoodies.binding.PresentationModel;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.function.Consumer;
import javax.swing.ImageIcon;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.collections4.IterableUtils;
import org.apache.commons.collections4.Predicate;
import org.apache.commons.lang3.StringUtils;
import org.bidib.jbidibc.core.schema.BidibFactory;
import org.bidib.jbidibc.core.schema.DecoderVendorFactory;
import org.bidib.jbidibc.core.schema.bidib.products.ProductType;
import org.bidib.jbidibc.core.schema.bidib2.FeatureCode;
import org.bidib.jbidibc.core.schema.bidib2.common.DocumentationType;
import org.bidib.jbidibc.core.schema.decodervendor.VendorType;
import org.bidib.jbidibc.exchange.bidib.ProductsUtils;
import org.bidib.jbidibc.messages.Feature;
import org.bidib.jbidibc.messages.Node;
import org.bidib.jbidibc.messages.SoftwareVersion;
import org.bidib.jbidibc.messages.utils.ByteUtils;
import org.bidib.jbidibc.messages.utils.ConversionUtils;
import org.bidib.jbidibc.messages.utils.NodeUtils;
import org.bidib.wizard.api.LookupService;
import org.bidib.wizard.api.locale.Resources;
import org.bidib.wizard.api.model.NodeInterface;
import org.bidib.wizard.api.utils.XmlLocaleUtils;
import org.bidib.wizard.client.common.mvc.firmware.controller.FirmwareController;
import org.bidib.wizard.client.common.view.BidibNodeNameUtils;
import org.bidib.wizard.client.common.view.TabPanelProvider;
import org.bidib.wizard.common.service.SettingsService;
import org.bidib.wizard.common.utils.ImageUtils;
import org.bidib.wizard.config.FirmwareControllerFactory;
import org.bidib.wizard.firmwarerepo.core.FirmwareRepoService;
import org.bidib.wizard.mvc.main.model.InfoModel;
import org.bidib.wizard.mvc.main.model.MainModel;
import org.bidib.wizard.mvc.main.view.panel.InfoPanel;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class InfoPanel
implements TabPanelProvider {
    private static final Logger LOGGER = LoggerFactory.getLogger(InfoPanel.class);
    private static final String ENCODED_DETAILS_COLUMN_SPECS = "pref, 3dlu, pref, 3dlu, pref, 3dlu, pref, 3dlu, fill:10dlu:grow, 3dlu, pref";
    private final MainModel mainModel;
    private final DetailsPanel detailsPanel;
    private final JPanel contentPanel;
    private List<VendorType> vendors;
    private final PropertyChangeListener nodeListener;
    private NodeInterface selectedNode;
    private JLabel imageContainer;
    private List<FeatureCode> featureCodes;
    private final SettingsService settingsService;
    private final LookupService lookupService;
    private final FirmwareControllerFactory firmwareControllerFactory;
    private final FirmwareRepoService firmwareRepoService;

    public InfoPanel(MainModel model, SettingsService settingsService, LookupService lookupService, FirmwareControllerFactory firmwareControllerFactory, FirmwareRepoService firmwareRepoService) {
        this.mainModel = model;
        this.settingsService = settingsService;
        this.lookupService = lookupService;
        this.firmwareControllerFactory = firmwareControllerFactory;
        this.firmwareRepoService = firmwareRepoService;
        this.nodeListener = new /* Unavailable Anonymous Inner Class!! */;
        this.detailsPanel = this.createDetailsPanel();
        this.contentPanel = this.detailsPanel.getContentPanel();
    }

    public JPanel getComponent() {
        return this.contentPanel;
    }

    private DetailsPanel createDetailsPanel() {
        DetailsPanel detailsPanel = new DetailsPanel(this, new InfoModel());
        Consumer<SoftwareVersion> firmwareUpdateConsumer = sw -> {
            NodeInterface node = this.selectedNode;
            JFrame frame = (JFrame)JOptionPane.getFrameForComponent(this.getComponent());
            SoftwareVersion newFirmware = node.getUpdateFirmwareVersion();
            LOGGER.info("Show the firmware update dialog for node: {}, newFirmware: {}", (Object)node, (Object)newFirmware);
            FirmwareController firmwareController = this.firmwareControllerFactory.createFirmwareController(this.firmwareRepoService, node, frame);
            firmwareController.start(newFirmware);
        };
        detailsPanel.preparePanel(firmwareUpdateConsumer);
        return detailsPanel;
    }

    public void nodeChanged() {
        LOGGER.info("The selected node has changed.");
        this.updateComponentState();
    }

    private void updateComponentState() {
        NodeInterface node = this.mainModel.getSelectedNode();
        if (this.selectedNode != null && !this.selectedNode.equals(node)) {
            this.selectedNode.getNode().removePropertyChangeListener(this.nodeListener);
        }
        if (CollectionUtils.isEmpty((Collection)this.featureCodes)) {
            LOGGER.info("Get the feature codes and the vendors.");
            this.featureCodes = BidibFactory.getFeatureCodes();
            this.vendors = DecoderVendorFactory.getDecoderVendors();
            LOGGER.info("Get the feature codes and the vendors has finished.");
        }
        InfoModel infoModel = (InfoModel)this.detailsPanel.getPresentationModel().getBean();
        if (node != null) {
            infoModel.setFeatures(null);
            this.selectedNode = node;
            this.selectedNode.getNode().addPropertyChangeListener(this.nodeListener);
            this.updateNodeInfo(node);
        } else {
            infoModel.setFeatures(null);
            this.selectedNode = null;
        }
    }

    private void updateNodeInfo(NodeInterface node) {
        String productName;
        if (node == null) {
            this.detailsPanel.getFirmwareUpdateButton().setEnabled(false);
            return;
        }
        Node coreNode = node.getNode();
        LOGGER.info("Update the node info panel for node: {}, coreNode: {}, coreNode identity: {}", new Object[]{node, coreNode, coreNode.getIdentity()});
        long uniqueId = node.getUniqueId();
        int vendorId = NodeUtils.getVendorId((long)node.getUniqueId());
        int productId = NodeUtils.getPid((long)node.getUniqueId(), (int)coreNode.getRelevantPidBits());
        LOGGER.info("Search for vendorId: {} (0x{}), productId: {} (0x{})", new Object[]{vendorId, ByteUtils.intToHex((int)vendorId), productId, ByteUtils.intToHex((int)productId)});
        Optional product = this.lookupService.getProduct(vendorId, productId);
        StringBuilder description = new StringBuilder();
        String url = null;
        if (product.isPresent()) {
            productName = ((ProductType)product.get()).getName();
            String language = XmlLocaleUtils.getXmlLocale();
            DocumentationType doc = ProductsUtils.getDocumentationOfLanguage((ProductType)((ProductType)product.get()), (String)language);
            if (doc != null) {
                if (StringUtils.isNotBlank((CharSequence)doc.getText())) {
                    description.append(doc.getText());
                } else {
                    description.append(productName);
                }
                if (StringUtils.isNotBlank((CharSequence)doc.getDescription())) {
                    description.append(" - ").append(doc.getDescription());
                }
                url = doc.getUrl();
            } else {
                description.append(productName);
            }
        } else {
            LOGGER.info("No products available to get the description for node: {}", (Object)node);
        }
        if (description.length() == 0) {
            description.append(Resources.getString(this.getClass(), (String)"product-unknown"));
        }
        if (StringUtils.isBlank((CharSequence)(productName = coreNode.getStoredString(0)))) {
            productName = "";
        }
        PresentationModel presentationModel = this.detailsPanel.getPresentationModel();
        InfoModel infoModel = (InfoModel)presentationModel.getBean();
        infoModel.setDescription(description.toString());
        infoModel.setProductName(productName);
        infoModel.setVendor(DecoderVendorFactory.getDecoderVendorName((List)this.vendors, (int)vendorId));
        infoModel.setHomepage(url);
        infoModel.setUniqueId(Long.valueOf(uniqueId));
        infoModel.setUserName(BidibNodeNameUtils.getNodeName((NodeInterface)node));
        infoModel.setAddress(NodeUtils.formatAddressLong((byte[])coreNode.getAddr()));
        infoModel.setFirmware(coreNode.getSoftwareVersion());
        infoModel.setProtocol(coreNode.getProtocolVersion() != null ? coreNode.getProtocolVersion().toString() : null);
        infoModel.setFeatures(Collections.unmodifiableList(this.getSortedFeatures(node)));
        this.detailsPanel.resortFeaturesTable();
        this.detailsPanel.getFirmwareUpdateButton().setEnabled(node.isUpdatable());
        try {
            LOGGER.debug("Size of container: {}", (Object)this.imageContainer.getSize());
            ImageIcon icon = this.loadImage(vendorId, (long)productId, 200, 200);
            this.imageContainer.setIcon(icon);
        }
        catch (Exception ex) {
            LOGGER.warn("Load image of node failed, vid: {}, pid: {}.", new Object[]{vendorId, productId, ex});
            this.imageContainer.setIcon(null);
        }
    }

    private List<Feature> getSortedFeatures(NodeInterface node) {
        ArrayList<Feature> features = new ArrayList<Feature>();
        features.addAll(node.getNode().getFeatures());
        Collections.sort(features, (o1, o2) -> o1.getType() - o2.getType());
        return features;
    }

    private static String getFeatureUnit(List<FeatureCode> featureCodes, Feature feature) {
        if (feature != null && feature.getFeatureEnum() != null) {
            String featureUnit;
            switch (3.$SwitchMap$org$bidib$jbidibc$messages$enums$FeatureEnum[feature.getFeatureEnum().ordinal()]) {
                case 1: {
                    return String.format("%d mA", ConversionUtils.convertCurrent((int)feature.getValue()));
                }
            }
            FeatureCode featureCode = (FeatureCode)IterableUtils.find(featureCodes, (Predicate)new /* Unavailable Anonymous Inner Class!! */);
            if (featureCode != null && StringUtils.isNotEmpty((CharSequence)(featureUnit = featureCode.getUnit()))) {
                return featureUnit;
            }
        }
        return " ";
    }

    private ImageIcon loadImage(int vendorId, long productId, int width, int height) {
        String labelPath = this.settingsService.getMiscSettings().getBidibConfigDir();
        String searchPathUser = "/data/images";
        File fileUser = new File(labelPath, searchPathUser);
        searchPathUser = fileUser.getPath();
        ImageIcon icon = null;
        File imageFile = new File(fileUser, "bidib-" + vendorId + "-" + productId + ".png");
        if (imageFile.exists()) {
            icon = ImageUtils.loadImageIcon((File)imageFile, (int)width, (int)height);
        }
        if (icon == null) {
            icon = ImageUtils.loadImageIcon(this.getClass(), (String)("/images/bidib-" + vendorId + "-" + productId + ".png"), (int)width, (int)height);
        }
        return icon;
    }
}

