/*
 * Decompiled with CFR 0.152.
 */
package org.bidib.wizard.mvc.stepcontrol.view;

import com.jgoodies.binding.PresentationModel;
import com.jgoodies.binding.adapter.BoundedRangeAdapter;
import com.jgoodies.binding.list.IndirectListModel;
import com.jgoodies.binding.list.SelectionInList;
import com.jgoodies.binding.value.AbstractValueModel;
import com.jgoodies.binding.value.BindingConverter;
import com.jgoodies.binding.value.ConverterFactory;
import com.jgoodies.binding.value.ConverterValueModel;
import com.jgoodies.binding.value.ValueHolder;
import com.jgoodies.binding.value.ValueModel;
import com.jgoodies.common.base.Objects;
import com.jgoodies.common.collect.ArrayListModel;
import com.jgoodies.forms.builder.ButtonBarBuilder;
import com.jgoodies.forms.builder.FormBuilder;
import com.jgoodies.forms.debug.FormDebugPanel;
import com.jgoodies.forms.factories.Paddings;
import com.jidesoft.grid.DefaultExpandableRow;
import com.jidesoft.grid.RowStripeTableStyleProvider;
import com.jidesoft.grid.SortableTableModel;
import com.jidesoft.grid.TableStyleProvider;
import com.jidesoft.pane.CollapsiblePane;
import com.jidesoft.swing.DefaultOverlayable;
import com.jidesoft.swing.JideButton;
import com.jidesoft.swing.JideSplitPane;
import com.jidesoft.swing.JideSwingUtilities;
import com.jidesoft.swing.JideToggleButton;
import com.jidesoft.swing.NullJideButton;
import com.vlsolutions.swing.toolbars.ToolBarConstraints;
import com.vlsolutions.swing.toolbars.ToolBarPanel;
import com.vlsolutions.swing.toolbars.VLToolBar;
import eu.hansolo.steelseries.extras.Led;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Window;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.beans.PropertyChangeListener;
import java.beans.PropertyVetoException;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.InvocationTargetException;
import java.net.URL;
import java.text.DecimalFormat;
import java.text.Format;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Function;
import javax.swing.BorderFactory;
import javax.swing.BoundedRangeModel;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSlider;
import javax.swing.JTextField;
import javax.swing.ListModel;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.event.ChangeListener;
import javax.swing.event.ListDataListener;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.TableModelListener;
import javax.swing.filechooser.FileNameExtensionFilter;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableCellRenderer;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.collections4.MapUtils;
import org.bidib.jbidibc.core.node.ConfigurationVariable;
import org.bidib.jbidibc.exchange.vendorcv.CVType;
import org.bidib.jbidibc.exchange.vendorcv.DataType;
import org.bidib.jbidibc.messages.AccessoryState;
import org.bidib.jbidibc.messages.Feature;
import org.bidib.jbidibc.messages.enums.AccessoryExecutionState;
import org.bidib.jbidibc.messages.enums.FeatureEnum;
import org.bidib.jbidibc.messages.utils.ByteUtils;
import org.bidib.jbidibc.messages.utils.ProductUtils;
import org.bidib.wizard.api.locale.Resources;
import org.bidib.wizard.api.model.Accessory;
import org.bidib.wizard.api.model.NodeInterface;
import org.bidib.wizard.api.model.SwitchingNodeInterface;
import org.bidib.wizard.api.model.listener.CvDefinitionRequestListener;
import org.bidib.wizard.api.model.listener.FeedbackPortListener;
import org.bidib.wizard.api.model.listener.PortValueListener;
import org.bidib.wizard.client.common.controller.FeedbackPortStatusChangeProvider;
import org.bidib.wizard.client.common.converter.StringToUnsignedLongConverter;
import org.bidib.wizard.client.common.text.WizardComponentFactory;
import org.bidib.wizard.client.common.view.BusyFrame;
import org.bidib.wizard.client.common.view.TabPanelProvider;
import org.bidib.wizard.client.common.view.cvdef.CvDefinitionTreeTableModel;
import org.bidib.wizard.client.common.view.cvdef.CvNode;
import org.bidib.wizard.client.common.view.cvdef.CvNodeUtils;
import org.bidib.wizard.client.common.view.cvdef.LongCvNode;
import org.bidib.wizard.client.common.view.listener.TabStatusListener;
import org.bidib.wizard.client.common.view.statusbar.StatusBar;
import org.bidib.wizard.common.context.DefaultApplicationContext;
import org.bidib.wizard.common.model.settings.ExperimentalSettingsInterface;
import org.bidib.wizard.common.script.switching.AccessoryScripting;
import org.bidib.wizard.common.service.SettingsService;
import org.bidib.wizard.common.utils.ImageUtils;
import org.bidib.wizard.model.ports.MotorPort;
import org.bidib.wizard.model.status.SpeedSteps;
import org.bidib.wizard.mvc.common.view.cvdefinition.CvDefinitionPanelProvider;
import org.bidib.wizard.mvc.common.view.cvdefinition.CvValueUtils;
import org.bidib.wizard.mvc.main.controller.CvDefinitionPanelController;
import org.bidib.wizard.mvc.main.model.MainModel;
import org.bidib.wizard.mvc.main.view.panel.listener.TabSelectionListener;
import org.bidib.wizard.mvc.stepcontrol.controller.StepControlControllerInterface;
import org.bidib.wizard.mvc.stepcontrol.model.AccelarationScaleEnum;
import org.bidib.wizard.mvc.stepcontrol.model.AspectExecutionModel;
import org.bidib.wizard.mvc.stepcontrol.model.AspectReference;
import org.bidib.wizard.mvc.stepcontrol.model.ConfigurationWizardModel;
import org.bidib.wizard.mvc.stepcontrol.model.CvConsoleModel;
import org.bidib.wizard.mvc.stepcontrol.model.MicroStepsEnum;
import org.bidib.wizard.mvc.stepcontrol.model.MotorSizeType;
import org.bidib.wizard.mvc.stepcontrol.model.MovementScaleEnum;
import org.bidib.wizard.mvc.stepcontrol.model.StepControlAspect;
import org.bidib.wizard.mvc.stepcontrol.model.StepControlModel;
import org.bidib.wizard.mvc.stepcontrol.model.TurnTableType;
import org.bidib.wizard.mvc.stepcontrol.view.AngleRenderer;
import org.bidib.wizard.mvc.stepcontrol.view.AspectCallbackListener;
import org.bidib.wizard.mvc.stepcontrol.view.AspectCellRenderer;
import org.bidib.wizard.mvc.stepcontrol.view.AspectEditorPanel;
import org.bidib.wizard.mvc.stepcontrol.view.AspectTable;
import org.bidib.wizard.mvc.stepcontrol.view.AspectTableModel;
import org.bidib.wizard.mvc.stepcontrol.view.ConfigurationWizard;
import org.bidib.wizard.mvc.stepcontrol.view.MotorSlider;
import org.bidib.wizard.mvc.stepcontrol.view.PositionOutOfRangeException;
import org.bidib.wizard.mvc.stepcontrol.view.ScriptPanel;
import org.bidib.wizard.mvc.stepcontrol.view.SpeedRangeValidationUtils;
import org.bidib.wizard.mvc.stepcontrol.view.StepControlAspectCellRenderer;
import org.bidib.wizard.mvc.stepcontrol.view.StepControlCvUtils;
import org.bidib.wizard.mvc.stepcontrol.view.StepControlPanel;
import org.bidib.wizard.mvc.stepcontrol.view.TurntableIconPanel;
import org.bidib.wizard.mvc.stepcontrol.view.excel.ExcelAspectReader;
import org.bidib.wizard.mvc.stepcontrol.view.excel.ImportAspect;
import org.oxbow.swingbits.dialog.task.TaskDialogs;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.Assert;

public class StepControlPanel
implements TabSelectionListener,
CvDefinitionPanelProvider,
TabPanelProvider,
PortValueListener<MotorPort>,
AccessoryScripting {
    private static final Logger LOGGER = LoggerFactory.getLogger(StepControlPanel.class);
    private static final String EMERGENCY_STOP = "<html><font color='red'><b>EMERGENCY STOP</b></font></html>";
    private static final String OPERATING = "<html><b>OPERATING</b></html>";
    private static final String HOMING_IN_PROGRESS = "<html><b>HOMING</b></html>";
    private static final String UNKNOWN = "<html><b>UNKNOWN</b></html>";
    private static final String READ = "read";
    private static final String WRITE = "write";
    private static final long INACTIVE_POSITION_VALUE = 0xFFFFFFFFL;
    private final StepControlModel stepControlModel;
    private final TabStatusListener tabStatusListener;
    private final FeedbackPortStatusChangeProvider feedbackPortStatusChangeProvider;
    private AspectTable aspectTable;
    private JPanel component;
    private NodeInterface selectedNode;
    private IndirectListModel<StepControlAspect> aspectSelection;
    private PresentationModel<StepControlModel> stepControlPresentationModel;
    private ImageIcon accessoryErrorIcon;
    private ImageIcon accessorySuccessfulIcon;
    private ImageIcon accessoryWaitIcon;
    private ImageIcon accessoryUnknownIcon;
    private ImageIcon emergencyStopIcon;
    private ImageIcon normalOperatingIcon;
    private ImageIcon homingInProgressIcon;
    private ImageIcon selectedIcon;
    private ImageIcon unselectedIcon;
    private ImageIcon emptyIcon;
    private ImageIcon errorIcon;
    private JLabel operationalStateIconLabel = new JLabel();
    private JLabel executionStateIconLabel = new JLabel();
    private final List<CvDefinitionRequestListener> cvDefinitionRequestListeners = new LinkedList();
    private Map<String, CvNode> mapKeywordToNode;
    private final List<ConfigurationVariable> requiredConfigVariables = new LinkedList();
    private final MainModel mainModel;
    private boolean initialized;
    private final StatusBar statusBar;
    private final List<String> fieldsToUpdate = new LinkedList();
    private final List<Led> occupancyLeds = new LinkedList();
    private JButton readCvButton;
    private JButton writeCvButton;
    private VLToolBar toolbarCvDefinition;
    private double degreeOffset;
    private TurntableIconPanel turntableIconPanel;
    private AngleRenderer angleRenderer;
    private boolean showMotorSliderEditor = false;
    private MotorSlider motorSliderEditor;
    private MotorPort selectedMotorPort;
    private StepControlControllerInterface stepControlController;
    private Map<String, JideButton> functionButtonMap = new HashMap();
    private JPanel functionButtonParentPanel;
    private JSlider speedSlider;
    private ValueModel speedModel;
    private BoundedRangeAdapter boundedRangeAdapterSpeed;
    private JSlider accelSlider;
    private BoundedRangeAdapter boundedRangeAdapterAccel;
    private JSlider decelSlider;
    private BoundedRangeAdapter boundedRangeAdapterDecel;
    private JideToggleButton soundActiveButton;
    private JButton rotateTurnTableFlipButton;
    private ScriptPanel scriptPanel;
    private final SettingsService settingsService;
    private final AspectExecutionModel aspectExecutionModel;
    private TableModelListener aspectTableModelListener;
    private final AtomicBoolean cvValuesLoaded = new AtomicBoolean();

    public StepControlPanel(MainModel mainModel, StepControlModel stepControlModel, SettingsService settingsService, TabStatusListener tabStatusListener, FeedbackPortStatusChangeProvider feedbackPortStatusChangeProvider, StepControlControllerInterface stepControlController, StatusBar statusBar) {
        this.tabStatusListener = tabStatusListener;
        this.mainModel = mainModel;
        this.feedbackPortStatusChangeProvider = feedbackPortStatusChangeProvider;
        this.stepControlController = stepControlController;
        this.stepControlModel = stepControlModel;
        this.settingsService = settingsService;
        this.aspectExecutionModel = new AspectExecutionModel();
        this.aspectExecutionModel.setAccessoryId(Integer.valueOf(0));
        this.statusBar = statusBar;
    }

    private SortableTableModel getSortableTableModel() {
        return (SortableTableModel)this.aspectTable.getModel();
    }

    public void createComponent() {
        1 container = new /* Unavailable Anonymous Inner Class!! */;
        boolean debug = false;
        FormBuilder formBuilder = FormBuilder.create().columns("p, 3dlu, fill:p:g", new Object[0]).rows("p, 3dlu, p", new Object[0]).panel((JPanel)(debug ? new DebugPanel((TabSelectionListener)this) : container));
        formBuilder.border((Border)Paddings.TABBED_DIALOG);
        this.initializeAccessoryStateIcons();
        this.aspectSelection = new SelectionInList((ListModel)this.stepControlModel.getStepControlAspectsListModel());
        this.stepControlPresentationModel = new PresentationModel((ValueModel)new ValueHolder((Object)this.stepControlModel, true));
        this.operationalStateIconLabel = new JLabel(UNKNOWN);
        formBuilder.add(Resources.getString(StepControlPanel.class, (String)"operational_state"), new Object[0]).xy(1, 1);
        formBuilder.add((Component)this.operationalStateIconLabel).xy(3, 1);
        this.operationalStateIconLabel.setIcon(this.accessoryUnknownIcon);
        this.executionStateIconLabel = new JLabel();
        formBuilder.add(Resources.getString(StepControlPanel.class, (String)"execution_state"), new Object[0]).xy(1, 3);
        formBuilder.add((Component)this.executionStateIconLabel).xy(3, 3);
        this.executionStateIconLabel.setIcon(this.accessoryUnknownIcon);
        formBuilder.appendRows("5dlu", new Object[0]);
        this.aspectTable = this.createAspectTable();
        JScrollPane scrollPane = new JScrollPane((Component)this.aspectTable);
        DefaultOverlayable overlayAspectTable = new DefaultOverlayable((JComponent)scrollPane);
        this.aspectTable.getModel().addTableModelListener((TableModelListener)new /* Unavailable Anonymous Inner Class!! */);
        NullJideButton createAspectLinkButton = new NullJideButton(this.aspectTable.getEmptyTableText());
        createAspectLinkButton.setButtonStyle(3);
        createAspectLinkButton.addActionListener(evt -> this.fireCreateNewAspect());
        overlayAspectTable.addOverlayComponent((JComponent)createAspectLinkButton);
        JPanel detailsPanel = this.createDetailsPanel();
        JideSplitPane jideSplitPane = new JideSplitPane(1);
        jideSplitPane.add((Component)overlayAspectTable, (Object)"flexible");
        jideSplitPane.add((Component)new JScrollPane(detailsPanel), (Object)"flexible");
        jideSplitPane.setShowGripper(true);
        formBuilder.appendRows("fill:300dlu:g", new Object[0]);
        formBuilder.add((Component)jideSplitPane).xyw(1, 5, 3);
        this.component = formBuilder.build();
        this.component.setName(this.getName());
        this.stepControlModel.addPropertyChangeListener((PropertyChangeListener)new /* Unavailable Anonymous Inner Class!! */);
        this.speedSlider.addChangeListener((ChangeListener)new /* Unavailable Anonymous Inner Class!! */);
        this.accelSlider.addChangeListener((ChangeListener)new /* Unavailable Anonymous Inner Class!! */);
        this.decelSlider.addChangeListener((ChangeListener)new /* Unavailable Anonymous Inner Class!! */);
        this.toolbarCvDefinition = new VLToolBar("stepControlCvDefinition");
        this.addToolBarButtons(this.toolbarCvDefinition);
        this.addToolBar(this.toolbarCvDefinition, new ToolBarConstraints(0, 2));
        this.toolbarCvDefinition.setVisible(false);
        this.feedbackPortStatusChangeProvider.addFeedbackPortListener((FeedbackPortListener)new /* Unavailable Anonymous Inner Class!! */);
    }

    private JPanel createDetailsPanel() {
        boolean debugDetail = false;
        FormBuilder detailFormBuilder = FormBuilder.create().columns("p, 3dlu, p, 3dlu, p, 3dlu, p, 3dlu, p, 3dlu, p, 3dlu, p:g", new Object[0]).rows("p, 3dlu, p, 3dlu, p, 3dlu, p", new Object[0]).panel((JPanel)(debugDetail ? new FormDebugPanel() : new JPanel()));
        detailFormBuilder.border((Border)Paddings.DLU4);
        ImageIcon iconConfigurationWizard = ImageUtils.createImageIcon(StepControlPanel.class, (String)"/icons/16x16/wrench.png");
        JButton startConfigurationWizard = new JButton(Resources.getString(StepControlPanel.class, (String)"button.wizard"), iconConfigurationWizard);
        startConfigurationWizard.addActionListener((ActionListener)new /* Unavailable Anonymous Inner Class!! */);
        detailFormBuilder.add((Component)this.buildLeftAlignedButtonBar(new JComponent[]{startConfigurationWizard})).xyw(1, 1, 13);
        boolean debugPosition = false;
        FormBuilder positionFormBuilder = FormBuilder.create().columns("max(40dlu;p), 3dlu, p, 6dlu, p, 3dlu, max(40dlu;p), 3dlu, p:g", new Object[0]).rows("p", new Object[0]).panel((JPanel)(debugPosition ? new FormDebugPanel() : new JPanel()));
        positionFormBuilder.border((Border)Paddings.EMPTY);
        ConverterValueModel currentPositionConverterModel = new ConverterValueModel((ValueModel)this.stepControlPresentationModel.getModel("currentPosition"), (BindingConverter)new StringToUnsignedLongConverter());
        JTextField currentPosition = WizardComponentFactory.createTextField((ValueModel)currentPositionConverterModel);
        currentPosition.setEditable(false);
        positionFormBuilder.add((Component)currentPosition).xy(1, 1);
        JButton getPosition = new JButton(Resources.getString(StepControlPanel.class, (String)"get_position"));
        getPosition.setToolTipText(Resources.getString(StepControlPanel.class, (String)"get_position.tooltip"));
        getPosition.addActionListener((ActionListener)new /* Unavailable Anonymous Inner Class!! */);
        positionFormBuilder.add((Component)getPosition).xy(3, 1);
        ValueHolder directPositionModel = new ValueHolder();
        ConverterValueModel directPositionConverterModel = new ConverterValueModel((ValueModel)directPositionModel, (BindingConverter)new StringToUnsignedLongConverter());
        JTextField directPosition = WizardComponentFactory.createTextField((ValueModel)directPositionConverterModel, (boolean)false);
        positionFormBuilder.addLabel(Resources.getString(StepControlPanel.class, (String)"direct"), new Object[0]).xy(5, 1);
        positionFormBuilder.add((Component)directPosition).xy(7, 1);
        JButton setPosition = new JButton(Resources.getString(StepControlPanel.class, (String)"set_position"));
        setPosition.setToolTipText(Resources.getString(StepControlPanel.class, (String)"set_position.tooltip"));
        setPosition.addActionListener((ActionListener)new /* Unavailable Anonymous Inner Class!! */);
        ImageIcon turntableRotateFlipIcon = ImageUtils.loadImageIcon(StepControlPanel.class, (String)"/icons/stepcontrol/turntable-rotate-half.png", (int)16, (int)16);
        this.rotateTurnTableFlipButton = new JButton(turntableRotateFlipIcon);
        this.rotateTurnTableFlipButton.setToolTipText(Resources.getString(StepControlPanel.class, (String)"rotateFlip.tooltip"));
        this.rotateTurnTableFlipButton.addActionListener((ActionListener)new /* Unavailable Anonymous Inner Class!! */);
        JButton leftStepsPosition = new JButton(Resources.getString(StepControlPanel.class, (String)"left_steps_position"));
        leftStepsPosition.setToolTipText(Resources.getString(StepControlPanel.class, (String)"left_steps_position.tooltip"));
        leftStepsPosition.addActionListener((ActionListener)new /* Unavailable Anonymous Inner Class!! */);
        JButton leftSingleStepPosition = new JButton(Resources.getString(StepControlPanel.class, (String)"left_single_step_position"));
        leftSingleStepPosition.setToolTipText(Resources.getString(StepControlPanel.class, (String)"left_single_step_position.tooltip"));
        leftSingleStepPosition.addActionListener((ActionListener)new /* Unavailable Anonymous Inner Class!! */);
        JButton rightSingleStepPosition = new JButton(Resources.getString(StepControlPanel.class, (String)"right_single_step_position"));
        rightSingleStepPosition.setToolTipText(Resources.getString(StepControlPanel.class, (String)"right_single_step_position.tooltip"));
        rightSingleStepPosition.addActionListener((ActionListener)new /* Unavailable Anonymous Inner Class!! */);
        JButton rightStepsPosition = new JButton(Resources.getString(StepControlPanel.class, (String)"right_steps_position"));
        rightStepsPosition.setToolTipText(Resources.getString(StepControlPanel.class, (String)"right_steps_position.tooltip"));
        rightStepsPosition.addActionListener((ActionListener)new /* Unavailable Anonymous Inner Class!! */);
        JComponent buttonBar = this.buildLeftAlignedButtonBar(new JComponent[]{setPosition, leftStepsPosition, leftSingleStepPosition, rightSingleStepPosition, rightStepsPosition, this.rotateTurnTableFlipButton});
        positionFormBuilder.add((Component)buttonBar).xy(9, 1);
        detailFormBuilder.addLabel(Resources.getString(StepControlPanel.class, (String)"position"), new Object[0]).xy(1, 3);
        detailFormBuilder.add((Component)positionFormBuilder.build()).xyw(3, 3, 11);
        JPanel speedSlidersPanel = this.createSpeedSlidersPanel();
        detailFormBuilder.add((Component)speedSlidersPanel).xyw(1, 5, 13);
        Led occupancy1 = new Led();
        occupancy1.setPreferredSize(new Dimension(32, 32));
        Led occupancy2 = new Led();
        occupancy2.setPreferredSize(new Dimension(32, 32));
        Led occupancy3 = new Led();
        occupancy3.setPreferredSize(new Dimension(32, 32));
        Led occupancy4 = new Led();
        occupancy4.setPreferredSize(new Dimension(32, 32));
        this.occupancyLeds.add(occupancy1);
        this.occupancyLeds.add(occupancy2);
        this.occupancyLeds.add(occupancy3);
        this.occupancyLeds.add(occupancy4);
        detailFormBuilder.addLabel(Resources.getString(StepControlPanel.class, (String)"occupancy"), new Object[0]).xy(1, 7);
        detailFormBuilder.add((Component)this.buildLeftAlignedButtonBar(new JComponent[]{occupancy1, occupancy2, occupancy3, occupancy4})).xyw(3, 7, 11);
        detailFormBuilder.appendRows("3dlu, top:p:g", new Object[0]);
        JPanel turnTablePanel = this.createTurnTablePanel();
        detailFormBuilder.add((Component)turnTablePanel).xyw(1, 9, 13);
        return detailFormBuilder.build();
    }

    private JPanel createSpeedSlidersPanel() {
        boolean debug = false;
        FormBuilder detailFormBuilder = FormBuilder.create().columns("p, 3dlu, p, 3dlu, p:g:fill", new Object[0]).rows("p, 3dlu, p, 3dlu, p", new Object[0]).panel((JPanel)(debug ? new FormDebugPanel() : new JPanel()));
        detailFormBuilder.border((Border)Paddings.EMPTY);
        int row = 1;
        if (this.showMotorSliderEditor) {
            detailFormBuilder.appendRows("3dlu, p", new Object[0]);
            this.motorSliderEditor = new MotorSlider(-SpeedSteps.DCC128.getSteps(), SpeedSteps.DCC128.getSteps());
            this.motorSliderEditor.setEnabled(false);
            JPanel sliderComponent = this.motorSliderEditor.getComponent();
            detailFormBuilder.addLabel("Motor", new Object[0]).xy(1, row);
            detailFormBuilder.add((Component)sliderComponent).xy(3, row);
            row += 2;
        }
        this.speedModel = this.stepControlPresentationModel.getModel("speed");
        this.speedSlider = new JSlider();
        this.speedSlider.setOpaque(false);
        int maxSpeed = 2001;
        int minSpeed = 1;
        LOGGER.info("Use initial speed range, min: {}, max: {}", (Object)minSpeed, (Object)maxSpeed);
        this.boundedRangeAdapterSpeed = new BoundedRangeAdapter(this.speedModel, 0, minSpeed, maxSpeed);
        this.speedSlider.setModel((BoundedRangeModel)this.boundedRangeAdapterSpeed);
        JLabel speedLabel = WizardComponentFactory.createLabel((ValueModel)ConverterFactory.createStringConverter((ValueModel)this.speedModel, (Format)new DecimalFormat("#####")));
        speedLabel.setPreferredSize(new Dimension(40, speedLabel.getPreferredSize().height));
        speedLabel.setHorizontalAlignment(4);
        detailFormBuilder.addLabel(Resources.getString(StepControlPanel.class, (String)"speed"), new Object[0]).xy(1, row);
        detailFormBuilder.add((Component)speedLabel).xy(3, row);
        detailFormBuilder.add((Component)this.speedSlider).xy(5, row);
        row += 2;
        AbstractValueModel accelModel = this.stepControlPresentationModel.getModel("accel");
        this.accelSlider = new JSlider();
        this.boundedRangeAdapterAccel = new BoundedRangeAdapter((ValueModel)accelModel, 1, 1, 65536);
        this.accelSlider.setModel((BoundedRangeModel)this.boundedRangeAdapterAccel);
        this.accelSlider.setOpaque(false);
        JLabel accelLabel = WizardComponentFactory.createLabel((ValueModel)ConverterFactory.createStringConverter((ValueModel)accelModel, (Format)new DecimalFormat("#####")));
        accelLabel.setHorizontalAlignment(4);
        detailFormBuilder.addLabel(Resources.getString(StepControlPanel.class, (String)"accel"), new Object[0]).xy(1, row);
        detailFormBuilder.add((Component)accelLabel).xy(3, row);
        detailFormBuilder.add((Component)this.accelSlider).xy(5, row);
        row += 2;
        AbstractValueModel decelModel = this.stepControlPresentationModel.getModel("decel");
        this.decelSlider = new JSlider();
        this.boundedRangeAdapterDecel = new BoundedRangeAdapter((ValueModel)decelModel, 1, 1, 65536);
        this.decelSlider.setModel((BoundedRangeModel)this.boundedRangeAdapterDecel);
        this.decelSlider.setOpaque(false);
        JLabel decelLabel = WizardComponentFactory.createLabel((ValueModel)ConverterFactory.createStringConverter((ValueModel)decelModel, (Format)new DecimalFormat("#####")));
        decelLabel.setHorizontalAlignment(4);
        detailFormBuilder.addLabel(Resources.getString(StepControlPanel.class, (String)"decel"), new Object[0]).xy(1, row);
        detailFormBuilder.add((Component)decelLabel).xy(3, row);
        detailFormBuilder.add((Component)this.decelSlider).xy(5, row);
        JPanel speedSliderPanel = detailFormBuilder.build();
        CollapsiblePane pane = new CollapsiblePane(Resources.getString(StepControlPanel.class, (String)"pane-speed-and-accelaration"));
        ImageIcon speedAndAccelarationIcon = ImageUtils.createImageIcon(StepControlPanel.class, (String)"/icons/16x16/wrench.png");
        pane.setIcon((Icon)speedAndAccelarationIcon);
        pane.setContentPane((JComponent)JideSwingUtilities.createTopPanel((Component)speedSliderPanel));
        try {
            pane.setCollapsed(true);
        }
        catch (PropertyVetoException ex) {
            LOGGER.warn("Collapse pane was vetoed.", (Throwable)ex);
        }
        return pane;
    }

    private JPanel createTurnTablePanel() {
        boolean debugTTFB = false;
        FormBuilder turntableFormBuilder = FormBuilder.create().columns("p, 3dlu, p, 10dlu, p:g", new Object[0]).rows("top:p:g", new Object[0]).panel((JPanel)(debugTTFB ? new FormDebugPanel() : new JPanel()));
        this.turntableIconPanel = this.prepareTurntableIconPanel();
        JPanel contentPanel = new JPanel(new BorderLayout());
        contentPanel.setMinimumSize(new Dimension(140, 140));
        contentPanel.setPreferredSize(new Dimension(140, 140));
        contentPanel.setOpaque(true);
        contentPanel.add((Component)this.turntableIconPanel, "Center");
        turntableFormBuilder.add((Component)contentPanel).xy(1, 1);
        this.functionButtonParentPanel = new JPanel();
        turntableFormBuilder.add((Component)this.functionButtonParentPanel).xy(3, 1);
        if (this.settingsService.getWizardSettings().isPowerUser()) {
            this.scriptPanel = new ScriptPanel((AccessoryScripting)this, this.settingsService);
            JPanel panel = this.scriptPanel.createPanel();
            panel.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), Resources.getString(this.getClass(), (String)"script") + ":"));
            turntableFormBuilder.add((Component)panel).xy(5, 1);
        } else {
            LOGGER.info("The script panel for StepControl is skipped because the user is not a power user.");
        }
        return turntableFormBuilder.build();
    }

    private TurntableIconPanel prepareTurntableIconPanel() {
        ExperimentalSettingsInterface experimentalSettings = this.settingsService.getExperimentalSettings();
        experimentalSettings.addPropertyChangeListener("turntableAngleOffset", evt -> {
            this.degreeOffset = experimentalSettings.getTurntableAngleOffset();
            double currentDegrees = this.stepControlModel.getTurntableCurrentDegrees();
            this.setTurntableDegrees(currentDegrees);
        });
        this.degreeOffset = experimentalSettings.getTurntableAngleOffset();
        ImageIcon turntableBackgroundIcon = ImageUtils.loadImageIcon(StepControlPanel.class, (String)"/icons/stepcontrol/turntable-bg.png", (int)120, (int)120);
        ImageIcon turntableBackgroundLinearIcon = ImageUtils.loadImageIcon(StepControlPanel.class, (String)"/icons/stepcontrol/turntable-bg-linear.png", (int)120, (int)120);
        ImageIcon turntableBasicIcon = ImageUtils.loadImageIcon(StepControlPanel.class, (String)"/icons/stepcontrol/turntable-platform.png", (int)110, (int)110);
        TurntableIconPanel turntableIconPanel = new TurntableIconPanel(turntableBackgroundIcon, turntableBackgroundLinearIcon, turntableBasicIcon, this.degreeOffset, TurnTableType.unknown);
        turntableIconPanel.prepareComponent();
        turntableIconPanel.setMinimumSize(new Dimension(140, 140));
        turntableIconPanel.setPreferredSize(new Dimension(140, 140));
        turntableIconPanel.setBounds(0, 0, 140, 140);
        return turntableIconPanel;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void turnTableTypeChanged(AspectTable aspectTable, boolean initial) {
        TurnTableType turnTableType = this.stepControlModel.getTurnTableType();
        LOGGER.info("The turntable type has changed: {}", (Object)turnTableType);
        aspectTable.turnTableTypeChanged(turnTableType);
        if (this.turntableIconPanel != null) {
            this.turntableIconPanel.setTurnTableType(turnTableType);
        }
        if (!initial && this.selectedNode != null) {
            int maxConfiguredAspects = 48;
            if (TurnTableType.round == turnTableType) {
                maxConfiguredAspects = 24;
            }
            this.stepControlModel.setMaxConfiguredAspects(maxConfiguredAspects);
            LOGGER.info("The turnTableType was set to: {}, maxConfiguredAspects: {}", (Object)turnTableType, (Object)maxConfiguredAspects);
            Map cvNumberToNodeMap = this.getCvNumberToNodeMap(this.selectedNode);
            AtomicBoolean errorDetected = new AtomicBoolean();
            List configuredAspects = this.prepareConfiguredAspects(cvNumberToNodeMap, errorDetected);
            try {
                aspectTable.getModel().removeTableModelListener(this.aspectTableModelListener);
                this.stepControlModel.setStepControlAspects(configuredAspects);
            }
            finally {
                aspectTable.getModel().addTableModelListener(this.aspectTableModelListener);
            }
            this.aspectTable.expandAllRows();
        }
    }

    private AspectTable createAspectTable() {
        AspectTableModel tableModel = new AspectTableModel(this.aspectSelection, new String[]{Resources.getString(StepControlPanel.class, (String)"aspect"), Resources.getString(StepControlPanel.class, (String)"position"), Resources.getString(StepControlPanel.class, (String)"angle"), Resources.getString(StepControlPanel.class, (String)"polarity")}, this.stepControlModel);
        AddAspectCallbackListener aspectCallbackListener = new AddAspectCallbackListener(this);
        this.selectedIcon = ImageUtils.createImageIcon(StepControlPanel.class, (String)"/icons/stepcontrol/arrow_straight.png");
        this.unselectedIcon = ImageUtils.createImageIcon(StepControlPanel.class, (String)"/icons/stepcontrol/arrow_switch.png");
        AspectTable aspectTable = new AspectTable(tableModel, Resources.getString(StepControlPanel.class, (String)"emptyTable"), this.selectedIcon, this.unselectedIcon, (AspectCallbackListener)aspectCallbackListener);
        aspectTable.setTableStyleProvider((TableStyleProvider)new RowStripeTableStyleProvider(new Color[]{UIManager.getColor("tableRowStripe.background"), UIManager.getColor("tableRowStripe.alternativeBackground")}));
        aspectTable.setName("Aspect Table");
        aspectTable.setRowHeight(24);
        aspectTable.setSortingEnabled(false);
        aspectTable.setAutoResort(true);
        aspectTable.sortColumn(1);
        aspectTable.setShowSortOrderNumber(false);
        aspectTable.setRestoreSelectionAndRowHeightAutomatically(true);
        aspectTable.setSelectionMode(0);
        aspectTable.getSelectionModel().addListSelectionListener((ListSelectionListener)new /* Unavailable Anonymous Inner Class!! */);
        aspectTable.createComponentFactory(this.stepControlModel);
        aspectTable.getColumnModel().getColumn(0).setPreferredWidth(80);
        aspectTable.getColumnModel().getColumn(0).setMaxWidth(80);
        aspectTable.getColumnModel().getColumn(0).setCellRenderer((TableCellRenderer)new AspectCellRenderer(this.stepControlModel));
        aspectTable.getColumnModel().getColumn(1).setPreferredWidth(100);
        aspectTable.getColumnModel().getColumn(1).setCellRenderer((TableCellRenderer)new StepControlAspectCellRenderer(this.stepControlModel, this.emptyIcon, this.errorIcon));
        aspectTable.setPreferredScrollableViewportSize(new Dimension(500, 200));
        AspectTablePopupMenu menu = new AspectTablePopupMenu(this);
        aspectTable.addMouseListener((MouseListener)new /* Unavailable Anonymous Inner Class!! */);
        JTableHeader header = aspectTable.getTableHeader();
        JideSwingUtilities.insertMouseListener((Component)header, (MouseListener)new /* Unavailable Anonymous Inner Class!! */, (int)0);
        this.turnTableTypeChanged(aspectTable, true);
        this.aspectSelection.addListDataListener((ListDataListener)new /* Unavailable Anonymous Inner Class!! */);
        return aspectTable;
    }

    protected void firePerformFlipRotate() {
        LOGGER.info("Rotate the turntable half.");
        this.fireGetPosition();
        Long value = this.stepControlModel.getCurrentPosition();
        if (value == null) {
            LOGGER.warn("The position value is null.");
            return;
        }
        Long totalSteps = this.stepControlModel.getTotalSteps();
        if (totalSteps == null) {
            LOGGER.warn("The total steps value is null.");
            return;
        }
        int currentPosition = value.intValue();
        if (this.stepControlModel.getSelectedAspect() != null && this.stepControlModel.getSelectedAspect().getPosition() == (long)currentPosition) {
            AspectReference oppositeAspect = this.stepControlModel.getSelectedAspect().getOppositeAspect();
            LOGGER.info("Flip turntable to opposite aspect: {}", (Object)oppositeAspect);
            this.firePerformAspect((StepControlAspect)oppositeAspect);
            return;
        }
        long targetPosition = (long)currentPosition + totalSteps / 2L;
        if (targetPosition >= totalSteps) {
            targetPosition -= totalSteps.longValue();
        }
        LOGGER.info("Calculated target position: {}", (Object)targetPosition);
        try {
            this.moveToTargetPosition((int)targetPosition);
        }
        catch (PositionOutOfRangeException ex) {
            LOGGER.info("Set direct position failed: {}", (Object)targetPosition);
            JOptionPane.showMessageDialog(this.component, Resources.getString(StepControlPanel.class, (String)"set_position_failed_message", (Object[])new Object[]{targetPosition}), Resources.getString(StepControlPanel.class, (String)"set_position_title"), 0);
        }
    }

    protected void fireGetPosition() {
        LOGGER.info("Read the current position value.");
        try {
            LinkedList cvList = new LinkedList();
            Function<List, List> prepareFunction = cvList1 -> this.prepareGetCurrentPosition(cvList1);
            Function<List, List> loadFunction = cvList1 -> this.fireLoadConfigVariablesPosition(cvList1);
            Function<List, List> prepareAndLoad = prepareFunction.andThen(loadFunction);
            List result = prepareAndLoad.apply(cvList);
            LOGGER.info("Fetched the current position: {}", (Object)result);
            Long currentPosition = Long.parseLong(((ConfigurationVariable)result.get(0)).getValue());
            this.stepControlModel.setCurrentPosition(currentPosition);
        }
        catch (Exception ex) {
            LOGGER.warn("Get the new {} value failed.", (Object)"STEPPOS", (Object)ex);
        }
    }

    private List<ConfigurationVariable> prepareGetCurrentPosition(List<ConfigurationVariable> cvList) {
        LOGGER.info("prepareGetCurrentPosition, current items in fieldsToUpdate: {}", (Object)this.fieldsToUpdate);
        this.fieldsToUpdate.clear();
        ConfigurationVariable cv = new ConfigurationVariable("STEPPOS", null);
        this.addConfigVariableDistinct(cvList, cv);
        Map cvNumberToNodeMap = this.getCvNumberToNodeMap(this.selectedNode);
        CvNode cvNode = (CvNode)cvNumberToNodeMap.get("STEPPOS");
        if (cvNode == null) {
            CVType cvType = new CVType();
            cvType.setNumber("STEPPOS");
            cvType.setType(DataType.STRING);
            cvNode = new CvNode(cvType, cv);
            LOGGER.info("Add the transient CvNode for current position: {}", (Object)cvNode);
            cvNumberToNodeMap.put("STEPPOS", cvNode);
        }
        return cvList;
    }

    protected void fireSetDirectPosition(Integer directPosition) {
        if (directPosition == null) {
            LOGGER.warn("The position value is null.");
            return;
        }
        int currentPosition = directPosition;
        try {
            this.moveToTargetPosition(currentPosition);
        }
        catch (PositionOutOfRangeException ex) {
            LOGGER.info("Set direct position failed: {}", (Object)currentPosition);
            JOptionPane.showMessageDialog(this.component, Resources.getString(StepControlPanel.class, (String)"set_position_failed_message", (Object[])new Object[]{currentPosition}), Resources.getString(StepControlPanel.class, (String)"set_position_title"), 0);
        }
    }

    protected void moveToTargetPosition(int targetPosition) throws PositionOutOfRangeException {
        LOGGER.info("Write the new target position value: {}", (Object)targetPosition);
        int maxPosition = 0;
        Long totalSteps = this.stepControlModel.getTotalSteps();
        if (totalSteps != null) {
            maxPosition = totalSteps.intValue();
        }
        if (targetPosition < 0 || targetPosition > maxPosition) {
            LOGGER.warn("Position is outside range.");
            throw new PositionOutOfRangeException();
        }
        try {
            LinkedList<ConfigurationVariable> cvList = new LinkedList<ConfigurationVariable>();
            ConfigurationVariable cv = new ConfigurationVariable("STEPPOS", Integer.toString(targetPosition));
            cvList.add(cv);
            Map cvNumberToNodeMap = this.getCvNumberToNodeMap(this.selectedNode);
            CvNode cvNode = (CvNode)cvNumberToNodeMap.get("STEPPOS");
            if (cvNode == null) {
                CVType cvType = new CVType();
                cvType.setNumber("STEPPOS");
                cvType.setType(DataType.STRING);
                cvNode = new CvNode(cvType, cv);
                LOGGER.info("Add the transient CvNode for current position: {}", (Object)cvNode);
                cvNumberToNodeMap.put("STEPPOS", cvNode);
            } else {
                cvNode.setNewValue((Object)Integer.toString(targetPosition));
            }
            this.fireWriteConfigVariablesPosition(cvList);
        }
        catch (Exception ex) {
            LOGGER.warn("Set the new {} value failed.", (Object)"STEPPOS", (Object)ex);
        }
    }

    public void setTurntableDegrees(double degree) {
        LOGGER.info("Set degree: {}", (Object)degree);
        if (this.turntableIconPanel != null) {
            if ((degree += this.degreeOffset) > 359.0) {
                degree -= 360.0;
            }
            this.turntableIconPanel.setDegrees(degree);
            this.turntableIconPanel.repaintTurntable();
        }
    }

    private void initializeAccessoryStateIcons() {
        this.accessoryErrorIcon = ImageUtils.createImageIcon(StepControlPanel.class, (String)"/icons/accessory-error.png");
        this.accessorySuccessfulIcon = ImageUtils.createImageIcon(StepControlPanel.class, (String)"/icons/accessory-successful.png");
        this.accessoryWaitIcon = ImageUtils.createImageIcon(StepControlPanel.class, (String)"/icons/accessory-wait.png");
        this.accessoryUnknownIcon = ImageUtils.createImageIcon(StepControlPanel.class, (String)"/icons/accessory-unknown.png");
        this.emergencyStopIcon = ImageUtils.createImageIcon(StepControlPanel.class, (String)"/icons/stepcontrol/emergency-stop.png", (int)16, (int)16);
        this.normalOperatingIcon = ImageUtils.createImageIcon(StepControlPanel.class, (String)"/icons/green-leaf.png");
        this.homingInProgressIcon = ImageUtils.createImageIcon(StepControlPanel.class, (String)"/icons/red-leaf.png");
        this.emptyIcon = ImageUtils.createImageIcon(StepControlPanel.class, (String)"/icons/empty.png");
        this.errorIcon = ImageUtils.createImageIcon(StepControlPanel.class, (String)"/icons/error-leaf.png");
    }

    private void firePerformAspect(StepControlAspect stepControlAspect) {
        LOGGER.info("Aspect is performed on stepControlAspect: {}", (Object)stepControlAspect);
        int aspectNumber = -1;
        for (int rowIndex = 0; rowIndex < this.aspectTable.getRowCount(); ++rowIndex) {
            StepControlAspect currentAspect = (StepControlAspect)this.getSortableTableModel().getValueAt(rowIndex, 1);
            if (!Objects.equals((Object)currentAspect.getPosition(), (Object)stepControlAspect.getPosition())) continue;
            aspectNumber = rowIndex;
            LOGGER.info("Found the aspect to activate at row: {}, aspectNumber: {}", (Object)rowIndex, (Object)aspectNumber);
            break;
        }
        this.firePerformAspect(aspectNumber);
    }

    private void firePerformOppositeAspect(StepControlAspect stepControlAspect) {
        LOGGER.info("Opposite aspect is performed on stepControlAspect: {}", (Object)stepControlAspect);
        int aspectNumber = -1;
        int totalRows = this.aspectTable.getRowCount();
        for (int rowIndex = 0; rowIndex < totalRows; ++rowIndex) {
            StepControlAspect currentAspect = (StepControlAspect)this.getSortableTableModel().getValueAt(rowIndex, 1);
            if (!Objects.equals((Object)currentAspect.getOppositePosition(), (Object)stepControlAspect.getOppositePosition())) continue;
            aspectNumber = rowIndex + totalRows;
            LOGGER.info("Found the opposite aspect to activate at row: {}, aspectNumber: {}", (Object)rowIndex, (Object)aspectNumber);
            break;
        }
        this.firePerformAspect(aspectNumber);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void firePerformAspect(int aspectNumber) {
        LOGGER.info("The controlling aspect is performed, current aspectNumber: {}", (Object)aspectNumber);
        Accessory accessory = new Accessory();
        accessory.setId(Integer.valueOf(0));
        if (aspectNumber < 0 || aspectNumber > 48) {
            LOGGER.warn("The current aspect has no valid aspectNumber assigned (0..{}). Abort perform aspect: {}", (Object)48, (Object)aspectNumber);
            return;
        }
        this.stepControlController.activateAspect(accessory, aspectNumber);
        AspectExecutionModel aspectExecutionModel = this.aspectExecutionModel;
        synchronized (aspectExecutionModel) {
            this.aspectExecutionModel.setAspectId(Integer.valueOf(aspectNumber));
        }
    }

    private void firePerformSpeed() {
        int speed = this.stepControlModel.getSpeed();
        LOGGER.info("Write the speed value: {}", (Object)speed);
        this.writeCvValue("speed", speed);
    }

    private void firePerformAccel() {
        int accel = this.stepControlModel.getAccel();
        this.writeCvValue("accel", accel);
    }

    private void firePerformDecel() {
        int decel = this.stepControlModel.getDecel();
        this.writeCvValue("decel", decel);
    }

    private void writeCvValue(String keyword, int modelValue) {
        try {
            LinkedList cvList = new LinkedList();
            CvNode speedNode = StepControlCvUtils.getNode((Map)this.mapKeywordToNode, (String)keyword);
            CvValueUtils.compareAndAddNewValue((CvNode)speedNode, (String)Integer.toString(modelValue), cvList, (Map)this.getCvNumberToNodeMap(this.selectedNode));
            LOGGER.info("Write CV value, keyword: {}, modelValue: {}, cvList: {}", new Object[]{keyword, modelValue, cvList});
            if (CollectionUtils.isNotEmpty(cvList)) {
                this.fireWriteConfigVariables(cvList);
            } else {
                LOGGER.warn("No CV values to write found.");
            }
        }
        catch (Exception ex) {
            LOGGER.warn("Set the new {} value failed.", (Object)keyword, (Object)ex);
        }
    }

    private void readCurrentValuesFromCV(NodeInterface node) {
        LOGGER.info("Read the values from CV for node: {}", (Object)node);
        if (node == null || !ProductUtils.isStepControl((long)node.getUniqueId())) {
            LOGGER.warn("No node available or not a StepControl: {}", (Object)node);
            if (this.mapKeywordToNode != null) {
                this.mapKeywordToNode.clear();
            }
            return;
        }
        LOGGER.info("Get the cvDefinitionTreeTableModel from the node: {}", (Object)node);
        CvDefinitionPanelController cvDefinitionPanelController = (CvDefinitionPanelController)DefaultApplicationContext.getInstance().get("cvDefinitionPanelController", CvDefinitionPanelController.class);
        CvDefinitionTreeTableModel cvDefinitionTreeTableModel = cvDefinitionPanelController.getCvDefinitionTreeTableModel(node);
        LOGGER.info("Current cvDefinitionTreeTableModel: {}", (Object)cvDefinitionTreeTableModel);
        if (cvDefinitionTreeTableModel != null) {
            this.mapKeywordToNode = new LinkedHashMap();
            DefaultExpandableRow rootNode = (DefaultExpandableRow)cvDefinitionTreeTableModel.getRoot();
            if (rootNode != null) {
                CvNodeUtils.harvestKeywordNodes((DefaultExpandableRow)rootNode, (Map)this.mapKeywordToNode);
            }
            LOGGER.info("Found keywords in nodes: {}", this.mapKeywordToNode.keySet());
            CvNode cvNodeSpeed = StepControlCvUtils.getNode((Map)this.mapKeywordToNode, (String)"speed");
            int maxSpeed = 2001;
            int minSpeed = 1;
            if (cvNodeSpeed != null) {
                try {
                    maxSpeed = Integer.parseInt(cvNodeSpeed.getCV().getMax()) + 1;
                }
                catch (Exception ex) {
                    LOGGER.warn("Get the max speed from CV definition failed.", (Throwable)ex);
                }
                try {
                    minSpeed = Integer.parseInt(cvNodeSpeed.getCV().getMin());
                }
                catch (Exception ex) {
                    LOGGER.warn("Get the min speed from CV definition failed.", (Throwable)ex);
                }
            }
            this.boundedRangeAdapterSpeed.setMinimum(minSpeed);
            this.boundedRangeAdapterSpeed.setMaximum(maxSpeed);
        } else {
            LOGGER.warn("No cvDefinitionTreeTableModel available for node: {}", (Object)node);
        }
        if (MapUtils.isNotEmpty((Map)this.mapKeywordToNode)) {
            LinkedList configVariables = new LinkedList();
            Map cvNumberToNodeMap = this.getCvNumberToNodeMap(this.selectedNode);
            for (CvNode cvNode : this.mapKeywordToNode.values()) {
                this.prepareConfigVariables(cvNode, configVariables, cvNumberToNodeMap);
            }
            this.requiredConfigVariables.clear();
            if (CollectionUtils.isNotEmpty(configVariables)) {
                this.requiredConfigVariables.addAll(configVariables);
            }
            this.prepareGetCurrentPosition(configVariables);
            this.fireLoadConfigVariables(configVariables);
        } else {
            LOGGER.warn("No values available in mapKeywordToNode!");
        }
    }

    private void prepareConfigVariables(CvNode cvNode, List<ConfigurationVariable> configVariables, Map<String, CvNode> cvNumberToNodeMap) {
        try {
            switch (24.$SwitchMap$org$bidib$jbidibc$exchange$vendorcv$DataType[cvNode.getCV().getType().ordinal()]) {
                case 1: {
                    LongCvNode masterNode = ((LongCvNode)cvNode).getMasterNode();
                    this.addConfigVariableDistinct(configVariables, masterNode.getConfigVar());
                    for (CvNode slaveNode : masterNode.getSlaveNodes()) {
                        this.addConfigVariableDistinct(configVariables, slaveNode.getConfigVar());
                    }
                    break;
                }
                case 2: {
                    this.addConfigVariableDistinct(configVariables, cvNode.getConfigVar());
                    int highCvNum = Integer.parseInt(cvNode.getCV().getHigh());
                    int cvNumber = Integer.parseInt(cvNode.getCV().getNumber());
                    if (highCvNum == cvNumber) {
                        CvNode lowCvNode = cvNumberToNodeMap.get(cvNode.getCV().getLow());
                        this.addConfigVariableDistinct(configVariables, lowCvNode.getConfigVar());
                        break;
                    }
                    CvNode highCvNode = cvNumberToNodeMap.get(cvNode.getCV().getHigh());
                    if (highCvNode == null) {
                        LOGGER.warn("The highCvNode is not available: {}", (Object)cvNode.getCV());
                    }
                    this.addConfigVariableDistinct(configVariables, highCvNode.getConfigVar());
                    break;
                }
                default: {
                    this.addConfigVariableDistinct(configVariables, cvNode.getConfigVar());
                }
            }
        }
        catch (Exception ex) {
            LOGGER.warn("Prepare config variables to read from node failed.", (Throwable)ex);
        }
    }

    private void addConfigVariableDistinct(List<ConfigurationVariable> configVariables, ConfigurationVariable cv) {
        if (!configVariables.contains(cv)) {
            configVariables.add(cv);
        } else {
            LOGGER.info("Skip add CV because it's in the list already: {}", (Object)cv);
        }
    }

    public void addCvDefinitionRequestListener(CvDefinitionRequestListener l) {
        this.cvDefinitionRequestListeners.add(l);
    }

    private List<ConfigurationVariable> fireLoadConfigVariables(List<ConfigurationVariable> configVariables) {
        LOGGER.info("Load the config variables.");
        Iterator iterator = this.cvDefinitionRequestListeners.iterator();
        if (iterator.hasNext()) {
            CvDefinitionRequestListener l = (CvDefinitionRequestListener)iterator.next();
            return l.loadCvValues(configVariables);
        }
        return Collections.emptyList();
    }

    private JComponent buildLeftAlignedButtonBar(JComponent ... button) {
        return new ButtonBarBuilder().addButton(button).addGlue().build();
    }

    public JPanel getComponent() {
        return this.component;
    }

    public String getName() {
        return Resources.getString(this.getClass(), (String)"name");
    }

    public void tabSelected(boolean selected) {
        LOGGER.info("Tab is selected: {}, initialized: {}", (Object)selected, (Object)this.initialized);
        this.toolbarCvDefinition.setVisible(selected);
        if (selected) {
            this.triggerLoadCvValues();
        }
        if (!selected && this.mainModel.getSelectedNode() == null) {
            LOGGER.info("The tab is no longer selected and the selected node is null, reset the selected node!");
            this.selectedNode = null;
        }
    }

    public void resetCvValuesLoaded() {
        LOGGER.info("Reset the cv values loaded flag.");
        this.cvValuesLoaded.set(false);
    }

    public void triggerLoadCvValues() {
        NodeInterface node = this.selectedNode;
        LOGGER.info("Load the CV values for node: {}, initialized: {}, cvValuesLoaded: {}", new Object[]{node, this.initialized, this.cvValuesLoaded});
        if (!this.cvValuesLoaded.get() && !this.initialized && this.selectedNode != null) {
            LOGGER.info("The CV values will be read from node.");
            this.statusBar.setStatusText(Resources.getString(StepControlPanel.class, (String)"loading_cvvalues"));
            this.cvValuesLoaded.set(true);
            SwingUtilities.invokeLater(() -> this.readCurrentValuesFromCV(node));
        } else {
            LOGGER.info("Skip loading CV values because the initialized is true.");
        }
    }

    private void handleMouseEvent(MouseEvent e, AspectTablePopupMenu aspectTableMenu) {
        if (e.isPopupTrigger()) {
            int row = this.aspectTable.rowAtPoint(e.getPoint());
            int column = this.aspectTable.columnAtPoint(e.getPoint());
            this.showAspectTableMenu(e, aspectTableMenu, row, column);
        }
    }

    private void showAspectTableMenu(MouseEvent e, AspectTablePopupMenu aspectTableMenu, int row, int column) {
        Object value = null;
        if (row > -1) {
            this.aspectTable.setRowSelectionInterval(row, row);
            int sortedRow = this.getSortableTableModel().getSortedRowAt(row);
            AspectTableModel aspectTableModel = (AspectTableModel)this.getSortableTableModel().getActualModel();
            value = aspectTableModel.getChildValueAt(sortedRow);
        }
        aspectTableMenu.setDeleteEnabled(value instanceof StepControlAspect);
        aspectTableMenu.setDeleteAllEnabled(this.aspectTable.getRowCount() > 0);
        aspectTableMenu.show(e.getComponent(), e.getX(), e.getY());
    }

    private void fireCreateNewAspect() {
        if (this.stepControlModel.getStepControlAspects().size() < this.stepControlModel.getMaxConfiguredAspects()) {
            LOGGER.info("Create the editorPanel to create a new aspect.");
            StepControlAspect stepControlAspect = new StepControlAspect(null, null, StepControlAspect.Polarity.normal);
            AddAspectCallbackListener aspectCallbackListener = new AddAspectCallbackListener(this);
            AspectEditorPanel aspectEditorPanel = this.aspectTable.createAspectEditorPanel((AspectCallbackListener)aspectCallbackListener, stepControlAspect, this.stepControlModel, AspectEditorPanel.EditorType.editorNew);
            AddAspectDialog aspectDialog = new AddAspectDialog(this, JOptionPane.getFrameForComponent(this.component), Resources.getString(StepControlPanel.class, (String)"dialog_add_aspect"), true, aspectEditorPanel);
            aspectCallbackListener.setAddAspectDialog(aspectDialog);
            aspectDialog.setVisible(true);
            if (aspectDialog.getResult() == 0) {
                LOGGER.info("User added new aspect: {}", (Object)stepControlAspect);
            } else {
                LOGGER.info("User cancelled add new aspect.");
            }
            aspectDialog.cleanup();
        } else {
            LOGGER.warn("Maximum number of aspects reached.");
            JOptionPane.showMessageDialog(this.component, Resources.getString(StepControlPanel.class, (String)"max_aspect_message"), Resources.getString(StepControlPanel.class, (String)"max_aspect_title"), 0);
        }
    }

    private void selectAspectByPosition(StepControlAspect stepControlAspect) {
        for (int rowIndex = 0; rowIndex < this.aspectTable.getRowCount(); ++rowIndex) {
            Object position = this.getSortableTableModel().getValueAt(rowIndex, 1);
            LOGGER.info("Current position: {}", position);
            Assert.isInstanceOf(StepControlAspect.class, (Object)position);
            if (!Objects.equals((Object)position, (Object)stepControlAspect)) continue;
            LOGGER.info("Found configured aspect with the same position: {} at rowIndex: {}", position, (Object)rowIndex);
            this.aspectTable.setRowSelectionInterval(rowIndex, rowIndex);
            LOGGER.info("Expand row: {}", (Object)rowIndex);
            this.aspectTable.expandRow(rowIndex);
            break;
        }
        LOGGER.info("Select aspect by position has finished.");
    }

    private void fireRemoveAspect() {
        LOGGER.info("Remove aspect.");
        int selectedRow = this.aspectTable.getSelectedRow();
        if (selectedRow > -1) {
            int sortedRow = this.getSortableTableModel().getSortedRowAt(selectedRow);
            AspectTableModel aspectTableModel = (AspectTableModel)this.getSortableTableModel().getActualModel();
            Object aspect = aspectTableModel.getChildValueAt(sortedRow);
            if (aspect instanceof StepControlAspect) {
                StepControlAspect stepControlAspect = (StepControlAspect)aspect;
                LOGGER.info("Remove aspect from stepControlModel: {}", (Object)stepControlAspect);
                this.stepControlModel.removeStepControlAspect(stepControlAspect);
            }
        }
    }

    private void fireRemoveAllAspects() {
        LOGGER.info("Remove all aspects.");
        int totalRows = this.aspectTable.getRowCount();
        if (totalRows > 0) {
            boolean continueDeleteAspects = TaskDialogs.build((Window)JOptionPane.getFrameForComponent(this.component), (String)Resources.getString(StepControlPanel.class, (String)"deleteAllAspects-confirm.instruction"), (String)Resources.getString(StepControlPanel.class, (String)"deleteAllAspects-confirm")).title(Resources.getString(StepControlPanel.class, (String)"deleteAllAspects-confirm.title")).isConfirmed();
            LOGGER.info("The user confirmed to continue delete all aspects: {}", (Object)continueDeleteAspects);
            if (continueDeleteAspects) {
                this.removeAllAspects();
            }
        }
    }

    private void removeAllAspects() {
        this.aspectTable.collapseAllRows();
        this.stepControlModel.setStepControlAspects(null);
    }

    private void fireImportAspectsFromExcel() {
        LOGGER.info("Import all aspects from excel.");
        FileNameExtensionFilter ff = new FileNameExtensionFilter(Resources.getString(StepControlPanel.class, (String)"filter") + " (*.xlsx)", "xlsx");
        20 dialog = new /* Unavailable Anonymous Inner Class!! */;
        dialog.showDialog();
    }

    private void loadAspectsFromExcel(File excelFile) throws IOException {
        LOGGER.info("Load aspects from excel file: {}", (Object)excelFile);
        List importAspects = null;
        try (BufferedInputStream is = new BufferedInputStream(new FileInputStream(excelFile));){
            ExcelAspectReader reader = new ExcelAspectReader();
            importAspects = reader.readAspects((InputStream)is);
        }
        if (CollectionUtils.isNotEmpty((Collection)importAspects)) {
            LOGGER.info("Import the aspects.");
            this.removeAllAspects();
            for (ImportAspect importAspect : importAspects) {
                StepControlAspect stepControlAspect = new StepControlAspect(null, Long.valueOf(importAspect.getPosition()), StepControlAspect.Polarity.normal);
                this.stepControlModel.addStepControlAspect(stepControlAspect);
            }
        } else {
            LOGGER.info("No aspects loaded.");
        }
    }

    private void fireConfigurationWizard() {
        LOGGER.info("Open the configuration wizard.");
        try {
            Map cvNumberToNodeMap = this.getCvNumberToNodeMap(this.selectedNode);
            ConfigurationWizard wizard = new ConfigurationWizard();
            wizard.prepareConfigurationModel(this.stepControlModel.getTurnTableType(), cvNumberToNodeMap, this.mapKeywordToNode);
            wizard.showWizard((Component)this.component);
            ConfigurationWizardModel configurationWizardModel = wizard.getConfigurationWizardModel();
            if (configurationWizardModel.getWizardStatus() == ConfigurationWizardModel.WizardStatus.finished) {
                this.writeConfigurationValues(configurationWizardModel, cvNumberToNodeMap, this.mapKeywordToNode);
            } else {
                LOGGER.info("The configurationWizardModel is not available.");
            }
        }
        catch (Exception ex) {
            LOGGER.warn("Show configuration wizard failed.", (Throwable)ex);
            TaskDialogs.build((Window)JOptionPane.getFrameForComponent(this.getComponent()), (String)Resources.getString(StepControlPanel.class, (String)"show-config-wizard-failed.instruction"), (String)Resources.getString(StepControlPanel.class, (String)"show-config-wizard-failed.text")).title(Resources.getString(StepControlPanel.class, (String)"show-config-wizard-failed.title")).showException((Throwable)ex);
        }
    }

    public void cvDefinitionChanged() {
        LOGGER.info("The cv definition has changed, selected node: {}", (Object)this.selectedNode);
        if (this.selectedNode != null && this.selectedNode.equals(this.mainModel.getSelectedNode()) || this.selectedNode == null && this.mainModel.getSelectedNode() == null) {
            LOGGER.info("The node in the model has not changed.");
            return;
        }
        if (this.selectedNode != null) {
            LOGGER.info("Remove the port value listener from the previous selected node.");
            this.selectedNode.removePortValueListener(MotorPort.class, (PortValueListener)this);
        }
        this.initialized = false;
        if (this.readCvButton != null) {
            this.readCvButton.setEnabled(false);
        }
        if (this.writeCvButton != null) {
            this.writeCvButton.setEnabled(false);
        }
        this.selectedNode = this.mainModel.getSelectedNode();
        try {
            this.aspectTable.getModel().removeTableModelListener(this.aspectTableModelListener);
            this.stepControlModel.clearModel();
        }
        finally {
            this.aspectTable.getModel().addTableModelListener(this.aspectTableModelListener);
        }
        this.requiredConfigVariables.clear();
        if (this.mapKeywordToNode != null) {
            LOGGER.info("Clear the mapKeywordToNode.");
            this.mapKeywordToNode.clear();
        }
        this.resetPendingChanges();
        this.updateToolbarButtons();
        if (this.selectedNode != null && ProductUtils.isStepControl((long)this.selectedNode.getUniqueId())) {
            LOGGER.info("The currently selected node is a StepControl.");
            this.selectedNode.addPortValueListener(MotorPort.class, (PortValueListener)this);
            this.fieldsToUpdate.add("configured_aspects");
        }
    }

    private void updateToolbarButtons() {
        if (this.selectedNode != null) {
            if (this.readCvButton != null) {
                this.readCvButton.setEnabled(MapUtils.isNotEmpty((Map)this.selectedNode.getConfigVariables()));
            }
            if (this.writeCvButton != null) {
                this.writeCvButton.setEnabled(MapUtils.isNotEmpty((Map)this.selectedNode.getConfigVariables()));
            }
        }
    }

    private String getCvName(String keyword) {
        CvNode cvNode = StepControlCvUtils.getNode((Map)this.mapKeywordToNode, (String)keyword);
        if (cvNode != null) {
            return cvNode.getConfigVar().getName();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cvDefinitionValuesChanged(boolean read, List<String> changedNames) {
        LOGGER.info("The cv definition values have changed, read: {}, changedNames: {}", (Object)read, changedNames);
        AtomicBoolean errorDetected = new AtomicBoolean();
        if (this.selectedNode == null || !ProductUtils.isStepControl((long)this.selectedNode.getUniqueId())) {
            LOGGER.info("The currently selected node is not a StepControl.");
            return;
        }
        Map cvNumberToNodeMap = this.getCvNumberToNodeMap(this.selectedNode);
        if (changedNames.contains("STEPPOS")) {
            try {
                long currentPosition = StepControlCvUtils.getConfigVarLongValueFromStringByCvKey((Map)cvNumberToNodeMap, (String)"STEPPOS");
                this.stepControlModel.setCurrentPosition(Long.valueOf(currentPosition));
                LOGGER.info("The current position was read and no more CV values are updated! The current position is: {}", (Object)currentPosition);
            }
            catch (Exception ex) {
                LOGGER.warn("Update the current position failed.", (Throwable)ex);
            }
        }
        if (MapUtils.isEmpty((Map)this.mapKeywordToNode)) {
            LOGGER.info("No mapKeywordToNode value available.");
            return;
        }
        if (changedNames.contains(this.getCvName("totalsteps"))) {
            try {
                Long totalSteps = StepControlCvUtils.getConfigVarLongValue((Map)this.mapKeywordToNode, (String)"totalsteps");
                LOGGER.info("Current total steps: {}", (Object)totalSteps);
                this.stepControlModel.setTotalSteps(totalSteps);
                if (this.angleRenderer != null) {
                    this.angleRenderer.setTotalSteps(totalSteps.longValue());
                }
            }
            catch (Exception ex) {
                LOGGER.warn("Set the total step count failed.", (Throwable)ex);
                errorDetected.set(true);
            }
        }
        if (changedNames.contains(this.getCvName("tabletype"))) {
            try {
                Integer value = StepControlCvUtils.getConfigVarIntValue((Map)this.mapKeywordToNode, (Map)cvNumberToNodeMap, (String)"tabletype");
                TurnTableType turnTableType = TurnTableType.fromValue((byte)ByteUtils.getLowByte((Integer)value));
                this.stepControlModel.setTurnTableType(turnTableType);
                int maxConfiguredAspects = 48;
                if (TurnTableType.round == turnTableType) {
                    maxConfiguredAspects = 24;
                }
                this.stepControlModel.setMaxConfiguredAspects(maxConfiguredAspects);
                LOGGER.info("The turnTableType was set to: {}, maxConfiguredAspects: {}", (Object)turnTableType, (Object)maxConfiguredAspects);
            }
            catch (Exception ex) {
                LOGGER.warn("Set the turnTableType failed.", (Throwable)ex);
                errorDetected.set(true);
            }
        }
        if (changedNames.contains(this.getCvName("speed"))) {
            try {
                Integer speed = StepControlCvUtils.getConfigVarIntValue((Map)this.mapKeywordToNode, (Map)cvNumberToNodeMap, (String)"speed");
                this.stepControlModel.setSpeed(speed.intValue());
            }
            catch (Exception ex) {
                LOGGER.warn("Set the speed failed.", (Throwable)ex);
                errorDetected.set(true);
            }
        }
        if (changedNames.contains(this.getCvName("accel"))) {
            try {
                Integer accel = StepControlCvUtils.getConfigVarIntValue((Map)this.mapKeywordToNode, (Map)cvNumberToNodeMap, (String)"accel");
                this.stepControlModel.setAccel(accel.intValue());
            }
            catch (Exception ex) {
                LOGGER.warn("Set the accel failed.", (Throwable)ex);
                errorDetected.set(true);
            }
        }
        if (changedNames.contains(this.getCvName("decel"))) {
            try {
                Integer decel = StepControlCvUtils.getConfigVarIntValue((Map)this.mapKeywordToNode, (Map)cvNumberToNodeMap, (String)"decel");
                this.stepControlModel.setDecel(decel.intValue());
            }
            catch (Exception ex) {
                LOGGER.warn("Set the decel failed.", (Throwable)ex);
                errorDetected.set(true);
            }
        }
        if (changedNames.contains(this.getCvName("stepcount")) || changedNames.contains(this.getCvName("unit"))) {
            Integer stepCount = StepControlCvUtils.getConfigVarIntValue((Map)this.mapKeywordToNode, (Map)cvNumberToNodeMap, (String)"stepcount");
            MicroStepsEnum microStepsEnum = StepControlCvUtils.getValidMicroStepping((Map)this.mapKeywordToNode, (Map)cvNumberToNodeMap);
            Integer unitSystemValue = StepControlCvUtils.getConfigVarByteValue((Map)this.mapKeywordToNode, (Map)cvNumberToNodeMap, (String)"unit");
            MovementScaleEnum movementScale = MovementScaleEnum.scale1;
            if (unitSystemValue != null) {
                int bitSpeed = ByteUtils.getBit((int)unitSystemValue, (int)0);
                movementScale = bitSpeed > 0 ? MovementScaleEnum.scale0_1 : MovementScaleEnum.scale1;
            }
            long maxSpeedValid = SpeedRangeValidationUtils.calculateValidMaxSpeed((int)microStepsEnum.getSteps(), (int)stepCount, (MovementScaleEnum)movementScale);
            int currentMaxSpeed = this.boundedRangeAdapterSpeed.getMaximum();
            LOGGER.info("Current speed range maximum is: {}", (Object)currentMaxSpeed);
            if ((long)currentMaxSpeed > maxSpeedValid) {
                LOGGER.warn("The configured maxSpeed ({}) exceeds the limit: {}. Set maxSpeed to limit.", (Object)currentMaxSpeed, (Object)maxSpeedValid);
                this.boundedRangeAdapterSpeed.setMaximum((int)maxSpeedValid);
                int currentSpeed = this.stepControlModel.getSpeed();
                if ((long)currentSpeed > maxSpeedValid) {
                    LOGGER.warn("Set the current speed to  the maximum valid speed: {}", (Object)maxSpeedValid);
                    this.stepControlModel.setSpeed((int)maxSpeedValid);
                }
                if (this.speedSlider != null) {
                    this.speedSlider.updateUI();
                }
            }
            try {
                long accelDecelLimit = 191500L;
                AccelarationScaleEnum accelarationScale = AccelarationScaleEnum.scale1;
                if (unitSystemValue != null) {
                    int bitAccelaration = ByteUtils.getBit((int)unitSystemValue, (int)4);
                    AccelarationScaleEnum accelarationScaleEnum = accelarationScale = bitAccelaration > 0 ? AccelarationScaleEnum.scale0_1 : AccelarationScaleEnum.scale1;
                }
                if (accelarationScale == AccelarationScaleEnum.scale0_1) {
                    accelDecelLimit = 19150L;
                }
                long accelarationFactor = SpeedRangeValidationUtils.calculateValidAccelarationFactor((int)microStepsEnum.getSteps(), (int)stepCount);
                long minAccel = accelarationFactor * (long)this.stepControlModel.getAccel();
                LOGGER.info("The calculated minAccel: {}", (Object)minAccel);
                if (minAccel < accelDecelLimit) {
                    long adjustedAccelValue = accelDecelLimit / accelarationFactor;
                    LOGGER.warn("Set the current accel value to minimum: {}", (Object)adjustedAccelValue);
                    this.stepControlModel.setAccel((int)adjustedAccelValue);
                }
                long minDecel = accelarationFactor * (long)this.stepControlModel.getDecel();
                LOGGER.info("The calculated minDecel: {}", (Object)minDecel);
                if (minDecel < accelDecelLimit) {
                    long adjustedDecelValue = accelDecelLimit / accelarationFactor;
                    LOGGER.warn("Set the current decel value to minimum: {}", (Object)adjustedDecelValue);
                    this.stepControlModel.setDecel((int)adjustedDecelValue);
                }
            }
            catch (Exception ex) {
                LOGGER.warn("Set or adjust the decel value failed.", (Throwable)ex);
                errorDetected.set(true);
            }
        }
        if (changedNames.contains(this.getCvName("push_interval"))) {
            try {
                Integer pushInterval = StepControlCvUtils.getConfigVarByteValue((Map)this.mapKeywordToNode, (Map)cvNumberToNodeMap, (String)"push_interval");
                this.stepControlModel.setPushInterval(pushInterval);
            }
            catch (Exception ex) {
                LOGGER.warn("Set the push interval failed.", (Throwable)ex);
                errorDetected.set(true);
            }
        }
        if (changedNames.contains(this.getCvName("bridge"))) {
            Integer cvNodeBridge = StepControlCvUtils.getConfigVarByteValue((Map)this.mapKeywordToNode, (Map)cvNumberToNodeMap, (String)"bridge");
            LOGGER.info("Current cvNodeBridge: {}", (Object)cvNodeBridge);
            if (cvNodeBridge != null) {
                int bridge = 0;
                try {
                    bridge = cvNodeBridge;
                    LOGGER.info("Current bridge value: {}", (Object)bridge);
                }
                catch (Exception ex) {
                    LOGGER.warn("Get the bridge value from CVs failed.", (Throwable)ex);
                }
            }
        }
        if (!this.initialized && read) {
            LOGGER.info("The values were read, update the aspects in the table.");
            this.fieldsToUpdate.add("configured_aspects");
        }
        if (this.fieldsToUpdate.contains("configured_aspects")) {
            LOGGER.info("Prepare the configured aspects.");
            List configuredAspects = this.prepareConfiguredAspects(cvNumberToNodeMap, errorDetected);
            try {
                this.aspectTable.getModel().removeTableModelListener(this.aspectTableModelListener);
                this.stepControlModel.setStepControlAspects(configuredAspects);
            }
            finally {
                this.aspectTable.getModel().addTableModelListener(this.aspectTableModelListener);
            }
            this.fieldsToUpdate.remove("configured_aspects");
            this.getSortableTableModel().fireTableDataChanged();
            this.aspectTable.expandAllRows();
        }
        if (!this.initialized && !errorDetected.get()) {
            this.initialized = true;
            LOGGER.info("The panel was initialized. Reset the pending changes flag on the tab.");
            this.tabStatusListener.updatePendingChanges((Component)this.component, false);
        } else if (read) {
            LOGGER.info("The CV values were read from the node. Reset the pending changes flag on the tab.");
            this.tabStatusListener.updatePendingChanges((Component)this.component, false);
        }
        this.updateToolbarButtons();
    }

    private List<StepControlAspect> prepareConfiguredAspects(Map<String, CvNode> cvNumberToJideNodeMap, AtomicBoolean errorDetected) {
        boolean roundTurnTable = TurnTableType.round == this.stepControlModel.getTurnTableType();
        long oppositePositionStartPosition = -1L;
        Long totalSteps = this.stepControlModel.getTotalSteps();
        LOGGER.info("Prepare the aspects for turntable type: {}, totalSteps: {}", (Object)this.stepControlModel.getTurnTableType(), (Object)totalSteps);
        if (totalSteps != null && totalSteps > 0L) {
            oppositePositionStartPosition = totalSteps / 2L;
        }
        StepControlAspect firstOppositeStepControlAspect = null;
        int maxAspectCount = 0;
        LinkedList<StepControlAspect> configuredAspects = new LinkedList<StepControlAspect>();
        int maxIndex = 48;
        for (int index = 0; index < maxIndex; ++index) {
            try {
                Integer targetPolarity = StepControlCvUtils.getConfigVarIntValue((Map)this.mapKeywordToNode, cvNumberToJideNodeMap, (String)String.format("target_polarity_%d", index));
                Long targetPosition = StepControlCvUtils.getConfigVarLongValue((Map)this.mapKeywordToNode, (String)String.format("target_position_%d", index));
                if (targetPosition < 0xFFFFFFFFL) {
                    StepControlAspect stepControlAspect = new StepControlAspect(null, Long.valueOf(targetPosition), StepControlAspect.Polarity.valueOf((int)targetPolarity));
                    stepControlAspect.setStatus(StepControlAspect.AspectPersistanceStatus.statusPersistent);
                    LOGGER.info("Adding new stepControlAspect: {}", (Object)stepControlAspect);
                    configuredAspects.add(stepControlAspect);
                    if (!roundTurnTable || firstOppositeStepControlAspect != null || stepControlAspect.getPosition() < oppositePositionStartPosition) continue;
                    firstOppositeStepControlAspect = stepControlAspect;
                    LOGGER.info("Found the first opposite position aspect based on the position and totalSteps at position: {}, firstOppositeStepControlAspect: {}", (Object)stepControlAspect.getPosition(), (Object)firstOppositeStepControlAspect);
                    maxAspectCount = configuredAspects.size() - 1;
                    continue;
                }
                LOGGER.info("No active position at index {}, skip further creation of aspects, position: {}", (Object)index, (Object)targetPosition);
                break;
            }
            catch (IllegalArgumentException ex) {
                LOGGER.warn("Prepare configured step control aspect failed: {}", (Object)ex.getMessage());
                errorDetected.set(true);
                continue;
            }
            catch (Exception ex) {
                LOGGER.warn("Prepare configured step control aspect failed.", (Throwable)ex);
                errorDetected.set(true);
            }
        }
        if (roundTurnTable) {
            int maxTrackPositions = configuredAspects.size();
            LOGGER.info("Number of aspects read from cv values: {}", (Object)maxTrackPositions);
            if (maxAspectCount == 0 && maxTrackPositions > 0) {
                maxAspectCount = maxTrackPositions / 2;
            }
            LinkedList<StepControlAspect> mergedConfiguredAspects = new LinkedList<StepControlAspect>();
            boolean foundFirstOppositePosition = false;
            for (int index = 0; index < maxAspectCount; ++index) {
                StepControlAspect stepControlAspect = (StepControlAspect)configuredAspects.get(index);
                StepControlAspect stepControlAspectOpposite = null;
                if (index + maxAspectCount < maxTrackPositions) {
                    stepControlAspectOpposite = (StepControlAspect)configuredAspects.get(index + maxAspectCount);
                }
                LOGGER.info("Fetched stepControlAspect: {}, stepControlAspectOpposite: {}", (Object)stepControlAspect, stepControlAspectOpposite);
                if (stepControlAspectOpposite != null && stepControlAspectOpposite.getPosition() != null && stepControlAspectOpposite.getPosition() >= oppositePositionStartPosition) {
                    if (!foundFirstOppositePosition) {
                        LOGGER.info("The first opposite position was found: {}", (Object)stepControlAspectOpposite);
                        foundFirstOppositePosition = true;
                    }
                    LOGGER.info("Merge the values from opposite aspect: {}, stepControlAspect: {}", (Object)stepControlAspectOpposite, (Object)stepControlAspect);
                    stepControlAspect.setOppositePosition(stepControlAspectOpposite.getPosition());
                    stepControlAspect.setOppositePolarity(stepControlAspectOpposite.getPolarity());
                    LOGGER.info("Set the opposite aspect on aspect: {}", (Object)stepControlAspect);
                    stepControlAspect.setOppositeAspect((AspectReference)stepControlAspectOpposite);
                }
                LOGGER.info("Adding merged stepControlAspect: {}", (Object)stepControlAspect);
                mergedConfiguredAspects.add(stepControlAspect);
            }
            configuredAspects.clear();
            configuredAspects.addAll(mergedConfiguredAspects);
        }
        return configuredAspects;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void executionStateChanged(AccessoryExecutionState executionState, Integer accessoryId, Integer aspect, AccessoryState accessoryState) {
        LOGGER.info("The execution state has changed: {}, accessoryId: {}, aspect: {}", new Object[]{executionState, accessoryId, aspect});
        if (aspect == null || executionState == null) {
            executionState = AccessoryExecutionState.IDLE;
        }
        this.executionStateIconLabel.setToolTipText(null);
        switch (24.$SwitchMap$org$bidib$jbidibc$messages$enums$AccessoryExecutionState[executionState.ordinal()]) {
            case 1: {
                this.executionStateIconLabel.setIcon(this.accessoryErrorIcon);
                this.executionStateIconLabel.setText(Resources.getString(StepControlPanel.class, (String)"unknown_error_aspect", (Object[])new Object[]{aspect}));
                if (accessoryState == null) break;
                this.executionStateIconLabel.setToolTipText(accessoryState.getErrorInformation());
                break;
            }
            case 2: {
                this.executionStateIconLabel.setIcon(this.accessoryWaitIcon);
                this.executionStateIconLabel.setText(Resources.getString(StepControlPanel.class, (String)"executing_aspect", (Object[])new Object[]{aspect}));
                break;
            }
            case 3: {
                this.executionStateIconLabel.setIcon(this.accessorySuccessfulIcon);
                this.executionStateIconLabel.setText(Resources.getString(StepControlPanel.class, (String)"active_aspect", (Object[])new Object[]{aspect}));
                break;
            }
            case 4: {
                this.executionStateIconLabel.setIcon(this.accessoryUnknownIcon);
                this.executionStateIconLabel.setText(null);
                break;
            }
            default: {
                this.executionStateIconLabel.setIcon(null);
                this.executionStateIconLabel.setText(null);
            }
        }
        AspectExecutionModel aspectExecutionModel = this.aspectExecutionModel;
        synchronized (aspectExecutionModel) {
            if (this.aspectExecutionModel.getAccessoryId() == accessoryId && this.aspectExecutionModel.getAspectId() == aspect) {
                LOGGER.info("Update the aspectExecutionModel.");
                this.aspectExecutionModel.setExecutionState(executionState);
                this.aspectExecutionModel.setAccessoryState(accessoryState);
            }
        }
    }

    private void addToolBarButtons(VLToolBar toolBar) {
        this.readCvButton = this.makeNavigationButton("loadfromnode", "/32x32", READ, Resources.getString(this.getClass(), (String)"toolbar.readallcv"), Resources.getString(this.getClass(), (String)"toolbar.readallcv.alttext"));
        this.readCvButton.setEnabled(false);
        toolBar.add(this.readCvButton);
        this.readCvButton.addActionListener((ActionListener)new /* Unavailable Anonymous Inner Class!! */);
        this.writeCvButton = this.makeNavigationButton("savetonode", "/32x32", WRITE, Resources.getString(this.getClass(), (String)"toolbar.writeallcv"), Resources.getString(this.getClass(), (String)"toolbar.writeallcv.alttext"));
        toolBar.add(this.writeCvButton);
        this.writeCvButton.setEnabled(false);
        this.writeCvButton.addActionListener((ActionListener)new /* Unavailable Anonymous Inner Class!! */);
    }

    private JButton makeNavigationButton(String imageName, String pathExt, String actionCommand, String toolTipText, String altText) {
        String imgLocation = "/icons/" + imageName + ".png";
        if (pathExt != null) {
            imgLocation = "/icons" + pathExt + "/" + imageName + ".png";
        }
        URL imageURL = StepControlPanel.class.getResource(imgLocation);
        JButton button = new JButton();
        button.setActionCommand(actionCommand);
        button.setToolTipText(toolTipText);
        if (imageURL != null) {
            button.setIcon(new ImageIcon(imageURL, altText));
        } else {
            button.setText(altText);
            LOGGER.warn("Resource not found: {}", (Object)imgLocation);
        }
        return button;
    }

    private void addToolBar(VLToolBar toolBar, ToolBarConstraints constraints) {
        ToolBarPanel topToolBarPanel = (ToolBarPanel)DefaultApplicationContext.getInstance().get("topToolBarPanel");
        topToolBarPanel.add(toolBar, constraints);
    }

    private void prepareAndWriteCvValuesToNode(boolean writeOnlyAspects) {
        LOGGER.info("Write the CV values.");
        Map cvNumberToNodeMap = this.getCvNumberToNodeMap(this.selectedNode);
        LinkedList cvList = new LinkedList();
        int aspectIndex = 0;
        ArrayListModel aspects = this.stepControlController.getConfigureAspectsListModel();
        for (StepControlAspect currentAspect : aspects) {
            LOGGER.info("Prepare aspect to save: {}", (Object)currentAspect);
            this.prepareCvValues(aspectIndex, currentAspect, cvList, cvNumberToNodeMap);
            ++aspectIndex;
        }
        if (aspectIndex < 48) {
            StepControlAspect currentAspect = new StepControlAspect(null, Long.valueOf(0xFFFFFFFFL), StepControlAspect.Polarity.normal);
            LOGGER.info("Add the terminating aspect: {}", (Object)currentAspect);
            this.prepareCvValues(aspectIndex, currentAspect, cvList, cvNumberToNodeMap);
            ++aspectIndex;
        }
        if (!writeOnlyAspects) {
            CvNode tableTypeNode = StepControlCvUtils.getNode((Map)this.mapKeywordToNode, (String)"tabletype");
            TurnTableType turnTableType = this.stepControlModel.getTurnTableType();
            CvValueUtils.compareAndAddNewValue((CvNode)tableTypeNode, (String)Integer.toString(turnTableType.getCvValue()), cvList, (Map)cvNumberToNodeMap);
            CvNode speedNode = StepControlCvUtils.getNode((Map)this.mapKeywordToNode, (String)"speed");
            int speed = this.stepControlModel.getSpeed();
            CvValueUtils.compareAndAddNewValue((CvNode)speedNode, (String)Integer.toString(speed), cvList, (Map)cvNumberToNodeMap);
            CvNode accelNode = StepControlCvUtils.getNode((Map)this.mapKeywordToNode, (String)"accel");
            int accel = this.stepControlModel.getAccel();
            CvValueUtils.compareAndAddNewValue((CvNode)accelNode, (String)Integer.toString(accel), cvList, (Map)cvNumberToNodeMap);
            CvNode decelNode = StepControlCvUtils.getNode((Map)this.mapKeywordToNode, (String)"decel");
            int decel = this.stepControlModel.getDecel();
            CvValueUtils.compareAndAddNewValue((CvNode)decelNode, (String)Integer.toString(decel), cvList, (Map)cvNumberToNodeMap);
        } else {
            LOGGER.info("Only write aspectst to node.");
        }
        StepControlPanel cvDefinitionPanelProvider = this;
        CvValueUtils.writeCvValues((NodeInterface)this.selectedNode, cvList, (Map)cvNumberToNodeMap, (CvDefinitionPanelProvider)cvDefinitionPanelProvider);
        if (!this.hasPendingChanges()) {
            LOGGER.info("Set the persistence status of all aspects to persistent.");
            for (StepControlAspect currentAspect : this.stepControlModel.getStepControlAspects()) {
                currentAspect.setStatus(StepControlAspect.AspectPersistanceStatus.statusPersistent);
            }
        }
    }

    private Map<String, CvNode> getCvNumberToNodeMap(NodeInterface node) {
        CvDefinitionPanelController cvDefinitionPanelController = (CvDefinitionPanelController)DefaultApplicationContext.getInstance().get("cvDefinitionPanelController", CvDefinitionPanelController.class);
        Map cvNumberToNodeMap = cvDefinitionPanelController.getCvNumberToNodeMap(node);
        return cvNumberToNodeMap;
    }

    private void writeConfigurationValues(ConfigurationWizardModel configurationWizardModel, Map<String, CvNode> cvNumberToNodeMap, Map<String, CvNode> mapKeywordToNode) {
        Integer microStepping;
        Integer backlash;
        CvNode backlashNode;
        LOGGER.info("Write the values from the configuration wizard model to the node.");
        LinkedList cvList = new LinkedList();
        CvNode tableTypeNode = StepControlCvUtils.getNode(mapKeywordToNode, (String)"tabletype");
        TurnTableType turnTableType = configurationWizardModel.getTurnTableType();
        this.stepControlModel.setTurnTableType(turnTableType);
        CvValueUtils.compareAndAddNewValue((CvNode)tableTypeNode, (String)Integer.toString(turnTableType.getCvValue()), cvList, cvNumberToNodeMap);
        CvNode nemaTypeNode = StepControlCvUtils.getNode(mapKeywordToNode, (String)"nematype");
        MotorSizeType motorSizeType = configurationWizardModel.getMotorSizeType();
        CvValueUtils.compareAndAddNewValue((CvNode)nemaTypeNode, (String)Integer.toString(motorSizeType.getCvValue()), cvList, cvNumberToNodeMap);
        CvNode stepCountNode = StepControlCvUtils.getNode(mapKeywordToNode, (String)"stepcount");
        Integer stepCount = configurationWizardModel.getStepCount();
        if (stepCount == null || stepCount == 0) {
            LOGGER.warn("Adjusting invalid stepCount to default value 1.");
            stepCount = 1;
        }
        CvValueUtils.compareAndAddNewValue((CvNode)stepCountNode, (String)Integer.toString(stepCount), cvList, cvNumberToNodeMap);
        CvNode gearPrimaryNode = StepControlCvUtils.getNode(mapKeywordToNode, (String)"gear_primary");
        Integer gearRatioPrimary = configurationWizardModel.getGearing().getGearRatioPrimary();
        CvValueUtils.compareAndAddNewValue((CvNode)gearPrimaryNode, (String)Integer.toString(gearRatioPrimary), cvList, cvNumberToNodeMap);
        CvNode gearSecondaryNode = StepControlCvUtils.getNode(mapKeywordToNode, (String)"gear_secondary");
        Integer gearRatioSecondary = configurationWizardModel.getGearing().getGearRatioSecondary();
        CvValueUtils.compareAndAddNewValue((CvNode)gearSecondaryNode, (String)Integer.toString(gearRatioSecondary), cvList, cvNumberToNodeMap);
        LongCvNode totalStepsNode = (LongCvNode)StepControlCvUtils.getNode(mapKeywordToNode, (String)"totalsteps");
        Integer totalStepCount = configurationWizardModel.getTotalStepCount();
        CvValueUtils.compareAndAddNewValue((LongCvNode)totalStepsNode, (Integer)totalStepCount, cvList);
        if ("yes".equals(configurationWizardModel.getGearing().getKey())) {
            backlashNode = StepControlCvUtils.getNode(mapKeywordToNode, (String)"backlash");
            backlash = configurationWizardModel.getGearing().getBackLash();
            CvValueUtils.compareAndAddNewValue((CvNode)backlashNode, (String)Integer.toString(backlash), cvList, cvNumberToNodeMap);
        } else {
            LOGGER.info("No gearing selected.");
            backlashNode = StepControlCvUtils.getNode(mapKeywordToNode, (String)"backlash");
            backlash = 0;
            CvValueUtils.compareAndAddNewValue((CvNode)backlashNode, (String)Integer.toString(backlash), cvList, cvNumberToNodeMap);
        }
        CvNode microSteppingNode = StepControlCvUtils.getNode(mapKeywordToNode, (String)"microstepping");
        Integer n = microStepping = configurationWizardModel.getMicroStepping() != null ? configurationWizardModel.getMicroStepping().getSteps() : null;
        if (microStepping == null || microStepping == 0) {
            LOGGER.warn("Adjusting invalid microstepping to default value 64.");
            microStepping = 64;
        }
        CvValueUtils.compareAndAddNewValue((CvNode)microSteppingNode, (String)Integer.toString(microStepping), cvList, cvNumberToNodeMap);
        CvValueUtils.writeCvValues((NodeInterface)this.selectedNode, cvList, cvNumberToNodeMap, (CvDefinitionPanelProvider)this);
        try {
            Long totalSteps = StepControlCvUtils.getConfigVarLongValue(mapKeywordToNode, (String)"totalsteps");
            if (this.angleRenderer != null) {
                this.angleRenderer.setTotalSteps(totalSteps.longValue());
            }
        }
        catch (Exception ex) {
            LOGGER.warn("Set the total step count failed.", (Throwable)ex);
        }
    }

    private void prepareCvValues(int aspectIndex, StepControlAspect currentAspect, List<ConfigurationVariable> cvList, Map<String, CvNode> cvNumberToNodeMap) {
        String keywordPolarity = String.format("target_polarity_%d", aspectIndex);
        CvNode polarityNode = StepControlCvUtils.getNode((Map)this.mapKeywordToNode, (String)keywordPolarity);
        StepControlAspect.Polarity polarity = currentAspect.getPolarity();
        CvValueUtils.compareAndAddNewValue((CvNode)polarityNode, (String)Integer.toString(polarity.getCvValue()), cvList, cvNumberToNodeMap);
        String keywordPosition = String.format("target_position_%d", aspectIndex);
        LongCvNode positionNode = (LongCvNode)StepControlCvUtils.getNode((Map)this.mapKeywordToNode, (String)keywordPosition);
        Long position = currentAspect.getPosition();
        LOGGER.debug("The new position is: {}", (Object)position);
        if (position != null) {
            CvValueUtils.compareAndAddNewValue((CvNode)positionNode, (String)Long.toString(position), cvList, cvNumberToNodeMap);
        } else {
            LOGGER.warn("No position of aspect available. Current aspect: {}", (Object)currentAspect);
        }
    }

    public void checkPendingChanges() {
        boolean hasPendingChanges = this.hasPendingChanges();
        if (!hasPendingChanges) {
            this.resetPendingChanges();
        }
    }

    private void resetPendingChanges() {
        LOGGER.info("Reset pending changes.");
        this.tabStatusListener.updatePendingChanges((Component)this.component, false);
    }

    private boolean hasPendingChanges() {
        return false;
    }

    public void writeConfigVariables(List<ConfigurationVariable> cvList) {
        this.fireWriteConfigVariables(cvList);
    }

    private void fireWriteConfigVariables(List<ConfigurationVariable> cvList) {
        CvConsoleModel cvConsoleModel = CvConsoleModel.getConsoleModel();
        for (ConfigurationVariable cv : cvList) {
            cvConsoleModel.addConsoleLine(Color.black, String.format(">> CV %s : %s", cv.getName(), cv.getValue()));
        }
        for (CvDefinitionRequestListener l : this.cvDefinitionRequestListeners) {
            l.writeCvValues(cvList);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fireWriteConfigVariablesPosition(List<ConfigurationVariable> cvList) {
        LOGGER.info("Write cvValue for current position: {}", cvList);
        Frame frame = JOptionPane.getFrameForComponent(this.getComponent());
        try {
            if (frame instanceof BusyFrame) {
                ((BusyFrame)frame).setBusy(true);
            }
            Map cvNumberToNodeMap = this.getCvNumberToNodeMap(this.selectedNode);
            StepControlPanel cvDefinitionPanelProvider = this;
            CvValueUtils.writeCvValues((NodeInterface)this.selectedNode, cvList, (Map)cvNumberToNodeMap, (CvDefinitionPanelProvider)cvDefinitionPanelProvider);
            String currentPositionValue = null;
            for (ConfigurationVariable configVar : cvList) {
                LOGGER.info("Update the configVar in the model: {}", (Object)configVar);
                this.selectedNode.getConfigVariables().put(configVar.getName(), configVar);
                currentPositionValue = configVar.getValue();
            }
            try {
                CvNode currentPositionNode = StepControlCvUtils.getNode((Map)cvNumberToNodeMap, (String)"STEPPOS");
                currentPositionNode.getConfigVar().setValue(currentPositionValue);
                Long currentPosition = Long.parseLong(currentPositionValue);
                LOGGER.info("Set the current position: {}", (Object)currentPosition);
                this.stepControlModel.setCurrentPosition(currentPosition);
                LOGGER.info("The current position was read and no more CV values are updated! The current position is: {}", (Object)currentPosition);
            }
            catch (Exception ex) {
                LOGGER.warn("Update the current position failed.", (Throwable)ex);
            }
        }
        finally {
            if (frame instanceof BusyFrame) {
                ((BusyFrame)frame).setBusy(false);
            }
        }
    }

    private List<ConfigurationVariable> fireLoadConfigVariablesPosition(List<ConfigurationVariable> configVariables) {
        LOGGER.info("Load the config variables for the positions.");
        Iterator iterator = this.cvDefinitionRequestListeners.iterator();
        if (iterator.hasNext()) {
            CvDefinitionRequestListener l = (CvDefinitionRequestListener)iterator.next();
            return l.loadCvValues(configVariables);
        }
        return Collections.emptyList();
    }

    public void labelChanged(MotorPort port, String label) {
    }

    public void valueChanged(NodeInterface node, MotorPort port) {
        LOGGER.info("The motor port value has changed: {}", (Object)port);
    }

    public void configChanged(NodeInterface node, MotorPort port) {
    }

    public Class<?> getPortClass() {
        return MotorPort.class;
    }

    private JPanel createFunctionButtonPanel(JPanel parentPanel, List<JideButton> functionButtons) {
        Feature feature;
        FormBuilder formBuilder = FormBuilder.create().columns("pref, 8dlu, pref, 8dlu, pref, 8dlu, pref, 8dlu, pref, 8dlu, pref, 8dlu, pref, 8dlu, pref", new Object[0]).rows("p, 3dlu, p", new Object[0]).panel(parentPanel);
        formBuilder.addSeparator(Resources.getString(this.getClass(), (String)"additionalFunctions"), new Object[0]).xyw(1, 1, 15);
        int totalSoundPorts = 0;
        if (this.selectedNode != null && (feature = Feature.findFeature((Collection)this.selectedNode.getNode().getFeatures(), (int)FeatureEnum.FEATURE_CTRL_SOUND_COUNT.getNumber())) != null) {
            totalSoundPorts = feature.getValue();
        }
        LOGGER.info("Total number of sound ports: {}", (Object)totalSoundPorts);
        ImageIcon iconSoundMute = ImageUtils.createImageIcon(StepControlPanel.class, (String)"/icons/stepcontrol/sound_mute.png");
        ImageIcon iconSoundOn = ImageUtils.createImageIcon(StepControlPanel.class, (String)"/icons/stepcontrol/sound.png");
        this.soundActiveButton = new JideToggleButton(Resources.getString(this.getClass(), (String)"soundActive"));
        this.soundActiveButton.setButtonStyle(1);
        this.soundActiveButton.setSelectedIcon((Icon)iconSoundMute);
        this.soundActiveButton.setIcon((Icon)iconSoundOn);
        this.soundActiveButton.addActionListener(evt -> {
            boolean isSoundMute = this.soundActiveButton.isSelected();
            LOGGER.info("Pressed the sound active button, isSoundMute: {}", (Object)isSoundMute);
            this.stepControlController.setSoundActive(!isSoundMute);
        });
        boolean soundActive = this.stepControlModel.isSoundActive();
        this.soundActiveButton.setSelected(!soundActive);
        formBuilder.add((Component)this.soundActiveButton).xyw(1, 3, 5);
        formBuilder.appendRows("10dlu, p", new Object[0]);
        int columns = 8;
        int currentSoundPortId = 0;
        for (int row = 0; row < 4; ++row) {
            for (int column = 0; column < 8; ++column) {
                int functionIndex = row * 8 + column;
                String buttonText = "F" + functionIndex;
                JideButton functionButton = new JideButton(buttonText);
                functionButton.setButtonStyle(1);
                functionButton.addActionListener((ActionListener)new /* Unavailable Anonymous Inner Class!! */);
                functionButtons.add(functionButton);
                this.functionButtonMap.put(buttonText, functionButton);
                formBuilder.add((Component)functionButton).xy(column * 2 + 1, row * 2 + 5);
                if (++currentSoundPortId < totalSoundPorts) continue;
                LOGGER.info("Maximum number of sound ports reached.");
                break;
            }
            formBuilder.appendRows("3dlu, p", new Object[0]);
            if (currentSoundPortId < totalSoundPorts) continue;
            LOGGER.info("Maximum number of sound ports reached.");
            break;
        }
        return formBuilder.build();
    }

    public void setActiveAspect(SwitchingNodeInterface node, int accessoryNumber, int aspectNumber) {
        LOGGER.info("Set the active aspect: {}", (Object)aspectNumber);
        if (SwingUtilities.isEventDispatchThread()) {
            this.firePerformAspect(aspectNumber);
        } else {
            try {
                SwingUtilities.invokeAndWait(() -> this.firePerformAspect(aspectNumber));
            }
            catch (InterruptedException | InvocationTargetException ex) {
                LOGGER.warn("Activate aspect failed, accessoryNumber: {}, aspectNumber: {}", new Object[]{accessoryNumber, aspectNumber, ex});
                throw new RuntimeException("Activate aspect failed, accessoryNumber: " + accessoryNumber + ", aspect: " + aspectNumber);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AccessoryExecutionState getAccessoryExecutionState(SwitchingNodeInterface node, int accessoryNumber) {
        AspectExecutionModel aspectExecutionModel = this.aspectExecutionModel;
        synchronized (aspectExecutionModel) {
            return this.aspectExecutionModel.getExecutionState();
        }
    }
}

