package org.bidib.wizard.mvc.stepcontrol.view.wizard;

import java.awt.Component;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import javax.swing.DefaultListCellRenderer;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;

import org.bidib.wizard.api.locale.Resources;
import org.bidib.wizard.client.common.converter.StringConverter;
import org.bidib.wizard.client.common.text.InputValidationDocument;
import org.bidib.wizard.client.common.text.WizardComponentFactory;
import org.bidib.wizard.client.common.view.validation.IconFeedbackPanel;
import org.bidib.wizard.client.common.view.validation.PropertyValidationI18NSupport;
import org.bidib.wizard.mvc.common.view.wizard.JWizardComponents;
import org.bidib.wizard.mvc.stepcontrol.model.AccelarationScaleEnum;
import org.bidib.wizard.mvc.stepcontrol.model.ConfigurationWizardModel;
import org.bidib.wizard.mvc.stepcontrol.model.Gearing;
import org.bidib.wizard.mvc.stepcontrol.model.MicroStepsEnum;
import org.bidib.wizard.mvc.stepcontrol.model.MotorSizeType;
import org.bidib.wizard.mvc.stepcontrol.model.MovementScaleEnum;
import org.bidib.wizard.mvc.stepcontrol.view.SpeedRangeValidationUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import com.jgoodies.binding.adapter.Bindings;
import com.jgoodies.binding.adapter.ComboBoxAdapter;
import com.jgoodies.binding.beans.PropertyAdapter;
import com.jgoodies.binding.beans.PropertyConnector;
import com.jgoodies.binding.value.ConverterValueModel;
import com.jgoodies.binding.value.ValueModel;
import com.jgoodies.forms.builder.FormBuilder;
import com.jgoodies.forms.debug.FormDebugPanel;
import com.jgoodies.forms.factories.Paddings;
import com.jgoodies.validation.ValidationResult;
import com.jgoodies.validation.ValidationResultModel;
import com.jgoodies.validation.util.PropertyValidationSupport;
import com.jgoodies.validation.view.ValidationComponentUtils;

public class StepMotorCharacteristicsPanel extends AbstractWizardPanel {
    private static final Logger LOGGER = LoggerFactory.getLogger(StepMotorCharacteristicsPanel.class);

    private ConfigurationWizardModel configurationWizardModel;

    private ValueModel selectionHolderMotorSize;

    private JComboBox<MotorSizeType> comboMotorSize;

    private ValueModel stepCountValueModel;

    private JTextField textStepCount;

    private InputValidationDocument stepCountDocument;

    private ValueModel gearingModel;

    private JLabel gearRatioLabel;

    private JTextField textGearRatioPrimary;

    private JTextField textGearRatioSecondary;

    private InputValidationDocument gearRatioDocument;

    private JTextField textBackLash;

    private JLabel backLashLabel;

    private ValueModel microSteppingModel;

    private JComboBox<MicroStepsEnum> comboMicroSteps;

    private ValueModel speedScaleModel;

    private ValueModel accelarationScaleModel;

    private ValueModel speedModel;

    private ValueModel accelModel;

    private ValueModel decelModel;

    private WizardValidationResultModel motorCharacteristicsValidationModel;

    public StepMotorCharacteristicsPanel(final JWizardComponents wizardComponents,
        final ConfigurationWizardModel configurationWizardModel) {
        super(wizardComponents);

        this.configurationWizardModel = configurationWizardModel;
    }

    @Override
    protected void initPanel() {
        super.initPanel();

        motorCharacteristicsValidationModel = new WizardValidationResultModel();

        // prepare the form
        boolean debug = false;
        FormBuilder builder =
            FormBuilder
                .create().columns("p, 3dlu, p:g")
                .rows(
                    "p, 3dlu, p, 3dlu, p, 3dlu, p, 3dlu, p, 3dlu, p, 3dlu, p, 3dlu, p, 3dlu, p, 3dlu, p, 3dlu, p, 3dlu, p")
                .panel(debug ? new FormDebugPanel() : new JPanel());

        builder.border(Paddings.TABBED_DIALOG);

        builder.add(Resources.getString(getClass(), "message")).xyw(1, 1, 3);

        // add the components
        selectionHolderMotorSize =
            new PropertyAdapter<ConfigurationWizardModel>(configurationWizardModel,
                ConfigurationWizardModel.PROPERTYNAME_MOTORSIZE_TYPE, true);

        List<MotorSizeType> motorSizes = new ArrayList<>();
        for (MotorSizeType motorSize : MotorSizeType.values()) {
            motorSizes.add(motorSize);
        }

        ComboBoxAdapter<MotorSizeType> comboBoxAdapterMotorSize =
            new ComboBoxAdapter<MotorSizeType>(motorSizes, selectionHolderMotorSize);
        comboMotorSize = new JComboBox<>();
        comboMotorSize.setModel(comboBoxAdapterMotorSize);

        builder.add(Resources.getString(getClass(), "motorSize")).xy(1, 3);
        builder.add(comboMotorSize).xy(3, 3);

        ValidationComponentUtils.setMandatory(comboMotorSize, true);
        ValidationComponentUtils.setMessageKeys(comboMotorSize, "validation.motorSize");

        // step count
        stepCountValueModel =
            new PropertyAdapter<ConfigurationWizardModel>(configurationWizardModel,
                ConfigurationWizardModel.PROPERTYNAME_STEPCOUNT, true);

        final ValueModel stepCountConverterModel =
            new ConverterValueModel(stepCountValueModel, new StringConverter(new DecimalFormat("#")));
        // create the textfield for the stepCount number
        textStepCount = new JTextField();
        stepCountDocument = new InputValidationDocument(5, InputValidationDocument.NUMERIC);
        textStepCount.setDocument(stepCountDocument);
        textStepCount.setColumns(5);

        // bind manually because we changed the document of the textfield
        Bindings.bind(textStepCount, stepCountConverterModel, false);
        builder.add(Resources.getString(getClass(), "stepCount")).xy(1, 5);
        builder.add(textStepCount).xy(3, 5);

        ValidationComponentUtils.setMandatory(textStepCount, true);
        ValidationComponentUtils.setMessageKeys(textStepCount, "validation.stepCount");

        // gearing
        final FormBuilder gearingBuilder = FormBuilder.create().columns("pref, 3dlu, pref").rows("p, 3dlu, p");

        gearingModel =
            new PropertyAdapter<ConfigurationWizardModel>(configurationWizardModel,
                ConfigurationWizardModel.PROPERTYNAME_GEARING, true);

        int column = 1;
        for (int i = 0; i < 2; i++) {
            Gearing gearing = null;
            switch (i) {
                case 0:
                    gearing = new Gearing(Gearing.NO);
                    break;
                default:
                    gearing = (Gearing) gearingModel.getValue();
                    if (gearing == null || Gearing.NO.equals(gearing.getKey())) {
                        gearing = new Gearing(Gearing.YES);
                    }
                    break;
            }

            JRadioButton radio =
                WizardComponentFactory
                    .createRadioButton(gearingModel, gearing, Resources.getString(Gearing.class, gearing.getKey()));

            // add radio button
            gearingBuilder.add(radio).xy(column, 1);
            column += 2;
        }

        builder.add(Resources.getString(getClass(), "gearing")).xy(1, 7);
        builder.add(gearingBuilder.build()).xy(3, 7);

        // add the input elements for the gearing
        final FormBuilder gearingAddedBuilder =
            FormBuilder.create().columns("pref, 3dlu, pref, 3dlu, pref, 3dlu, pref").rows("p, 3dlu, p");

        // create the textfield for the gear ratio number
        ValueModel gearRatioPrimaryValueModel =
            new PropertyAdapter<Gearing>(gearingModel, Gearing.PROPERTYNAME_GEARRATIO_PRIMARY, true);

        final ValueModel gearRatioPrimaryConverterModel =
            new ConverterValueModel(gearRatioPrimaryValueModel, new StringConverter(new DecimalFormat("#")));

        textGearRatioPrimary = new JTextField();
        InputValidationDocument gearRatioPrimaryDocument =
            new InputValidationDocument(3, InputValidationDocument.NUMERIC);
        textGearRatioPrimary.setDocument(gearRatioPrimaryDocument);
        textGearRatioPrimary.setColumns(3);

        // bind manually because we changed the document of the textfield
        Bindings.bind(textGearRatioPrimary, gearRatioPrimaryConverterModel, false);
        gearRatioLabel = new JLabel(Resources.getString(getClass(), "gearRatio"));
        gearingAddedBuilder.add(gearRatioLabel).xy(1, 1);
        gearingAddedBuilder.add(textGearRatioPrimary).xy(3, 1);

        ValidationComponentUtils.setMandatory(textGearRatioPrimary, true);
        ValidationComponentUtils
            .setMessageKeys(textGearRatioPrimary, "validation." + Gearing.PROPERTYNAME_GEARRATIO_PRIMARY);

        // create the textfield for the gear ratio number
        ValueModel gearRatioSecondaryValueModel =
            new PropertyAdapter<Gearing>(gearingModel, Gearing.PROPERTYNAME_GEARRATIO_SECONDARY, true);

        final DecimalFormat decFormat = new DecimalFormat("#");
        final ValueModel gearRatioSecondaryConverterModel =
            new ConverterValueModel(gearRatioSecondaryValueModel, new StringConverter(decFormat));

        textGearRatioSecondary = new JTextField();
        gearRatioDocument = new InputValidationDocument(5, InputValidationDocument.NUMERIC);
        textGearRatioSecondary.setDocument(gearRatioDocument);
        textGearRatioSecondary.setColumns(5);

        // bind manually because we changed the document of the textfield
        Bindings.bind(textGearRatioSecondary, gearRatioSecondaryConverterModel, false);
        gearingAddedBuilder.add(":").xy(5, 1);
        gearingAddedBuilder.add(textGearRatioSecondary).xy(7, 1);

        ValidationComponentUtils.setMandatory(textGearRatioSecondary, true);
        ValidationComponentUtils
            .setMessageKeys(textGearRatioSecondary, "validation." + Gearing.PROPERTYNAME_GEARRATIO_SECONDARY);

        gearRatioLabel.setEnabled(false);

        textGearRatioPrimary.setEnabled(false);
        textGearRatioSecondary.setEnabled(false);

        // back lash
        ValueModel backLashValueModel = new PropertyAdapter<Gearing>(gearingModel, Gearing.PROPERTYNAME_BACKLASH, true);

        final ValueModel backLashConverterModel =
            new ConverterValueModel(backLashValueModel, new StringConverter(new DecimalFormat("#")));

        textBackLash = new JTextField();
        InputValidationDocument backLashDocument = new InputValidationDocument(5, InputValidationDocument.NUMERIC);
        textBackLash.setDocument(backLashDocument);
        textBackLash.setColumns(5);

        Bindings.bind(textBackLash, backLashConverterModel, false);
        backLashLabel = new JLabel(Resources.getString(getClass(), "backLash"));
        gearingAddedBuilder.add(backLashLabel).xy(1, 3);
        gearingAddedBuilder.add(textBackLash).xyw(3, 3, 3);

        ValidationComponentUtils.setMandatory(textBackLash, true);
        ValidationComponentUtils.setMessageKeys(textBackLash, "validation." + Gearing.PROPERTYNAME_BACKLASH);

        textBackLash.setEnabled(false);
        backLashLabel.setEnabled(false);

        builder.add(new JLabel()).xy(1, 9);
        builder.add(gearingAddedBuilder.build()).xy(3, 9);

        // micro stepping
        microSteppingModel =
            new PropertyAdapter<ConfigurationWizardModel>(configurationWizardModel,
                ConfigurationWizardModel.PROPERTYNAME_MICROSTEPPING, true);

        // create the combo for the micro steps
        comboMicroSteps = new JComboBox<>();
        ComboBoxAdapter<MicroStepsEnum> comboAdapterMicroSteps =
            new ComboBoxAdapter<MicroStepsEnum>(MicroStepsEnum.values(), microSteppingModel);
        comboMicroSteps.setModel(comboAdapterMicroSteps);
        comboMicroSteps.setRenderer(new MicroStepsCellRenderer());

        builder.add(Resources.getString(getClass(), "microStepping")).xy(1, 11);
        builder.add(comboMicroSteps).xy(3, 11);

        ValidationComponentUtils.setMandatory(comboMicroSteps, true);
        ValidationComponentUtils
            .setMessageKeys(comboMicroSteps, "validation." + ConfigurationWizardModel.PROPERTYNAME_MICROSTEPPING);

        // speed scale
        FormBuilder speedScaleBuilder = FormBuilder.create().columns("pref, 3dlu, pref").rows("pref, 3dlu, pref");
        speedScaleModel =
            new PropertyAdapter<ConfigurationWizardModel>(configurationWizardModel,
                ConfigurationWizardModel.PROPERTYNAME_SPEED_SCALE, true);

        column = 1;
        for (int i = 0; i < 2; i++) {
            MovementScaleEnum speedScale = null;
            switch (i) {
                case 0:
                    speedScale = MovementScaleEnum.scale0_1;
                    break;
                default:
                    speedScale = MovementScaleEnum.scale1;
                    break;
            }

            JRadioButton radio =
                WizardComponentFactory
                    .createRadioButton(speedScaleModel, speedScale,
                        Resources.getString(MovementScaleEnum.class, speedScale.getKey()));

            // add radio button
            speedScaleBuilder.add(radio).xy(column, 1);
            column += 2;

            // TODO enable the radio button
            radio.setEnabled(false);
        }

        builder.add(Resources.getString(getClass(), "speedScale")).xy(1, 13);
        builder.add(speedScaleBuilder.build()).xy(3, 13);
        // builder.nextLine();

        // accelaration scale
        FormBuilder accelarationScaleBuilder =
            FormBuilder.create().columns("pref, 3dlu, pref").rows("pref, 3dlu, pref");
        accelarationScaleModel =
            new PropertyAdapter<ConfigurationWizardModel>(configurationWizardModel,
                ConfigurationWizardModel.PROPERTYNAME_ACCELERATION_SCALE, true);

        column = 1;
        for (int i = 0; i < 2; i++) {
            AccelarationScaleEnum accelarationScale = null;
            switch (i) {
                case 0:
                    accelarationScale = AccelarationScaleEnum.scale0_1;
                    break;
                default:
                    accelarationScale = AccelarationScaleEnum.scale1;
                    break;
            }

            JRadioButton radio =
                WizardComponentFactory
                    .createRadioButton(accelarationScaleModel, accelarationScale,
                        Resources.getString(AccelarationScaleEnum.class, accelarationScale.getKey()));

            // add radio button
            accelarationScaleBuilder.add(radio).xy(column, 1);
            column += 2;

            // TODO enable the radio button
            radio.setEnabled(false);
        }

        builder.add(Resources.getString(getClass(), "accelarationScale")).xy(1, 15);
        builder.add(accelarationScaleBuilder.build()).xy(3, 15);
        // builder.nextLine();

        // speed
        speedModel =
            new PropertyAdapter<ConfigurationWizardModel>(configurationWizardModel,
                ConfigurationWizardModel.PROPERTYNAME_SPEED, true);
        final ValueModel speedConverterModel =
            new ConverterValueModel(speedModel, new StringConverter(new DecimalFormat("#")));
        // create the textfield for the speed
        JTextField textSpeed = new JTextField();
        InputValidationDocument speedDocument = new InputValidationDocument(10, InputValidationDocument.NUMERIC);
        textSpeed.setDocument(speedDocument);
        textSpeed.setColumns(8);

        // bind manually because we changed the document of the textfield
        Bindings.bind(textSpeed, speedConverterModel, false);
        builder.add(Resources.getString(getClass(), "speed")).xy(1, 17);
        builder.add(textSpeed).xy(3, 17);

        textSpeed.setEditable(false);

        ValidationComponentUtils.setMandatory(textSpeed, true);
        ValidationComponentUtils.setMessageKeys(textSpeed, "validation." + ConfigurationWizardModel.PROPERTYNAME_SPEED);

        // accel
        accelModel =
            new PropertyAdapter<ConfigurationWizardModel>(configurationWizardModel,
                ConfigurationWizardModel.PROPERTYNAME_ACCEL, true);
        final ValueModel accelConverterModel =
            new ConverterValueModel(accelModel, new StringConverter(new DecimalFormat("#")));
        // create the textfield for the accel
        JTextField textAccel = new JTextField();
        InputValidationDocument accelDocument = new InputValidationDocument(10, InputValidationDocument.NUMERIC);
        textAccel.setDocument(accelDocument);
        textAccel.setColumns(8);

        // bind manually because we changed the document of the textfield
        Bindings.bind(textAccel, accelConverterModel, false);
        builder.add(Resources.getString(getClass(), "accel")).xy(1, 19);
        builder.add(textAccel).xy(3, 19);

        textAccel.setEditable(false);

        ValidationComponentUtils.setMandatory(textAccel, true);
        ValidationComponentUtils.setMessageKeys(textAccel, "validation." + ConfigurationWizardModel.PROPERTYNAME_ACCEL);

        // decel
        decelModel =
            new PropertyAdapter<ConfigurationWizardModel>(configurationWizardModel,
                ConfigurationWizardModel.PROPERTYNAME_DECEL, true);
        final ValueModel decelConverterModel =
            new ConverterValueModel(decelModel, new StringConverter(new DecimalFormat("#")));
        // create the textfield for the decel
        JTextField textDecel = new JTextField();
        InputValidationDocument decelDocument = new InputValidationDocument(10, InputValidationDocument.NUMERIC);
        textDecel.setDocument(decelDocument);
        textDecel.setColumns(8);

        // bind manually because we changed the document of the textfield
        Bindings.bind(textDecel, decelConverterModel, false);
        builder.add(Resources.getString(getClass(), "decel")).xy(1, 21);
        builder.add(textDecel).xy(3, 21);

        textDecel.setEditable(false);

        ValidationComponentUtils.setMandatory(textDecel, true);
        ValidationComponentUtils.setMessageKeys(textDecel, "validation." + ConfigurationWizardModel.PROPERTYNAME_DECEL);

        // total step count
        ValueModel totalStepCountModel =
            new PropertyAdapter<ConfigurationWizardModel>(configurationWizardModel,
                ConfigurationWizardModel.PROPERTYNAME_TOTALSTEPCOUNT, true);

        final ValueModel totalStepCountConverterModel =
            new ConverterValueModel(totalStepCountModel, new StringConverter(new DecimalFormat("#")));
        // create the textfield for the micro stepping number
        JTextField textTotalStepCount = new JTextField();
        InputValidationDocument totalStepCountDocument =
            new InputValidationDocument(10, InputValidationDocument.NUMERIC);
        textTotalStepCount.setDocument(totalStepCountDocument);
        textTotalStepCount.setColumns(10);

        // bind manually because we changed the document of the textfield
        Bindings.bind(textTotalStepCount, totalStepCountConverterModel, false);
        builder.add(Resources.getString(getClass(), "totalStepCount")).xy(1, 23);
        builder.add(textTotalStepCount).xy(3, 23);

        textTotalStepCount.setEditable(false);

        // check if we have validation enabled
        if (getValidationResultModel() != null) {
            LOGGER.debug("Create iconfeedback panel.");
            JComponent cvIconPanel = new IconFeedbackPanel(getValidationResultModel(), builder.build());

            FormBuilder feedbackBuilder = FormBuilder.create().columns("p:g").rows("fill:p:grow");
            feedbackBuilder.add(cvIconPanel).xy(1, 1);

            this.panel = feedbackBuilder.build();
        }
        else {
            this.panel = builder.build();
        }

        configurationWizardModel
            .addPropertyChangeListener(ConfigurationWizardModel.PROPERTYNAME_STEPCOUNT, new PropertyChangeListener() {

                @Override
                public void propertyChange(PropertyChangeEvent evt) {
                    triggerValidation();
                }
            });
        configurationWizardModel
            .addPropertyChangeListener(ConfigurationWizardModel.PROPERTYNAME_MICROSTEPPING,
                new PropertyChangeListener() {

                    @Override
                    public void propertyChange(PropertyChangeEvent evt) {
                        triggerValidation();
                    }
                });
        configurationWizardModel
            .addPropertyChangeListener(ConfigurationWizardModel.PROPERTYNAME_MOTORSIZE_TYPE,
                new PropertyChangeListener() {

                    @Override
                    public void propertyChange(PropertyChangeEvent evt) {
                        triggerValidation();
                    }
                });
        configurationWizardModel
            .addPropertyChangeListener(ConfigurationWizardModel.PROPERTYNAME_GEARING, new PropertyChangeListener() {

                @Override
                public void propertyChange(PropertyChangeEvent evt) {
                    updateGearingComponents();
                }
            });

        final PropertyChangeListener gearingModelChangeListener = new PropertyChangeListener() {

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                LOGGER.info("Property changed, evt: {}", evt);
                if (evt != null && (Gearing.PROPERTYNAME_GEARRATIO_PRIMARY.equals(evt.getPropertyName())
                    || Gearing.PROPERTYNAME_GEARRATIO_SECONDARY.equals(evt.getPropertyName()))) {
                    configurationWizardModel.triggerUpdateTotalSteps();
                }

                triggerValidation();
            }
        };

        gearingModel.addValueChangeListener(new PropertyChangeListener() {

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                LOGGER.info("The value of the gearing model has changed, evt: {}", evt);

                // we must remove and add the listener to gearing if gearing was changed.
                // otherwise the calculation of the total step count does not work.
                Gearing oldValue = (Gearing) evt.getOldValue();
                if (oldValue != null) {
                    oldValue
                        .removePropertyChangeListener(Gearing.PROPERTYNAME_GEARRATIO_PRIMARY,
                            gearingModelChangeListener);
                    oldValue
                        .removePropertyChangeListener(Gearing.PROPERTYNAME_GEARRATIO_SECONDARY,
                            gearingModelChangeListener);
                    oldValue.removePropertyChangeListener(Gearing.PROPERTYNAME_BACKLASH, gearingModelChangeListener);
                }
                Gearing newValue = (Gearing) evt.getNewValue();
                if (newValue != null) {
                    newValue
                        .addPropertyChangeListener(Gearing.PROPERTYNAME_GEARRATIO_PRIMARY, gearingModelChangeListener);
                    newValue
                        .addPropertyChangeListener(Gearing.PROPERTYNAME_GEARRATIO_SECONDARY,
                            gearingModelChangeListener);
                    newValue.addPropertyChangeListener(Gearing.PROPERTYNAME_BACKLASH, gearingModelChangeListener);
                }
                triggerValidation();
            }
        });

        if (gearingModel.getValue() != null) {
            LOGGER.info("Add initial property change listener for gearing properties.");
            Gearing gearing = (Gearing) gearingModel.getValue();
            gearing.addPropertyChangeListener(Gearing.PROPERTYNAME_GEARRATIO_PRIMARY, gearingModelChangeListener);
            gearing.addPropertyChangeListener(Gearing.PROPERTYNAME_GEARRATIO_SECONDARY, gearingModelChangeListener);
            gearing.addPropertyChangeListener(Gearing.PROPERTYNAME_BACKLASH, gearingModelChangeListener);
        }

        PropertyConnector.connect(motorCharacteristicsValidationModel, "validStateNoWarnOrErrors", this, "stepValid");

        LOGGER.info("initPanel finished.");
    }

    protected ValidationResultModel getValidationResultModel() {
        return motorCharacteristicsValidationModel;
    }

    private ValidationResult validate() {
        PropertyValidationSupport support = new PropertyValidationI18NSupport(configurationWizardModel, "validation");

        if (comboMotorSize.getSelectedItem() == null) {
            support.addError("motorSize", "not_empty");
        }

        // TODO get the validation ranges from CV definition

        if (configurationWizardModel.getStepCount() == null || configurationWizardModel.getStepCount() < 1) {
            support.addError("stepCount", "invalid_value;min=4,max=16384");
        }

        Gearing gearing = configurationWizardModel.getGearing();
        if (gearing != null && Gearing.YES.equals(gearing.getKey())) {
            // gearing is active
            if (gearing.getBackLash() == null || gearing.getBackLash() < 0) {
                support.addError(Gearing.PROPERTYNAME_BACKLASH, "invalid_value;min=0,max=1000");
            }
            // enable validation for gearRatio primary
            if (gearing.getGearRatioPrimary() == null || gearing.getGearRatioPrimary() < 1
                || gearing.getGearRatioPrimary() > 255) {
                support.addError(Gearing.PROPERTYNAME_GEARRATIO_PRIMARY, "invalid_value;min=1,max=255");
            }
            if (gearing.getGearRatioSecondary() == null || gearing.getGearRatioSecondary() < 1
                || gearing.getGearRatioSecondary() > 20000) {
                support.addError(Gearing.PROPERTYNAME_GEARRATIO_SECONDARY, "invalid_value;min=1,max=20000");
            }
        }

        if (configurationWizardModel.getMicroStepping() == null) {
            support.addError("microStepping", "invalid_value;min=64,max=256");
        }

        // TODO add validation for SFR and speed, accel and decel
        if (configurationWizardModel.getMicroStepping() != null && configurationWizardModel.getStepCount() != null) {

            try {
                // calc max speed
                long maxSpeed =
                    SpeedRangeValidationUtils
                        .calculateValidMaxSpeed(configurationWizardModel.getMicroStepping().getSteps(),
                            configurationWizardModel.getStepCount(), configurationWizardModel.getSpeedScale());

                LOGGER
                    .info("The calculated maxSpeed: {}, selected speed: {}", maxSpeed,
                        configurationWizardModel.getSpeed());
                if (configurationWizardModel.getSpeed() > maxSpeed) {
                    support.addError("speed", "invalid_value");
                }
            }
            catch (Exception ex) {
                LOGGER.warn("Validation of speed value failed", ex);
                support.addError("speed", "invalid_value");
            }

            try {
                // calc min accel and decel
                long accelDecelLimit = SpeedRangeValidationUtils.F_STEP_ACCEL_LIMITx10;
                if (configurationWizardModel.getAccelerationScale() == AccelarationScaleEnum.scale0_1) {
                    accelDecelLimit = SpeedRangeValidationUtils.F_STEP_ACCEL_LIMIT;
                }

                long accelarationFactor =
                    SpeedRangeValidationUtils
                        .calculateValidAccelarationFactor(configurationWizardModel.getMicroStepping().getSteps(),
                            configurationWizardModel.getStepCount());

                long minAccel = accelarationFactor * configurationWizardModel.getAccel();
                LOGGER.info("The calculated minAccel: {}", minAccel);
                if (minAccel < accelDecelLimit) {
                    support.addError("accel", "invalid_value");
                }

                long minDecel = accelarationFactor * configurationWizardModel.getDecel();
                LOGGER.info("The calculated minDecel: {}", minDecel);
                if (minDecel < accelDecelLimit) {
                    support.addError("decel", "invalid_value");
                }
            }
            catch (Exception ex) {
                LOGGER.warn("Validation of speed value failed", ex);
                support.addError("speed", "invalid_value");
            }
        }

        ValidationResult validationResult = support.getResult();
        LOGGER.info("Prepared validationResult: {}", validationResult);
        return validationResult;
    }

    protected void triggerValidation() {
        ValidationResult validationResult = validate();
        motorCharacteristicsValidationModel.setResult(validationResult);
    }

    @Override
    public void update() {
        LOGGER.info("update is called.");
        super.update();
        updateGearingComponents();
    }

    private void updateGearingComponents() {
        if (configurationWizardModel.getGearing() != null
            && Gearing.YES.equals(configurationWizardModel.getGearing().getKey())) {
            // set the gearing parts enabled
            gearRatioLabel.setEnabled(true);

            textGearRatioPrimary.setEnabled(true);
            textGearRatioSecondary.setEnabled(true);

            textBackLash.setEnabled(true);
            backLashLabel.setEnabled(true);
        }
        else {
            // set the gearing parts disabled
            gearRatioLabel.setEnabled(false);

            textGearRatioPrimary.setEnabled(false);
            textGearRatioSecondary.setEnabled(false);

            textBackLash.setEnabled(false);
            backLashLabel.setEnabled(false);
        }

        triggerValidation();
    }

    private class MicroStepsCellRenderer extends DefaultListCellRenderer {
        private static final long serialVersionUID = 1L;

        private Map<String, String> labelMap = new HashMap<>();

        public MicroStepsCellRenderer() {
            for (MicroStepsEnum microStepEnum : MicroStepsEnum.values()) {
                String label = Resources.getString(MicroStepsEnum.class, microStepEnum.getKey());
                labelMap.put(microStepEnum.getKey(), label);
            }
        }

        @Override
        public Component getListCellRendererComponent(
            JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {

            JLabel renderer = (JLabel) super.getListCellRendererComponent(list, value, index, isSelected, cellHasFocus);

            if (value instanceof MicroStepsEnum) {
                MicroStepsEnum microStepEnum = (MicroStepsEnum) value;
                renderer.setText(labelMap.get(microStepEnum.getKey()));
            }
            else {
                renderer.setText(null);
            }

            return renderer;
        }
    }

}
