/*
 * Decompiled with CFR 0.152.
 */
package org.bidib.wizard.mvc.backup.view;

import com.jgoodies.binding.adapter.SingleListSelectionAdapter;
import com.jgoodies.binding.beans.PropertyAdapter;
import com.jgoodies.binding.beans.PropertyConnector;
import com.jgoodies.binding.list.SelectionInList;
import com.jgoodies.binding.value.BindingConverter;
import com.jgoodies.binding.value.ConverterValueModel;
import com.jgoodies.binding.value.ValueModel;
import com.jgoodies.forms.builder.FormBuilder;
import com.jgoodies.forms.debug.FormDebugPanel;
import com.jgoodies.forms.factories.Paddings;
import com.jidesoft.grid.CellRendererManager;
import com.jidesoft.grid.EditorContext;
import com.jidesoft.grid.SortableTableModel;
import com.jidesoft.grid.TableColumnChooserPopupMenuCustomizer;
import com.jidesoft.grid.TableHeaderPopupMenuCustomizer;
import com.jidesoft.grid.TableHeaderPopupMenuInstaller;
import com.jidesoft.grid.TableModelWrapperUtils;
import com.jidesoft.swing.DefaultOverlayable;
import com.jidesoft.swing.JideSwingUtilities;
import com.jidesoft.swing.StyledLabelBuilder;
import com.vlsolutions.swing.docking.DockKey;
import com.vlsolutions.swing.docking.Dockable;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Insets;
import java.awt.event.MouseListener;
import java.io.File;
import java.io.IOException;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.LinkedList;
import java.util.concurrent.CompletableFuture;
import java.util.function.BiConsumer;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.ListModel;
import javax.swing.ListSelectionModel;
import javax.swing.SwingUtilities;
import javax.swing.border.Border;
import javax.swing.event.DocumentListener;
import javax.swing.event.TableModelListener;
import javax.swing.filechooser.FileFilter;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableModel;
import javax.swing.text.Document;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.StringUtils;
import org.bidib.wizard.api.locale.Resources;
import org.bidib.wizard.client.common.table.ProgressCellRenderer;
import org.bidib.wizard.client.common.text.WizardComponentFactory;
import org.bidib.wizard.client.common.view.DockKeys;
import org.bidib.wizard.client.common.view.statusbar.StatusBarPublisher;
import org.bidib.wizard.common.model.settings.WizardSettingsInterface;
import org.bidib.wizard.common.service.SettingsService;
import org.bidib.wizard.mvc.backup.controller.listener.BackupControllerListener;
import org.bidib.wizard.mvc.backup.model.BackupTableModel;
import org.bidib.wizard.mvc.backup.model.NodeBackupModel;
import org.bidib.wizard.mvc.backup.view.BackupTableTableModel;
import org.bidib.wizard.mvc.backup.view.BackupView;
import org.bidib.wizard.mvc.common.view.text.ChangeDocumentListener;
import org.bidib.wizard.mvc.debug.view.FileStringConverter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BackupView
implements Dockable {
    private static final Logger LOGGER = LoggerFactory.getLogger(BackupView.class);
    private static final String ENCODED_DIALOG_COLUMN_SPECS = "pref, 3dlu, fill:pref:grow, 3dlu, pref";
    private static final String ENCODED_DIALOG_ROW_SPECS = "p, 3dlu, fill:50dlu:grow, 3dlu, p, 3dlu, p";
    private final JPanel contentPanel;
    private SelectionInList<NodeBackupModel> nodeBackupSelection;
    private TableModelListener tableModelListener;
    private ValueModel backupDirectoryValueModel;
    private JTextField backupDirectoryText;
    private final JButton selectDirectoryButton = new JButton(Resources.getString(this.getClass(), (String)"select"));
    private final JButton startBackupButton = new JButton(Resources.getString(this.getClass(), (String)"startBackup"));
    private final BackupTableModel backupTableModel;
    private final SettingsService settingsService;
    private final BackupControllerListener backupController;
    private final StatusBarPublisher<String, Integer> statusBarPublisher;
    private static final String WORKING_DIR_BACKUP_KEY = "backup";

    public BackupView(BackupControllerListener backupController, BackupTableModel backupTableModel, SettingsService settingsService, StatusBarPublisher<String, Integer> statusBarPublisher) {
        Object panel;
        this.backupController = backupController;
        this.backupTableModel = backupTableModel;
        this.settingsService = settingsService;
        this.statusBarPublisher = statusBarPublisher;
        DockKeys.DOCKKEY_BACKUP_VIEW.setName(Resources.getString(this.getClass(), (String)"title"));
        DockKeys.DOCKKEY_BACKUP_VIEW.setFloatEnabled(true);
        DockKeys.DOCKKEY_BACKUP_VIEW.setAutoHideEnabled(false);
        LOGGER.info("Create new BackupView");
        WizardSettingsInterface wizardSettings = this.settingsService.getWizardSettings();
        String storedBackupDirectory = wizardSettings.getWorkingDirectory(WORKING_DIR_BACKUP_KEY);
        if (StringUtils.isNotBlank((CharSequence)storedBackupDirectory)) {
            try {
                this.backupTableModel.setBackupDirectory(new File(storedBackupDirectory));
            }
            catch (Exception ex) {
                LOGGER.warn("Set the backup directory in the model failed.", (Throwable)ex);
            }
        }
        FormBuilder dialogBuilder = null;
        boolean debugDialog = false;
        if (debugDialog) {
            panel = new FormDebugPanel();
            dialogBuilder = FormBuilder.create().columns(ENCODED_DIALOG_COLUMN_SPECS, new Object[0]).rows(ENCODED_DIALOG_ROW_SPECS, new Object[0]).panel((JPanel)panel);
        } else {
            panel = new JPanel(new BorderLayout());
            dialogBuilder = FormBuilder.create().columns(ENCODED_DIALOG_COLUMN_SPECS, new Object[0]).rows(ENCODED_DIALOG_ROW_SPECS, new Object[0]).panel((JPanel)panel);
        }
        dialogBuilder.border((Border)Paddings.DIALOG);
        dialogBuilder.add(Resources.getString(this.getClass(), (String)"select-nodes-to-backup"), new Object[0]).xyw(1, 1, 3);
        this.nodeBackupSelection = new SelectionInList((ListModel)this.backupTableModel.getNodeBackupListModel());
        SortableTableModel tableModel = new SortableTableModel((TableModel)new BackupTableTableModel(this.nodeBackupSelection));
        1 backupTable = new /* Unavailable Anonymous Inner Class!! */;
        backupTable.adjustRowHeight();
        backupTable.setSelectionModel((ListSelectionModel)new SingleListSelectionAdapter(this.nodeBackupSelection.getSelectionIndexHolder()));
        backupTable.setAutoResizeMode(259);
        CellRendererManager.registerRenderer(Integer.class, (TableCellRenderer)new ProgressCellRenderer(true), (EditorContext)ProgressCellRenderer.CONTEXT);
        TableColumn tc = backupTable.getColumnModel().getColumn(0);
        tc.setPreferredWidth(30);
        tc.setMaxWidth(50);
        tc = backupTable.getColumnModel().getColumn(1);
        tc.setMinWidth(120);
        tc.setMaxWidth(150);
        tc.setPreferredWidth(150);
        tc = backupTable.getColumnModel().getColumn(2);
        tc.setPreferredWidth(300);
        tc = backupTable.getColumnModel().getColumn(3);
        this.tableModelListener = new /* Unavailable Anonymous Inner Class!! */;
        tableModel.addTableModelListener(this.tableModelListener);
        SortableTableModel sortableTableModel = (SortableTableModel)TableModelWrapperUtils.getActualTableModel((TableModel)backupTable.getModel(), SortableTableModel.class);
        sortableTableModel.setColumnSortable(0, false);
        3 header = new /* Unavailable Anonymous Inner Class!! */;
        header.setAutoFilterEnabled(true);
        header.setUseNativeHeaderRenderer(true);
        backupTable.setTableHeader((JTableHeader)header);
        JideSwingUtilities.insertMouseListener((Component)header, (MouseListener)new /* Unavailable Anonymous Inner Class!! */, (int)0);
        TableHeaderPopupMenuInstaller installer = new TableHeaderPopupMenuInstaller((JTable)backupTable);
        installer.addTableHeaderPopupMenuCustomizer((TableHeaderPopupMenuCustomizer)new TableColumnChooserPopupMenuCustomizer());
        DefaultOverlayable overlayTable = new DefaultOverlayable((JComponent)new JScrollPane((Component)backupTable));
        tableModel.addTableModelListener((TableModelListener)new /* Unavailable Anonymous Inner Class!! */);
        overlayTable.addOverlayComponent((JComponent)StyledLabelBuilder.createStyledLabel((String)("{" + backupTable.getEmptyTableText() + ":f:gray}")));
        dialogBuilder.add((Component)overlayTable).xyw(1, 3, 5);
        this.backupDirectoryValueModel = new PropertyAdapter((Object)this.backupTableModel, "backupDirectory", true);
        ConverterValueModel backupDirectoryConverterModel = new ConverterValueModel(this.backupDirectoryValueModel, (BindingConverter)new FileStringConverter());
        this.backupDirectoryText = WizardComponentFactory.createTextField((ValueModel)backupDirectoryConverterModel, (boolean)true);
        this.backupDirectoryText.setEditable(false);
        DefaultOverlayable backupDirectoryOverlayable = new DefaultOverlayable((JComponent)this.backupDirectoryText);
        backupDirectoryOverlayable.addOverlayComponent((JComponent)StyledLabelBuilder.createStyledLabel((String)("{" + Resources.getString(this.getClass(), (String)"backupDirectory.prompt") + ":f:gray}")), 7);
        backupDirectoryOverlayable.setOverlayLocationInsets(new Insets(0, -5, 0, 5));
        Document backupDirectoryDoc = this.backupDirectoryText.getDocument();
        backupDirectoryDoc.addDocumentListener((DocumentListener)new ChangeDocumentListener(doc -> backupDirectoryOverlayable.setOverlayVisible(doc.getLength() < 1)));
        backupDirectoryOverlayable.setOverlayVisible(backupDirectoryDoc.getLength() < 1);
        dialogBuilder.add(Resources.getString(this.getClass(), (String)"backupDirectory"), new Object[0]).xy(1, 5);
        dialogBuilder.add((Component)backupDirectoryOverlayable).xy(3, 5);
        dialogBuilder.add((Component)this.selectDirectoryButton).xy(5, 5);
        this.selectDirectoryButton.addActionListener(evt -> this.fireSelectDirectory());
        this.selectDirectoryButton.setEnabled(true);
        dialogBuilder.add((Component)this.startBackupButton).xy(1, 7);
        this.startBackupButton.addActionListener(evt -> this.fireStartBackup());
        this.startBackupButton.setEnabled(false);
        this.contentPanel = dialogBuilder.build();
        PropertyConnector.connect((Object)this.backupTableModel, (String)"backupEnabled", (Object)this.startBackupButton, (String)"enabled");
        this.startBackupButton.setEnabled(this.backupTableModel.isBackupEnabled());
    }

    public DockKey getDockKey() {
        return DockKeys.DOCKKEY_BACKUP_VIEW;
    }

    public Component getComponent() {
        return this.contentPanel;
    }

    private void fireSelectDirectory() {
        WizardSettingsInterface wizardSettings = this.settingsService.getWizardSettings();
        String storedBackupDirectory = wizardSettings.getWorkingDirectory(WORKING_DIR_BACKUP_KEY);
        FileFilter[] ff = null;
        6 dialog = new /* Unavailable Anonymous Inner Class!! */;
        dialog.showDialog();
    }

    private void fireStartBackup() {
        File backupDir;
        LinkedList<NodeBackupModel> nodeBackupModels = new LinkedList<NodeBackupModel>();
        for (NodeBackupModel nodeBackupModel : this.backupTableModel.getNodes()) {
            if (nodeBackupModel.isSelected()) {
                nodeBackupModels.add(nodeBackupModel);
            }
            nodeBackupModel.setProgress(0);
        }
        if (CollectionUtils.isEmpty(nodeBackupModels)) {
            JOptionPane.showMessageDialog(this.contentPanel, Resources.getString(this.getClass(), (String)"backup.no-nodes-selected"), Resources.getString(this.getClass(), (String)"title"), 2);
            return;
        }
        WizardSettingsInterface wizardSettings = this.settingsService.getWizardSettings();
        String storedBackupDirectory = wizardSettings.getWorkingDirectory(WORKING_DIR_BACKUP_KEY);
        boolean nodeExportAppendDateEnabled = wizardSettings.isNodeExportAppendDateEnabled();
        if (nodeExportAppendDateEnabled) {
            LocalDateTime now = LocalDateTime.now();
            DateTimeFormatter formatter = DateTimeFormatter.ofPattern("yyyyMMdd_HHmmss");
            String currentDateTime = now.format(formatter);
            backupDir = new File(storedBackupDirectory, currentDateTime);
            LOGGER.info("Use storedBackupDirectory with timestamp as backupDir: {}", (Object)backupDir);
        } else {
            backupDir = new File(storedBackupDirectory);
            LOGGER.info("Use storedBackupDirectory as backupDir: {}", (Object)backupDir);
        }
        String storedBackupDirectoryWithTime = backupDir.getPath();
        try {
            FileUtils.forceMkdir((File)backupDir);
        }
        catch (IOException ex) {
            LOGGER.warn("Create backup directory with date and time failed.", (Throwable)ex);
            JOptionPane.showMessageDialog(this.contentPanel, Resources.getString(this.getClass(), (String)"backup.create-backup-dir-failed", (Object[])new Object[]{storedBackupDirectoryWithTime}), Resources.getString(this.getClass(), (String)"title"), 2);
            return;
        }
        this.statusBarPublisher.publish((Object)Resources.getString(this.getClass(), (String)"backup.started", (Object[])new Object[]{storedBackupDirectoryWithTime}), null);
        LOGGER.info("Perform the backup async.");
        CompletableFuture<Object> results = CompletableFuture.supplyAsync(() -> this.backupController.performBackup(storedBackupDirectoryWithTime, nodeBackupModels));
        BiConsumer<Object, Throwable> handle = (s, t) -> {
            LOGGER.info("The backup has finished with verdict: {}", s, t);
            if (t == null) {
                this.statusBarPublisher.publish((Object)Resources.getString(this.getClass(), (String)"backup.finished", (Object[])new Object[]{storedBackupDirectoryWithTime}), null);
                SwingUtilities.invokeLater(() -> JOptionPane.showMessageDialog(this.contentPanel, Resources.getString(this.getClass(), (String)"backup.finished.dialog", (Object[])new Object[]{storedBackupDirectoryWithTime}), Resources.getString(this.getClass(), (String)"title"), 1));
            } else {
                this.statusBarPublisher.publish((Object)Resources.getString(this.getClass(), (String)"backup.finished-with-error", (Object[])new Object[]{storedBackupDirectoryWithTime}), null);
                SwingUtilities.invokeLater(() -> JOptionPane.showMessageDialog(this.contentPanel, Resources.getString(this.getClass(), (String)"backup.finished-with-error.dialog", (Object[])new Object[]{storedBackupDirectoryWithTime}), Resources.getString(this.getClass(), (String)"title"), 2));
            }
        };
        try {
            results.whenCompleteAsync((BiConsumer)handle);
        }
        catch (Exception ex) {
            LOGGER.warn("The backup has finished but there was an error.", (Throwable)ex);
        }
    }
}

