/*
 * Decompiled with CFR 0.152.
 */
package org.bidib.wizard.mvc.booster.model;

import com.jgoodies.binding.beans.Model;
import com.jgoodies.common.collect.ArrayListModel;
import java.beans.PropertyChangeListener;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.function.Consumer;
import org.bidib.wizard.api.model.BoosterNodeInterface;
import org.bidib.wizard.api.model.NodeInterface;
import org.bidib.wizard.api.model.listener.BoosterStatusListener;
import org.bidib.wizard.api.model.listener.CommandStationStatusListener;
import org.bidib.wizard.api.service.console.ConsoleService;
import org.bidib.wizard.client.common.view.statusbar.StatusBarPublisher;
import org.bidib.wizard.common.labels.WizardLabelWrapper;
import org.bidib.wizard.model.status.BoosterStatus;
import org.bidib.wizard.model.status.CommandStationStatus;
import org.bidib.wizard.mvc.booster.model.BoosterModel;
import org.bidib.wizard.mvc.booster.model.BoosterTableModel;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BoosterTableModel
extends Model {
    private static final long serialVersionUID = 1L;
    private static final Logger LOGGER = LoggerFactory.getLogger(BoosterTableModel.class);
    public static final String PROPERTY_BOOSTERS = "boosters";
    private ArrayListModel<BoosterModel> boosterList = new ArrayListModel();
    private final PropertyChangeListener boosterListener;
    private final CommandStationStatusListener commandStationStatusListener;
    private final BoosterStatusListener boosterStatusListener;
    private final ConsoleService consoleService;

    public BoosterTableModel(StatusBarPublisher<String, Integer> publisher, ConsoleService consoleService) {
        this.consoleService = consoleService;
        1 overcurrent = new /* Unavailable Anonymous Inner Class!! */;
        this.boosterListener = new /* Unavailable Anonymous Inner Class!! */;
        this.commandStationStatusListener = new /* Unavailable Anonymous Inner Class!! */;
        this.boosterStatusListener = new /* Unavailable Anonymous Inner Class!! */;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addBooster(NodeInterface node, WizardLabelWrapper wizardLabelWrapper) {
        ArrayListModel arrayListModel = this.boosterList;
        synchronized (arrayListModel) {
            BoosterModel booster = new BoosterModel(node, wizardLabelWrapper, this.boosterListener);
            if (!this.boosterList.contains((Object)booster)) {
                LOGGER.info("Add booster to booster list: {}", (Object)node);
                booster.registerNode();
                String nodeLabel = booster.prepareNodeLabel();
                booster.setNodeLabel(nodeLabel);
                LinkedList oldValue = new LinkedList(this.boosterList);
                this.boosterList.add((Object)booster);
                this.firePropertyChange(PROPERTY_BOOSTERS, oldValue, (Object)this.boosterList);
                if (node.getBoosterNode() != null) {
                    BoosterNodeInterface boosterNode = node.getBoosterNode();
                    boosterNode.addBoosterStatusListener(this.boosterStatusListener);
                    if (boosterNode.getBoosterStatus() != null) {
                        booster.setState(boosterNode.getBoosterStatus().getBoosterState());
                    }
                    booster.setVoltage(boosterNode.getBoosterVoltage());
                    booster.setTemperature(boosterNode.getBoosterTemperature());
                }
                if (node.getCommandStationNode() != null) {
                    node.getCommandStationNode().addCommandStationStatusListener(this.commandStationStatusListener);
                    if (node.getCommandStationNode().getCommandStationState() != null) {
                        booster.setCommandStationState(node.getCommandStationNode().getCommandStationState());
                    }
                }
            } else {
                LOGGER.warn("Node is already in booster list: {}", (Object)node);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeBooster(NodeInterface node) {
        ArrayListModel arrayListModel = this.boosterList;
        synchronized (arrayListModel) {
            LOGGER.info("Remove booster from booster list: {}", (Object)node);
            LinkedList oldValue = new LinkedList(this.boosterList);
            int index = this.boosterList.indexOf((Object)new BoosterModel(node, null, null));
            if (index > -1) {
                BoosterModel removed = (BoosterModel)this.boosterList.remove(index);
                if (removed != null) {
                    try {
                        if (removed.getBooster().getBoosterNode() != null) {
                            removed.getBooster().getBoosterNode().removeBoosterStatusListener(this.boosterStatusListener);
                        }
                        if (node.getCommandStationNode() != null) {
                            node.getCommandStationNode().removeCommandStationStatusListener(this.commandStationStatusListener);
                        }
                        removed.freeNode();
                    }
                    catch (Exception ex) {
                        LOGGER.warn("Free booster node failed.", (Throwable)ex);
                    }
                }
                this.firePropertyChange(PROPERTY_BOOSTERS, oldValue, (Object)this.boosterList);
            }
        }
    }

    public ArrayListModel<BoosterModel> getBoosterListModel() {
        return this.boosterList;
    }

    public List<BoosterModel> getBoosters() {
        return Collections.unmodifiableList(this.boosterList);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setBoosterState(NodeInterface node, BoosterStatus state) {
        int fireChangeIndex = -1;
        ArrayListModel arrayListModel = this.boosterList;
        synchronized (arrayListModel) {
            for (BoosterModel booster : this.boosterList) {
                int index;
                if (booster.getBooster().getUniqueId() != node.getUniqueId()) continue;
                LOGGER.trace("Found booster to update: {}", (Object)booster);
                booster.setState(state != null ? state.getBoosterState() : null);
                fireChangeIndex = index = this.boosterList.indexOf((Object)booster);
                break;
            }
        }
        if (fireChangeIndex > -1) {
            this.boosterList.fireContentsChanged(fireChangeIndex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setCommandStationStatus(NodeInterface node, CommandStationStatus status) {
        int fireChangeIndex = -1;
        ArrayListModel arrayListModel = this.boosterList;
        synchronized (arrayListModel) {
            for (BoosterModel booster : this.boosterList) {
                int index;
                if (booster.getBooster().getUniqueId() != node.getUniqueId()) continue;
                LOGGER.trace("Found command station to update: {}", (Object)booster);
                if (status == null) {
                    LOGGER.warn("The command station status is not available. Use OFF as state.");
                    status = CommandStationStatus.OFF;
                }
                booster.setCommandStationState(status.getCommandStationState());
                fireChangeIndex = index = this.boosterList.indexOf((Object)booster);
                break;
            }
        }
        if (fireChangeIndex > -1) {
            this.boosterList.fireContentsChanged(fireChangeIndex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setBoosterCurrent(NodeInterface node, Integer current, Consumer<Integer> overcurrent) {
        int fireChangeIndex = -1;
        ArrayListModel arrayListModel = this.boosterList;
        synchronized (arrayListModel) {
            for (BoosterModel booster : this.boosterList) {
                int index;
                if (booster.getBooster().getUniqueId() != node.getUniqueId()) continue;
                LOGGER.trace("Found booster to update: {}", (Object)booster);
                booster.setCurrent(current);
                if (current != null && booster.getMaxCurrent() != null && overcurrent != null && current > booster.getMaxCurrent()) {
                    overcurrent.accept(current);
                }
                fireChangeIndex = index = this.boosterList.indexOf((Object)booster);
                break;
            }
        }
        if (fireChangeIndex > -1) {
            this.boosterList.fireContentsChanged(fireChangeIndex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void triggerFetchBoosterMaxCurrent(NodeInterface node) {
        BoosterModel boosterToFetch = null;
        ArrayListModel arrayListModel = this.boosterList;
        synchronized (arrayListModel) {
            for (BoosterModel booster : this.boosterList) {
                if (booster.getBooster().getUniqueId() != node.getUniqueId()) continue;
                LOGGER.info("Fetch the max current value for booster: {}", (Object)booster);
                boosterToFetch = booster;
                break;
            }
        }
        if (boosterToFetch != null) {
            boosterToFetch.fetchMaxBoosterCurrent();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setBoosterVoltage(NodeInterface node, Integer voltage) {
        int fireChangeIndex = -1;
        ArrayListModel arrayListModel = this.boosterList;
        synchronized (arrayListModel) {
            for (BoosterModel booster : this.boosterList) {
                int index;
                if (booster.getBooster().getUniqueId() != node.getUniqueId()) continue;
                LOGGER.trace("Found booster to update: {}", (Object)booster);
                booster.setVoltage(voltage);
                fireChangeIndex = index = this.boosterList.indexOf((Object)booster);
                break;
            }
        }
        if (fireChangeIndex > -1) {
            this.boosterList.fireContentsChanged(fireChangeIndex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setBoosterTemperature(NodeInterface node, int temperature) {
        int fireChangeIndex = -1;
        ArrayListModel arrayListModel = this.boosterList;
        synchronized (arrayListModel) {
            for (BoosterModel booster : this.boosterList) {
                int index;
                if (booster.getBooster().getUniqueId() != node.getUniqueId()) continue;
                LOGGER.trace("Found booster to update: {}", (Object)booster);
                booster.setTemperature(Integer.valueOf(temperature));
                fireChangeIndex = index = this.boosterList.indexOf((Object)booster);
                break;
            }
        }
        if (fireChangeIndex > -1) {
            this.boosterList.fireContentsChanged(fireChangeIndex);
        }
    }
}

