/*
 * Decompiled with CFR 0.152.
 */
package org.bidib.wizard.mvc.locolist.view.wizard;

import com.jgoodies.forms.builder.ButtonBarBuilder;
import com.jgoodies.forms.builder.FormBuilder;
import com.jidesoft.dialog.PageListener;
import com.jidesoft.wizard.WelcomeWizardPage;
import java.awt.Component;
import java.awt.Window;
import java.awt.event.ActionListener;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.stream.Collectors;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.ListCellRenderer;
import org.apache.commons.collections4.CollectionUtils;
import org.bidib.jbidibc.core.schema.LocoLibraryFactory;
import org.bidib.jbidibc.core.schema.locolibrary.v1_0.LocoLibrary;
import org.bidib.jbidibc.core.schema.locolibrary.v1_0.LocoLibraryEntryType;
import org.bidib.wizard.api.locale.Resources;
import org.bidib.wizard.model.locolist.LocoListModel;
import org.bidib.wizard.model.status.SpeedSteps;
import org.bidib.wizard.mvc.locolist.model.LocoLibraryModel;
import org.bidib.wizard.mvc.locolist.model.LocoTableModel;
import org.bidib.wizard.mvc.locolist.view.wizard.SelectLocoPage;
import org.oxbow.swingbits.dialog.task.TaskDialog;
import org.oxbow.swingbits.dialog.task.TaskDialogs;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SelectLocoPage
extends WelcomeWizardPage {
    private static final long serialVersionUID = 1L;
    private static final Logger LOGGER = LoggerFactory.getLogger(SelectLocoPage.class);
    private static final String ENCODED_DIALOG_COLUMN_SPECS = "pref, 10dlu, pref:grow";
    private static final String ENCODED_DIALOG_ROW_SPECS = "pref";
    private final LocoTableModel locoTableModel;
    private final LocoLibraryModel locoLibrary;
    private JComboBox<LocoListModel>[] locoCombos;

    public SelectLocoPage(LocoTableModel locoTableModel, LocoLibraryModel locoLibrary) {
        super(Resources.getString(SelectLocoPage.class, (String)"title"), Resources.getString(SelectLocoPage.class, (String)"description"));
        this.locoTableModel = locoTableModel;
        this.locoLibrary = locoLibrary;
    }

    protected void initContentPane() {
        super.initContentPane();
        FormBuilder builder = FormBuilder.create().columns(ENCODED_DIALOG_COLUMN_SPECS, new Object[0]).rows(ENCODED_DIALOG_ROW_SPECS, new Object[0]).panel(new JPanel());
        ArrayList locos = new ArrayList();
        locos.add(null);
        locos.addAll(this.locoTableModel.getLocos());
        this.locoCombos = new JComboBox[8];
        int row = 3;
        for (int index = 0; index < 8; ++index) {
            JComboBox<LocoListModel> comboLoco = new JComboBox<LocoListModel>(locos.toArray(new LocoListModel[0]));
            comboLoco.setRenderer((ListCellRenderer<LocoListModel>)new LocoListRenderer());
            this.locoCombos[index] = comboLoco;
            builder.appendRows("3dlu, pref", new Object[0]);
            builder.add(Integer.toString(index), new Object[0]).xy(1, row);
            builder.add(comboLoco).xy(3, row);
            row += 2;
        }
        JButton loadButton = new JButton(Resources.getString(this.getClass(), (String)"load"));
        loadButton.addActionListener((ActionListener)new /* Unavailable Anonymous Inner Class!! */);
        JButton saveButton = new JButton(Resources.getString(this.getClass(), (String)"save"));
        saveButton.addActionListener((ActionListener)new /* Unavailable Anonymous Inner Class!! */);
        JPanel buttons = new ButtonBarBuilder().addGlue().addButton(new JComponent[]{loadButton, saveButton}).build();
        builder.appendRows("9dlu, pref", new Object[0]);
        builder.add((Component)buttons).xyw(1, row, 3);
        this.addComponent((JComponent)builder.build(), true);
        this.addPageListener((PageListener)new /* Unavailable Anonymous Inner Class!! */);
    }

    protected void fireSave() {
        LocoLibrary locoLibrary = new LocoLibrary();
        int index = 0;
        for (JComboBox combo : this.locoCombos) {
            Object selectedItem = combo.getSelectedItem();
            if (selectedItem instanceof LocoListModel) {
                LocoListModel locoModel = (LocoListModel)selectedItem;
                LocoLibraryEntryType locoListEntry = new LocoLibraryEntryType();
                locoListEntry.setIndex(index);
                locoListEntry.setAddress(locoModel.getLocoAddress());
                locoListEntry.setName(locoModel.getLocoName());
                locoListEntry.setSpeedSteps(SpeedSteps.valueOf((SpeedSteps)locoModel.getSpeedSteps()));
                locoLibrary.getLocoList().add(locoListEntry);
            }
            ++index;
        }
        File[] libraryFile = new File[1];
        XmlFileFilter ff = new XmlFileFilter(this);
        String defaultFilename = "locoLibrary-1.0.xml";
        String workingDirectory = null;
        4 dialog = new /* Unavailable Anonymous Inner Class!! */;
        dialog.showDialog();
        if (libraryFile[0] != null) {
            try {
                LocoLibraryFactory.saveLocoLibrary((LocoLibrary)locoLibrary, (File)libraryFile[0]);
            }
            catch (Exception ex) {
                LOGGER.warn("Save loco library failed.", (Throwable)ex);
                TaskDialogs.build((Window)JOptionPane.getFrameForComponent((Component)this), (String)Resources.getString(SelectLocoPage.class, (String)"save-failed.instruction"), (String)ex.getMessage()).title(Resources.getString(SelectLocoPage.class, (String)"save-failed.title")).icon((Icon)TaskDialog.StandardIcon.WARNING).inform();
            }
        }
    }

    protected void fireLoad() {
        File[] libraryFile = new File[1];
        XmlFileFilter ff = new XmlFileFilter(this);
        String workingDirectory = null;
        5 dialog = new /* Unavailable Anonymous Inner Class!! */;
        dialog.showDialog();
        if (libraryFile[0] != null) {
            try {
                for (JComboBox combo : this.locoCombos) {
                    combo.setSelectedItem(null);
                }
                LocoLibrary locoLibrary = LocoLibraryFactory.getLocoLibrary((File)libraryFile[0]);
                if (locoLibrary != null && CollectionUtils.isNotEmpty((Collection)locoLibrary.getLocoList())) {
                    LOGGER.info("Load the loco items.");
                    for (LocoLibraryEntryType locoListEntry : locoLibrary.getLocoList().stream().sorted((f1, f2) -> Integer.compare(f1.getIndex(), f2.getIndex())).collect(Collectors.toList())) {
                        int index = locoListEntry.getIndex();
                        if (index <= -1 || index >= this.locoCombos.length) continue;
                        JComboBox combo = this.locoCombos[index];
                        LocoListModel locoModel = new LocoListModel(locoListEntry.getAddress());
                        locoModel.setLocoName(locoListEntry.getName());
                        locoModel.setSpeedSteps(SpeedSteps.valueOf((int)locoListEntry.getSpeedSteps()));
                        combo.setSelectedItem(locoModel);
                    }
                }
            }
            catch (Exception ex) {
                LOGGER.warn("Load loco library failed.", (Throwable)ex);
                TaskDialogs.build((Window)JOptionPane.getFrameForComponent((Component)this), (String)Resources.getString(SelectLocoPage.class, (String)"load-failed.instruction"), (String)ex.getMessage()).title(Resources.getString(SelectLocoPage.class, (String)"load-failed.title")).icon((Icon)TaskDialog.StandardIcon.WARNING).inform();
            }
        }
    }
}

