/*
 * Decompiled with CFR 0.152.
 */
package org.bidib.wizard.mvc.main.model;

import java.util.Arrays;
import java.util.Set;
import java.util.function.IntConsumer;
import org.bidib.jbidibc.messages.enums.LcOutputType;
import org.bidib.jbidibc.messages.enums.PortConfigKeys;
import org.bidib.wizard.api.locale.Resources;
import org.bidib.wizard.client.common.model.SimpleHierarchicalPortTableModel;
import org.bidib.wizard.model.ports.BacklightPort;
import org.bidib.wizard.model.ports.Port;
import org.bidib.wizard.model.status.BacklightPortStatus;
import org.bidib.wizard.model.status.BidibStatus;
import org.bidib.wizard.mvc.main.model.listener.BacklightPortModelListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BacklightPortTableModel
extends SimpleHierarchicalPortTableModel<BacklightPortStatus, BacklightPort, BacklightPortModelListener> {
    private static final long serialVersionUID = 1L;
    private static final Logger LOGGER = LoggerFactory.getLogger(BacklightPortTableModel.class);
    public static final int COLUMN_LABEL = 0;
    public static final int COLUMN_DIM_SLOPE_UP = 1;
    public static final int COLUMN_DIM_SLOPE_DOWN = 2;
    public static final int COLUMN_DMX_MAPPING = 3;
    public static final int COLUMN_VALUE = 4;
    public static final int COLUMN_PORT_INSTANCE = 5;

    public int getColumnPortInstance() {
        return 5;
    }

    protected void initialize() {
        super.setPortValuesProcessing(true);
        this.columnNames = new String[]{Resources.getString(BacklightPortTableModel.class, (String)"label"), Resources.getString(BacklightPortTableModel.class, (String)"dimSlopeDown"), Resources.getString(BacklightPortTableModel.class, (String)"dimSlopeUp"), Resources.getString(BacklightPortTableModel.class, (String)"dmxMapping"), Resources.getString(BacklightPortTableModel.class, (String)"test"), null};
    }

    public void addRow(BacklightPort port) {
        if (port != null) {
            Object[] rowData = new Object[this.columnNames.length];
            rowData[0] = port.toString();
            rowData[2] = port.getDimSlopeDown();
            rowData[1] = port.getDimSlopeUp();
            rowData[3] = port.getDmxMapping();
            rowData[4] = port.getValue();
            rowData[5] = port;
            this.addRow(rowData);
        }
    }

    public boolean isCellEditable(int row, int column) {
        return false;
    }

    public Class<?> getColumnClass(int column) {
        switch (column) {
            case 0: {
                return String.class;
            }
            case 5: {
                return Object.class;
            }
        }
        return Integer.class;
    }

    public Object getValueAt(int row, int column) {
        Integer result = null;
        BacklightPort port = (BacklightPort)super.getValueAt(row, 5);
        switch (column) {
            case 0: {
                column = 5;
                break;
            }
            case 4: {
                if (port == null) break;
                result = port.getValue();
                LOGGER.trace("Return relative brightness value: {}", (Object)result);
                return result;
            }
            case 3: {
                return port.getDmxMapping();
            }
            case 5: {
                return port;
            }
        }
        return super.getValueAt(row, column);
    }

    public void setValueAt(Object value, int row, int column) {
        BacklightPort port = (BacklightPort)super.getValueAt(row, 5);
        LOGGER.trace("Set value, row: {}, column: {}, value: {}, port: {}", new Object[]{row, column, value, port});
        switch (column) {
            case 0: {
                port.setLabel((String)value);
                super.setValueAt((Object)port.toString(), row, column);
                this.fireLabelChanged((Port)port, port.getLabel());
                break;
            }
            case 2: {
                port.setDimSlopeDown(((Integer)value).intValue());
                super.setValueAt(value, row, column);
                this.fireConfigValuesChanged(port, new PortConfigKeys[]{PortConfigKeys.BIDIB_PCFG_DIMM_DOWN_8_8});
                break;
            }
            case 1: {
                port.setDimSlopeUp(((Integer)value).intValue());
                super.setValueAt(value, row, column);
                this.fireConfigValuesChanged(port, new PortConfigKeys[]{PortConfigKeys.BIDIB_PCFG_DIMM_UP_8_8});
                break;
            }
            case 3: {
                try {
                    if (value instanceof Integer) {
                        port.setDmxMapping((Integer)value);
                    } else {
                        port.setDmxMapping(Integer.valueOf(Integer.parseInt(value.toString())));
                    }
                    super.setValueAt(value, row, column);
                    this.fireConfigValuesChanged(port, new PortConfigKeys[]{PortConfigKeys.BIDIB_PCFG_OUTPUT_MAP});
                }
                catch (NumberFormatException numberFormatException) {}
                break;
            }
            case 4: {
                try {
                    BacklightPort testBacklightPort = new BacklightPort();
                    testBacklightPort.setId(port.getId());
                    testBacklightPort.setStatus((BidibStatus)BacklightPortStatus.START);
                    this.toggleTest(testBacklightPort);
                    break;
                }
                catch (NumberFormatException ex) {
                    LOGGER.warn("Parse backlight value failed.", (Throwable)ex);
                }
            }
        }
    }

    public void notifyPortStatusChanged(BacklightPort port) {
        LOGGER.debug("The port status has changed, port: {}, port.status: {}", (Object)port, (Object)port.getStatus());
        for (int row = 0; row < this.getRowCount(); ++row) {
            if (!port.equals(this.getValueAt(row, 5))) continue;
            BacklightPort backlightPort = port;
            LOGGER.info("The port value has changed: {}", (Object)backlightPort.getValue());
            super.setValueAt((Object)port.getValue(), row, 4);
            break;
        }
    }

    public void notifyPortConfigChanged(BacklightPort port) {
        LOGGER.info("The port config was changed for port: {}", (Object)port.getDebugString());
        for (int row = 0; row < this.getRowCount(); ++row) {
            if (!port.equals(this.getValueAt(row, 5))) continue;
            BacklightPort backlightPort = port;
            super.setValueAt((Object)backlightPort.getDmxMapping(), row, 3);
            super.setValueAt((Object)backlightPort.getDimSlopeDown(), row, 2);
            super.setValueAt((Object)backlightPort.getDimSlopeUp(), row, 1);
            break;
        }
    }

    public void notifyPortLabelChanged(BacklightPort port) {
        LOGGER.info("The port label was changed for port: {}", (Object)port.getDebugString());
        for (int row = 0; row < this.getRowCount(); ++row) {
            if (!port.equals(this.getValueAt(row, 5))) continue;
            super.setValueAt((Object)port.toString(), row, 0);
            break;
        }
    }

    public void refreshRow(BacklightPort port, IntConsumer rowConsumer) {
        int row = this.findRow(port);
        rowConsumer.accept(row);
    }

    private int findRow(BacklightPort port) {
        for (int row = 0; row < this.getRowCount(); ++row) {
            BacklightPort current = (BacklightPort)this.getValueAt(row, 5);
            if (!port.equals((Object)current)) continue;
            return row;
        }
        return -1;
    }

    public void updatePortConfig(BacklightPort port) {
        LOGGER.debug("The config of the port has changed: {}", (Object)port.getDebugString());
        PortConfigKeys[] keys = PortConfigKeys.valueOf((Set)port.getKnownPortConfigKeys());
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("prepared keys: {}", Arrays.asList(keys));
        }
        this.fireConfigValuesChanged(port, keys);
        int row = this.findRow(port);
        if (row > -1) {
            this.setValueAt((Object)port.getLabel(), row, 0);
        }
    }

    private void fireConfigValuesChanged(BacklightPort port, PortConfigKeys ... portConfigKeys) {
        ((BacklightPortModelListener)this.portListener).configChanged((Port)port, portConfigKeys);
    }

    public void fireTestButtonPressed(BacklightPort port) {
        LOGGER.info("Slider value has changed for port: {}", (Object)port);
        ((BacklightPortModelListener)this.portListener).testButtonPressed(port, port.getValue().intValue());
    }

    private void toggleTest(BacklightPort port) {
        LOGGER.info("Toggle the test function for port: {}", (Object)port);
    }

    public void changePortType(LcOutputType portType, BacklightPort port) {
        ((BacklightPortModelListener)this.portListener).changePortType(portType, (Port)port);
    }

    protected BacklightPort getRow(int rowIndex) {
        BacklightPort servoPort = (BacklightPort)this.getValueAt(rowIndex, 5);
        return servoPort;
    }

    public void setValue(BacklightPort port) {
        LOGGER.info("Set the value: {}", (Object)port.getDebugString());
        this.fireTestButtonPressed(port);
    }

    public void updateSliderPosition(int row, int column) {
        this.fireTableCellUpdated(row, column);
    }
}

