/*
 * Decompiled with CFR 0.152.
 */
package org.bidib.wizard.mvc.netdebug.view;

import com.jgoodies.binding.adapter.Bindings;
import com.jgoodies.binding.beans.PropertyAdapter;
import com.jgoodies.binding.beans.PropertyConnector;
import com.jgoodies.binding.value.BindingConverter;
import com.jgoodies.binding.value.ConverterValueModel;
import com.jgoodies.binding.value.ValueModel;
import com.jgoodies.forms.builder.ButtonBarBuilder;
import com.jgoodies.forms.builder.FormBuilder;
import com.jgoodies.forms.debug.FormDebugPanel;
import com.jgoodies.forms.factories.Paddings;
import com.jidesoft.swing.DefaultOverlayable;
import com.jidesoft.swing.JideScrollPane;
import com.jidesoft.swing.StyledLabelBuilder;
import com.vlsolutions.swing.docking.DockKey;
import com.vlsolutions.swing.docking.Dockable;
import com.vlsolutions.swing.docking.DockingDesktop;
import com.vlsolutions.swing.docking.event.DockableStateChangeListener;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Font;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.text.DecimalFormat;
import java.text.Format;
import java.text.SimpleDateFormat;
import java.util.Collection;
import java.util.Date;
import java.util.LinkedList;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.border.Border;
import javax.swing.event.DocumentListener;
import javax.swing.filechooser.FileFilter;
import javax.swing.filechooser.FileNameExtensionFilter;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.JTextComponent;
import org.apache.commons.lang3.StringUtils;
import org.bidib.wizard.api.locale.Resources;
import org.bidib.wizard.client.common.component.TextLineNumber;
import org.bidib.wizard.client.common.converter.StringConverter;
import org.bidib.wizard.client.common.text.InputValidationDocument;
import org.bidib.wizard.client.common.text.WizardComponentFactory;
import org.bidib.wizard.client.common.view.BasicPopupMenu;
import org.bidib.wizard.client.common.view.DockKeys;
import org.bidib.wizard.common.model.settings.WizardSettingsInterface;
import org.bidib.wizard.common.service.SettingsService;
import org.bidib.wizard.common.utils.ImageUtils;
import org.bidib.wizard.mvc.common.view.text.ChangeDocumentListener;
import org.bidib.wizard.mvc.common.view.text.CopyAllAction;
import org.bidib.wizard.mvc.common.view.text.HistoryModel;
import org.bidib.wizard.mvc.common.view.text.HistoryTextField;
import org.bidib.wizard.mvc.netdebug.controller.listener.NetDebugControllerListener;
import org.bidib.wizard.mvc.netdebug.model.NetDebugModel;
import org.bidib.wizard.mvc.netdebug.view.NetDebugView;
import org.bidib.wizard.mvc.netdebug.view.listener.NetDebugViewListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NetDebugView
implements Dockable {
    private static final Logger LOGGER = LoggerFactory.getLogger(NetDebugView.class);
    private static final String ENCODED_DIALOG_COLUMN_SPECS = "pref, 3dlu, max(80dlu;pref), 3dlu, pref, 3dlu, pref, 3dlu, pref, 3dlu, fill:50dlu:grow, 3dlu, pref";
    private static final String ENCODED_DIALOG_ROW_SPECS = "p, 3dlu, p, 3dlu, fill:50dlu:grow, 3dlu, p, 3dlu, p";
    private final SettingsService settingsService;
    private final NetDebugModel netDebugModel;
    private final Collection<NetDebugViewListener> listeners = new LinkedList();
    private final DockableStateChangeListener dockableStateChangeListener;
    private final JComponent contentPanel;
    private final JButton connectButton = new JButton(Resources.getString(this.getClass(), (String)"connect"));
    private final JButton disconnectButton = new JButton(Resources.getString(this.getClass(), (String)"disconnect"));
    private ValueModel hostValueModel;
    private ValueModel portValueModel;
    private JTextField host;
    private JTextField port;
    private HistoryTextField sendText;
    private ValueModel sendTextValueModel;
    private final JButton transmitButton = new JButton(Resources.getString(this.getClass(), (String)"transmit"));
    private TextLineNumber tln;
    private final JTextArea logsArea = new JTextArea();
    private static FileFilter logfileFilter;
    private static final String LOGFILE_EXTENSION = "log";
    private static final String WORKING_DIR_NET_DEBUG_LOG_KEY = "netDebugLog";
    private String savedLogFilesDescription;
    private final SimpleDateFormat sdf = new SimpleDateFormat("HH:mm:ss.SSS");
    public static final String LOGGER_PANE_NAME = "DebugInterfacePane";
    private static final Logger LOGGER_PANE;
    StringBuilder sbLogger = new StringBuilder();
    private int currentLineLen;
    private boolean timestampsEnabled;

    public NetDebugView(DockingDesktop desktop, NetDebugControllerListener listener, NetDebugModel netDebugModel, SettingsService settingsService) {
        Object panel;
        this.settingsService = settingsService;
        this.netDebugModel = netDebugModel;
        DockKeys.DOCKKEY_NET_DEBUG_VIEW.setName(Resources.getString(this.getClass(), (String)"title"));
        DockKeys.DOCKKEY_NET_DEBUG_VIEW.setFloatEnabled(true);
        DockKeys.DOCKKEY_NET_DEBUG_VIEW.setAutoHideEnabled(false);
        this.dockableStateChangeListener = new /* Unavailable Anonymous Inner Class!! */;
        desktop.addDockableStateChangeListener(this.dockableStateChangeListener);
        LOGGER.info("Create new NetDebugView");
        FormBuilder dialogBuilder = null;
        boolean debugDialog = false;
        if (debugDialog) {
            panel = new FormDebugPanel();
            dialogBuilder = FormBuilder.create().columns(ENCODED_DIALOG_COLUMN_SPECS, new Object[0]).rows(ENCODED_DIALOG_ROW_SPECS, new Object[0]).panel((JPanel)panel);
        } else {
            panel = new JPanel(new BorderLayout());
            dialogBuilder = FormBuilder.create().columns(ENCODED_DIALOG_COLUMN_SPECS, new Object[0]).rows(ENCODED_DIALOG_ROW_SPECS, new Object[0]).panel((JPanel)panel);
        }
        dialogBuilder.border((Border)Paddings.DIALOG);
        this.hostValueModel = new PropertyAdapter((Object)this.netDebugModel, "selectedHost", true);
        this.host = WizardComponentFactory.createTextField((ValueModel)this.hostValueModel, (boolean)false);
        dialogBuilder.add(Resources.getString(this.getClass(), (String)"selectedHost"), new Object[0]).xy(1, 1);
        dialogBuilder.add((Component)this.host).xy(3, 1);
        this.portValueModel = new PropertyAdapter((Object)this.netDebugModel, "selectedPort", true);
        ConverterValueModel portConverterModel = new ConverterValueModel(this.portValueModel, (BindingConverter)new StringConverter((Format)new DecimalFormat("#")));
        this.port = new JTextField();
        InputValidationDocument portDocument = new InputValidationDocument(5, "0123456789");
        this.port.setDocument((Document)portDocument);
        this.port.setColumns(5);
        Bindings.bind((JTextField)this.port, (ValueModel)portConverterModel, (boolean)false);
        dialogBuilder.add(Resources.getString(this.getClass(), (String)"selectedPort"), new Object[0]).xy(5, 1);
        dialogBuilder.add((Component)this.port).xy(7, 1);
        JPanel debugInterfaceActionButtons = new ButtonBarBuilder().addButton((JComponent)this.connectButton).addRelatedGap().addButton((JComponent)this.disconnectButton).build();
        dialogBuilder.add((Component)debugInterfaceActionButtons).xy(9, 1);
        this.logsArea.setEditable(false);
        this.logsArea.setFont(new Font("Monospaced", 0, 13));
        JScrollPane logsPane = new JScrollPane(this.logsArea);
        this.tln = new TextLineNumber((JTextComponent)this.logsArea);
        logsPane.setRowHeaderView((Component)this.tln);
        logsPane.setAutoscrolls(true);
        dialogBuilder.add((Component)logsPane).xyw(1, 5, 13);
        this.sendTextValueModel = new PropertyAdapter((Object)this.netDebugModel, "sendText", true);
        HistoryModel.setMax((int)20);
        this.sendText = new HistoryTextField("sendText", false, true);
        Bindings.bind((JTextField)this.sendText, (ValueModel)this.sendTextValueModel, (boolean)false);
        this.sendText.addActionListener((ActionListener)new /* Unavailable Anonymous Inner Class!! */);
        DefaultOverlayable sendTextOverlayable = new DefaultOverlayable((JComponent)this.sendText);
        sendTextOverlayable.addOverlayComponent((JComponent)StyledLabelBuilder.createStyledLabel((String)("{" + Resources.getString(this.getClass(), (String)"transmitText.prompt") + ":f:gray}")), 7);
        sendTextOverlayable.setOverlayLocationInsets(new Insets(0, -5, 0, 5));
        Document textDoc = this.sendText.getDocument();
        textDoc.addDocumentListener((DocumentListener)new ChangeDocumentListener(doc -> sendTextOverlayable.setOverlayVisible(doc.getLength() < 1)));
        sendTextOverlayable.setOverlayVisible(textDoc.getLength() < 1);
        dialogBuilder.add(Resources.getString(this.getClass(), (String)"transmitText"), new Object[0]).xy(1, 7);
        dialogBuilder.add((Component)sendTextOverlayable).xyw(3, 7, 9);
        dialogBuilder.add((Component)this.transmitButton).xy(13, 7);
        this.transmitButton.addActionListener((ActionListener)new /* Unavailable Anonymous Inner Class!! */);
        this.transmitButton.setEnabled(false);
        PropertyConnector.connect((Object)this.netDebugModel, (String)"transmitEnabled", (Object)this.transmitButton, (String)"enabled");
        PropertyConnector.connect((Object)this.netDebugModel, (String)"disconnected", (Object)this.connectButton, (String)"enabled");
        PropertyConnector.connect((Object)this.netDebugModel, (String)"connected", (Object)this.disconnectButton, (String)"enabled");
        JPanel contentPanelTemp = dialogBuilder.build();
        JideScrollPane scrollPane = new JideScrollPane((Component)contentPanelTemp);
        this.contentPanel = scrollPane;
        this.connectButton.addActionListener((ActionListener)new /* Unavailable Anonymous Inner Class!! */);
        this.disconnectButton.addActionListener((ActionListener)new /* Unavailable Anonymous Inner Class!! */);
        this.disconnectButton.setEnabled(false);
        BasicPopupMenu popupMenu = new BasicPopupMenu();
        JMenuItem clearConsole = new JMenuItem(Resources.getString(this.getClass(), (String)"clear_console"));
        clearConsole.addActionListener((ActionListener)new /* Unavailable Anonymous Inner Class!! */);
        popupMenu.add(clearConsole);
        JMenuItem copyAllToClipboard = new JMenuItem(Resources.getString(this.getClass(), (String)"copyAllToClipboard"));
        copyAllToClipboard.addActionListener((ActionListener)new /* Unavailable Anonymous Inner Class!! */);
        popupMenu.add(copyAllToClipboard);
        JMenuItem saveToFile = new JMenuItem(Resources.getString(this.getClass(), (String)"save_to_file"), ImageUtils.createImageIcon(this.getClass(), (String)"/icons/savetofile.png"));
        saveToFile.addActionListener((ActionListener)new /* Unavailable Anonymous Inner Class!! */);
        popupMenu.add(saveToFile);
        JMenuItem saveSelectedToFile = new JMenuItem(Resources.getString(this.getClass(), (String)"save_selected_to_file"), ImageUtils.createImageIcon(this.getClass(), (String)"/icons/saveselectedtofile.png"));
        saveSelectedToFile.addActionListener((ActionListener)new /* Unavailable Anonymous Inner Class!! */);
        popupMenu.add(saveSelectedToFile);
        this.logsArea.setComponentPopupMenu((JPopupMenu)popupMenu);
    }

    public DockKey getDockKey() {
        return DockKeys.DOCKKEY_NET_DEBUG_VIEW;
    }

    public Component getComponent() {
        return this.contentPanel;
    }

    public void addNetDebugViewListener(NetDebugViewListener listener) {
        this.listeners.add(listener);
    }

    private void fireConnect() {
        for (NetDebugViewListener listener : this.listeners) {
            listener.openConnection();
        }
    }

    private void fireDisconnect() {
        for (NetDebugViewListener listener : this.listeners) {
            listener.closeConnection();
        }
    }

    private void fireTransmit() {
        for (NetDebugViewListener listener : this.listeners) {
            listener.transmit();
        }
        this.sendText.setText(null);
    }

    private void fireClearConsole() {
        LOGGER.info("clear the console.");
        this.logsArea.setText(null);
    }

    private void fireCopyAllToClipboard() {
        LOGGER.info("Copy all content to clipboard.");
        ActionEvent copyAll = new ActionEvent(this.logsArea, 0, "copy-all-to-clipboard");
        CopyAllAction action = new CopyAllAction();
        action.actionPerformed(copyAll);
    }

    private void fireSaveToFile(boolean selectedOnly) {
        LOGGER.info("Save the console content to file.");
        this.savedLogFilesDescription = Resources.getString(this.getClass(), (String)"savedLogFilesDescription");
        logfileFilter = new FileNameExtensionFilter(this.savedLogFilesDescription, LOGFILE_EXTENSION);
        WizardSettingsInterface wizardSettings = this.settingsService.getWizardSettings();
        String storedWorkingDirectory = wizardSettings.getWorkingDirectory(WORKING_DIR_NET_DEBUG_LOG_KEY);
        10 dialog = new /* Unavailable Anonymous Inner Class!! */;
        dialog.showDialog();
    }

    public void addLog(String logMessage) {
        SwingUtilities.invokeLater((Runnable)new /* Unavailable Anonymous Inner Class!! */);
    }

    private void addLogMessage(String logMessage) {
        try {
            int lines = this.logsArea.getLineCount();
            if (lines > 500) {
                int end = this.logsArea.getLineEndOffset(50);
                this.logsArea.getDocument().remove(0, end);
            }
        }
        catch (BadLocationException ex) {
            LOGGER.warn("Remove some lines from logsArea failed.", (Throwable)ex);
        }
        int beginIndex = 0;
        int index = logMessage.indexOf(10);
        int lenOfTimestamp = 0;
        if (index > -1) {
            String part;
            while (index > -1) {
                part = logMessage.substring(beginIndex, index);
                if (this.timestampsEnabled && this.currentLineLen == 0) {
                    this.sbLogger.append(this.sdf.format(new Date()));
                    this.sbLogger.append(" - ");
                    lenOfTimestamp = 12;
                }
                this.sbLogger.append(part);
                LOGGER.debug("1. Added part: {}, currentLineLen: {}, sbLogger: {}", new Object[]{part, this.currentLineLen, this.sbLogger});
                this.logsArea.append(this.sbLogger.substring(this.currentLineLen));
                this.logsArea.append("\n");
                LOGGER_PANE.info(this.sbLogger.toString().replace("\r", ""));
                lenOfTimestamp = 0;
                this.sbLogger.setLength(0);
                this.currentLineLen = 0;
                beginIndex = index + 1;
                index = logMessage.indexOf(10, beginIndex);
            }
            lenOfTimestamp = 0;
            if (beginIndex < logMessage.length()) {
                part = logMessage.substring(beginIndex);
                if (this.timestampsEnabled) {
                    this.sbLogger.append(this.sdf.format(new Date()));
                    this.sbLogger.append(" - ");
                    lenOfTimestamp = 12;
                }
                this.sbLogger.append(part);
                LOGGER.debug("2. Added part: {}, currentLineLen: {}, sbLogger: {}", new Object[]{part, this.currentLineLen, this.sbLogger});
                this.logsArea.append(this.sbLogger.substring(this.currentLineLen));
                this.currentLineLen = part.length() + lenOfTimestamp;
                lenOfTimestamp = 0;
                LOGGER.debug("Added last part: {}, currentLineLen: {}", (Object)part, (Object)this.currentLineLen);
            }
        } else {
            if (this.timestampsEnabled && this.currentLineLen == 0) {
                LOGGER.debug("Add timestamp, currentLineLen: {}", (Object)this.currentLineLen);
                this.sbLogger.append(this.sdf.format(new Date()));
                this.sbLogger.append(" - ");
                lenOfTimestamp = 12;
            }
            String toLog = logMessage;
            if (logMessage.length() > 120 - this.currentLineLen) {
                int start = 0;
                int end = 0;
                String part = null;
                toLog = null;
                end = start + (120 - this.currentLineLen);
                while (end < logMessage.length()) {
                    part = StringUtils.substring((String)logMessage, (int)start, (int)end);
                    LOGGER.debug("Fetched part, currentLineLen {}, part: '{}'", (Object)this.currentLineLen, (Object)part);
                    this.sbLogger.append(part);
                    this.logsArea.append(this.sbLogger.substring(this.currentLineLen));
                    this.logsArea.append("\n");
                    this.currentLineLen = 120;
                    LOGGER.debug("Added logMessage: {}, currentLineLen: {}", (Object)logMessage, (Object)this.currentLineLen);
                    this.currentLineLen = 0;
                    this.sbLogger.setLength(0);
                    end = (start += 120) + (120 - this.currentLineLen);
                }
                if (start < logMessage.length()) {
                    LOGGER.debug("Keep the remaining part from logMessage, currentLineLen: {}", (Object)this.currentLineLen, (Object)start);
                    toLog = StringUtils.substring((String)logMessage, (int)start);
                }
            }
            if (StringUtils.isNotBlank((CharSequence)toLog)) {
                this.sbLogger.append(toLog);
                LOGGER.debug("3. Added logMessage: {}, currentLineLen: {}, sbLogger: {}", new Object[]{toLog, this.currentLineLen, this.sbLogger});
                this.logsArea.append(this.sbLogger.substring(this.currentLineLen));
                this.currentLineLen += toLog.length() + lenOfTimestamp;
                LOGGER.debug("Added logMessage: {}, currentLineLen: {}", (Object)logMessage, (Object)this.currentLineLen);
            }
        }
        if (this.currentLineLen > 120) {
            LOGGER.debug("Append new line to logsArea, currentLineLen: {}", (Object)this.currentLineLen);
            this.logsArea.append("\n");
            LOGGER_PANE.info(this.sbLogger.toString().replace("\r", ""));
            lenOfTimestamp = 0;
            this.sbLogger.setLength(0);
            this.currentLineLen = 0;
        }
        this.logsArea.invalidate();
    }

    static {
        LOGGER_PANE = LoggerFactory.getLogger((String)LOGGER_PANE_NAME);
    }
}

