/*
 * Decompiled with CFR 0.152.
 */
package org.bidib.wizard.mvc.preferences.view.panel;

import com.jgoodies.binding.adapter.Bindings;
import com.jgoodies.binding.value.BindingConverter;
import com.jgoodies.binding.value.BufferedValueModel;
import com.jgoodies.binding.value.ConverterValueModel;
import com.jgoodies.binding.value.ValueModel;
import com.jgoodies.forms.builder.FormBuilder;
import com.jgoodies.forms.debug.FormDebugPanel;
import com.jgoodies.forms.factories.Paddings;
import com.jidesoft.field.IPTextField;
import java.awt.BorderLayout;
import java.awt.Component;
import java.util.function.Consumer;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.border.Border;
import javax.swing.filechooser.FileFilter;
import javax.swing.text.Document;
import org.bidib.jbidibc.messages.utils.ByteUtils;
import org.bidib.wizard.api.locale.Resources;
import org.bidib.wizard.client.common.converter.StringToIntegerConverter;
import org.bidib.wizard.client.common.converter.StringToNetBidibUniqueIdConverter;
import org.bidib.wizard.client.common.preferences.view.panel.AbstractSettingsPanel;
import org.bidib.wizard.client.common.text.InputValidationDocument;
import org.bidib.wizard.client.common.text.WizardComponentFactory;
import org.bidib.wizard.common.model.settings.NetBidibSettingsInterface;
import org.bidib.wizard.mvc.preferences.view.panel.NetBidibSettingsPanel;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NetBidibSettingsPanel
extends AbstractSettingsPanel<NetBidibSettingsInterface> {
    private static final Logger LOGGER = LoggerFactory.getLogger(NetBidibSettingsPanel.class);
    private static final String ENCODED_DIALOG_COLUMN_SPECS = "pref, 3dlu, pref, 3dlu, 50dlu, 3dlu, fill:50dlu:grow, 3dlu, pref";
    private static final String ENCODED_DIALOG_ROW_SPECS = "pref, 3dlu, pref, 3dlu, pref, 3dlu, pref, 3dlu, pref, 3dlu, pref, 3dlu, pref, 3dlu, pref, 3dlu, pref, 3dlu, pref";
    private final NetBidibSettingsInterface netBidibSettings;
    private JPanel contentPanel;

    public NetBidibSettingsPanel(NetBidibSettingsInterface netBidibSettings, Consumer<Boolean> bufferingCallback) {
        super(bufferingCallback);
        this.netBidibSettings = netBidibSettings;
    }

    public JPanel createPanel() {
        Object panel;
        FormBuilder dialogBuilder = null;
        boolean debugDialog = false;
        if (debugDialog) {
            panel = new FormDebugPanel();
            dialogBuilder = FormBuilder.create().columns(ENCODED_DIALOG_COLUMN_SPECS, new Object[0]).rows(ENCODED_DIALOG_ROW_SPECS, new Object[0]).panel((JPanel)panel);
        } else {
            panel = new JPanel(new BorderLayout());
            dialogBuilder = FormBuilder.create().columns(ENCODED_DIALOG_COLUMN_SPECS, new Object[0]).rows(ENCODED_DIALOG_ROW_SPECS, new Object[0]).panel((JPanel)panel);
        }
        dialogBuilder.border((Border)Paddings.TABBED_DIALOG);
        this.preparePresentationModel((Object)this.netBidibSettings);
        int row = 1;
        BufferedValueModel bufferedUniqueIdModel = this.presentationModel.getBufferedModel("netBidibUniqueId");
        ConverterValueModel currentUniqueIdConverterModel = new ConverterValueModel((ValueModel)bufferedUniqueIdModel, (BindingConverter)new StringToNetBidibUniqueIdConverter(13, 250));
        dialogBuilder.add(Resources.getString(this.getClass(), (String)"netBidibClientSerialNumber") + ":", new Object[0]).xy(1, 1);
        dialogBuilder.add(String.format("V %1$02X P %2$02X%3$02X", 13, ByteUtils.getLowByte((int)250), ByteUtils.getHighByte((int)250)), new Object[0]).xy(3, 1);
        JTextField netBidibClientSerialNumber = new JTextField();
        netBidibClientSerialNumber.setDocument((Document)new InputValidationDocument(4, "0123456789ABCDEF"));
        Bindings.bind((JTextField)netBidibClientSerialNumber, (ValueModel)currentUniqueIdConverterModel, (boolean)false);
        dialogBuilder.add((Component)netBidibClientSerialNumber).xyw(5, row, 5);
        BufferedValueModel bufferedJmDnsNameModel = this.presentationModel.getBufferedModel("jmDnsName");
        dialogBuilder.add(Resources.getString(this.getClass(), (String)"jmDnsName") + ":", new Object[0]).xy(1, row += 2);
        JTextField jmDnsName = WizardComponentFactory.createTextField((ValueModel)bufferedJmDnsNameModel, (boolean)false);
        dialogBuilder.add((Component)jmDnsName).xyw(3, row, 7);
        BufferedValueModel bufferedPairingTimeoutModel = this.presentationModel.getBufferedModel("pairingTimeout");
        ConverterValueModel pairingTimeoutConverterModel = new ConverterValueModel((ValueModel)bufferedPairingTimeoutModel, (BindingConverter)new StringToIntegerConverter(Integer.valueOf(30)));
        dialogBuilder.add(Resources.getString(this.getClass(), (String)"pairingTimeout") + ":", new Object[0]).xy(1, row += 2);
        JTextField pairingTimeout = new JTextField();
        pairingTimeout.setDocument((Document)new InputValidationDocument(4, "0123456789"));
        Bindings.bind((JTextField)pairingTimeout, (ValueModel)pairingTimeoutConverterModel, (boolean)false);
        dialogBuilder.add((Component)pairingTimeout).xyw(3, row, 7);
        BufferedValueModel discoveryEnabledModel = this.presentationModel.getBufferedModel("discoveryEnabled");
        JCheckBox discoveryEnabled = WizardComponentFactory.createCheckBox((ValueModel)discoveryEnabledModel, (String)Resources.getString(this.getClass(), (String)"discoveryEnabled"));
        dialogBuilder.add((Component)discoveryEnabled).xyw(1, row += 2, 9);
        BufferedValueModel discoveryOnAllNetworkInterfacesEnabledModel = this.presentationModel.getBufferedModel("discoveryOnAllNetworkInterfacesEnabled");
        JCheckBox discoveryOnAllNetworkInterfacesEnabled = WizardComponentFactory.createCheckBox((ValueModel)discoveryOnAllNetworkInterfacesEnabledModel, (String)Resources.getString(this.getClass(), (String)"discoveryOnAllNetworkInterfacesEnabled"));
        dialogBuilder.add((Component)discoveryOnAllNetworkInterfacesEnabled).xyw(1, row += 2, 9);
        dialogBuilder.add(Resources.getString(this.getClass(), (String)"pairingStoreLocation") + ":", new Object[0]).xy(1, row += 2);
        BufferedValueModel pairingStoreLocationModel = this.presentationModel.getBufferedModel("pairingStoreLocation");
        JTextField pairingStoreLocation = WizardComponentFactory.createTextField((ValueModel)pairingStoreLocationModel, (boolean)false);
        dialogBuilder.add((Component)pairingStoreLocation).xyw(3, row, 5);
        JButton selectDirectoyButton = new JButton(Resources.getString(NetBidibSettingsPanel.class, (String)"select-directory"));
        selectDirectoyButton.setToolTipText(Resources.getString(NetBidibSettingsPanel.class, (String)"select-directory.tooltip"));
        selectDirectoyButton.addActionListener(evt -> {
            String storedPairingStoreDirectory = pairingStoreLocationModel.getString();
            FileFilter[] ff = null;
            1 dialog = new /* Unavailable Anonymous Inner Class!! */;
            dialog.setApproveButtonText(Resources.getString(NetBidibSettingsPanel.class, (String)"select-directory"));
            dialog.showDialog();
        });
        dialogBuilder.add((Component)selectDirectoyButton).xy(9, row);
        BufferedValueModel useFixedIpModel = this.presentationModel.getBufferedModel("useFixIpAddress");
        JCheckBox useFixedIp = WizardComponentFactory.createCheckBox((ValueModel)useFixedIpModel, (String)Resources.getString(this.getClass(), (String)"useFixedIp"));
        dialogBuilder.add((Component)useFixedIp).xyw(1, row += 2, 1);
        BufferedValueModel fixIpModel = this.presentationModel.getBufferedModel("jmDnsIpAddress");
        IPTextField fixIp = WizardComponentFactory.createIPTextField((ValueModel)fixIpModel, (boolean)false);
        dialogBuilder.add((Component)fixIp).xyw(3, row, 3);
        BufferedValueModel discoveryUdpEnabledModel = this.presentationModel.getBufferedModel("discoveryUdpEnabled");
        JCheckBox discoveryUdpEnabled = WizardComponentFactory.createCheckBox((ValueModel)discoveryUdpEnabledModel, (String)Resources.getString(this.getClass(), (String)"discoveryUdpEnabled"));
        dialogBuilder.add((Component)discoveryUdpEnabled).xyw(1, row += 2, 9);
        BufferedValueModel preventLocalPingModel = this.presentationModel.getBufferedModel("preventLocalPing");
        JCheckBox preventLocalPing = WizardComponentFactory.createCheckBox((ValueModel)preventLocalPingModel, (String)Resources.getString(this.getClass(), (String)"preventLocalPing"));
        preventLocalPing.setToolTipText(Resources.getString(this.getClass(), (String)"preventLocalPing.tooltip"));
        dialogBuilder.add((Component)preventLocalPing).xyw(1, row += 2, 9);
        row += 2;
        this.contentPanel = dialogBuilder.build();
        this.contentPanel.setOpaque(false);
        return this.contentPanel;
    }
}

