/*
 * Decompiled with CFR 0.152.
 */
package org.bidib.wizard.mvc.worklist.model;

import com.jgoodies.binding.adapter.AbstractTableAdapter;
import com.jgoodies.binding.list.SelectionInList;
import org.bidib.wizard.api.locale.Resources;
import org.bidib.wizard.mvc.worklist.model.WorkItemModel;

public class WorkListItemTableModel
extends AbstractTableAdapter<WorkItemModel> {
    private static final long serialVersionUID = 1L;
    public static final int COLUMN_COMPONENT = 0;
    public static final int COLUMN_DESCRIPTION = 1;
    public static final int COLUMN_ACTION = 2;
    private static final String[] COLUMNNAMES = new String[]{Resources.getString(WorkListItemTableModel.class, (String)"column.component"), Resources.getString(WorkListItemTableModel.class, (String)"column.description"), Resources.getString(WorkListItemTableModel.class, (String)"column.action")};

    public WorkListItemTableModel(SelectionInList<WorkItemModel> workItemSelection) {
        super(workItemSelection, COLUMNNAMES);
    }

    public Object getValueAt(int rowIndex, int columnIndex) {
        WorkItemModel workItem = (WorkItemModel)this.getRow(rowIndex);
        switch (columnIndex) {
            case 0: {
                return workItem.getComponent();
            }
            case 1: {
                return this.getActionText(workItem);
            }
        }
        return null;
    }

    private String getActionText(WorkItemModel workItem) {
        String actionKey = workItem.getAction();
        Object[] actinParams = workItem.getWorkListItemEvent().getActionsParams();
        return Resources.getString(workItem.getWorkListItemEvent().getClass(), (String)actionKey, (Object[])actinParams);
    }
}

