package org.bidib.wizard.mvc.common.view.icon;

import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;

import javax.swing.Icon;

public class LinearMovingIcon implements AnimatedIcon {

    private Icon icon;

    private double degrees;

    public LinearMovingIcon(Icon icon, double degrees) {
        this.icon = icon;
        this.degrees = degrees;
    }

    /**
     * Gets the Icon to be rotated
     *
     * @return the Icon to be rotated
     */
    public Icon getIcon() {
        return icon;
    }

    /**
     * Gets the degrees of rotation. Only used for Rotate.ABOUT_CENTER.
     *
     * @return the degrees of rotation
     */
    public double getDegrees() {
        return degrees;
    }

    /**
     * Set the degrees of rotation. Only used for Rotate.ABOUT_CENTER. This method only sets the degress of rotation, it
     * will not cause the Icon to be repainted. You must invoke repaint() on any component using this icon for it to be
     * repainted.
     *
     * @param degrees
     *            the degrees of rotation
     */
    @Override
    public void setDegrees(double degrees) {
        if (degrees > 359) {
            degrees = 359;
        }
        if (degrees < 0) {
            degrees = 0;
        }

        this.degrees = degrees;
    }

    @Override
    public int getIconWidth() {
        return icon.getIconWidth();
    }

    @Override
    public int getIconHeight() {
        return icon.getIconHeight();
    }

    @Override
    public void paintIcon(Component c, Graphics g, int x, int y) {

        Graphics2D g2 = (Graphics2D) g.create();

        // left: 0, right: 85
        int cWidth = (int) ((degrees > 0) ? (degrees * 85) / 360 : 0);
        int cHeight = 0;

        int xAdjustment = -15;

        g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        // g2.translate((getIconWidth() - icon.getIconWidth()) / 2, (getIconHeight() - icon.getIconHeight()) / 2);

        // g2.translate(x + cHeight, y + cWidth);
        icon.paintIcon(c, g2, xAdjustment + cWidth, -cHeight);

        g2.dispose();
    }
}
