package org.bidib.wizard.mvc.main.view.component;

import java.awt.Component;

import javax.swing.filechooser.FileFilter;
import javax.swing.filechooser.FileNameExtensionFilter;

import org.apache.commons.lang3.StringUtils;
import org.bidib.wizard.api.locale.Resources;
import org.bidib.wizard.api.model.Accessory;
import org.bidib.wizard.core.dialog.FileDialog;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AccessoryFileDialog extends FileDialog {
    private static final Logger LOGGER = LoggerFactory.getLogger(AccessoryFileDialog.class);

    private final String ACCESSORY_EXTENSION = "axml";

    private FileFilter accessoryFilter;

    private String accessoryDescription;

    public AccessoryFileDialog(Component parent, int dialogType, String storedWorkingDirectory,
        final Accessory accessory, boolean legacyFormatDefault) {
        super(parent, dialogType, storedWorkingDirectory, null, (FileFilter[]) null);

        accessoryDescription = Resources.getString(AccessoryFileDialog.class, "accessoryDescription");
        accessoryFilter = new FileNameExtensionFilter(accessoryDescription, ACCESSORY_EXTENSION);

        String fileName = null;
        if (accessory != null) {

            fileName = accessory.toString();
            if (StringUtils.isBlank(fileName)) {
                // generate default accessory name
                fileName = Resources.getString(Accessory.class, "label") + "_" + accessory.getId();
            }

            fileName = fileName + "." + ACCESSORY_EXTENSION;
            LOGGER.info("Update the file filter for accessory, fileName: {}", fileName);
        }
        updateFileFilter(accessoryFilter, fileName);
    }
}
