package org.bidib.wizard.mvc.main.view.panel;

import java.awt.BorderLayout;
import java.awt.Component;
import java.beans.PropertyChangeListener;
import java.util.LinkedList;
import java.util.List;
import java.util.Optional;

import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import javax.swing.border.TitledBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

import org.bidib.jbidibc.core.schema.bidib.products.ProductType;
import org.bidib.jbidibc.messages.utils.NodeUtils;
import org.bidib.jbidibc.messages.utils.ProductUtils;
import org.bidib.wizard.api.LookupService;
import org.bidib.wizard.api.locale.Resources;
import org.bidib.wizard.api.model.NodeInterface;
import org.bidib.wizard.api.model.listener.AccessoryListListener;
import org.bidib.wizard.api.model.listener.CvDefinitionListener;
import org.bidib.wizard.api.model.listener.CvDefinitionRequestListener;
import org.bidib.wizard.api.model.listener.MacroListListener;
import org.bidib.wizard.api.model.listener.NodeListListener;
import org.bidib.wizard.api.model.listener.PortListListener;
import org.bidib.wizard.api.model.listener.PortListener;
import org.bidib.wizard.api.model.listener.PortListenerProvider;
import org.bidib.wizard.api.model.listener.PortStatusListener;
import org.bidib.wizard.api.model.listener.PortValueListener;
import org.bidib.wizard.client.common.uils.SwingUtils;
import org.bidib.wizard.client.common.view.DockKeys;
import org.bidib.wizard.client.common.view.TabPanelProvider;
import org.bidib.wizard.client.common.view.listener.TabStatusListener;
import org.bidib.wizard.common.context.DefaultApplicationContext;
import org.bidib.wizard.common.script.node.types.ScriptingTargetType;
import org.bidib.wizard.common.service.SettingsService;
import org.bidib.wizard.common.utils.ImageUtils;
import org.bidib.wizard.config.CvDefinitionPanelControllerFactory;
import org.bidib.wizard.config.FirmwareControllerFactory;
import org.bidib.wizard.config.ReverserPanelControllerFactory;
import org.bidib.wizard.firmwarerepo.core.FirmwareRepoService;
import org.bidib.wizard.mvc.common.exception.NodeChangeVetoException;
import org.bidib.wizard.mvc.main.controller.AccessoryPanelController;
import org.bidib.wizard.mvc.main.controller.BacklightPortPanelController;
import org.bidib.wizard.mvc.main.controller.BoosterPanelController;
import org.bidib.wizard.mvc.main.controller.CvDefinitionPanelController;
import org.bidib.wizard.mvc.main.controller.FeedbackPortPanelController;
import org.bidib.wizard.mvc.main.controller.FeedbackPositionPanelController;
import org.bidib.wizard.mvc.main.controller.FlagPanelController;
import org.bidib.wizard.mvc.main.controller.GlobalDetectorPanelController;
import org.bidib.wizard.mvc.main.controller.InputPortPanelController;
import org.bidib.wizard.mvc.main.controller.LightPortPanelController;
import org.bidib.wizard.mvc.main.controller.LocoPanelController;
import org.bidib.wizard.mvc.main.controller.MacroPanelController;
import org.bidib.wizard.mvc.main.controller.MotorPortPanelController;
import org.bidib.wizard.mvc.main.controller.ReverserPanelController;
import org.bidib.wizard.mvc.main.controller.ServoPortPanelController;
import org.bidib.wizard.mvc.main.controller.SoundPortPanelController;
import org.bidib.wizard.mvc.main.controller.SwitchPairPortPanelController;
import org.bidib.wizard.mvc.main.controller.SwitchPortPanelController;
import org.bidib.wizard.mvc.main.model.ConnectionPhaseModel;
import org.bidib.wizard.mvc.main.model.MainModel;
import org.bidib.wizard.mvc.main.model.listener.AccessorySelectionListener;
import org.bidib.wizard.mvc.main.model.listener.MacroSelectionListener;
import org.bidib.wizard.mvc.main.view.menu.listener.MainMenuListener;
import org.bidib.wizard.mvc.main.view.panel.listener.ShutdownListener;
import org.bidib.wizard.mvc.main.view.panel.listener.TabSelectionListener;
import org.bidib.wizard.mvc.main.view.panel.listener.TabVisibilityListener;
import org.bidib.wizard.mvc.main.view.panel.listener.TabVisibilityProvider;
import org.bidib.wizard.mvc.stepcontrol.controller.StepControlController;
import org.bidib.wizard.mvc.stepcontrol.view.StepControlPanel;
import org.bidib.wizard.nodescript.script.node.ScriptingSupportProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.ApplicationContext;

import com.jidesoft.swing.JideTabbedPane;
import com.vlsolutions.swing.docking.DockKey;
import com.vlsolutions.swing.docking.Dockable;

public class TabPanel extends JPanel implements NodeListListener, Dockable, TabVisibilityListener {
    private static final long serialVersionUID = 1L;

    private static final Logger LOGGER = LoggerFactory.getLogger(TabPanel.class);

    private String emptyLabel;

    private final MainModel model;

    private final TitledBorder border;

    private InfoPanel infoPanel;

    private BasicOperationsPanel basicOperationsPanel;

    private AccessoryListPanel accessoryListPanel;

    private AnalogPortListPanel analogPortListPanel;

    private BoosterPanel boosterPanel;

    private FeedbackPortListPanel feedbackPortListPanel;

    private FeedbackPositionListPanel feedbackPositionListPanel;

    private GlobalDetectorPanel globalDetectorPanel;

    private InputPortListPanel inputPortListPanel;

    private LightPortListPanel lightPortListPanel;

    private BacklightPortListPanel backlightPortListPanel;

    private MacroListPanel macroListPanel;

    private MotorPortListPanel motorPortListPanel;

    private ServoPortListPanel servoPortListPanel;

    private SoundPortListPanel soundPortListPanel;

    private SwitchPortListPanel switchPortListPanel;

    private SwitchPairPortListPanel switchPairPortListPanel;

    private FlagListPanel flagListPanel;

    private StepControlPanel stepControlPanel;

    private CvDefinitionPanel cvDefinitionPanel;

    private ReverserPanel reverserPanel;

    private final JideTabbedPane tabbedPane;

    private NodeInterface displayedNode;

    private final List<TabPanelProvider> tabs = new LinkedList<>();

    private final ScriptingSupportProvider scriptingSupportProvider;

    private EmptyPanel emptyPanel;

    private TabStatusListener tabStatusListener;

    private AccessoryPanelController accessoryPanelController;

    private BoosterPanelController boosterPanelController;

    private MacroPanelController macroPanelController;

    private FeedbackPortPanelController feedbackPortPanelController;

    private BacklightPortPanelController backlightPortPanelController;

    private InputPortPanelController inputPortPanelController;

    private FeedbackPositionPanelController feedbackPositionPanelController;

    private LightPortPanelController lightPortPanelController;

    private GlobalDetectorPanelController globalDetectorPanelController;

    private SoundPortPanelController soundPortPanelController;

    private SwitchPortPanelController switchPortPanelController;

    private ServoPortPanelController servoPortPanelController;

    private MotorPortPanelController motorPortPanelController;

    private SwitchPairPortPanelController switchPairPortPanelController;

    private StepControlController stepControlController;

    private CvDefinitionPanelController cvDefinitionPanelController;

    private ReverserPanelController reverserPanelController;

    private FlagPanelController flagPanelController;

    private LocoPanelController locoPanelController;

    private LocoPanelView locoControlPanel;

    private final SettingsService settingsService;

    private final ApplicationContext applicationContext;

    private final LookupService lookupService;

    private final PropertyChangeListener pclNodeLabel;

    public TabPanel(final MainModel model, final ConnectionPhaseModel connectionPhaseModel,
        final SettingsService settingsService, final ScriptingSupportProvider scriptingSupportProvider,
        final MainMenuListener mainMenuListener, final ApplicationContext applicationContext,
        final LookupService lookupService) {
        this.model = model;
        this.settingsService = settingsService;
        this.scriptingSupportProvider = scriptingSupportProvider;
        this.applicationContext = applicationContext;
        this.lookupService = lookupService;

        LOGGER.info("Create new TabPanel instance.");

        emptyLabel = Resources.getString(getClass(), "emptyLabel");
        border = BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), emptyLabel);
        setBorder(border);
        setLayout(new BorderLayout());

        DockKeys.DOCKKEY_TAB_PANEL.setName(Resources.getString(getClass(), "title"));
        // turn off autohide and close features
        DockKeys.DOCKKEY_TAB_PANEL.setCloseEnabled(false);
        DockKeys.DOCKKEY_TAB_PANEL.setAutoHideEnabled(false);
        DockKeys.DOCKKEY_TAB_PANEL.setFloatEnabled(true);

        final ImageIcon pendingChangesIcon = ImageUtils.createImageIcon(TabPanel.class, "/icons/16x16/savetonode.png");

        emptyPanel = new EmptyPanel(connectionPhaseModel, settingsService, mainMenuListener);

        tabbedPane = new JideTabbedPane();
        tabStatusListener = new TabStatusListener() {

            @Override
            public void updatePendingChanges(Component source, boolean hasPendingChanges) {
                Icon icon = null;
                if (hasPendingChanges) {
                    icon = pendingChangesIcon;
                }
                int componentIndex = tabbedPane.indexOfComponent(source);
                LOGGER
                    .info("updatePendingChanges, hasPendingChanges: {}, componentIndex: {}, component: {}",
                        hasPendingChanges, componentIndex, source);

                if (componentIndex > -1) {
                    tabbedPane.setIconAt(componentIndex, icon);
                }
            }
        };

        this.pclNodeLabel = evt -> {

            updateBorderLabel();
        };

        showInnerComponent(true);

        final Timer createContentTimer = new Timer(1000, evt -> createContent());
        createContentTimer.setRepeats(false);
        createContentTimer.start();
    }

    private void createContent() {
        LOGGER.info("Create the content of the TabPanel. Get the controllers from the application context.");

        accessoryPanelController = this.applicationContext.getBean(AccessoryPanelController.class);
        accessoryListPanel = accessoryPanelController.createAccessoryListPanel(this);

        boosterPanelController = this.applicationContext.getBean(BoosterPanelController.class);
        model.addNodeListListener(boosterPanelController);
        boosterPanel = boosterPanelController.createPanel(this);

        analogPortListPanel = new AnalogPortListPanel(model, this);

        feedbackPortPanelController = this.applicationContext.getBean(FeedbackPortPanelController.class);
        feedbackPortListPanel = feedbackPortPanelController.createPanel(this);

        inputPortPanelController = this.applicationContext.getBean(InputPortPanelController.class);
        inputPortListPanel = inputPortPanelController.createPanel(this);

        globalDetectorPanelController = new GlobalDetectorPanelController(model, this);
        globalDetectorPanel = globalDetectorPanelController.createGlobalDetectorPanel();

        feedbackPositionPanelController = this.applicationContext.getBean(FeedbackPositionPanelController.class);
        feedbackPositionListPanel = feedbackPositionPanelController.createFeedbackPositionListPanel(this);

        lightPortPanelController = this.applicationContext.getBean(LightPortPanelController.class);
        lightPortListPanel = lightPortPanelController.createPanel(this);

        backlightPortPanelController = this.applicationContext.getBean(BacklightPortPanelController.class);
        backlightPortListPanel = backlightPortPanelController.createPanel(this);

        motorPortPanelController = this.applicationContext.getBean(MotorPortPanelController.class);
        motorPortListPanel = motorPortPanelController.createPanel(this);

        servoPortPanelController = this.applicationContext.getBean(ServoPortPanelController.class);
        servoPortListPanel = servoPortPanelController.createPanel(this);

        soundPortPanelController = this.applicationContext.getBean(SoundPortPanelController.class);
        soundPortListPanel = soundPortPanelController.createPanel(this);

        switchPortPanelController = this.applicationContext.getBean(SwitchPortPanelController.class);
        switchPortListPanel = switchPortPanelController.createPanel(this);

        macroPanelController = this.applicationContext.getBean(MacroPanelController.class);
        macroListPanel = macroPanelController.createMacroListPanel(this);
        DefaultApplicationContext
            .getInstance().register(DefaultApplicationContext.KEY_MACROLIST_CONTROLLER, macroPanelController);

        switchPairPortPanelController = this.applicationContext.getBean(SwitchPairPortPanelController.class);
        switchPairPortListPanel = switchPairPortPanelController.createPanel(this);

        flagPanelController = this.applicationContext.getBean(FlagPanelController.class);
        flagListPanel = flagPanelController.createFlagListPanel();

        locoPanelController = this.applicationContext.getBean(LocoPanelController.class);
        locoControlPanel = locoPanelController.createPanel();

        final FirmwareControllerFactory firmwareControllerFactory =
            this.applicationContext.getBean(FirmwareControllerFactory.class);
        final FirmwareRepoService firmwareRepoService = this.applicationContext.getBean(FirmwareRepoService.class);

        infoPanel =
            new InfoPanel(model, settingsService, this.lookupService, firmwareControllerFactory, firmwareRepoService);
        basicOperationsPanel = new BasicOperationsPanel(model, this.applicationContext);

        // create the CV definition panel
        final CvDefinitionPanelControllerFactory cvDefinitionPanelControllerFactory =
            this.applicationContext.getBean(CvDefinitionPanelControllerFactory.class);
        cvDefinitionPanelController = cvDefinitionPanelControllerFactory.createController(model);
        cvDefinitionPanelController.start(tabStatusListener);
        cvDefinitionPanel = cvDefinitionPanelController.getCvDefinitionPanel();

        // register in application context
        DefaultApplicationContext
            .getInstance()
            .register(DefaultApplicationContext.KEY_CVDEFINITIONPANEL_CONTROLLER, cvDefinitionPanelController);

        // create the reverser panel
        final ReverserPanelControllerFactory reverserPanelControllerFactory =
            this.applicationContext.getBean(ReverserPanelControllerFactory.class);
        reverserPanelController = reverserPanelControllerFactory.createController(model, this);
        reverserPanelController.start(tabStatusListener);
        reverserPanel = reverserPanelController.getReverserPanel();

        // create the step control panel
        stepControlController = this.applicationContext.getBean(StepControlController.class);
        DefaultApplicationContext
            .getInstance().register(DefaultApplicationContext.KEY_STEPCONTROL_CONTROLLER, stepControlController);
        stepControlController.start(tabStatusListener);

        stepControlPanel = stepControlController.getComponent();

        boolean showActionInLastTab = settingsService.getWizardSettings().isShowActionInLastTab();

        if (!showActionInLastTab) {
            tabs.add(basicOperationsPanel);
        }
        tabs.add(infoPanel);
        tabs.add(stepControlPanel);
        tabs.add(accessoryListPanel);
        tabs.add(macroListPanel);
        tabs.add(inputPortListPanel);
        tabs.add(analogPortListPanel);
        tabs.add(lightPortListPanel);
        tabs.add(backlightPortListPanel);
        tabs.add(motorPortListPanel);
        tabs.add(switchPortListPanel);
        tabs.add(switchPairPortListPanel);
        tabs.add(servoPortListPanel);
        tabs.add(soundPortListPanel);
        tabs.add(flagListPanel);
        tabs.add(boosterPanel);
        tabs.add(feedbackPortListPanel);
        tabs.add(feedbackPositionListPanel);
        tabs.add(globalDetectorPanel);
        tabs.add(reverserPanel);
        tabs.add(cvDefinitionPanel);
        tabs.add(locoControlPanel);
        if (showActionInLastTab) {
            tabs.add(basicOperationsPanel);
        }

        // register the supported port types
        scriptingSupportProvider.addScriptingSupport(ScriptingTargetType.ANALOGPORT, analogPortListPanel);
        scriptingSupportProvider.addScriptingSupport(ScriptingTargetType.BACKLIGHTPORT, backlightPortListPanel);
        scriptingSupportProvider.addScriptingSupport(ScriptingTargetType.FEEDBACKPORT, feedbackPortListPanel);
        // scriptingSupportProvider.addScriptingSupport(ScriptingTargetType.FEEDBACKPOSITION,
        // feedbackPositionListPanel);
        scriptingSupportProvider.addScriptingSupport(ScriptingTargetType.INPUTPORT, inputPortListPanel);
        scriptingSupportProvider.addScriptingSupport(ScriptingTargetType.LIGHTPORT, lightPortListPanel);
        scriptingSupportProvider.addScriptingSupport(ScriptingTargetType.MOTORPORT, motorPortListPanel);
        scriptingSupportProvider.addScriptingSupport(ScriptingTargetType.SERVOPORT, servoPortListPanel);
        scriptingSupportProvider.addScriptingSupport(ScriptingTargetType.SOUNDPORT, soundPortListPanel);
        scriptingSupportProvider.addScriptingSupport(ScriptingTargetType.SWITCHPORT, switchPortListPanel);
        scriptingSupportProvider.addScriptingSupport(ScriptingTargetType.SWITCHPAIRPORT, switchPairPortListPanel);
        scriptingSupportProvider.addScriptingSupport(ScriptingTargetType.FLAG, flagListPanel);

        scriptingSupportProvider.addScriptingSupport(ScriptingTargetType.MACRO, macroListPanel);
        scriptingSupportProvider.addScriptingSupport(ScriptingTargetType.ACCESSORY, accessoryListPanel);
        scriptingSupportProvider.addScriptingSupport(ScriptingTargetType.ASPECT, accessoryListPanel);

        model.addNodeListListener(this);

        model.addCvDefinitionListener(new CvDefinitionListener() {
            @Override
            public void cvDefinitionChanged() {
                LOGGER
                    .info(
                        "The CV definition has changed. Enable/disable the cvDefintionPanel and the stepControlPanel.");
                enableTab(cvDefinitionPanel, displayedNode != null && displayedNode.isCvDefinitionAvailable());

                // enableTab(reverserPanel.getComponent(), model.isCvDefinitionAvailable());

                // step control has special panel
                enableTab(stepControlPanel.getComponent(),
                    displayedNode != null && ProductUtils.isStepControl(displayedNode.getUniqueId()));

                // if the node is a StepControl we must activate the StepControl panel
                if (displayedNode != null && ProductUtils.isStepControl(displayedNode.getUniqueId())) {
                    LOGGER.info("Activate the StepControl panel.");

                    try {
                        tabbedPane.setSelectedComponent(stepControlPanel.getComponent());
                    }
                    catch (Exception ex) {
                        LOGGER.warn("Activate the StepControl panel failed.", ex);
                    }
                }
            }

            @Override
            public void cvDefinitionValuesChanged(final boolean read, final List<String> changedNames) {
            }
        });

        tabbedPane.addChangeListener(new ChangeListener() {

            @Override
            public void stateChanged(ChangeEvent e) {
                Component selectedComponent = tabbedPane.getSelectedComponent();
                LOGGER.debug("Currently selected component in tabbedPane: {}", selectedComponent);

                for (TabPanelProvider comp : tabs) {
                    if (comp.getComponent() instanceof TabSelectionListener) {
                        TabSelectionListener listener = (TabSelectionListener) comp.getComponent();
                        LOGGER.info("Select tab, current component: {}", listener);

                        listener.tabSelected(((JPanel) listener).equals(selectedComponent));
                    }
                }
            }
        });

        // TODO remove this after the refactoring of listeners and removal from MainController
        ((CvDefinitionRequestListenerAware) cvDefinitionPanel)
            .addCvDefinitionRequestListener(this.cvDefinitionRequestListener);
        stepControlPanel.addCvDefinitionRequestListener(this.cvDefinitionRequestListener);
        lightPortPanelController.addCvDefinitionRequestListener(this.cvDefinitionRequestListener);

        reverserPanel.addCvDefinitionRequestListener(this.cvDefinitionRequestListener);

    }

    private void showInnerComponent(boolean empty) {

        if (empty) {
            remove(this.tabbedPane);
            add(this.emptyPanel.getContent());
        }
        else {
            remove(this.emptyPanel.getContent());
            add(this.tabbedPane);
        }
    }

    @Override
    public void updateUI() {
        super.updateUI();

        if (this.emptyPanel != null && this.emptyPanel.getContent() != null) {
            this.emptyPanel.getContent().updateUI();
        }

        if (this.tabbedPane != null) {
            this.tabbedPane.updateUI();
        }
    }

    private CvDefinitionRequestListener cvDefinitionRequestListener;

    // TODO remove this after the refactoring of listeners and removal from MainController
    public void addCvDefinitionRequestListener(CvDefinitionRequestListener cvDefinitionRequestListener) {

        this.cvDefinitionRequestListener = cvDefinitionRequestListener;
        // ((CvDefinitionRequestListenerAware) cvDefinitionPanel).addCvDefinitionRequestListener(l);
        // stepControlPanel.addCvDefinitionRequestListener(l);
        // lightPortPanelController.addCvDefinitionRequestListener(l);
        //
        // reverserPanel.addCvDefinitionRequestListener(l);
    }

    private void updateBorderLabel() {

        SwingUtils.executeInEDT(() -> {
            String nodeName = emptyLabel;
            if (displayedNode != null) {
                Optional<ProductType> product =
                    TabPanel.this.lookupService.getProduct(displayedNode.getNode().getUniqueId());

                nodeName = org.bidib.wizard.api.utils.NodeUtils.getNodeName(displayedNode);
                if (product.isPresent()) {
                    nodeName = nodeName + " - " + product.get().getName();
                }
            }

            border.setTitle(nodeName);
            repaint();
        });
    }

    @Override
    public void listChanged() {
        LOGGER.debug("list has changed.");
    }

    @Override
    public void nodeChanged(final NodeInterface node) {
        LOGGER.debug("The node has changed, currently displayedNode: {}", displayedNode);
        SwingUtils.executeInEDT(() -> internalNodeChanged());
    }

    private void internalNodeChanged() {
        LOGGER.debug("handle node has changed: {}", displayedNode);

        if (displayedNode != null && displayedNode.equals(model.getSelectedNode())) {
            LOGGER.debug("The node has not changed.");
            return;
        }

        if (displayedNode != null) {
            displayedNode.removePropertyChangeListener(NodeInterface.PROPERTY_LABEL, pclNodeLabel);
        }
        // remove all tabs because otherwise while loading features from LC the booster panel is still displayed
        tabbedPane.removeAll();

        // remove all listeners
        if (displayedNode != null) {
            for (TabPanelProvider tab : tabs) {
                if (tab instanceof PortListListener) {
                    PortListListener portListListener = (PortListListener) tab;
                    displayedNode.removePortListListener(portListListener.getPortClass(), portListListener);
                }

                if (tab instanceof PortStatusListener) {
                    PortStatusListener<?> portListener = (PortStatusListener<?>) tab;
                    displayedNode.removePortListener(portListener.getPortClass(), portListener);
                }

                if (tab instanceof PortListenerProvider) {
                    PortListener<?> portListener = ((PortListenerProvider<?>) tab).getPortListener();
                    if (portListener != null) {
                        displayedNode.removePortListener(portListener.getPortClass(), portListener);

                        if (portListener instanceof PortValueListener) {
                            PortValueListener<?> portValueListener = (PortValueListener<?>) portListener;
                            LOGGER
                                .debug("Remove port value listener: {}, port class: {}", portValueListener,
                                    portValueListener.getPortClass());
                            displayedNode.removePortValueListener(portValueListener.getPortClass(), portValueListener);
                        }

                    }
                }

                if (tab instanceof PortValueListener) {
                    PortValueListener<?> portValueListener = (PortValueListener<?>) tab;
                    displayedNode.removePortValueListener(portValueListener.getPortClass(), portValueListener);
                }

                if (tab instanceof MacroListListener) {
                    MacroListListener macroListListener = (MacroListListener) tab;
                    displayedNode.removeMacroListListener(macroListListener);
                }

                if (tab instanceof MacroSelectionListener) {
                    MacroSelectionListener macroSelectionListener = (MacroSelectionListener) tab;
                    model.removeMacroSelectionListener(macroSelectionListener);
                }

                if (tab instanceof AccessoryListListener) {
                    AccessoryListListener accessoryListListener = (AccessoryListListener) tab;
                    displayedNode.removeAccessoryListListener(accessoryListListener);
                }

                if (tab instanceof AccessorySelectionListener) {
                    AccessorySelectionListener accessorySelectionListener = (AccessorySelectionListener) tab;
                    model.removeAccessorySelectionListener(accessorySelectionListener);
                }
            }
        }

        displayedNode = model.getSelectedNode();
        showInnerComponent(displayedNode == null);

        // add listeners again
        for (TabPanelProvider tab : tabs) {
            if (displayedNode != null) {
                if (tab instanceof PortListListener) {
                    PortListListener portListListener = (PortListListener) tab;
                    displayedNode.addPortListListener(portListListener.getPortClass(), portListListener);

                    // trigger the refresh
                    // portListListener.listChanged();
                    portListListener.refreshPorts();
                }

                if (tab instanceof PortStatusListener) {
                    PortStatusListener<?> portListener = (PortStatusListener<?>) tab;

                    LOGGER
                        .debug("Add port status listener, port class: {}, port status listener: {}",
                            portListener.getPortClass(), portListener);

                    displayedNode.addPortListener(portListener.getPortClass(), portListener);
                }

                if (tab instanceof PortListenerProvider) {
                    PortListener<?> portListener = ((PortListenerProvider<?>) tab).getPortListener();
                    if (portListener != null) {
                        LOGGER
                            .debug("Add port listener, port class: {}, port listener: {}", portListener.getPortClass(),
                                portListener);

                        displayedNode.addPortListener(portListener.getPortClass(), portListener);

                        if (portListener instanceof PortValueListener) {
                            PortValueListener<?> portValueListener = (PortValueListener<?>) portListener;
                            LOGGER
                                .debug("Add port value listener: {}, port class: {}", portValueListener,
                                    portValueListener.getPortClass());
                            displayedNode.addPortValueListener(portValueListener.getPortClass(), portValueListener);
                        }
                    }
                    else {
                        LOGGER.warn("The PortListenerProvider has no port listener assigned: {}", tab);
                    }
                }

                if (tab instanceof PortValueListener) {
                    PortValueListener<?> portValueListener = (PortValueListener<?>) tab;
                    displayedNode.addPortValueListener(portValueListener.getPortClass(), portValueListener);
                }

                if (tab instanceof MacroListListener) {
                    MacroListListener macroListListener = (MacroListListener) tab;
                    displayedNode.addMacroListListener(macroListListener);

                    // trigger the refresh
                    macroListListener.listChanged();
                }

                if (tab instanceof MacroSelectionListener) {
                    MacroSelectionListener macroSelectionListener = (MacroSelectionListener) tab;
                    model.addMacroSelectionListener(macroSelectionListener);
                }

                if (tab instanceof AccessoryListListener) {
                    AccessoryListListener accessoryListListener = (AccessoryListListener) tab;
                    displayedNode.addAccessoryListListener(accessoryListListener);

                    // trigger the refresh
                    accessoryListListener.listChanged();
                }

                if (tab instanceof AccessorySelectionListener) {
                    AccessorySelectionListener accessorySelectionListener = (AccessorySelectionListener) tab;
                    model.addAccessorySelectionListener(accessorySelectionListener);
                }
            }

            if (tab instanceof TabVisibilityProvider) {
                TabVisibilityProvider tabVisibilityProvider = (TabVisibilityProvider) tab;
                LOGGER.debug("Set visibility of tab: {}", tabVisibilityProvider);
                enableTab(tabVisibilityProvider.getComponent(), ((TabVisibilityProvider) tab).isTabVisible());
            }
        }

        // change visibility of flag list panel
        enableTab(flagListPanel.getComponent(), displayedNode != null
            && NodeUtils.hasAccessoryFunctions(displayedNode.getUniqueId()) && displayedNode.hasMacros());

        // change visibility of info panel
        enableTab(infoPanel.getComponent(), displayedNode != null);

        // change visibility of basic operations panel
        enableTab(basicOperationsPanel.getComponent(), displayedNode != null);

        // the booster panel needs special handling because it has no list of ports
        enableTab(boosterPanel.getComponent(),
            displayedNode != null && (NodeUtils.hasBoosterFunctions(displayedNode.getUniqueId())
                || NodeUtils.hasCommandStationFunctions(displayedNode.getUniqueId())));

        // the loco control panel needs special handling because it has no list of ports
        enableTab(locoControlPanel.getComponent(),
            displayedNode != null && ProductUtils.isSpeedometer(displayedNode.getUniqueId()));

        if (displayedNode != null) {
            displayedNode.addPropertyChangeListener(NodeInterface.PROPERTY_LABEL, pclNodeLabel);
        }

        updateBorderLabel();

        flagListPanel.nodeChanged();
        infoPanel.nodeChanged();
        basicOperationsPanel.nodeChanged();

        reverserPanel.nodeChanged();
    }

    private void enableTab(final Component component, final boolean enable) {
        if (SwingUtilities.isEventDispatchThread()) {
            innerEnableTab(component, enable);
        }
        else {
            SwingUtilities.invokeLater(() -> innerEnableTab(component, enable));
        }
    }

    private void innerEnableTab(final Component component, final boolean enable) {

        int componentIndex = tabbedPane.indexOfComponent(component);
        LOGGER
            .debug("enableTab, enable: {}, componentIndex: {}, name: {}, component: {}", enable, componentIndex,
                component.getName(), component);
        if (enable && componentIndex == -1) {

            // count all visible components in front of me
            int index = 0;

            for (TabPanelProvider tab : tabs) {
                Component currentComponent = tab.getComponent();
                if (currentComponent == component) {
                    break;
                }
                if (tabbedPane.indexOfComponent(currentComponent) >= 0) {
                    index++;
                }
            }
            tabbedPane.add(component, index);
            if (index == 0) {
                tabbedPane.setSelectedIndex(0);
            }
        }
        else if (!enable && componentIndex >= 0) {
            tabbedPane.remove(component);
        }
        LOGGER.debug("number of components in tabbed pane: {}", tabbedPane.getComponentCount());
    }

    @Override
    public void nodeStateChanged(final NodeInterface node) {
    }

    @Override
    public Component getComponent() {
        return this;
    }

    @Override
    public DockKey getDockKey() {
        return DockKeys.DOCKKEY_TAB_PANEL;
    }

    @Override
    public void listNodeAdded(NodeInterface node) {
    }

    @Override
    public void listNodeRemoved(NodeInterface node) {
    }

    @Override
    public void nodeWillChange(final NodeInterface node) {

        for (TabPanelProvider tab : tabs) {

            if (tab instanceof NodeListListener) {
                ((NodeListListener) tab).nodeWillChange(node);
            }

            if (tab instanceof PendingChangesAware) {

                boolean pendingChanges = ((PendingChangesAware) tab).hasPendingChanges();

                if (pendingChanges) {
                    LOGGER.warn("The current tab has pending changes: {}", tab);

                    // throw exception that prevents the change of the selected node
                    throw new NodeChangeVetoException("Pending changes in " + tab + " detected.");
                }
            }
        }
    }

    @Override
    public void setTabVisible(Component component, boolean visible) {
        LOGGER.debug("Set the component visible, component: {}, visible: {}", component, visible);

        enableTab(component, visible);
    }

    public void performShutdown() {

        for (TabPanelProvider tab : tabs) {
            if (tab.getComponent() instanceof ShutdownListener) {
                try {
                    ((ShutdownListener) tab.getComponent()).performShutdown();
                }
                catch (Exception ex) {
                    LOGGER.warn("Perform shutdown failed on tab: {}", tab, ex);
                }
            }
        }
    }

    public void savePendingChanges() {

        for (TabPanelProvider tab : tabs) {
            if (tab instanceof PendingChangesAware) {

                boolean pendingChanges = ((PendingChangesAware) tab).hasPendingChanges();

                if (pendingChanges) {
                    LOGGER.warn("The current tab has pending changes: {}", tab);
                    ((PendingChangesAware) tab).savePendingChanges();
                }
            }
        }
    }
}
