/*
 * Decompiled with CFR 0.152.
 */
package org.bidib.wizard.mvc.main.controller;

import com.jidesoft.alert.Alert;
import com.jidesoft.alert.AlertGroup;
import com.jidesoft.animation.CustomAnimation;
import com.jidesoft.plaf.UIDefaultsLookup;
import com.jidesoft.swing.JideButton;
import com.jidesoft.swing.JideSwingUtilities;
import com.jidesoft.swing.PaintPanel;
import io.reactivex.rxjava3.disposables.CompositeDisposable;
import io.reactivex.rxjava3.disposables.Disposable;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.GradientPaint;
import java.awt.GridLayout;
import java.awt.LayoutManager;
import java.awt.Paint;
import java.awt.event.ActionListener;
import java.awt.event.MouseListener;
import java.beans.PropertyChangeListener;
import java.net.InetAddress;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.bidib.api.json.types.SerialPortInfo;
import org.bidib.wizard.api.locale.Resources;
import org.bidib.wizard.api.model.common.NetBidibServiceInfo;
import org.bidib.wizard.api.model.common.PreferencesPortType;
import org.bidib.wizard.api.model.event.ConsoleMessageEvent;
import org.bidib.wizard.api.service.console.ConsoleColor;
import org.bidib.wizard.client.common.uils.SwingUtils;
import org.bidib.wizard.client.common.view.statusbar.StatusBar;
import org.bidib.wizard.common.service.SettingsService;
import org.bidib.wizard.common.utils.ImageUtils;
import org.bidib.wizard.core.service.SystemInfoService;
import org.bidib.wizard.discovery.listener.NetBidibServiceListener;
import org.bidib.wizard.mvc.main.controller.AlertController;
import org.bidib.wizard.mvc.main.controller.listener.AlertListener;
import org.bidib.wizard.mvc.main.view.MainView;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationEventPublisher;

public class AlertController {
    private static final Logger LOGGER = LoggerFactory.getLogger(AlertController.class);
    @Autowired
    private SettingsService settingsService;
    @Autowired
    private SystemInfoService systemInfoService;
    @Autowired
    private StatusBar statusBar;
    @Autowired
    private List<NetBidibServiceListener> netBidibServiceListeners;
    @Autowired
    private ApplicationEventPublisher applicationEventPublisher;
    private final BidibAlertGroup alertGroup;
    private CompositeDisposable dispUsbPortEvents = new CompositeDisposable();
    private CompositeDisposable dispNetBidibServiceListenerEvents = new CompositeDisposable();
    private final MainView mainView;
    private final List<AlertListener> alertListeners = new LinkedList();

    public AlertController(MainView mainView) {
        this.mainView = mainView;
        this.alertGroup = new BidibAlertGroup();
    }

    public void start() {
        Disposable disposable = this.systemInfoService.subscribeUsbPortEvents(upe -> {
            LOGGER.info("Publish the USB port event: {}", upe);
            SerialPortInfo serialPort = upe.getSerialPort();
            switch (7.$SwitchMap$org$bidib$api$json$types$UsbPortInfo$UsbPortAction[upe.getAction().ordinal()]) {
                case 1: {
                    this.usbDeviceAdded(serialPort);
                    break;
                }
                default: {
                    this.usbDeviceRemoved(serialPort);
                }
            }
        }, error -> LOGGER.warn("The USB port event signalled a failure: {}", error));
        this.dispUsbPortEvents.add(disposable);
        List registeredPorts = this.systemInfoService.getRegisteredSerialPorts();
        for (SerialPortInfo port : registeredPorts) {
            this.usbDeviceAdded(port);
        }
        if (CollectionUtils.isNotEmpty((Collection)this.netBidibServiceListeners)) {
            for (NetBidibServiceListener listener : this.netBidibServiceListeners) {
                Disposable disp = listener.subscribeNetBidibServiceEvents(sie -> {
                    LOGGER.info("Received netBidibServiceEvent: {}", sie);
                    try {
                        switch (7.$SwitchMap$org$bidib$wizard$api$model$common$NetBidibServiceInfo$DiscoveryAction[sie.getAction().ordinal()]) {
                            case 1: {
                                this.netBidibServiceResolved(sie);
                                break;
                            }
                            case 2: {
                                this.netBidibServiceRemoved(sie);
                                break;
                            }
                            default: {
                                LOGGER.warn("Unhandled action in event: {}", sie);
                                break;
                            }
                        }
                    }
                    catch (Exception ex) {
                        LOGGER.warn("Publish changed netBidib service info event failed.", (Throwable)ex);
                    }
                }, error -> LOGGER.warn("The netBidibServiceListener event signalled a failure: {}", error));
                this.dispNetBidibServiceListenerEvents.add(disp);
            }
        }
    }

    public void stopWatcher() {
        this.dispUsbPortEvents.dispose();
        this.dispNetBidibServiceListenerEvents.dispose();
    }

    private void netBidibServiceResolved(NetBidibServiceInfo sie) {
        String text;
        StringBuilder sb = new StringBuilder();
        InetAddress address = sie.getAddresses()[0];
        LOGGER.info("Provided address: {}, port: {}", (Object)address, (Object)sie.getPort());
        sb.append(PreferencesPortType.ConnectionPortType.NetBidibClient.name()).append(':').append(address.getHostName()).append(':').append(sie.getPort());
        String highlightText = text = "<HTML><B>" + Resources.getString(AlertController.class, (String)"message.netbidib-device-resolved") + "</B><BR><FONT COLOR=" + this.getColor("Alert.titleColor") + ">" + Resources.getString(AlertController.class, (String)"message.product", (Object[])new Object[]{sie.getProps().get("prod")}) + "<BR>" + Resources.getString(AlertController.class, (String)"message.username", (Object[])new Object[]{sie.getProps().getOrDefault("user", "")}) + "<BR>IP: " + address.getHostAddress() + "</FONT></HTML>";
        String portName = sb.toString();
        try {
            SwingUtils.executeInEDT(() -> {
                Alert alert = this.createAlert(portName, text, highlightText, (Object)sie);
                this.notifyAlertAddedListeners(alert, AlertListener.AlertAction.DEVICE_ADDED);
                this.showAlert(alert, (Component)this.mainView.getFrame());
            });
        }
        catch (Exception ex) {
            LOGGER.warn("Show resolved event failed.", (Throwable)ex);
        }
        try {
            String messageText = Resources.getString(AlertController.class, (String)"message.netbidib-device-resolved") + ", " + Resources.getString(AlertController.class, (String)"message.product", (Object[])new Object[]{sie.getProps().get("prod")}) + ", " + Resources.getString(AlertController.class, (String)"message.username", (Object[])new Object[]{sie.getProps().getOrDefault("user", "")}) + ", IP: " + address.getHostAddress();
            this.applicationEventPublisher.publishEvent((Object)new ConsoleMessageEvent(ConsoleColor.black, messageText));
        }
        catch (Exception ex) {
            LOGGER.warn("Publish console event of netBiDiB device resolved failed.");
        }
    }

    private String getColor(String colorKey) {
        Color color = UIDefaultsLookup.getColor((Object)colorKey);
        return String.format("#%06x", color.getRGB() & 0xFFFFFF);
    }

    private void netBidibServiceRemoved(NetBidibServiceInfo sie) {
        String text;
        StringBuilder sb = new StringBuilder();
        InetAddress address = sie.getAddresses()[0];
        LOGGER.info("Provided address: {}", (Object)address);
        sb.append(PreferencesPortType.ConnectionPortType.NetBidibClient.name()).append(':').append(address.getHostName()).append(':').append(sie.getPort());
        String highlightText = text = "<HTML><B>" + Resources.getString(AlertController.class, (String)"message.netbidib-device-removed") + "</B><BR><FONT COLOR=" + this.getColor("Alert.titleColor") + ">" + Resources.getString(AlertController.class, (String)"message.product", (Object[])new Object[]{sie.getProps().get("prod")}) + "<BR>" + Resources.getString(AlertController.class, (String)"message.username", (Object[])new Object[]{sie.getProps().getOrDefault("user", "")}) + "<BR>IP: " + address.getHostAddress() + "</FONT></HTML>";
        String portName = sb.toString();
        try {
            SwingUtilities.invokeLater(() -> {
                Alert alert = this.createAlert(portName, highlightText, highlightText, (Object)sie);
                this.notifyAlertAddedListeners(alert, AlertListener.AlertAction.DEVICE_REMOVED);
                this.showAlert(alert, (Component)this.mainView.getFrame());
            });
        }
        catch (Exception ex) {
            LOGGER.warn("Show removed event failed.", (Throwable)ex);
        }
    }

    private void usbDeviceRemoved(SerialPortInfo serialPort) {
        try {
            String text = "<HTML><B>" + Resources.getString(AlertController.class, (String)"message.usb-device-removed") + "</B><BR><FONT COLOR=" + this.getColor("Alert.titleColor") + ">VID: 0x" + serialPort.getVendorId() + "&nbsp;PID: 0x" + serialPort.getProductId() + "<BR>Serial number: " + serialPort.getSerialNumber() + "<BR>Product: " + serialPort.getProductString() + "<BR>COM Port: " + serialPort.getPortName() + "</FONT></HTML>";
            String highlightText = "<HTML><U><B>" + Resources.getString(AlertController.class, (String)"message.usb-device-removed") + "</B><BR><FONT COLOR=" + this.getColor("Alert.titleColor") + ">VID: 0x" + serialPort.getVendorId() + "&nbsp;PID: 0x" + serialPort.getProductId() + "<BR>Serial number: " + serialPort.getSerialNumber() + "<BR>Product: " + serialPort.getProductString() + "<BR>COM Port: " + serialPort.getPortName() + "</FONT><U></HTML>";
            SwingUtilities.invokeLater(() -> {
                Alert alert = this.createAlert(null, text, highlightText, (Object)serialPort);
                this.notifyAlertAddedListeners(alert, AlertListener.AlertAction.DEVICE_REMOVED);
                this.showAlert(alert, (Component)this.mainView.getFrame());
            });
        }
        catch (Exception ex) {
            LOGGER.warn("Show device removed alert failed.", (Throwable)ex);
        }
    }

    private void usbDeviceAdded(SerialPortInfo serialPort) {
        try {
            String text = "<HTML><B>" + Resources.getString(AlertController.class, (String)"message.usb-device-resolved") + "</B><BR><FONT COLOR=" + this.getColor("Alert.titleColor") + ">VID: 0x" + serialPort.getVendorId() + "&nbsp;PID: 0x" + serialPort.getProductId() + "<BR>Serial number: " + serialPort.getSerialNumber() + "<BR>Product: " + serialPort.getProductString() + "<BR>Manufacturer: " + serialPort.getManufacturerString() + "<BR>COM Port: " + serialPort.getPortName() + "</FONT></HTML>";
            String highlightText = "<HTML><U><B>" + Resources.getString(AlertController.class, (String)"message.usb-device-resolved") + "</B><BR><FONT COLOR=" + this.getColor("Alert.titleColor") + ">VID: 0x" + serialPort.getVendorId() + "&nbsp;PID: 0x" + serialPort.getProductId() + "<BR>Serial number: " + serialPort.getSerialNumber() + "<BR>Product: " + serialPort.getProductString() + "<BR>Manufacturer: " + serialPort.getManufacturerString() + "<BR>COM Port: " + serialPort.getPortName() + "</FONT><U></HTML>";
            String comPort = serialPort.getPortName();
            String serialNumber = serialPort.getSerialNumber();
            SwingUtilities.invokeLater(() -> {
                String portInfo = "SerialPort:" + comPort;
                if (serialNumber != null) {
                    portInfo = "SerialPort:" + comPort + " - " + serialNumber;
                }
                Alert alert = this.createAlert(portInfo, text, highlightText, (Object)serialPort);
                LOGGER.info("Created alert: {}", (Object)alert);
                this.notifyAlertAddedListeners(alert, AlertListener.AlertAction.DEVICE_ADDED);
                this.showAlert(alert, (Component)this.mainView.getFrame());
            });
        }
        catch (Exception ex) {
            LOGGER.warn("Show device added alert failed.", (Throwable)ex);
        }
    }

    public void showAlert(Alert alert, Component owner) {
        this.alertGroup.add(alert);
        alert.setAlertGroup((AlertGroup)this.alertGroup);
        this.alertGroup.add(alert);
        LOGGER.info("Show the alert: {}, owner: {}", (Object)alert, (Object)owner);
        alert.showPopup(4, owner);
    }

    private <T> Alert createAlert(String comPort, String text, String highlightText, T serialPort) {
        BidibAlert alert = new BidibAlert(comPort, serialPort);
        alert.getContentPane().setLayout(new BorderLayout());
        1 flagAction = null;
        if (StringUtils.isNotBlank((CharSequence)comPort)) {
            flagAction = new /* Unavailable Anonymous Inner Class!! */;
        } else {
            LOGGER.warn("No comPort identifier provided.");
        }
        alert.getContentPane().add(this.createUSBSerialAlert((ActionListener)flagAction, (ActionListener)new /* Unavailable Anonymous Inner Class!! */, text, highlightText));
        alert.setResizable(true);
        alert.setMovable(true);
        alert.setTransient(true);
        3 animation = new /* Unavailable Anonymous Inner Class!! */;
        animation.setFunctionFade(CustomAnimation.FUNC_BOUNCE);
        alert.setShowAnimation((CustomAnimation)animation);
        4 animationExit = new /* Unavailable Anonymous Inner Class!! */;
        animationExit.setFunctionFade(CustomAnimation.FUNC_POW_HALF);
        alert.setHideAnimation((CustomAnimation)animationExit);
        alert.addPropertyChangeListener("visible", (PropertyChangeListener)new /* Unavailable Anonymous Inner Class!! */);
        return alert;
    }

    private JideButton createButton(Icon icon) {
        JideButton button = new JideButton(icon);
        return button;
    }

    private JComponent createUSBSerialAlert(ActionListener flagAction, ActionListener closeAction, String text, String highlightText) {
        JPanel bottomPanel = new JPanel(new GridLayout(1, 2, 0, 0));
        if (flagAction != null) {
            JideButton flagButton = this.createButton((Icon)ImageUtils.createImageIcon(this.getClass(), (String)"/icons/16x16/connect.png"));
            flagButton.addActionListener(flagAction);
            bottomPanel.add((Component)flagButton);
        }
        JideButton deleteButton = this.createButton((Icon)ImageUtils.createImageIcon(this.getClass(), (String)"/icons/alert/delete.png"));
        deleteButton.addActionListener(closeAction);
        bottomPanel.add((Component)deleteButton);
        JPanel leftPanel = new JPanel(new BorderLayout(6, 6));
        leftPanel.add(new JLabel(ImageUtils.createImageIcon(this.getClass(), (String)"/icons/alert/usb_plug.png")));
        leftPanel.add((Component)bottomPanel, "Last");
        JPanel rightPanel = new JPanel(new GridLayout(1, 2, 0, 0));
        rightPanel.add((Component)this.createButton((Icon)ImageUtils.createImageIcon(this.getClass(), (String)"/icons/alert/option.png")));
        JideButton closeButton = this.createButton((Icon)ImageUtils.createImageIcon(this.getClass(), (String)"/icons/alert/close.png"));
        closeButton.addActionListener(closeAction);
        rightPanel.add((Component)closeButton);
        JLabel message = new JLabel(text);
        message.addMouseListener((MouseListener)new /* Unavailable Anonymous Inner Class!! */);
        PaintPanel panel = new PaintPanel((LayoutManager)new BorderLayout(6, 6));
        panel.setBorder(BorderFactory.createEmptyBorder(6, 7, 7, 7));
        panel.add((Component)message, (Object)"Center");
        JPanel topPanel = JideSwingUtilities.createTopPanel((Component)rightPanel);
        panel.add((Component)topPanel, (Object)"After");
        panel.add((Component)leftPanel, (Object)"Before");
        for (int i = 0; i < panel.getComponentCount(); ++i) {
            JideSwingUtilities.setOpaqueRecursively((Component)panel.getComponent(i), (boolean)false);
        }
        panel.setOpaque(true);
        Color background = UIDefaultsLookup.getColor((Object)"AlertPanel.background");
        if (background != null) {
            panel.setBackgroundPaint((Paint)background);
        } else {
            panel.setBackgroundPaint((Paint)new GradientPaint(0.0f, 0.0f, new Color(231, 229, 224), 0.0f, panel.getPreferredSize().height, new Color(212, 208, 200)));
        }
        return panel;
    }

    public void addAlertListener(AlertListener alertListener) {
        this.alertListeners.add(alertListener);
    }

    public void removeAlertListener(AlertListener alertListener) {
        this.alertListeners.remove(alertListener);
    }

    private void notifyAlertAddedListeners(Alert alert, AlertListener.AlertAction alertAction) {
        LOGGER.info("Notify the alertListeners about added, alertAction: {}, alert: {}", (Object)alertAction, (Object)alert);
        for (AlertListener listener : this.alertListeners) {
            listener.alertAdded(alert, alertAction);
        }
    }

    private void notifyAlertRemoveListeners(Alert alert) {
        LOGGER.info("Notify the alertListeners about remove, alert: {}", (Object)alert);
        for (AlertListener listener : this.alertListeners) {
            listener.alertRemoved(alert);
        }
    }
}

