/*
 * Decompiled with CFR 0.152.
 */
package org.bidib.wizard.mvc.main.view.panel;

import com.jgoodies.forms.builder.FormBuilder;
import com.jgoodies.forms.factories.DefaultComponentFactory;
import com.jgoodies.forms.factories.Paddings;
import java.awt.Component;
import javax.swing.Action;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.border.Border;
import org.bidib.jbidibc.messages.utils.NodeUtils;
import org.bidib.wizard.api.model.NodeInterface;
import org.bidib.wizard.client.common.event.MenuEvent;
import org.bidib.wizard.client.common.view.TabPanelProvider;
import org.bidib.wizard.common.context.DefaultApplicationContext;
import org.bidib.wizard.common.utils.ImageUtils;
import org.bidib.wizard.mvc.main.model.MainModel;
import org.bidib.wizard.mvc.main.view.panel.BasicOperationsPanel;
import org.bidib.wizard.mvc.main.view.panel.listener.NodeListActionListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.ApplicationContext;

public class BasicOperationsPanel
implements TabPanelProvider {
    private static final Logger LOGGER = LoggerFactory.getLogger(BasicOperationsPanel.class);
    private static final String ENCODED_DIALOG_COLUMN_SPECS = "fill:pref:grow";
    private static final String ENCODED_DIALOG_ROW_SPECS = "pref, 3dlu, pref, 3dlu, pref";
    private final MainModel mainModel;
    private final JPanel contentPanel;
    private final JButton btnFirmwareUpdate;
    private final JButton btnNodeDocumentation;
    private final JButton btnNodeConfigurator;
    private ImageIcon firmwareUpdateIcon;
    private ImageIcon nodeConfiguratorIcon;
    private ImageIcon nodeDocumentationIcon;
    private final ApplicationContext context;

    public BasicOperationsPanel(MainModel model, ApplicationContext context) {
        1 panel;
        this.mainModel = model;
        this.context = context;
        FormBuilder dialogBuilder = null;
        boolean debugDialog = false;
        if (debugDialog) {
            panel = new /* Unavailable Anonymous Inner Class!! */;
            dialogBuilder = FormBuilder.create().columns(ENCODED_DIALOG_COLUMN_SPECS, new Object[0]).rows(ENCODED_DIALOG_ROW_SPECS, new Object[0]).panel((JPanel)panel);
        } else {
            panel = new /* Unavailable Anonymous Inner Class!! */;
            dialogBuilder = FormBuilder.create().columns(ENCODED_DIALOG_COLUMN_SPECS, new Object[0]).rows(ENCODED_DIALOG_ROW_SPECS, new Object[0]).panel((JPanel)panel);
        }
        dialogBuilder.border((Border)Paddings.TABBED_DIALOG);
        DefaultComponentFactory componentFactory = DefaultComponentFactory.getInstance();
        this.firmwareUpdateIcon = ImageUtils.createImageIcon(BasicOperationsPanel.class, (String)"/icons/64x64/firmware-update.png");
        this.btnFirmwareUpdate = componentFactory.createButton((Action)new /* Unavailable Anonymous Inner Class!! */);
        dialogBuilder.add((Component)this.btnFirmwareUpdate).xy(1, 1);
        this.nodeConfiguratorIcon = ImageUtils.createImageIcon(BasicOperationsPanel.class, (String)"/icons/64x64/nodescript-wizard.png");
        this.btnNodeConfigurator = componentFactory.createButton((Action)new /* Unavailable Anonymous Inner Class!! */);
        dialogBuilder.add((Component)this.btnNodeConfigurator).xy(1, 3);
        this.nodeDocumentationIcon = ImageUtils.createImageIcon(BasicOperationsPanel.class, (String)"/icons/64x64/node-documentation.png");
        this.btnNodeDocumentation = componentFactory.createButton((Action)new /* Unavailable Anonymous Inner Class!! */);
        dialogBuilder.add((Component)this.btnNodeDocumentation).xy(1, 5);
        this.contentPanel = dialogBuilder.build();
    }

    public JPanel getComponent() {
        return this.contentPanel;
    }

    public void nodeChanged() {
        LOGGER.info("The selected node has changed.");
        this.updateComponentState();
    }

    private void updateComponentState() {
        NodeInterface node = this.mainModel.getSelectedNode();
        if (node != null) {
            this.updateNodeInfo(node);
        }
    }

    private void updateNodeInfo(NodeInterface node) {
        if (node == null) {
            return;
        }
        LOGGER.info("Update the basic operations panel for node: {}", (Object)node);
        this.btnFirmwareUpdate.setEnabled(node.isUpdatable());
        if (NodeUtils.hasAccessoryFunctions((long)node.getUniqueId()) || NodeUtils.hasSwitchFunctions((long)node.getUniqueId())) {
            this.btnNodeConfigurator.setEnabled(true);
        } else {
            this.btnNodeConfigurator.setEnabled(false);
        }
    }

    private void fireFirmwareUpdate() {
        LOGGER.info("Trigger the firmware update.");
        NodeListActionListener nodeListActionListener = (NodeListActionListener)DefaultApplicationContext.getInstance().get("mainNodeListActionListener", NodeListActionListener.class);
        if (nodeListActionListener != null) {
            nodeListActionListener.firmwareUpdate(this.mainModel.getSelectedNode());
        } else {
            LOGGER.warn("No nodeListAction listener available.");
        }
    }

    private void fireNodeScriptWizard() {
        LOGGER.info("Trigger the node script wizard.");
        this.context.publishEvent((Object)new MenuEvent(MenuEvent.Action.nodeScriptWizard));
    }

    private void fireNodeDocumentation() {
        LOGGER.info("Trigger the node documentation.");
        NodeListActionListener nodeListActionListener = (NodeListActionListener)DefaultApplicationContext.getInstance().get("mainNodeListActionListener", NodeListActionListener.class);
        if (nodeListActionListener != null) {
            nodeListActionListener.generateDocumentation(this.mainModel.getSelectedNode());
        } else {
            LOGGER.warn("No nodeListAction listener available.");
        }
    }
}

