/*
 * Decompiled with CFR 0.152.
 */
package org.bidib.wizard.mvc.nodedebug.controller;

import com.vlsolutions.swing.docking.Dockable;
import com.vlsolutions.swing.docking.DockableState;
import com.vlsolutions.swing.docking.DockingConstants;
import com.vlsolutions.swing.docking.DockingDesktop;
import com.vlsolutions.swing.docking.DockingUtilities;
import com.vlsolutions.swing.docking.RelativeDockablePosition;
import com.vlsolutions.swing.docking.TabbedDockableContainer;
import com.vlsolutions.swing.docking.event.DockableStateChangeListener;
import javax.annotation.PostConstruct;
import javax.swing.SwingUtilities;
import org.apache.commons.lang3.StringUtils;
import org.bidib.jbidibc.core.schema.bidiblabels.NodeLabels;
import org.bidib.jbidibc.messages.utils.ByteUtils;
import org.bidib.wizard.api.model.NodeInterface;
import org.bidib.wizard.api.model.event.DebugActionEvent;
import org.bidib.wizard.api.model.listener.NodeSelectionListener;
import org.bidib.wizard.api.service.console.ConsoleColor;
import org.bidib.wizard.client.common.view.BidibNodeNameUtils;
import org.bidib.wizard.client.common.view.DockKeys;
import org.bidib.wizard.client.common.view.DockUtils;
import org.bidib.wizard.common.context.DefaultApplicationContext;
import org.bidib.wizard.common.labels.WizardLabelWrapper;
import org.bidib.wizard.config.DebugConsoleControllerFactory;
import org.bidib.wizard.core.model.connection.ConnectionRegistry;
import org.bidib.wizard.core.service.node.DebugService;
import org.bidib.wizard.mvc.main.model.MainModel;
import org.bidib.wizard.mvc.nodedebug.model.DebugConsoleModel;
import org.bidib.wizard.mvc.nodedebug.view.DebugConsoleView;
import org.bidib.wizard.mvc.nodedebug.view.listener.DebugConsoleViewListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationContext;

/*
 * Exception performing whole class analysis ignored.
 */
public class DebugConsoleController {
    private static final Logger LOGGER = LoggerFactory.getLogger(DebugConsoleController.class);
    @Autowired
    private DockingDesktop desktop;
    private DockableStateChangeListener dockableStateChangeListener;
    private DebugConsoleView debugConsoleView;
    @Autowired
    private MainModel mainModel;
    @Autowired
    private DebugConsoleModel debugConsoleModel;
    @Autowired
    private ConnectionRegistry connectionRegistry;
    @Autowired
    private DebugService debugService;
    @Autowired
    private WizardLabelWrapper wizardLabelWrapper;

    @PostConstruct
    public void initialize() {
        this.debugService.getSubjectDebugEvents().subscribe(evt -> {
            LOGGER.debug("Received DebugActionEvent: {}", evt);
            SwingUtilities.invokeLater(() -> {
                DebugConsoleController.ensureConsoleVisible();
                this.publishToConsole(evt);
            });
        });
    }

    public void start() {
        String searchKey = "DebugConsoleView";
        LOGGER.info("Search for view with key: {}", (Object)searchKey);
        Dockable consoleView = this.desktop.getContext().getDockableByKey(searchKey);
        if (consoleView != null) {
            LOGGER.info("Select the existing console view.");
            DockUtils.selectWindow((Dockable)consoleView);
            return;
        }
        LOGGER.info("Create new DebugConsoleView.");
        this.debugConsoleModel.setSelectedNode(this.mainModel.getSelectedNode());
        this.debugConsoleView = new DebugConsoleView(this.debugConsoleModel);
        DockableState[] dockables = this.desktop.getDockables();
        LOGGER.info("Current dockables: {}", new Object[]{dockables});
        if (dockables.length > 1) {
            DockableState boosterTableView = null;
            for (DockableState dockable : dockables) {
                if (!DockKeys.DOCKKEY_BOOSTER_TABLE_VIEW.equals((Object)dockable.getDockable().getDockKey())) continue;
                LOGGER.info("Found the booster table view dockable.");
                boosterTableView = dockable;
                break;
            }
            Dockable dock = this.desktop.getDockables()[1].getDockable();
            if (boosterTableView != null) {
                LOGGER.info("Add the Debug console view to the booster table view panel.");
                dock = boosterTableView.getDockable();
                TabbedDockableContainer container = DockingUtilities.findTabbedDockableContainer((Dockable)dock);
                int order = 0;
                if (container != null) {
                    order = container.getTabCount();
                }
                LOGGER.info("Add new log panel at order: {}", (Object)order);
                this.desktop.createTab(dock, (Dockable)this.debugConsoleView, order, true);
            } else if (this.desktop.getDockables().length > 1) {
                this.desktop.split(dock, (Dockable)this.debugConsoleView, DockingConstants.SPLIT_BOTTOM);
                this.desktop.setDockableHeight((Dockable)this.debugConsoleView, 0.2);
            } else {
                this.desktop.split(dock, (Dockable)this.debugConsoleView, DockingConstants.SPLIT_RIGHT);
            }
        } else {
            this.desktop.addDockable((Dockable)this.debugConsoleView, RelativeDockablePosition.RIGHT);
        }
        this.dockableStateChangeListener = new /* Unavailable Anonymous Inner Class!! */;
        this.desktop.addDockableStateChangeListener(this.dockableStateChangeListener);
        this.debugConsoleView.addDebugConsoleViewListener((DebugConsoleViewListener)new /* Unavailable Anonymous Inner Class!! */);
        this.mainModel.addNodeSelectionListener((NodeSelectionListener)new /* Unavailable Anonymous Inner Class!! */);
    }

    public static synchronized void ensureConsoleVisible() {
        String searchKey = "DebugConsoleView";
        LOGGER.info("Search for view with key: {}", (Object)searchKey);
        DockingDesktop desktop = (DockingDesktop)DefaultApplicationContext.getInstance().get("desktop", DockingDesktop.class);
        Dockable consoleView = desktop.getContext().getDockableByKey(searchKey);
        if (consoleView != null) {
            LOGGER.info("Use the existing console view.");
            return;
        }
        LOGGER.info("Create new controller to open the console.");
        org.bidib.wizard.api.context.ApplicationContext applicationContext = DefaultApplicationContext.getInstance();
        ApplicationContext ctx = (ApplicationContext)applicationContext.get("SpringContext", ApplicationContext.class);
        DebugConsoleControllerFactory debugConsoleControllerFactory = (DebugConsoleControllerFactory)ctx.getBean(DebugConsoleControllerFactory.class);
        DebugConsoleController debugConsoleController = debugConsoleControllerFactory.createController();
        debugConsoleController.start();
    }

    protected void publishToConsole(DebugActionEvent evt) {
        int stringId = evt.getStringId();
        String nodeLabel = this.getNodeLabel(evt.getNode());
        String value = evt.getValue();
        ConsoleColor textColor = ConsoleColor.black;
        switch (stringId) {
            case 5: {
                textColor = ConsoleColor.gray;
                break;
            }
            case 4: {
                textColor = ConsoleColor.gray;
                break;
            }
            case 3: {
                textColor = ConsoleColor.blue;
                break;
            }
            case 1: 
            case 2: {
                textColor = ConsoleColor.red;
                break;
            }
        }
        this.debugConsoleModel.addConsoleLine(textColor, String.format("%s : %s - %d : %s", evt.getConnectionId(), nodeLabel, stringId, value));
    }

    private String getNodeLabel(NodeInterface node) {
        BidibNodeNameUtils.NodeLabelData labelData;
        String userName;
        NodeLabels nodeLabels = this.wizardLabelWrapper.loadLabels(Long.valueOf(node.getUniqueId()));
        if (nodeLabels != null && StringUtils.isNotBlank((CharSequence)(userName = (labelData = BidibNodeNameUtils.prepareLabel((NodeInterface)node, (NodeLabels)nodeLabels, (boolean)false, (boolean)false)).getNodeLabel()))) {
            return userName;
        }
        return ByteUtils.getUniqueIdAsString((long)node.getUniqueId());
    }
}

