/*
 * Decompiled with CFR 0.152.
 */
package org.bidib.wizard.mvc.ping.model;

import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.datatype.jsr310.JavaTimeModule;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.io.FileUtils;
import org.bidib.jbidibc.messages.utils.ByteUtils;
import org.bidib.wizard.mvc.ping.model.PingTableNodePreferenceEntry;
import org.bidib.wizard.mvc.ping.model.PingTablePreferences;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultPingTablePreferences
implements PingTablePreferences {
    private static final Logger LOGGER = LoggerFactory.getLogger(DefaultPingTablePreferences.class);
    private final transient ObjectMapper mapper;
    private final transient File pingTablePreferencesFile;
    private Map<Long, PingTableNodePreferenceEntry> preferencesMap = new HashMap();

    public DefaultPingTablePreferences(File pingTablePreferencesFile) {
        this.pingTablePreferencesFile = pingTablePreferencesFile;
        this.mapper = new ObjectMapper();
        this.mapper.registerModule((Module)new JavaTimeModule());
    }

    public void load() {
        this.preferencesMap.clear();
        try {
            PingTableNodePreferenceEntry[] entries;
            for (PingTableNodePreferenceEntry entry : entries = (PingTableNodePreferenceEntry[])this.mapper.readValue(this.pingTablePreferencesFile, PingTableNodePreferenceEntry[].class)) {
                this.preferencesMap.put(ByteUtils.parseHexUniqueId((String)entry.getUid()), entry);
            }
        }
        catch (FileNotFoundException ex) {
            LOGGER.warn("Load the preferences store failed because the file was not found: {}", (Object)ex.getMessage());
        }
        catch (IOException ex) {
            LOGGER.warn("Load the preferences store failed.", (Throwable)ex);
        }
        LOGGER.info("Current preferencesMap: {}", (Object)this.preferencesMap);
    }

    public void store() {
        LOGGER.info("Store the pairing store to file.");
        try {
            FileUtils.forceMkdirParent((File)this.pingTablePreferencesFile);
            this.mapper.writerWithDefaultPrettyPrinter().writeValue(this.pingTablePreferencesFile, (Object)this.preferencesMap.values().toArray(new PingTableNodePreferenceEntry[0]));
        }
        catch (IOException ex) {
            LOGGER.warn("Store preferences store failed.", (Throwable)ex);
        }
    }

    public void clear() {
        LOGGER.info("Clear the pairing store.");
        this.preferencesMap.clear();
    }

    public PingTableNodePreferenceEntry getPrefences(long uniqueId) {
        Long lookupValue = uniqueId;
        return (PingTableNodePreferenceEntry)this.preferencesMap.get(lookupValue);
    }

    public PingTableNodePreferenceEntry getPrefencesOrDefault(long uniqueId) {
        Long lookupValue = uniqueId;
        return this.preferencesMap.computeIfAbsent(lookupValue, uid -> new PingTableNodePreferenceEntry(ByteUtils.formatHexUniqueId((Long)uid)));
    }
}

