/*
 * Decompiled with CFR 0.152.
 */
package org.bidib.wizard.mvc.ping.model;

import com.jgoodies.binding.beans.Model;
import com.jgoodies.common.collect.ArrayListModel;
import java.beans.PropertyChangeListener;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import org.bidib.wizard.api.model.NodeInterface;
import org.bidib.wizard.mvc.ping.model.NodePingModel;
import org.bidib.wizard.mvc.ping.model.NodePingState;
import org.bidib.wizard.mvc.ping.model.PingTableNodePreferenceEntry;
import org.bidib.wizard.mvc.ping.model.PingTablePreferences;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PingTableModel
extends Model {
    private static final long serialVersionUID = 1L;
    private static final Logger LOGGER = LoggerFactory.getLogger(PingTableModel.class);
    public static final String PROPERTY_NODES = "nodes";
    public static final String PROPERTY_NODE_PING_STATUS = "nodePingStatus";
    private ArrayListModel<NodePingModel> nodeList = new ArrayListModel();
    private final PropertyChangeListener pclNodePingModel;
    private int defaultPingInterval = 200;
    private final PingTablePreferences pingTablePreferences;

    public PingTableModel(PingTablePreferences pingTablePreferences) {
        this.pingTablePreferences = pingTablePreferences;
        this.pclNodePingModel = new /* Unavailable Anonymous Inner Class!! */;
    }

    public void setDefaultPingInterval(int pingInterval) {
        LOGGER.info("Set the defaultPingInterval: {}", (Object)pingInterval);
        this.defaultPingInterval = pingInterval;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addNode(NodeInterface node) {
        ArrayListModel arrayListModel = this.nodeList;
        synchronized (arrayListModel) {
            NodePingModel nodePingModel = new NodePingModel(node);
            if (!this.nodeList.contains((Object)nodePingModel)) {
                LOGGER.info("Add node to ping node list: {}", (Object)node);
                nodePingModel.registerNode();
                nodePingModel.setPingInterval(Integer.valueOf(this.defaultPingInterval));
                nodePingModel.setLastPing(System.currentTimeMillis());
                nodePingModel.setNodePingState(NodePingState.OFF);
                String nodeLabel = nodePingModel.prepareNodeLabel();
                nodePingModel.setNodeLabel(nodeLabel);
                PingTableNodePreferenceEntry prefs = this.pingTablePreferences.getPrefences(node.getUniqueId());
                if (prefs != null) {
                    nodePingModel.setPingInterval(Integer.valueOf(prefs.getPingInterval()));
                    nodePingModel.setAdditionalFillBytesCount(prefs.getAdditionalFillBytesCount());
                    nodePingModel.setAdditionalTotalBytesCount(prefs.getAdditionalTotalBytesCount());
                }
                LinkedList oldValue = new LinkedList(this.nodeList);
                this.nodeList.add((Object)nodePingModel);
                this.firePropertyChange(PROPERTY_NODES, oldValue, (Object)this.nodeList);
                nodePingModel.addPropertyChangeListener(this.pclNodePingModel);
            } else {
                LOGGER.warn("Node is already in ping node list: {}", (Object)node);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeNode(NodeInterface node) {
        ArrayListModel arrayListModel = this.nodeList;
        synchronized (arrayListModel) {
            LOGGER.info("Remove node from ping node list: {}", (Object)node);
            LinkedList oldValue = new LinkedList(this.nodeList);
            int index = this.nodeList.indexOf((Object)new NodePingModel(node));
            if (index > -1) {
                NodePingModel removed = (NodePingModel)this.nodeList.remove(index);
                LOGGER.info("Removed node: {}", (Object)removed);
                removed.removePropertyChangeListener(this.pclNodePingModel);
                if (removed != null) {
                    removed.freeNode();
                }
                this.firePropertyChange(PROPERTY_NODES, oldValue, (Object)this.nodeList);
            }
        }
    }

    public ArrayListModel<NodePingModel> getNodeListModel() {
        return this.nodeList;
    }

    public List<NodePingModel> getNodes() {
        return Collections.unmodifiableList(this.nodeList);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setNodePingState(NodeInterface node, NodePingState nodePingState) {
        ArrayListModel arrayListModel = this.nodeList;
        synchronized (arrayListModel) {
            NodePingModel nodePingModel;
            int index = this.nodeList.indexOf((Object)new NodePingModel(node));
            if (index > -1 && (nodePingModel = (NodePingModel)this.nodeList.get(index)) != null) {
                nodePingModel.setNodePingState(nodePingState);
            }
        }
    }

    public void setPongMarker(byte[] address, int marker) {
    }

    static /* synthetic */ void access$000(PingTableModel x0, String x1, Object x2, Object x3) {
        x0.firePropertyChange(x1, x2, x3);
    }
}

