/*
 * Decompiled with CFR 0.152.
 */
package org.bidib.wizard.mvc.preferences.model;

import com.jgoodies.binding.beans.Model;
import com.jgoodies.common.collect.ArrayListModel;
import java.time.DayOfWeek;
import java.util.LinkedHashSet;
import java.util.Set;
import org.apache.commons.lang3.SystemUtils;
import org.bidib.jbidibc.netbidib.pairingstore.PairingStore;
import org.bidib.wizard.api.model.common.CommPort;
import org.bidib.wizard.api.model.common.NetBidibServiceInfo;
import org.bidib.wizard.common.model.settings.ExperimentalSettingsInterface;
import org.bidib.wizard.common.model.settings.GlobalSettingsInterface;
import org.bidib.wizard.common.model.settings.Misc2SettingsInterface;
import org.bidib.wizard.common.model.settings.MiscSettingsInterface;
import org.bidib.wizard.common.model.settings.NetBidibSettingsInterface;
import org.bidib.wizard.common.model.settings.WizardSettingsInterface;

public class PreferencesModel
extends Model {
    private static final long serialVersionUID = 1L;
    public static final String PROPERTY_COMM_PORTS = "commPorts";
    public static final String PROPERTY_DETECTED_NETBIDIB_SERVICES = "detectedNetBidibServices";
    private final Set<CommPort> commPorts = new LinkedHashSet();
    private ArrayListModel<String> serialProviderList = new ArrayListModel();
    private ArrayListModel<DayOfWeek> dayOfWeekList = new ArrayListModel();
    private ArrayListModel<String> languageList = new ArrayListModel();
    private final Set<NetBidibServiceInfo> detectedNetBidibServices = new LinkedHashSet();
    private final GlobalSettingsInterface globalSettings;
    private final WizardSettingsInterface wizardSettings;
    private final MiscSettingsInterface miscSettings;
    private final Misc2SettingsInterface misc2Settings;
    private final ExperimentalSettingsInterface experimentalSettings;
    private final NetBidibSettingsInterface netBidibSettings;
    private final PairingStore pairingStore;

    public PreferencesModel(GlobalSettingsInterface globalSettings, WizardSettingsInterface wizardSettings, MiscSettingsInterface miscSettings, Misc2SettingsInterface misc2Settings, ExperimentalSettingsInterface experimentalSettings, NetBidibSettingsInterface netBidibSettings, PairingStore pairingStore) {
        this.serialProviderList.add((Object)"RXTX");
        this.serialProviderList.add((Object)"SCM");
        this.serialProviderList.add((Object)"SPSW");
        this.serialProviderList.add((Object)"JSerialComm");
        this.serialProviderList.add((Object)"PureJavaComm");
        if (SystemUtils.IS_OS_WINDOWS || SystemUtils.IS_OS_LINUX || SystemUtils.IS_OS_MAC_OSX) {
            this.serialProviderList.add((Object)"FTDI");
        }
        this.dayOfWeekList.add((Object)DayOfWeek.SUNDAY);
        this.dayOfWeekList.add((Object)DayOfWeek.MONDAY);
        this.dayOfWeekList.add((Object)DayOfWeek.TUESDAY);
        this.dayOfWeekList.add((Object)DayOfWeek.WEDNESDAY);
        this.dayOfWeekList.add((Object)DayOfWeek.THURSDAY);
        this.dayOfWeekList.add((Object)DayOfWeek.FRIDAY);
        this.dayOfWeekList.add((Object)DayOfWeek.SATURDAY);
        this.languageList.add((Object)"de");
        this.languageList.add((Object)"en");
        this.languageList.add((Object)"nl");
        this.globalSettings = globalSettings;
        this.wizardSettings = wizardSettings;
        this.miscSettings = miscSettings;
        this.misc2Settings = misc2Settings;
        this.experimentalSettings = experimentalSettings;
        this.netBidibSettings = netBidibSettings;
        this.pairingStore = pairingStore;
    }

    public Set<CommPort> getAvailableCommPorts() {
        return this.commPorts;
    }

    public void setAvailableCommPorts(Set<CommPort> commPorts) {
        LinkedHashSet oldValue = new LinkedHashSet();
        oldValue.addAll(this.commPorts);
        this.commPorts.clear();
        this.commPorts.addAll(commPorts);
        this.firePropertyChange(PROPERTY_COMM_PORTS, oldValue, (Object)this.commPorts);
    }

    public void setDetectedNetBidibServices(Set<NetBidibServiceInfo> detectedNetBidibServices) {
        LinkedHashSet oldValue = new LinkedHashSet();
        oldValue.addAll(this.detectedNetBidibServices);
        this.detectedNetBidibServices.clear();
        this.detectedNetBidibServices.addAll(detectedNetBidibServices);
        this.firePropertyChange(PROPERTY_DETECTED_NETBIDIB_SERVICES, oldValue, (Object)this.detectedNetBidibServices);
    }

    public Set<NetBidibServiceInfo> getDetectedNetBidibServices() {
        return this.detectedNetBidibServices;
    }

    public ArrayListModel<String> getSerialProviderList() {
        return this.serialProviderList;
    }

    public ArrayListModel<DayOfWeek> getDayOfWeekList() {
        return this.dayOfWeekList;
    }

    public ArrayListModel<String> getLanguageList() {
        return this.languageList;
    }

    public GlobalSettingsInterface getGlobalSettings() {
        return this.globalSettings;
    }

    public WizardSettingsInterface getWizardSettings() {
        return this.wizardSettings;
    }

    public MiscSettingsInterface getMiscSettings() {
        return this.miscSettings;
    }

    public Misc2SettingsInterface getMisc2Settings() {
        return this.misc2Settings;
    }

    public ExperimentalSettingsInterface getExperimentalSettings() {
        return this.experimentalSettings;
    }

    public NetBidibSettingsInterface getNetBidibSettings() {
        return this.netBidibSettings;
    }

    public PairingStore getPairingStore() {
        return this.pairingStore;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("PreferencesModel, commPorts: ").append(this.commPorts);
        return sb.toString();
    }
}

