/*
 * Decompiled with CFR 0.152.
 */
package org.bidib.wizard.mvc.pt.view.command;

import org.bidib.jbidibc.messages.enums.AddressMode;
import org.bidib.jbidibc.messages.enums.PtOperation;
import org.bidib.wizard.mvc.pt.view.command.PtOperationIfElseCommand;
import org.bidib.wizard.mvc.pt.view.panel.AddressProgBeanModel;
import org.bidib.wizard.mvc.pt.view.panel.ProgCommandAwareBeanModel;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PtAddressModeCommand
extends PtOperationIfElseCommand<AddressProgBeanModel> {
    private static final Logger LOGGER = LoggerFactory.getLogger(PtAddressModeCommand.class);
    private AddressMode addressMode;

    public PtAddressModeCommand(PtOperation ptOperation, int cvNumber, int cvValue) {
        super(ptOperation, cvNumber, cvValue);
    }

    public void setCvValueResult(Integer cvValueResult) {
        super.setCvValueResult(cvValueResult);
        if (cvValueResult != null) {
            this.setAddressMode(AddressMode.valueOf((int)cvValueResult));
        }
    }

    public void setAddressMode(AddressMode addressMode) {
        this.addressMode = addressMode;
    }

    public AddressMode getAddressMode() {
        return this.addressMode;
    }

    public void postExecute(AddressProgBeanModel addressProgBeanModel) {
        super.postExecute((ProgCommandAwareBeanModel)addressProgBeanModel);
        if (this.addressMode != null) {
            LOGGER.debug("Set the addressMode: {}", (Object)this.addressMode);
            addressProgBeanModel.setAddressMode(this.addressMode);
        }
    }

    public boolean isExpectedResult() {
        try {
            LOGGER.info("isExpectedResult, compare values, expected: {}, received: {}", (Object)this.getCvValue(), (Object)this.getCvValueResult());
            return this.getCvValue() == this.getCvValueResult().intValue();
        }
        catch (Exception ex) {
            LOGGER.warn("Compare expected and result cv value failed.", (Throwable)ex);
            return false;
        }
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(this.getClass().getSimpleName());
        sb.append(", ").append(super.toString());
        sb.append(",addressMode=").append(this.addressMode);
        return sb.toString();
    }
}

