/*
 * Decompiled with CFR 0.152.
 */
package org.bidib.wizard.mvc.stepcontrol.controller;

import com.jgoodies.common.collect.ArrayListModel;
import java.awt.Component;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import org.bidib.jbidibc.messages.AccessoryState;
import org.bidib.jbidibc.messages.AccessoryStateOptions;
import org.bidib.jbidibc.messages.accessory.ByteOptionsValue;
import org.bidib.jbidibc.messages.accessory.OptionsValue;
import org.bidib.jbidibc.messages.enums.AccessoryExecutionState;
import org.bidib.jbidibc.messages.enums.AccessoryStateOptionsKeys;
import org.bidib.jbidibc.messages.utils.ThreadFactoryBuilder;
import org.bidib.wizard.api.model.Accessory;
import org.bidib.wizard.api.model.NodeInterface;
import org.bidib.wizard.api.model.listener.AccessoryListListener;
import org.bidib.wizard.api.model.listener.AccessoryListener;
import org.bidib.wizard.api.model.listener.CvDefinitionListener;
import org.bidib.wizard.api.model.listener.NodeListListener;
import org.bidib.wizard.api.model.listener.PortListListener;
import org.bidib.wizard.api.service.node.SwitchingNodeService;
import org.bidib.wizard.client.common.controller.FeedbackPortStatusChangeProvider;
import org.bidib.wizard.client.common.uils.SwingUtils;
import org.bidib.wizard.client.common.view.DefaultBusyFrame;
import org.bidib.wizard.client.common.view.listener.TabStatusListener;
import org.bidib.wizard.client.common.view.statusbar.StatusBar;
import org.bidib.wizard.common.service.SettingsService;
import org.bidib.wizard.model.ports.MotorPort;
import org.bidib.wizard.model.ports.Port;
import org.bidib.wizard.model.ports.SoundPort;
import org.bidib.wizard.model.status.BidibStatus;
import org.bidib.wizard.model.status.SoundPortStatus;
import org.bidib.wizard.mvc.main.model.MainModel;
import org.bidib.wizard.mvc.stepcontrol.controller.StepControlController;
import org.bidib.wizard.mvc.stepcontrol.controller.StepControlControllerInterface;
import org.bidib.wizard.mvc.stepcontrol.model.AspectReference;
import org.bidib.wizard.mvc.stepcontrol.model.StepControlAspect;
import org.bidib.wizard.mvc.stepcontrol.model.StepControlModel;
import org.bidib.wizard.mvc.stepcontrol.model.TurnTableType;
import org.bidib.wizard.mvc.stepcontrol.view.InvalidAspectException;
import org.bidib.wizard.mvc.stepcontrol.view.StepControlPanel;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

public class StepControlController
implements CvDefinitionListener,
StepControlControllerInterface,
PortListListener {
    private static final Logger LOGGER = LoggerFactory.getLogger(StepControlController.class);
    private StepControlPanel stepControlPanel;
    private final StepControlModel stepControlModel;
    private final MainModel mainModel;
    private final FeedbackPortStatusChangeProvider feedbackPortStatusChangeProvider;
    private final AccessoryListener accessoryListener;
    private final AccessoryListListener accessoryListListener;
    private NodeInterface controlledNode;
    private Accessory controlledAccessory;
    private Accessory operationalAccessory;
    private Accessory soundAccessory;
    private final ScheduledExecutorService accessoryStateWorkers = Executors.newScheduledThreadPool(1, new ThreadFactoryBuilder().setNameFormat("accessoryStateWorkers-thread-%d").build());
    @Autowired
    private SwitchingNodeService switchingService;
    @Autowired
    private SettingsService settingsService;
    private final StatusBar statusBar;
    private final org.bidib.jbidibc.messages.logger.Logger accessoryStateOptionsLogger;
    private ScheduledFuture<?> taskFuture;

    public StepControlController(MainModel mainModel, FeedbackPortStatusChangeProvider feedbackPortStatusChangeProvider, StatusBar statusBar) {
        this.mainModel = mainModel;
        this.feedbackPortStatusChangeProvider = feedbackPortStatusChangeProvider;
        this.statusBar = statusBar;
        this.stepControlModel = new StepControlModel();
        this.stepControlModel.setMaxConfiguredAspects(48);
        this.accessoryStateOptionsLogger = new /* Unavailable Anonymous Inner Class!! */;
        this.accessoryListener = new /* Unavailable Anonymous Inner Class!! */;
        this.accessoryListListener = new /* Unavailable Anonymous Inner Class!! */;
    }

    public void start(TabStatusListener tabStatusListener) {
        LOGGER.info("Use changeProvider: {}", (Object)this.feedbackPortStatusChangeProvider);
        this.stepControlPanel = new StepControlPanel(this.mainModel, this.stepControlModel, this.settingsService, tabStatusListener, this.feedbackPortStatusChangeProvider, (StepControlControllerInterface)this, this.statusBar);
        this.stepControlPanel.createComponent();
        4 motorPortListListener = new /* Unavailable Anonymous Inner Class!! */;
        5 soundPortListListener = new /* Unavailable Anonymous Inner Class!! */;
        this.mainModel.addNodeListListener((NodeListListener)new /* Unavailable Anonymous Inner Class!! */);
    }

    public StepControlPanel getComponent() {
        return this.stepControlPanel;
    }

    public void triggerLoadCvValues() {
        LOGGER.info("Load the CV for the StepControl.");
        if (this.stepControlPanel != null) {
            LOGGER.info("Let the stepControlPanel initiate loading the CV values: {}", (Object)this.stepControlPanel);
            this.stepControlPanel.triggerLoadCvValues();
        }
    }

    public void cvDefinitionChanged() {
        LOGGER.info("The CV definition has changed.");
    }

    public void cvDefinitionValuesChanged(boolean read, List<String> changedNames) {
        LOGGER.info("The CV definition values have changed, read: {}, changedNames: {}", (Object)read, changedNames);
        if (this.stepControlPanel != null) {
            LOGGER.info("Notify the stepControl panel of the changed CV defintion values: {}", (Object)this.stepControlPanel);
            SwingUtils.executeInEDT(() -> this.stepControlPanel.cvDefinitionValuesChanged(read, changedNames));
        }
    }

    public ArrayListModel<StepControlAspect> getConfigureAspectsListModel() {
        LinkedList<StepControlAspect> aspects = new LinkedList<StepControlAspect>();
        aspects.addAll(this.stepControlModel.getStepControlAspects());
        if (TurnTableType.round == this.stepControlModel.getTurnTableType()) {
            int totalSteps = this.stepControlModel.getTotalSteps() != null ? this.stepControlModel.getTotalSteps().intValue() : 0;
            int currentAspectIndex = 0;
            for (StepControlAspect currentAspect : this.stepControlModel.getStepControlAspects()) {
                StepControlAspect aspectOpposite;
                LOGGER.info("Prepare aspect opposite to save from aspect: {}", (Object)currentAspect);
                if (currentAspect.getOppositeAspect() != null) {
                    aspectOpposite = (StepControlAspect)currentAspect.getOppositeAspect();
                    aspectOpposite.setPosition(currentAspect.getOppositePosition());
                    aspectOpposite.setPolarity(currentAspect.getOppositePolarity());
                    if (!aspectOpposite.isValid()) {
                        LOGGER.warn("The opposite aspect is not valid: {}", (Object)aspectOpposite);
                        throw new InvalidAspectException("The opposite aspect is not valid: " + aspectOpposite, currentAspectIndex);
                    }
                    LOGGER.info("Prepared the aspect opposite to save: {}", (Object)aspectOpposite);
                    aspects.add(aspectOpposite);
                    if (currentAspect.getPosition() >= (long)(totalSteps / 2)) {
                        throw new InvalidAspectException("The aspect is not valid: " + currentAspect, currentAspectIndex);
                    }
                    if (aspectOpposite.getPosition() >= (long)totalSteps) {
                        throw new InvalidAspectException("The aspect is not valid: " + aspectOpposite, currentAspectIndex);
                    }
                } else {
                    LOGGER.warn("The opposite aspect is not available for aspect: {}", (Object)currentAspect);
                    aspectOpposite = new StepControlAspect(null, currentAspect.getOppositePosition(), currentAspect.getOppositePolarity());
                    if (!aspectOpposite.isValid()) {
                        LOGGER.warn("The opposite aspect is not valid: {}", (Object)aspectOpposite);
                        throw new InvalidAspectException("The opposite aspect is not valid: " + aspectOpposite, currentAspectIndex);
                    }
                    currentAspect.setOppositeAspect((AspectReference)aspectOpposite);
                    LOGGER.info("Prepared the aspect opposite to save: {}", (Object)aspectOpposite);
                    aspects.add(aspectOpposite);
                    if (currentAspect.getPosition() >= (long)(totalSteps / 2)) {
                        throw new InvalidAspectException("The aspect is not valid: " + currentAspect, currentAspectIndex);
                    }
                    if (aspectOpposite.getPosition() >= (long)totalSteps) {
                        throw new InvalidAspectException("The aspect is not valid: " + aspectOpposite, currentAspectIndex);
                    }
                }
                ++currentAspectIndex;
            }
        }
        Collections.sort(aspects, new /* Unavailable Anonymous Inner Class!! */);
        ArrayListModel arrayListModel = new ArrayListModel();
        arrayListModel.addAll(aspects);
        return arrayListModel;
    }

    public NodeInterface getSelectedNode() {
        return this.mainModel.getSelectedNode();
    }

    public void scheduleAccessoryStateCheck() {
        Integer pushInterval = this.stepControlModel.getPushInterval();
        if (pushInterval != null && pushInterval > 0) {
            LOGGER.info("The updates of the accessory state are delivered via push notification.");
            return;
        }
        this.taskFuture = this.accessoryStateWorkers.schedule(() -> {
            try {
                LOGGER.info("Check the state of the controlledAccessory: {}", (Object)this.controlledAccessory);
                this.taskFuture = null;
                if (this.controlledNode != null) {
                    this.switchingService.queryAccessoryState("main", this.controlledNode.getSwitchingNode(), Arrays.asList(this.controlledAccessory));
                }
            }
            catch (Exception ex) {
                LOGGER.warn("Check the state of the controlledAccessory failed for bidibNode: {}", (Object)this.controlledNode, (Object)ex);
            }
        }, 250L, TimeUnit.MILLISECONDS);
    }

    private void cancelScheduleAccessoryStateCheck() {
        LOGGER.info("Cancel the accessory state check.");
        try {
            if (this.taskFuture != null) {
                this.taskFuture.cancel(true);
                this.taskFuture = null;
            }
        }
        catch (Exception ex) {
            LOGGER.warn("Stop scheduled task failed.", (Throwable)ex);
        }
    }

    public void setMotorPortValue(MotorPort motorPort) {
        LOGGER.info("Set the motor port value: {}", (Object)motorPort);
        this.switchingService.setPortStatus("main", this.controlledNode.getSwitchingNode(), (Port)motorPort);
    }

    public Class<?> getPortClass() {
        return MotorPort.class;
    }

    public void triggerSoundPort(int portId, SoundPortStatus soundPortStatus) {
        LOGGER.info("Activate the sound port value: {}, soundPortStatus: {}", (Object)portId, (Object)soundPortStatus);
        SoundPort soundPort = new SoundPort();
        soundPort.setId(portId);
        soundPort.setStatus((BidibStatus)soundPortStatus);
        this.switchingService.setPortStatus("main", this.controlledNode.getSwitchingNode(), (Port)soundPort);
    }

    public void listChanged() {
    }

    public void refreshPorts() {
    }

    public void setSoundActive(boolean soundActive) {
        LOGGER.info("Activate the sound accessory, soundActive: {}", (Object)soundActive);
        if (this.controlledNode != null) {
            try {
                DefaultBusyFrame.setWaitCursor((Component)this.stepControlPanel.getComponent());
                Accessory accessory = new Accessory();
                accessory.setId(Integer.valueOf(2));
                this.switchingService.setAccessoryAspect("main", this.controlledNode.getSwitchingNode(), accessory, soundActive ? 2 : 0);
            }
            finally {
                DefaultBusyFrame.setDefaultCursor((Component)this.stepControlPanel.getComponent());
            }
        } else {
            LOGGER.warn("Activate the sound accessory is skipped. The controlled node is not avaialable.");
        }
    }

    public void activateAspect(Accessory accessory, int aspectNumber) {
        LOGGER.info("Start accessory with aspect: {}, accessory: {}", (Object)aspectNumber, (Object)accessory);
        try {
            DefaultBusyFrame.setWaitCursor((Component)this.stepControlPanel.getComponent());
            this.switchingService.setAccessoryAspect("main", this.getSelectedNode().getSwitchingNode(), accessory, aspectNumber);
        }
        finally {
            DefaultBusyFrame.setDefaultCursor((Component)this.stepControlPanel.getComponent());
        }
    }

    public void storeAccessory(Accessory accessory) {
        LOGGER.info("Store the accessory: {}", (Object)accessory);
        try {
            DefaultBusyFrame.setWaitCursor((Component)this.stepControlPanel.getComponent());
            this.switchingService.saveAccessory("main", this.getSelectedNode().getSwitchingNode(), accessory);
        }
        finally {
            DefaultBusyFrame.setDefaultCursor((Component)this.stepControlPanel.getComponent());
        }
    }

    private void updateAnimation(Integer accessoryId, Integer aspect, boolean emergencyStop) {
        AccessoryStateOptions.Options stateOptions;
        AccessoryState state = this.controlledAccessory.getAccessoryState();
        AccessoryStateOptions options = this.controlledAccessory.getAccessoryStateOptions();
        AccessoryExecutionState executionState = this.controlledAccessory.getAccessoryExecutionState();
        LOGGER.info("Current accessory state: {},  options: {}, executionState: {}", new Object[]{state, options, executionState});
        this.stepControlPanel.executionStateChanged(executionState, accessoryId, aspect, state);
        if (options != null && (stateOptions = options.getOptions(this.accessoryStateOptionsLogger)) != null) {
            try {
                Integer currentAngle = null;
                OptionsValue optionsValue = (OptionsValue)stateOptions.getOptionsValue(AccessoryStateOptionsKeys.STATE_OPTION_CURRENT_ANGLE);
                if (optionsValue != null) {
                    currentAngle = ByteOptionsValue.getIntValue((OptionsValue)optionsValue);
                    double currentDegrees = 1.5 * (double)currentAngle.intValue();
                    LOGGER.info("Current angle: {}, degrees: {}", (Object)currentAngle, (Object)currentDegrees);
                    if (this.stepControlModel != null) {
                        this.stepControlModel.setTurntableCurrentDegrees(currentDegrees);
                    }
                    this.stepControlPanel.setTurntableDegrees(currentDegrees);
                }
                if ((optionsValue = (OptionsValue)stateOptions.getOptionsValue(AccessoryStateOptionsKeys.STATE_OPTION_TARGET_ANGLE)) != null) {
                    int targetAngle = ByteOptionsValue.getIntValue((OptionsValue)optionsValue);
                    double targetDegrees = 1.5 * (double)targetAngle;
                    LOGGER.info("Target angle: {}, degrees: {}, currentAngle: {}, emergencyStop: {}", new Object[]{targetAngle, targetDegrees, currentAngle, emergencyStop});
                    if (this.stepControlModel != null) {
                        this.stepControlModel.setTurntableTargetDegrees(targetDegrees);
                    }
                    if (currentAngle != null && !emergencyStop && executionState == AccessoryExecutionState.RUNNING) {
                        if (targetAngle != currentAngle) {
                            LOGGER.info("targetAngle != currentAngle, start the scheduler.");
                            this.scheduleAccessoryStateCheck();
                        } else if (executionState == AccessoryExecutionState.RUNNING) {
                            LOGGER.info("executionState is running, start the scheduler.");
                            this.scheduleAccessoryStateCheck();
                        }
                    } else {
                        LOGGER.info("The execution state is no longer running! Current executionState: {}", (Object)executionState);
                        this.cancelScheduleAccessoryStateCheck();
                    }
                }
            }
            catch (Exception ex) {
                LOGGER.warn("Get the current turntable angle failed.", (Throwable)ex);
            }
        }
    }

    private void processOperationalAccessory(Integer aspect) {
        block10: {
            block9: {
                if (aspect == null) break block9;
                switch (aspect) {
                    case 1: {
                        if (this.stepControlModel != null) {
                            StepControlModel.OperationModeEnum oldOpMode = this.stepControlModel.getOperationalMode();
                            LOGGER.info("Set the step control operational mode, oldOpMode: {}, newMode: {}", (Object)oldOpMode, (Object)StepControlModel.OperationModeEnum.operational);
                            this.stepControlModel.setOperationalMode(StepControlModel.OperationModeEnum.operational);
                            if (this.controlledNode != null && this.operationalAccessory != null && this.controlledAccessory != null && oldOpMode != StepControlModel.OperationModeEnum.operational) {
                                LOGGER.info("Query the controlled accessory state.");
                                this.switchingService.queryAccessoryState("main", this.controlledNode.getSwitchingNode(), Arrays.asList(this.controlledAccessory));
                                break;
                            }
                            LOGGER.info("Do not query the controlled accessory state.");
                            break;
                        }
                        break block10;
                    }
                    case 2: {
                        if (this.stepControlModel != null) {
                            LOGGER.info("Set the step control to homing mode.");
                            this.stepControlModel.setOperationalMode(StepControlModel.OperationModeEnum.homingInProgress);
                            break;
                        }
                        break block10;
                    }
                    default: {
                        if (this.stepControlModel != null) {
                            LOGGER.info("Set the step control to non-operational mode.");
                            this.stepControlModel.setOperationalMode(StepControlModel.OperationModeEnum.emergencyStop);
                            break;
                        }
                        break block10;
                    }
                }
                break block10;
            }
            if (this.stepControlModel != null) {
                LOGGER.info("Set the step control to non-operational mode.");
                this.stepControlModel.setOperationalMode(StepControlModel.OperationModeEnum.emergencyStop);
            }
        }
    }
}

