package org.bidib.wizard.config;

import org.bidib.wizard.client.common.boot.SwingCommandLineRunner;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.annotation.Order;
import org.springframework.stereotype.Component;

@Component
@Order(10)
public class InitClientControllerCmdLineRunner implements SwingCommandLineRunner {

    private static final Logger LOGGER = LoggerFactory.getLogger(InitClientControllerCmdLineRunner.class);

    @Autowired
    private DebugConsoleControllerFactory debugConsoleControllerFactory;

    @Override
    public void run(String... args) throws Exception {
        LOGGER.info("Run the InitClientControllerCmdLineRunner to create the DebugConsoleController.");
        debugConsoleControllerFactory.createController();

    }

}
