package org.bidib.wizard.mvc.common.view.icon;

import java.awt.Dimension;

import javax.swing.JLabel;

public class RotateLabel extends JLabel {

    private static final long serialVersionUID = 1L;

    private final Dimension size;

    public RotateLabel(final AnimatedIcon icon) {
        size = new Dimension(icon.getIconHeight(), icon.getIconHeight());
        setIcon(icon);
    }

    @Override
    public Dimension getMinimumSize() {
        return size;
    }

    @Override
    public Dimension getMaximumSize() {
        return size;
    }

    @Override
    public Dimension getPreferredSize() {
        return size;
    }
}
