package org.bidib.wizard.mvc.features.controller.listener;

import org.bidib.jbidibc.messages.Feature;
import org.bidib.wizard.api.model.NodeInterface;

public interface FeaturesControllerListener {

    /**
     * Read all features of the specified node.
     * 
     * @param node
     *            the node
     */
    void readAll(NodeInterface node);

    /**
     * Write feature to node.
     * 
     * @param node
     *            the node
     * @param feature
     *            the feature
     */
    void write(NodeInterface node, Feature feature);

    /**
     * Close the controller
     */
    void close();
}
