package org.bidib.wizard.mvc.loco.view.listener;

import java.util.concurrent.atomic.AtomicBoolean;

public interface MeasurementViewListener {

    /**
     * Start the measurement.
     * 
     * @param continueMeasurementHolder
     *            the continue measurement flag holder. If the measurement should be stopped, the value is set to
     *            {@code false}.
     * @param callback
     *            the progress callback
     */
    void startMeasurement(AtomicBoolean continueMeasurementHolder, ProgressStatusCallback callback);

    /**
     * Stop the measurement.
     * 
     * @param continueMeasurementHolder
     *            the continue measurement flag holder. If the measurement should be stopped, the value is set to
     *            {@code false}.
     * @param callback
     *            the progress callback
     */
    void stopMeasurement(AtomicBoolean continueMeasurementHolder, ProgressStatusCallback callback);
}
