package org.bidib.wizard.mvc.main.controller;

import java.util.Map;

import org.bidib.jbidibc.exchange.vendorcv.VendorCvData;
import org.bidib.wizard.api.model.NodeInterface;
import org.bidib.wizard.api.model.listener.DefaultNodeListListener;
import org.bidib.wizard.client.common.controller.FeedbackPortStatusChangeProvider;
import org.bidib.wizard.client.common.view.cvdef.CvContainer;
import org.bidib.wizard.client.common.view.cvdef.CvDefinitionTreeModelRegistry;
import org.bidib.wizard.client.common.view.cvdef.CvDefinitionTreeTableModel;
import org.bidib.wizard.client.common.view.cvdef.CvNode;
import org.bidib.wizard.mvc.main.model.MainModel;
import org.bidib.wizard.mvc.main.view.panel.ReverserPanel;
import org.bidib.wizard.mvc.main.view.panel.listener.TabStatusListener;
import org.bidib.wizard.mvc.main.view.panel.listener.TabVisibilityListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

public class ReverserPanelController {

    private static final Logger LOGGER = LoggerFactory.getLogger(ReverserPanelController.class);

    private final MainModel mainModel;

    private final TabVisibilityListener tabVisibilityListener;

    private ReverserPanel reverserPanel;

    @Autowired
    private CvDefinitionTreeModelRegistry cvDefinitionTreeModelRegistry;

    private final FeedbackPortStatusChangeProvider feedbackPortStatusChangeProvider;

    public ReverserPanelController(final MainModel mainModel,
        final FeedbackPortStatusChangeProvider feedbackPortStatusChangeProvider,
        final TabVisibilityListener tabVisibilityListener) {
        this.mainModel = mainModel;
        this.tabVisibilityListener = tabVisibilityListener;
        this.feedbackPortStatusChangeProvider = feedbackPortStatusChangeProvider;
    }

    public void start(final TabStatusListener tabStatusListener) {

        reverserPanel =
            new ReverserPanel(this, this.feedbackPortStatusChangeProvider, this.mainModel, tabStatusListener);

        // add the node list listener

        mainModel.addNodeListListener(new DefaultNodeListListener() {

            @Override
            public void nodeChanged(final NodeInterface node) {

                final NodeInterface selectedNode = mainModel.getSelectedNode();
                LOGGER.info("The selected node has changed: {}", selectedNode);

                if (selectedNode == null) {
                    LOGGER.info("Reset the pending changes in the cvDefintionPanel.");

                    // TODO
                    // reverserPanel.resetPendingChanges();
                }
            }

        });

    }

    public ReverserPanel getReverserPanel() {

        return reverserPanel;
    }

    public Map<String, CvNode> getCvNumberToNodeMap(final NodeInterface node) {
        LOGGER.info("Get the cvNumberToNodeMap for node: {}", node);
        long uniqueId = node.getUniqueId();
        CvContainer cvContainer = cvDefinitionTreeModelRegistry.getCvContainer(uniqueId);
        if (cvContainer != null) {
            return cvContainer.getCvNumberToNodeMap();
        }
        return null;
    }

    public CvDefinitionTreeTableModel getCvDefinitionTreeTableModel(final NodeInterface node) {
        LOGGER.info("Get the cvDefinitionTreeTableModel for node: {}", node);
        long uniqueId = node.getUniqueId();

        CvContainer cvContainer = null;
        synchronized (cvDefinitionTreeModelRegistry) {

            cvContainer = cvDefinitionTreeModelRegistry.getCvContainer(uniqueId);

            if (cvContainer == null) {
                if (node.getVendorCV() != null) {
                    LOGGER
                        .info("No cvContainer found but vendorCV available. Prepare the vendorCV tree for node: {}",
                            node);
                    final VendorCvData vendorCV = node.getVendorCV();
                    cvDefinitionTreeModelRegistry.prepareVendorCVTree(node, vendorCV, false);

                    cvContainer = cvDefinitionTreeModelRegistry.getCvContainer(uniqueId);
                }

            }
        }

        if (cvContainer != null) {
            return cvContainer.getCvTreeModel();
        }
        return null;
    }

}
