package org.bidib.wizard.mvc.stepcontrol.view;

import java.util.Map;

import org.bidib.wizard.client.common.view.cvdef.CvNode;
import org.bidib.wizard.mvc.common.view.cvdefinition.CvValueUtils;
import org.bidib.wizard.mvc.stepcontrol.model.MicroStepsEnum;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StepControlCvUtils {

    private static final Logger LOGGER = LoggerFactory.getLogger(StepControlCvUtils.class);

    public static CvNode getNode(final Map<String, CvNode> mapKeywordToNode, String keyword) {
        CvNode cvNode = mapKeywordToNode.get(keyword);
        return cvNode;
    }

    public static Integer getConfigVarByteValue(
        final Map<String, CvNode> mapKeywordToNode, final Map<String, CvNode> cvNumberToJideNodeMap, String keyword) {
        CvNode cvNode = getNode(mapKeywordToNode, keyword);
        if (cvNode != null) {
            Integer value = CvValueUtils.getConfigVarByteValue(cvNode, cvNumberToJideNodeMap);
            return value;
        }
        return null;
    }

    public static Integer getConfigVarIntValue(
        final Map<String, CvNode> mapKeywordToNode, final Map<String, CvNode> cvNumberToJideNodeMap, String keyword) {
        CvNode cvNode = getNode(mapKeywordToNode, keyword);
        if (cvNode != null) {
            Integer value = CvValueUtils.getConfigVarIntValue(cvNode, cvNumberToJideNodeMap);
            return value;
        }
        return null;
    }

    public static Long getConfigVarLongValue(final Map<String, CvNode> mapKeywordToNode, String keyword) {
        CvNode cvNode = getNode(mapKeywordToNode, keyword);
        if (cvNode != null) {
            Long value = CvValueUtils.getConfigVarLongValue(cvNode);
            return value;
        }
        return null;
    }

    public static Long getConfigVarLongValueFromStringByCvKey(
        final Map<String, CvNode> cvNumberToJideNodeMap, String cvKey) {
        LOGGER.info("Get the cvNode for CV key: {}", cvKey);

        CvNode cvNode = cvNumberToJideNodeMap.get(cvKey);
        if (cvNode != null) {
            // get the value as string and parse the value to long
            String value = CvValueUtils.getConfigVarStringValue(cvNode);
            long longValue = Long.parseLong(value);
            LOGGER.info("Current string value: {}, parsed long value: {}", value, longValue);
            return longValue;
        }
        return null;
    }

    public static MicroStepsEnum getValidMicroStepping(
        final Map<String, CvNode> mapKeywordToNode, final Map<String, CvNode> cvNumberToJideNodeMap) {
        Integer microSteppingValue =
            StepControlCvUtils
                .getConfigVarByteValue(mapKeywordToNode, cvNumberToJideNodeMap,
                    StepControlKeywords.KEYWORD_MICROSTEPPING);
        MicroStepsEnum microStepsEnum = null;
        if (microSteppingValue != null) {
            try {
                microStepsEnum = MicroStepsEnum.fromValue(microSteppingValue);
            }
            catch (Exception ex) {
                LOGGER.warn("Parse microsteps value to supported enum failed.", ex);
            }
        }

        if (microStepsEnum == null) {
            LOGGER.warn("Set the default microstepping value of 32!");
            microStepsEnum = MicroStepsEnum.steps64;
        }
        return microStepsEnum;
    }

}
