package org.bidib.wizard.mvc.common.view;

import javax.swing.JFrame;
import javax.swing.JMenuItem;
import javax.swing.UIManager;
import javax.swing.UnsupportedLookAndFeelException;

import org.bidib.wizard.client.common.view.LabeledPopupMenu;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LabeledPopupMenuTest {

    private static final Logger LOGGER = LoggerFactory.getLogger(LabeledPopupMenuTest.class);

    public static void main(String[] args) {

        try {
            UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
        }
        catch (ClassNotFoundException | InstantiationException | IllegalAccessException
            | UnsupportedLookAndFeelException ex) {
            LOGGER.warn("Set the L&F failed.", ex);
        }

        JFrame frame = new JFrame();
        frame.setSize(100, 100);
        frame.setDefaultCloseOperation(JFrame.EXIT_ON_CLOSE);
        frame.setLocation(100, 100);
        frame.setVisible(true);

        LabeledPopupMenu myPopup = new LabeledPopupMenu("Say & <something>");
        myPopup.add(new JMenuItem("Sample item"));
        myPopup.show(frame, 50, 50);
    }
}
