/*
 * Decompiled with CFR 0.152.
 */
package org.bidib.wizard.mvc.booster.view;

import com.jgoodies.binding.list.SelectionInList;
import java.awt.Component;
import javax.swing.JMenuItem;
import org.bidib.jbidibc.messages.enums.BoosterState;
import org.bidib.jbidibc.messages.enums.CommandStationState;
import org.bidib.wizard.api.locale.Resources;
import org.bidib.wizard.client.common.view.BasicPopupMenu;
import org.bidib.wizard.model.status.BoosterStatus;
import org.bidib.wizard.mvc.booster.controller.listener.BoosterTableControllerListener;
import org.bidib.wizard.mvc.booster.model.BoosterModel;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BoosterTableMenu
extends BasicPopupMenu {
    private static final long serialVersionUID = 1L;
    private static final Logger LOGGER = LoggerFactory.getLogger(BoosterTableMenu.class);
    private JMenuItem boosterOnItem;
    private JMenuItem boosterOffItem;
    private JMenuItem commandStationOnItem;
    private JMenuItem commandStationOffItem;
    private final Component parent;
    private final BoosterTableControllerListener boosterTableController;
    private final SelectionInList<BoosterModel> boosterSelection;

    public BoosterTableMenu(Component parent, BoosterTableControllerListener boosterTableController, SelectionInList<BoosterModel> boosterSelection) {
        this.parent = parent;
        this.boosterTableController = boosterTableController;
        this.boosterSelection = boosterSelection;
        this.boosterOnItem = new JMenuItem(Resources.getString(BoosterTableMenu.class, (String)"boosterOn"));
        this.boosterOnItem.addActionListener(e -> {
            BoosterModel boosterModel = (BoosterModel)boosterSelection.getSelection();
            if (boosterModel != null) {
                LOGGER.info("Turn booster on: {}", (Object)boosterModel);
                boosterTableController.setBoosterState(boosterModel.getBooster(), BoosterStatus.ON);
            }
        });
        this.add(this.boosterOnItem);
        this.boosterOffItem = new JMenuItem(Resources.getString(BoosterTableMenu.class, (String)"boosterOff"));
        this.boosterOffItem.addActionListener(e -> {
            BoosterModel boosterModel = (BoosterModel)boosterSelection.getSelection();
            if (boosterModel != null) {
                LOGGER.info("Turn booster off: {}", (Object)boosterModel);
                boosterTableController.setBoosterState(boosterModel.getBooster(), BoosterStatus.OFF);
            }
        });
        this.add(this.boosterOffItem);
        this.addSeparator();
        this.commandStationOnItem = new JMenuItem(Resources.getString(BoosterTableMenu.class, (String)"commandStationOn"));
        this.commandStationOnItem.addActionListener(e -> {
            BoosterModel boosterModel = (BoosterModel)boosterSelection.getSelection();
            if (boosterModel != null) {
                LOGGER.info("Turn command station on: {}", (Object)boosterModel);
                boosterTableController.setCommandStationState(boosterModel.getBooster(), CommandStationState.GO_IGN_WD);
            }
        });
        this.add(this.commandStationOnItem);
        this.commandStationOffItem = new JMenuItem(Resources.getString(BoosterTableMenu.class, (String)"commandStationOff"));
        this.commandStationOffItem.addActionListener(e -> {
            BoosterModel boosterModel = (BoosterModel)boosterSelection.getSelection();
            if (boosterModel != null) {
                LOGGER.info("Turn command station off: {}", (Object)boosterModel);
                boosterTableController.setCommandStationState(boosterModel.getBooster(), CommandStationState.STOP);
            }
        });
        this.add(this.commandStationOffItem);
        this.boosterOnItem.setEnabled(false);
        this.boosterOffItem.setEnabled(false);
        this.commandStationOnItem.setEnabled(false);
        this.commandStationOffItem.setEnabled(false);
    }

    public void prepareMenuItems(BoosterState boosterState, CommandStationState csState) {
        if (boosterState != null) {
            if (BoosterState.isOffState((BoosterState)boosterState)) {
                this.boosterOnItem.setEnabled(true);
                this.boosterOffItem.setEnabled(false);
            } else {
                this.boosterOnItem.setEnabled(false);
                this.boosterOffItem.setEnabled(true);
            }
        } else {
            this.boosterOnItem.setEnabled(false);
            this.boosterOffItem.setEnabled(false);
        }
        if (csState != null) {
            if (CommandStationState.isOffState((CommandStationState)csState)) {
                this.commandStationOnItem.setEnabled(true);
                this.commandStationOffItem.setEnabled(false);
            } else {
                this.commandStationOnItem.setEnabled(false);
                this.commandStationOffItem.setEnabled(true);
            }
        } else {
            this.commandStationOnItem.setEnabled(false);
            this.commandStationOffItem.setEnabled(false);
        }
    }
}

