/*
 * Decompiled with CFR 0.152.
 */
package org.bidib.wizard.mvc.locolist.model;

import com.jgoodies.binding.beans.Model;
import com.jgoodies.common.collect.ArrayListModel;
import java.beans.PropertyChangeListener;
import java.util.Collections;
import java.util.Date;
import java.util.LinkedList;
import java.util.List;
import java.util.UUID;
import javax.swing.SwingUtilities;
import org.apache.commons.collections4.IterableUtils;
import org.apache.commons.collections4.Predicate;
import org.apache.commons.lang3.StringUtils;
import org.bidib.jbidibc.core.schema.UserDevicesListFactory;
import org.bidib.jbidibc.core.schema.decoder.commontypes.DecoderTypeType;
import org.bidib.jbidibc.core.schema.decoder.userdevices.DecoderType;
import org.bidib.jbidibc.core.schema.decoder.userdevices.UserDeviceType;
import org.bidib.jbidibc.core.schema.decoder.userdevices.UserDevicesList;
import org.bidib.jbidibc.messages.DriveState;
import org.bidib.jbidibc.messages.enums.DirectionEnum;
import org.bidib.wizard.model.status.DirectionStatus;
import org.bidib.wizard.model.status.SpeedSteps;
import org.bidib.wizard.mvc.locolist.controller.listener.LocoTableControllerListener;
import org.bidib.wizard.mvc.locolist.model.LocoModel;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LocoTableModel
extends Model {
    private static final long serialVersionUID = 1L;
    private static final Logger LOGGER = LoggerFactory.getLogger(LocoTableModel.class);
    public static final String PROPERTY_LOCOS = "locos";
    public static final String PROPERTY_CS_NODE_SELECTED = "csNodeSelected";
    private ArrayListModel<LocoModel> locoList = new ArrayListModel();
    private boolean csNodeSelected;
    private final PropertyChangeListener locoChangeListener;
    private final LocoTableControllerListener locoTableController;
    private UserDevicesList userDevicesList;

    public LocoTableModel(LocoTableControllerListener locoTableController) {
        this.locoTableController = locoTableController;
        this.locoChangeListener = new /* Unavailable Anonymous Inner Class!! */;
    }

    private UserDevicesList toUserDevicesList(ArrayListModel<LocoModel> locoList) {
        if (this.userDevicesList == null) {
            LOGGER.info("Create the initial userDevicesList to store the data.");
            this.userDevicesList = UserDevicesListFactory.prepareEmptyList((Date)new Date());
        }
        List userDeviceList = this.userDevicesList.getUserDevices().getUserDevice();
        for (LocoModel loco : locoList) {
            UserDeviceType userDevice = userDeviceList.stream().filter(dev -> dev.getAddress().intValue() == loco.getLocoAddress() && dev.getDeviceType() == DecoderTypeType.LOCO).findFirst().orElse(null);
            if (userDevice == null) {
                UUID uuid = UUID.randomUUID();
                String randomUUIDString = uuid.toString();
                Object locoName = loco.getLocoName();
                if (StringUtils.isBlank((CharSequence)locoName)) {
                    locoName = "Lok " + loco.getLocoAddress();
                }
                userDevice = new UserDeviceType().withAddress(Integer.valueOf(loco.getLocoAddress())).withId(randomUUIDString).withName((String)locoName).withDeviceType(DecoderTypeType.LOCO);
                int speedSteps = SpeedSteps.valueOf((SpeedSteps)loco.getSpeedSteps());
                userDevice.withDecoder(new DecoderType().withName("Unknown").withSpeedsteps(speedSteps));
                LOGGER.info("Created new userDevice entry: {}", (Object)userDevice);
                this.userDevicesList.getUserDevices().withUserDevice(new UserDeviceType[]{userDevice});
                continue;
            }
            Object locoName = loco.getLocoName();
            if (StringUtils.isBlank((CharSequence)locoName)) {
                locoName = "Lok " + loco.getLocoAddress();
            }
            userDevice.setName((String)locoName);
        }
        return this.userDevicesList;
    }

    public void setUserDevicesList(UserDevicesList userDevicesList) {
        this.userDevicesList = userDevicesList;
        if (userDevicesList != null && userDevicesList.getUserDevices() != null) {
            List locoDevices = UserDevicesListFactory.findUserDevices((DecoderTypeType)DecoderTypeType.LOCO, (List)userDevicesList.getUserDevices().getUserDevice());
            for (UserDeviceType locoDevice : locoDevices) {
                this.addLoco(locoDevice);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addLoco(UserDeviceType locoDevice) {
        ArrayListModel arrayListModel = this.locoList;
        synchronized (arrayListModel) {
            int locoAddress = locoDevice.getAddress();
            LocoModel loco = new LocoModel(locoAddress);
            if (!this.locoList.contains((Object)loco)) {
                LOGGER.info("Add loco to loco list: {}, locoDevice: {}", (Object)loco, (Object)locoDevice);
                this.toLocoModel(locoDevice, loco);
                loco.addPropertyChangeListener(this.locoChangeListener);
                LinkedList oldValue = new LinkedList(this.locoList);
                this.locoList.add((Object)loco);
                this.firePropertyChange(PROPERTY_LOCOS, oldValue, (Object)this.locoList);
            } else {
                LOGGER.warn("Loco is already in loco list: {}", (Object)loco);
                LocoModel existing = (LocoModel)IterableUtils.find((Iterable)this.locoList, (Predicate)new /* Unavailable Anonymous Inner Class!! */);
                this.toLocoModel(locoDevice, existing);
            }
        }
    }

    private void toLocoModel(UserDeviceType locoDevice, LocoModel loco) {
        if (locoDevice.getDecoder() != null && locoDevice.getDecoder().getSpeedsteps() > 0) {
            loco.setSpeedSteps(SpeedSteps.valueOf((int)locoDevice.getDecoder().getSpeedsteps()));
        }
        loco.setLocoName(locoDevice.getName());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addLoco(DriveState driveState) {
        ArrayListModel arrayListModel = this.locoList;
        synchronized (arrayListModel) {
            int locoAddress = driveState.getAddress();
            LocoModel loco = new LocoModel(locoAddress);
            if (!this.locoList.contains((Object)loco)) {
                LOGGER.info("Add loco to loco list: {}, driveState: {}", (Object)loco, (Object)driveState);
                this.toLocoModel(driveState, loco);
                loco.addPropertyChangeListener(this.locoChangeListener);
                LinkedList oldValue = new LinkedList(this.locoList);
                this.locoList.add((Object)loco);
                this.firePropertyChange(PROPERTY_LOCOS, oldValue, (Object)this.locoList);
            } else {
                LOGGER.warn("Loco is already in loco list: {}", (Object)loco);
                LocoModel existing = (LocoModel)IterableUtils.find((Iterable)this.locoList, (Predicate)new /* Unavailable Anonymous Inner Class!! */);
                this.toLocoModel(driveState, existing);
                this.fireLocoChanged(existing);
            }
        }
    }

    private void fireLocoChanged(LocoModel locoModel) {
        LOGGER.debug("The loco address has been changed.");
        int index = this.locoList.indexOf((Object)locoModel);
        this.locoList.fireContentsChanged(index);
    }

    private void toLocoModel(DriveState driveState, LocoModel loco) {
        loco.setSpeed(driveState.getSpeed() & 0x7F);
        loco.setDirection(driveState.getDirection() == DirectionEnum.FORWARD ? DirectionStatus.FORWARD : DirectionStatus.BACKWARD);
        loco.setSpeedSteps(SpeedSteps.fromBidibFormat((int)driveState.getAddressFormat()));
        loco.setFunctions(driveState.getFunctions());
        loco.setOutputActive(driveState.getOutputActive() > 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeLoco(int locoAddress) {
        ArrayListModel arrayListModel = this.locoList;
        synchronized (arrayListModel) {
            LOGGER.info("Remove loco from loco list: {}", (Object)locoAddress);
            LinkedList oldValue = new LinkedList(this.locoList);
            int index = this.locoList.indexOf((Object)new LocoModel(locoAddress));
            if (index > -1) {
                LocoModel loco = (LocoModel)this.locoList.remove(index);
                if (loco != null) {
                    loco.removePropertyChangeListener(this.locoChangeListener);
                }
                this.firePropertyChange(PROPERTY_LOCOS, oldValue, (Object)this.locoList);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeAllLocos() {
        ArrayListModel arrayListModel = this.locoList;
        synchronized (arrayListModel) {
            LOGGER.info("Remove all locos from loco list.");
            if (SwingUtilities.isEventDispatchThread()) {
                this.internalRemoveAllLocos();
            } else {
                SwingUtilities.invokeLater(() -> this.internalRemoveAllLocos());
            }
        }
    }

    private void internalRemoveAllLocos() {
        LinkedList oldValue = new LinkedList(this.locoList);
        this.locoList.clear();
        for (LocoModel loco : oldValue) {
            loco.removePropertyChangeListener(this.locoChangeListener);
        }
        this.firePropertyChange(PROPERTY_LOCOS, oldValue, (Object)this.locoList);
    }

    public void setDriveState(byte[] address, DriveState driveState) {
        LOGGER.info("Drive state was delivered: {}", (Object)driveState);
        if (driveState.getAddress() > 0) {
            this.addLoco(driveState);
        }
    }

    public ArrayListModel<LocoModel> getLocoListModel() {
        return this.locoList;
    }

    public List<LocoModel> getLocos() {
        return Collections.unmodifiableList(this.locoList);
    }

    public boolean isCsNodeSelected() {
        return this.csNodeSelected;
    }

    public void setCsNodeSelected(boolean csNodeSelected) {
        boolean oldValue = this.csNodeSelected;
        this.csNodeSelected = csNodeSelected;
        if (SwingUtilities.isEventDispatchThread()) {
            this.firePropertyChange(PROPERTY_CS_NODE_SELECTED, oldValue, csNodeSelected);
        } else {
            SwingUtilities.invokeLater(() -> this.firePropertyChange(PROPERTY_CS_NODE_SELECTED, oldValue, csNodeSelected));
        }
    }

    public UserDevicesList getUserDevicesList() {
        UserDevicesList userDevicesList = this.toUserDevicesList(this.locoList);
        return userDevicesList;
    }
}

