/*
 * Decompiled with CFR 0.152.
 */
package org.bidib.wizard.mvc.main.view.panel;

import com.jidesoft.swing.SearchableUtils;
import com.vlsolutions.swing.docking.DockKey;
import com.vlsolutions.swing.docking.Dockable;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Frame;
import java.awt.Point;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.LinkedList;
import java.util.List;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.event.ListSelectionListener;
import javax.swing.filechooser.FileNameExtensionFilter;
import org.apache.commons.lang3.StringUtils;
import org.bidib.jbidibc.core.schema.bidiblabels.NodeLabels;
import org.bidib.jbidibc.messages.enums.DetachedState;
import org.bidib.jbidibc.messages.enums.IdentifyState;
import org.bidib.jbidibc.messages.utils.ByteUtils;
import org.bidib.jbidibc.messages.utils.NodeUtils;
import org.bidib.wizard.api.locale.Resources;
import org.bidib.wizard.api.model.NodeInterface;
import org.bidib.wizard.api.model.listener.NodeListListener;
import org.bidib.wizard.api.utils.XmlLocaleUtils;
import org.bidib.wizard.client.common.nodetree.JideNodeTree;
import org.bidib.wizard.client.common.nodetree.JideNodeTreeTableModel;
import org.bidib.wizard.client.common.view.DockKeys;
import org.bidib.wizard.client.common.view.menu.listener.NodeListMenuListener;
import org.bidib.wizard.common.context.DefaultApplicationContext;
import org.bidib.wizard.common.labels.LabelsChangedEvent;
import org.bidib.wizard.common.labels.WizardLabelWrapper;
import org.bidib.wizard.common.model.settings.WizardSettingsInterface;
import org.bidib.wizard.core.service.SettingsService;
import org.bidib.wizard.mvc.main.model.MainModel;
import org.bidib.wizard.mvc.main.view.menu.NodeListMenu;
import org.bidib.wizard.mvc.main.view.panel.NodeListPanel;
import org.bidib.wizard.mvc.main.view.panel.listener.LabelAction;
import org.bidib.wizard.mvc.main.view.panel.listener.LabelChangedListener;
import org.bidib.wizard.mvc.main.view.panel.listener.NodeListActionListener;
import org.bidib.wizard.nodescript.client.view.listener.NodeTreeScriptingListener;
import org.bushe.swing.event.EventBus;
import org.bushe.swing.event.annotation.AnnotationProcessor;
import org.bushe.swing.event.annotation.EventSubscriber;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.ApplicationEventPublisher;

public class NodeListPanel
implements NodeListMenuListener,
Dockable,
NodeTreeScriptingListener {
    private static final Logger LOGGER = LoggerFactory.getLogger(NodeListPanel.class);
    private final List<NodeListActionListener> nodeListListeners = new LinkedList();
    private final List<LabelChangedListener<NodeInterface>> labelChangedListeners = new LinkedList();
    private final JideNodeTree nodeTree;
    private LabelAction<NodeInterface> labelAction;
    private final NodeListMenu nodeListMenu;
    private final JPopupMenu popupMenu;
    private JPanel contentPanel;
    private final SettingsService settingsService;
    private final WizardLabelWrapper wizardLabelWrapper;
    private final ApplicationEventPublisher applicationEventPublisher;
    private static final String BIDIB_DEFAULT_NAMES_EXTENSION = "xml";
    private static final String WORKING_DIR_DEFAULT_LABELS_KEY = "defaultLabels";

    public NodeListPanel(MainModel mainModel, SettingsService settingsService, WizardLabelWrapper wizardLabelWrapper, ApplicationEventPublisher applicationEventPublisher) {
        this.settingsService = settingsService;
        this.wizardLabelWrapper = wizardLabelWrapper;
        this.applicationEventPublisher = applicationEventPublisher;
        JideNodeTreeTableModel jideNodeTreeTableModel = new JideNodeTreeTableModel();
        this.nodeTree = new JideNodeTree(jideNodeTreeTableModel, settingsService, wizardLabelWrapper);
        this.labelAction = new /* Unavailable Anonymous Inner Class!! */;
        LOGGER.info("Register the nodeTree in applicationContext.");
        DefaultApplicationContext.getInstance().register("nodeTree", (Object)this.nodeTree);
        this.nodeListMenu = new NodeListMenu(mainModel, settingsService);
        this.popupMenu = this.nodeListMenu.getPopupMenu();
        DockKeys.DOCKKEY_NODE_LIST_PANEL.setName(Resources.getString(this.getClass(), (String)"title"));
        DockKeys.DOCKKEY_NODE_LIST_PANEL.setCloseEnabled(false);
        DockKeys.DOCKKEY_NODE_LIST_PANEL.setAutoHideEnabled(false);
        this.nodeTree.addMouseListener((MouseListener)new /* Unavailable Anonymous Inner Class!! */);
        this.nodeTree.setItems(new NodeInterface[0]);
        mainModel.addNodeListListener((NodeListListener)new /* Unavailable Anonymous Inner Class!! */);
        this.nodeListMenu.addMenuListener((NodeListMenuListener)this);
        JideNodeTree tree = this.nodeTree;
        SearchableUtils.installSearchable((JTable)tree);
        AnnotationProcessor.process((Object)this);
    }

    private JPanel createPanel() {
        LOGGER.info("Create the content panel.");
        JPanel contentPanel = new JPanel(new BorderLayout());
        JScrollPane scrollPane = new JScrollPane((Component)this.nodeTree);
        contentPanel.add(scrollPane);
        return contentPanel;
    }

    public Component getComponent() {
        if (this.contentPanel == null) {
            this.contentPanel = this.createPanel();
        }
        return this.contentPanel;
    }

    public DockKey getDockKey() {
        return DockKeys.DOCKKEY_NODE_LIST_PANEL;
    }

    @EventSubscriber(eventClass=LabelsChangedEvent.class)
    public void labelsChangedEvent(LabelsChangedEvent labelsChangedEvent) {
        LOGGER.info("The labels have changed, node: {}", (Object)labelsChangedEvent);
        this.nodeTree.refreshView();
    }

    private void internalListChanged(MainModel model) {
        NodeInterface selectedValue = this.nodeTree.getSelectedItem();
        LOGGER.info("The list has changed, current selected value: {}", (Object)selectedValue);
        NodeInterface[] nodes = new NodeInterface[]{};
        if (model.getNodeProvider() != null) {
            nodes = model.getNodeProvider().getNodes().toArray(new NodeInterface[0]);
        }
        this.nodeTree.setItems(nodes);
        LOGGER.debug("The list has changed, set the new nodes has finished.");
    }

    public void addressMessagesEnabled(boolean isSelected) {
        NodeInterface node = this.nodeTree.getSelectedItem();
        if (node != null) {
            node.setAddressMessagesEnabled(Boolean.valueOf(isSelected));
            for (NodeListActionListener l : this.nodeListListeners) {
                l.enableAddressMessages(node);
            }
        }
    }

    public void editLabel(MouseEvent popupEvent) {
        NodeInterface selectedItem = this.getSelectedItem();
        if (selectedItem != null) {
            this.labelAction.editLabel((Object)selectedItem, this.selectedIndexToLocation(), (object, label) -> this.fireLabelChanged(object, label));
        }
    }

    protected void handleMouseEvent(MouseEvent e, JPopupMenu popupMenu) {
        if (e.isPopupTrigger() && this.nodeTree.getItemSize() > 0) {
            this.nodeTree.selectElement(e.getPoint());
            popupMenu.show(e.getComponent(), e.getX(), e.getY());
        }
    }

    protected Point selectedIndexToLocation() {
        int selectedIndex = this.nodeTree.getSelectedIndex();
        return this.selectedIndexToLocation(selectedIndex);
    }

    private Point selectedIndexToLocation(int selectedIndex) {
        Point result = new Point();
        if (selectedIndex >= 0) {
            Point listPosition = this.nodeTree.getLocationOnScreen();
            Point itemPosition = this.nodeTree.indexToLocation(selectedIndex);
            result.setLocation(listPosition.x + itemPosition.x, listPosition.y + itemPosition.y);
        }
        return result;
    }

    public void addListSelectionListener(ListSelectionListener l) {
        this.nodeTree.addListSelectionListener(l);
    }

    public void addNodeListListener(NodeListActionListener l) {
        this.addLabelChangedListener((LabelChangedListener)l);
        this.nodeListListeners.add(l);
    }

    public void addLabelChangedListener(LabelChangedListener<NodeInterface> l) {
        this.labelChangedListeners.add(l);
    }

    public void dccStartEnabled(boolean isSelected) {
        NodeInterface node = this.nodeTree.getSelectedItem();
        if (node != null) {
            node.setDccStartEnabled(Boolean.valueOf(isSelected));
            for (NodeListActionListener l : this.nodeListListeners) {
                l.enableDccStart(node);
            }
        }
    }

    public void importNode() {
        NodeInterface node = this.nodeTree.getSelectedItem();
        if (node != null) {
            for (NodeListActionListener l : this.nodeListListeners) {
                l.importNode(node);
            }
        }
    }

    public void exportNode() {
        NodeInterface node = this.nodeTree.getSelectedItem();
        if (node != null) {
            for (NodeListActionListener l : this.nodeListListeners) {
                l.exportNode(node);
            }
        }
    }

    public void externalStartEnabled(boolean isSelected) {
        NodeInterface node = this.nodeTree.getSelectedItem();
        if (node != null) {
            node.setExternalStartEnabled(Boolean.valueOf(isSelected));
            for (NodeListActionListener l : this.nodeListListeners) {
                l.enableExternalStart(node);
            }
        }
    }

    public void feedbackMessagesEnabled(boolean isSelected) {
        NodeInterface node = this.nodeTree.getSelectedItem();
        if (node != null) {
            node.setFeedbackMessagesEnabled(Boolean.valueOf(isSelected));
            for (NodeListActionListener l : this.nodeListListeners) {
                l.enableFeedbackMessages(node);
            }
        }
    }

    public void feedbackMirrorDisabled(boolean disable) {
        NodeInterface node = this.nodeTree.getSelectedItem();
        if (node != null) {
            node.setFeedbackMirrorDisabled(Boolean.valueOf(disable));
            for (NodeListActionListener l : this.nodeListListeners) {
                l.disableFeedbackMirror(node, disable);
            }
        }
    }

    public void firmwareUpdate() {
        for (NodeListActionListener l : this.nodeListListeners) {
            l.firmwareUpdate(this.nodeTree.getSelectedItem());
        }
    }

    public void identify(boolean isSelected) {
        NodeInterface node = this.nodeTree.getSelectedItem();
        if (node != null) {
            node.setIdentifyState(isSelected ? IdentifyState.START : IdentifyState.STOP);
            for (NodeListActionListener l : this.nodeListListeners) {
                l.identify(node);
            }
        }
    }

    public void dccAdvView() {
        NodeInterface node = this.nodeTree.getSelectedItem();
        if (node != null) {
            for (NodeListActionListener l : this.nodeListListeners) {
                l.dccAdvView(node);
            }
        }
    }

    public void keyMessagesEnabled(boolean isSelected) {
        NodeInterface node = this.nodeTree.getSelectedItem();
        if (node != null) {
            node.setInputMessagesEnabled(Boolean.valueOf(isSelected));
            for (NodeListActionListener l : this.nodeListListeners) {
                l.enableKeyMessages(node);
            }
        }
    }

    public void features() {
        NodeInterface node = this.nodeTree.getSelectedItem();
        LOGGER.debug("Open the features dialog on node: {}", (Object)node);
        if (node != null) {
            Point itemPosition = this.selectedIndexToLocation();
            for (NodeListActionListener l : this.nodeListListeners) {
                l.features(node);
            }
        }
    }

    public void reset() {
        NodeInterface node = this.nodeTree.getSelectedItem();
        LOGGER.debug("Open the reset dialog on node: {}", (Object)node);
        if (node != null) {
            Frame parent = JOptionPane.getFrameForComponent((Component)this.nodeTree);
            new ResetDialog(this, parent, node, true);
        }
    }

    public void reloadNode() {
        NodeInterface node = this.nodeTree.getSelectedItem();
        LOGGER.debug("Open the reload dialog on node: {}", (Object)node);
        if (node != null) {
            Frame parent = JOptionPane.getFrameForComponent((Component)this.nodeTree);
            new ReloadNodeDialog(this, parent, node, true);
        }
    }

    public void ping() {
        NodeInterface node = this.nodeTree.getSelectedItem();
        LOGGER.info("Send ping to node: {}", (Object)node);
        if (node != null) {
            for (NodeListActionListener l : this.nodeListListeners) {
                l.ping(node, (byte)1);
            }
        }
    }

    public void enable() {
        NodeInterface node = this.nodeTree.getSelectedItem();
        LOGGER.info("Send enable to node: {}", (Object)node);
        if (node != null) {
            for (NodeListActionListener l : this.nodeListListeners) {
                l.enableNode(node);
            }
        }
    }

    public void disable() {
        NodeInterface node = this.nodeTree.getSelectedItem();
        LOGGER.info("Send disable to node: {}", (Object)node);
        if (node != null) {
            for (NodeListActionListener l : this.nodeListListeners) {
                l.disableNode(node);
            }
        }
    }

    public void readUniqueId() {
        NodeInterface node = this.nodeTree.getSelectedItem();
        LOGGER.info("Read the uniqueId from the node: {}", (Object)node);
        long uniqueId = 0L;
        if (node != null) {
            for (NodeListActionListener l : this.nodeListListeners) {
                uniqueId = l.readUniqueId(node);
            }
        }
        StringBuilder message = new StringBuilder("The UniqueId from the current node: ");
        message.append(ByteUtils.getUniqueIdAsString((long)uniqueId));
        Frame parent = JOptionPane.getFrameForComponent((Component)this.nodeTree);
        JOptionPane.showMessageDialog(parent, message);
    }

    public void detachAttachNode() {
        NodeInterface node = this.nodeTree.getSelectedItem();
        LOGGER.info("Logoff from the node: {}", (Object)node);
        if (node != null) {
            for (NodeListActionListener l : this.nodeListListeners) {
                boolean detached = node.getDetachedState() == DetachedState.DETACHED;
                LOGGER.info("Current detached state: {}", (Object)detached);
                l.detachAttachNode(node, !detached);
            }
        }
    }

    public void dmxModeler() {
        NodeInterface node = this.nodeTree.getSelectedItem();
        LOGGER.debug("Open the dmxModeler on node: {}", (Object)node);
        if (node != null) {
            for (NodeListActionListener l : this.nodeListListeners) {
                l.dmxModeler(node);
            }
        }
    }

    protected void fireLabelChanged(NodeInterface node, String label) {
        for (LabelChangedListener l : this.labelChangedListeners) {
            l.labelChanged((Object)node, label);
        }
        this.nodeTree.refreshView();
    }

    public void loco() {
        NodeInterface node = this.nodeTree.getSelectedItem();
        if (node != null && NodeUtils.hasCommandStationFunctions((long)node.getUniqueId())) {
            LOGGER.info("Open the loco dialog.");
            for (NodeListActionListener l : this.nodeListListeners) {
                l.loco(node);
            }
        }
    }

    public void locoList() {
        NodeInterface node = this.nodeTree.getSelectedItem();
        if (node != null && NodeUtils.hasCommandStationFunctions((long)node.getUniqueId())) {
            LOGGER.info("Open the loco table.");
            for (NodeListActionListener l : this.nodeListListeners) {
                l.locoList(node);
            }
        }
    }

    public void dccAccessory() {
        Point itemPosition = this.selectedIndexToLocation();
        NodeInterface node = this.nodeTree.getSelectedItem();
        if (node != null) {
            for (NodeListActionListener l : this.nodeListListeners) {
                l.dccAccessory(node, itemPosition.x, itemPosition.y);
            }
        }
    }

    public void locoCv() {
        Point itemPosition = this.selectedIndexToLocation();
        NodeInterface node = this.nodeTree.getSelectedItem();
        if (node != null) {
            for (NodeListActionListener l : this.nodeListListeners) {
                l.locoCv(node, itemPosition.x, itemPosition.y);
            }
        }
    }

    public void locoCvPt() {
        Point itemPosition = this.selectedIndexToLocation();
        NodeInterface node = this.nodeTree.getSelectedItem();
        if (node != null) {
            for (NodeListActionListener l : this.nodeListListeners) {
                l.locoCvPt(node, itemPosition.x, itemPosition.y);
            }
        }
    }

    public void showDetails() {
        Point itemPosition = this.selectedIndexToLocation();
        for (NodeListActionListener l : this.nodeListListeners) {
            l.nodeDetails(this.nodeTree.getSelectedItem(), itemPosition.x, itemPosition.y);
        }
    }

    public void bulkSwitchNode() {
        NodeInterface node = this.nodeTree.getSelectedItem();
        LOGGER.debug("Open the bulk switch node dialog on node: {}", (Object)node);
        if (node != null) {
            Point itemPosition = this.selectedIndexToLocation();
            for (NodeListActionListener l : this.nodeListListeners) {
                l.bulkSwitchDialog(node, itemPosition.x, itemPosition.y);
            }
        }
    }

    public void clearErrors() {
        NodeInterface node = this.nodeTree.getSelectedItem();
        LOGGER.debug("Clear errors on node: {}", (Object)node);
        if (node != null) {
            node.setNodeHasError(false);
        }
    }

    public void setSelectedNode(NodeInterface node) {
        LOGGER.info("Set the selected node: {}", (Object)node);
        this.nodeTree.setSelectedItem(node);
    }

    public NodeInterface getSelectedItem() {
        return this.nodeTree.getSelectedItem();
    }

    public void generateDocumentation() {
        LOGGER.info("Generate documentation.");
        NodeInterface node = this.getSelectedItem();
        if (node != null) {
            for (NodeListActionListener l : this.nodeListListeners) {
                l.generateDocumentation(node);
            }
        }
    }

    public void generateDefaultLabels() {
        LOGGER.info("Generate default labels.");
        try {
            NodeInterface node = this.getSelectedItem();
            if (node != null) {
                long uniqueId = node.getUniqueId();
                NodeLabels nodeLabels = this.wizardLabelWrapper.prepareDefaultLabels(Long.valueOf(uniqueId));
                if (nodeLabels != null) {
                    String lang = XmlLocaleUtils.getXmlLocaleVendorCV();
                    String shortLang = StringUtils.substringBefore((String)lang, (String)"-");
                    StringBuilder sb = new StringBuilder("bidib-default-names-");
                    sb.append(NodeUtils.getVendorId((long)uniqueId)).append("-");
                    sb.append(NodeUtils.getPid((long)uniqueId, (int)node.getNode().getRelevantPidBits())).append("-").append(shortLang).append(".xml");
                    String defaultFileName = sb.toString();
                    LOGGER.info("Prepared default filename: {}", (Object)defaultFileName);
                    WizardSettingsInterface wizardSettings = this.settingsService.getWizardSettings();
                    String storedWorkingDirectory = wizardSettings.getWorkingDirectory(WORKING_DIR_DEFAULT_LABELS_KEY);
                    String bidibNodeFilesDescription = Resources.getString(NodeListPanel.class, (String)"bidibDefaultLabelFilesDescription");
                    FileNameExtensionFilter bidibNodesFilter = new FileNameExtensionFilter(bidibNodeFilesDescription, BIDIB_DEFAULT_NAMES_EXTENSION);
                    4 dialog = new /* Unavailable Anonymous Inner Class!! */;
                    dialog.showDialog();
                } else {
                    JOptionPane.showMessageDialog(this.getComponent(), "No labels available for selected node.", "Default Labels", 0);
                }
            }
        }
        catch (Exception ex) {
            LOGGER.warn("Generate default labels failed.", (Throwable)ex);
        }
    }

    public void performShutdown() {
    }

    public void deleteNodeLabels() {
        LOGGER.info("Delete the node labels.");
        NodeInterface node = this.getSelectedItem();
        if (node != null) {
            for (NodeListActionListener l : this.nodeListListeners) {
                l.deleteNodeLabels(node);
            }
            LabelsChangedEvent labelsChangedEvent = new LabelsChangedEvent(node.getUniqueId());
            LOGGER.info("Publish the labelsChangedEvent: {}", (Object)labelsChangedEvent);
            EventBus.publish((Object)labelsChangedEvent);
            this.applicationEventPublisher.publishEvent((Object)labelsChangedEvent);
        }
    }
}

