package org.bidib.wizard.mvc.main.view.panel;

import java.awt.BorderLayout;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;

import javax.swing.AbstractAction;
import javax.swing.DropMode;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.ListSelectionModel;
import javax.swing.border.EmptyBorder;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;

import org.bidib.wizard.api.locale.Resources;
import org.bidib.wizard.api.model.Flag;
import org.bidib.wizard.api.model.Macro;
import org.bidib.wizard.api.model.NodeInterface;
import org.bidib.wizard.api.model.function.AccessoryOkayFunction;
import org.bidib.wizard.api.model.function.AnalogPortAction;
import org.bidib.wizard.api.model.function.BacklightPortAction;
import org.bidib.wizard.api.model.function.Delayable;
import org.bidib.wizard.api.model.function.FlagFunction;
import org.bidib.wizard.api.model.function.Function;
import org.bidib.wizard.api.model.function.InputFunction;
import org.bidib.wizard.api.model.function.LightPortAction;
import org.bidib.wizard.api.model.function.MacroFunction;
import org.bidib.wizard.api.model.function.MotorPortAction;
import org.bidib.wizard.api.model.function.RandomDelayFunction;
import org.bidib.wizard.api.model.function.ServoMoveQueryFunction;
import org.bidib.wizard.api.model.function.ServoPortAction;
import org.bidib.wizard.api.model.function.SoundPortAction;
import org.bidib.wizard.api.model.function.SwitchPairPortAction;
import org.bidib.wizard.api.model.function.SwitchPortAction;
import org.bidib.wizard.client.common.table.AbstractStatusEmptyTable;
import org.bidib.wizard.client.common.view.renderer.BidibStatusListRenderer;
import org.bidib.wizard.client.common.view.renderer.FlagRenderer;
import org.bidib.wizard.client.common.view.renderer.MacroRenderer;
import org.bidib.wizard.client.common.view.renderer.PortTypeRenderer;
import org.bidib.wizard.client.common.view.slider.SliderRenderer;
import org.bidib.wizard.common.utils.MacroListUtils;
import org.bidib.wizard.model.ports.AnalogPort;
import org.bidib.wizard.model.ports.BacklightPort;
import org.bidib.wizard.model.ports.InputPort;
import org.bidib.wizard.model.ports.LightPort;
import org.bidib.wizard.model.ports.MotorPort;
import org.bidib.wizard.model.ports.Port;
import org.bidib.wizard.model.ports.ServoPort;
import org.bidib.wizard.model.ports.SoundPort;
import org.bidib.wizard.model.ports.SwitchPairPort;
import org.bidib.wizard.model.ports.SwitchPort;
import org.bidib.wizard.model.status.AccessoryOkayStatus;
import org.bidib.wizard.model.status.BidibStatus;
import org.bidib.wizard.model.status.MacroStatus;
import org.bidib.wizard.mvc.main.model.MacroTableModel;
import org.bidib.wizard.mvc.main.model.MainModel;
import org.bidib.wizard.mvc.main.model.listener.MacroSelectionListener;
import org.bidib.wizard.mvc.main.view.menu.AccessoryTableMenu;
import org.bidib.wizard.mvc.main.view.menu.MacroTableMenu;
import org.bidib.wizard.mvc.main.view.menu.listener.MacroTableMenuListener;
import org.bidib.wizard.mvc.main.view.table.ComboBoxEditor;
import org.bidib.wizard.mvc.main.view.table.ComboBoxRenderer;
import org.bidib.wizard.mvc.main.view.table.MacroTableRowTransferHandler;
import org.bidib.wizard.mvc.main.view.table.NumberWithLabelEditor;
import org.bidib.wizard.mvc.main.view.table.NumberWithLabelRenderer;
import org.bidib.wizard.mvc.main.view.table.PortComboBoxEditor;
import org.bidib.wizard.mvc.main.view.table.PortComboBoxRenderer;
import org.bidib.wizard.mvc.main.view.table.SwitchPairPortTable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import com.jidesoft.swing.DefaultOverlayable;
import com.jidesoft.swing.StyledLabelBuilder;

public class MacroContentPanel extends JPanel {
    private static final long serialVersionUID = 1L;

    private static final Logger LOGGER = LoggerFactory.getLogger(MacroContentPanel.class);

    private final MainModel model;

    private final MacroTableModel tableModel;

    private final AbstractStatusEmptyTable table;

    private final MacroTableMenu macroTableMenu;

    private Function<?>[] functionsClipBoard;

    private final String emptyPortLabel;

    public MacroContentPanel(final MainModel model) {
        this.macroTableMenu = new MacroTableMenu(model);
        this.model = model;

        setLayout(new BorderLayout());
        setBorder(new EmptyBorder(5, 2, 5, 3));

        this.emptyPortLabel = Resources.getString(Port.class, "portNone");

        macroTableMenu.addMenuListener(new MacroTableMenuListener() {
            @Override
            public void copy() {
                int[] rows = table.getSelectedRows();
                if (rows != null && rows.length > 0) {
                    fireCopy(rows);
                }
            }

            @Override
            public void cut() {
                int[] rows = table.getSelectedRows();
                if (rows != null && rows.length > 0) {
                    fireCut(rows);
                }
            }

            @Override
            public void delete() {
                int[] rows = table.getSelectedRows();
                if (rows != null && rows.length > 0) {
                    fireDelete(rows);
                }
            }

            @Override
            public void insertEmptyAfter() {
                fireInsertEmptyAfter(table.getSelectedRow());
            }

            @Override
            public void insertEmptyBefore() {
                fireInsertEmptyBefore(table.getSelectedRow());
            }

            @Override
            public void pasteAfter() {
                firePasteAfter(table.getSelectedRow());
            }

            @Override
            public void pasteBefore() {
                firePasteBefore(table.getSelectedRow());
            }

            @Override
            public void pasteInvertedAfter() {
                firePasteInvertedAfter(table.getSelectedRow());
            }

            @Override
            public void selectAll() {
                int rowCount = table.getRowCount();

                if (rowCount > 0) {
                    table.setRowSelectionInterval(0, rowCount - 1);
                }
            }
        });

        tableModel = new MacroTableModel(model);
        table = new AbstractStatusEmptyTable(tableModel, Resources.getString(getClass(), "emptyTable")) {
            private static final long serialVersionUID = 1L;

            @Override
            public void adjustRowHeight() {
                // set the correct row height
                SliderRenderer sliderEditor = new SliderRenderer(0, 255, 10);

                int rowHeight =
                    sliderEditor.getTableCellRendererComponent(this, 1, false, false, 0, 0).getPreferredSize().height
                        + 6;

                LOGGER.info("Set row height: {}", rowHeight);

                setRowHeight(rowHeight);
            }

            @Override
            protected String getErrorText() {
                if (model.getSelectedMacro() != null && model.getSelectedMacro().isContainsError()) {
                    return Resources.getString(MacroContentPanel.class, "restore-macro-failed");
                }
                return null;
            }

            @Override
            public Dimension getMinimumSize() {
                // the table should retain a minimum visible size
                return new Dimension(200, 100);
            }

            @Override
            public BidibStatus[] getActions(BidibStatus status) {
                if (status != null) {
                    BidibStatus[] actions = status.getMacroValues();
                    return actions;
                }
                else {
                    LOGGER.debug("No BidibStatus available.");
                }
                return new BidibStatus[0];
            }

            @Override
            public TableCellEditor getCellEditor(int row, int column) {
                TableCellEditor result = null;
                Function<?> function = model.getSelectedMacro().getFunction(row);

                switch (column) {
                    case MacroTableModel.COLUMN_DELAY:
                        if (function instanceof Delayable) {
                            result =
                                new NumberWithLabelEditor(Resources.getString(MacroContentPanel.class, "delay") + ":",
                                    "Ticks", 250);
                        }
                        else if (function instanceof RandomDelayFunction) {
                            result =
                                new NumberWithLabelEditor(Resources.getString(MacroContentPanel.class, "maximum") + ":",
                                    "Ticks");
                        }
                        break;
                    case MacroTableModel.COLUMN_PORT_TYPE:
                        Function<?>[] functions = MacroListUtils.prepareAvailableFunctions(model.getSelectedNode());
                        JComboBox<Function<?>> combobox = new JComboBox<>(functions);
                        combobox.setRenderer(new PortTypeRenderer());
                        result = new ComboBoxEditor<Function<?>>(combobox);
                        break;
                    case MacroTableModel.COLUMN_ACTION:
                        if (function != null) {
                            BidibStatus[] actions = getActions(function.getAction());

                            if (actions.length > 0) {
                                if (function instanceof SwitchPairPortAction) {
                                    result =
                                        ComboBoxEditor
                                            .createComboBoxEditor(actions, SwitchPairPortTable.STATUS_RESOURCE_KEY);
                                }
                                else {
                                    JComboBox<BidibStatus> comboboxStatus = new JComboBox<>(actions);
                                    comboboxStatus.setRenderer(new BidibStatusListRenderer<>((String) null));
                                    result = new ComboBoxEditor<BidibStatus>(comboboxStatus);
                                }
                            }
                        }
                        break;
                    case MacroTableModel.COLUMN_PORT_NUMBER:
                        final NodeInterface selectedNode = model.getSelectedNode();

                        if (function instanceof AccessoryOkayFunction) {
                            AccessoryOkayFunction aof = (AccessoryOkayFunction) function;
                            if (!AccessoryOkayStatus.NO_FEEDBACK.equals(aof.getAction())) {
                                List<InputPort> inputPorts = new ArrayList<InputPort>();
                                inputPorts.add(InputPort.NONE);
                                inputPorts.addAll(selectedNode.getEnabledInputPorts());
                                result =
                                    PortComboBoxEditor
                                        .prepareEditor(inputPorts.toArray(new InputPort[0]), emptyPortLabel);
                            }
                            else {
                                // no renderer if 'no feedback'
                            }
                        }
                        else if (function instanceof ServoMoveQueryFunction) {
                            List<ServoPort> servoPorts = new ArrayList<ServoPort>();
                            servoPorts.add(ServoPort.NONE);
                            servoPorts.addAll(selectedNode.getServoPorts());
                            result =
                                PortComboBoxEditor.prepareEditor(servoPorts.toArray(new ServoPort[0]), emptyPortLabel);
                        }
                        else if (function instanceof AnalogPortAction) {
                            result =
                                PortComboBoxEditor
                                    .prepareEditor(selectedNode.getAnalogPorts().toArray(new AnalogPort[0]),
                                        emptyPortLabel);
                        }
                        else if (function instanceof BacklightPortAction) {
                            result =
                                PortComboBoxEditor
                                    .prepareEditor(selectedNode.getBacklightPorts().toArray(new BacklightPort[0]),
                                        emptyPortLabel);
                        }
                        else if (function instanceof FlagFunction) {

                            JComboBox<Flag> comboboxFlag =
                                new JComboBox<>(selectedNode.getFlags().toArray(new Flag[0]));
                            comboboxFlag.setRenderer(new FlagRenderer());
                            result = new ComboBoxEditor<Flag>(comboboxFlag);
                        }
                        else if (function instanceof InputFunction) {
                            List<InputPort> inputPorts = new ArrayList<InputPort>();
                            inputPorts.add(InputPort.NONE);
                            inputPorts.addAll(selectedNode.getEnabledInputPorts());
                            result =
                                PortComboBoxEditor.prepareEditor(inputPorts.toArray(new InputPort[0]), emptyPortLabel);
                        }
                        else if (function instanceof LightPortAction) {
                            LinkedList<LightPort> ports = new LinkedList<>();
                            ports.add(LightPort.NONE);
                            ports.addAll(selectedNode.getEnabledLightPorts());
                            result = PortComboBoxEditor.prepareEditor(ports.toArray(new LightPort[0]), emptyPortLabel);
                        }
                        else if (function instanceof MacroFunction) {
                            MacroFunction macroFunction = (MacroFunction) function;
                            if (MacroStatus.END.equals(macroFunction.getAction())) {
                                // no renderer if 'End' because end always stops the current macro
                            }
                            else {
                                JComboBox<Macro> comboboxMacro =
                                    new JComboBox<>(selectedNode.getMacros().toArray(new Macro[0]));
                                comboboxMacro.setRenderer(new MacroRenderer());
                                result = new ComboBoxEditor<Macro>(comboboxMacro);
                            }
                        }
                        else if (function instanceof MotorPortAction) {
                            result =
                                PortComboBoxEditor
                                    .prepareEditor(selectedNode.getMotorPorts().toArray(new MotorPort[0]),
                                        emptyPortLabel);
                        }
                        else if (function instanceof ServoPortAction) {
                            result =
                                PortComboBoxEditor
                                    .prepareEditor(selectedNode.getServoPorts().toArray(new ServoPort[0]),
                                        emptyPortLabel);
                        }
                        else if (function instanceof SoundPortAction) {
                            result =
                                PortComboBoxEditor
                                    .prepareEditor(selectedNode.getSoundPorts().toArray(new SoundPort[0]),
                                        emptyPortLabel);
                        }
                        else if (function instanceof SwitchPortAction) {
                            LinkedList<SwitchPort> ports = new LinkedList<>();
                            ports.add(SwitchPort.NONE);
                            ports.addAll(selectedNode.getEnabledSwitchPorts());
                            result = PortComboBoxEditor.prepareEditor(ports.toArray(new SwitchPort[0]), emptyPortLabel);
                        }
                        else if (function instanceof SwitchPairPortAction) {
                            LinkedList<SwitchPairPort> ports = new LinkedList<>();
                            ports.add(SwitchPairPort.NONE);
                            ports.addAll(selectedNode.getEnabledSwitchPairPorts());
                            result =
                                PortComboBoxEditor.prepareEditor(ports.toArray(new SwitchPairPort[0]), emptyPortLabel);
                        }
                        break;
                    case MacroTableModel.COLUMN_EXTRA:
                        if (function instanceof ServoPortAction) {
                            result =
                                new NumberWithLabelEditor(
                                    Resources.getString(MacroContentPanel.class, "destination") + ":", "%", 100);
                        }
                        else if (function instanceof BacklightPortAction) {
                            result =
                                new NumberWithLabelEditor(
                                    Resources.getString(MacroContentPanel.class, "brightness") + ":", "%", 100);
                        }
                        else if (function instanceof MotorPortAction) {
                            result =
                                new NumberWithLabelEditor(Resources.getString(MacroContentPanel.class, "speed") + ":",
                                    null, 126);
                        }
                        break;
                }
                return result;
            }

            @Override
            public TableCellRenderer getCellRenderer(int row, int column) {
                TableCellRenderer result = super.getCellRenderer(row, column);

                if (model.getSelectedMacro() != null && row >= 0
                    && row < model.getSelectedMacro().getFunctions().size()) {
                    Function<? extends BidibStatus> function = model.getSelectedMacro().getFunction(row);

                    switch (column) {
                        case MacroTableModel.COLUMN_DELAY:
                            if (function instanceof Delayable) {
                                result =
                                    new NumberWithLabelRenderer(
                                        Resources.getString(MacroContentPanel.class, "delay") + ":", "Ticks");
                            }
                            else if (function instanceof RandomDelayFunction) {
                                result =
                                    new NumberWithLabelRenderer(
                                        Resources.getString(MacroContentPanel.class, "maximum") + ":", "Ticks");
                            }
                            break;
                        case MacroTableModel.COLUMN_PORT_TYPE:
                            ComboBoxRenderer<Function<?>> renderer =
                                new ComboBoxRenderer<>(
                                    MacroListUtils.prepareAvailableFunctions(model.getSelectedNode()));
                            renderer.setRenderer(new PortTypeRenderer());
                            result = renderer;
                            break;
                        case MacroTableModel.COLUMN_ACTION:
                            if (function != null) {
                                BidibStatus[] actions = getActions(function.getAction());

                                if (actions.length > 0) {
                                    if (function instanceof SwitchPairPortAction) {
                                        result =
                                            ComboBoxRenderer
                                                .createComboBoxRenderer(actions,
                                                    SwitchPairPortTable.STATUS_RESOURCE_KEY);
                                    }
                                    else {
                                        ComboBoxRenderer<BidibStatus> rendererStatus = new ComboBoxRenderer<>(actions);
                                        rendererStatus.setRenderer(new BidibStatusListRenderer<>((String) null));
                                        result = rendererStatus;
                                    }
                                }
                            }
                            break;
                        case MacroTableModel.COLUMN_PORT_NUMBER:
                            final NodeInterface selectedNode = model.getSelectedNode();

                            if (function instanceof AccessoryOkayFunction) {
                                AccessoryOkayFunction aof = (AccessoryOkayFunction) function;
                                if (!AccessoryOkayStatus.NO_FEEDBACK.equals(aof.getAction())) {
                                    List<InputPort> inputPorts = new ArrayList<InputPort>();
                                    inputPorts.add(InputPort.NONE);
                                    inputPorts.addAll(selectedNode.getEnabledInputPorts());
                                    result =
                                        new PortComboBoxRenderer<InputPort>(inputPorts.toArray(new InputPort[0]),
                                            emptyPortLabel);
                                }
                                else {
                                    // no renderer if 'no feedback'
                                }
                            }
                            else if (function instanceof ServoMoveQueryFunction) {
                                List<ServoPort> servoPorts = new ArrayList<ServoPort>();
                                servoPorts.add(ServoPort.NONE);
                                servoPorts.addAll(selectedNode.getServoPorts());
                                result =
                                    new PortComboBoxRenderer<ServoPort>(servoPorts.toArray(new ServoPort[0]),
                                        emptyPortLabel);
                            }
                            else if (function instanceof AnalogPortAction) {
                                result =
                                    new PortComboBoxRenderer<AnalogPort>(
                                        selectedNode.getAnalogPorts().toArray(new AnalogPort[0]), emptyPortLabel);
                            }
                            else if (function instanceof BacklightPortAction) {
                                result =
                                    new PortComboBoxRenderer<BacklightPort>(
                                        selectedNode.getBacklightPorts().toArray(new BacklightPort[0]), emptyPortLabel);
                            }
                            else if (function instanceof FlagFunction) {
                                ComboBoxRenderer<Flag> flagRenderer =
                                    new ComboBoxRenderer<Flag>(selectedNode.getFlags().toArray(new Flag[0]));
                                flagRenderer.setRenderer(new FlagRenderer());
                                result = flagRenderer;
                            }
                            else if (function instanceof InputFunction) {
                                List<InputPort> inputPorts = new LinkedList<>();
                                inputPorts.add(InputPort.NONE);
                                inputPorts.addAll(selectedNode.getEnabledInputPorts());
                                result =
                                    new PortComboBoxRenderer<InputPort>(inputPorts.toArray(new InputPort[0]),
                                        emptyPortLabel);
                            }
                            else if (function instanceof LightPortAction) {
                                LinkedList<LightPort> ports = new LinkedList<>();
                                ports.add(LightPort.NONE);
                                ports.addAll(selectedNode.getEnabledLightPorts());
                                result =
                                    new PortComboBoxRenderer<LightPort>(ports.toArray(new LightPort[0]),
                                        emptyPortLabel);
                            }
                            else if (function instanceof MacroFunction) {
                                MacroFunction macroFunction = (MacroFunction) function;
                                if (MacroStatus.END.equals(macroFunction.getAction())) {
                                    // no renderer if 'End' because end always stops the current macro
                                }
                                else {
                                    ComboBoxRenderer<Macro> macroRenderer =
                                        new ComboBoxRenderer<Macro>(selectedNode.getMacros().toArray(new Macro[0]));
                                    macroRenderer.setRenderer(new MacroRenderer());
                                    result = macroRenderer;
                                }
                            }
                            else if (function instanceof MotorPortAction) {
                                result =
                                    new PortComboBoxRenderer<MotorPort>(
                                        selectedNode.getMotorPorts().toArray(new MotorPort[0]), emptyPortLabel);
                            }
                            else if (function instanceof ServoPortAction) {
                                result =
                                    new PortComboBoxRenderer<ServoPort>(
                                        selectedNode.getServoPorts().toArray(new ServoPort[0]), emptyPortLabel);
                            }
                            else if (function instanceof SoundPortAction) {
                                result =
                                    new PortComboBoxRenderer<SoundPort>(
                                        selectedNode.getSoundPorts().toArray(new SoundPort[0]), emptyPortLabel);
                            }
                            else if (function instanceof SwitchPortAction) {
                                LinkedList<SwitchPort> ports = new LinkedList<>();
                                ports.add(SwitchPort.NONE);
                                ports.addAll(selectedNode.getEnabledSwitchPorts());
                                result =
                                    new PortComboBoxRenderer<SwitchPort>(ports.toArray(new SwitchPort[0]),
                                        emptyPortLabel);
                            }
                            else if (function instanceof SwitchPairPortAction) {
                                LinkedList<SwitchPairPort> ports = new LinkedList<>();
                                ports.add(SwitchPairPort.NONE);
                                ports.addAll(selectedNode.getEnabledSwitchPairPorts());
                                result =
                                    new PortComboBoxRenderer<SwitchPairPort>(ports.toArray(new SwitchPairPort[0]),
                                        emptyPortLabel);
                            }
                            break;
                        case MacroTableModel.COLUMN_EXTRA:
                            if (function instanceof ServoPortAction) {
                                result =
                                    new NumberWithLabelRenderer(
                                        Resources.getString(MacroContentPanel.class, "destination") + ":", "%");
                            }
                            else if (function instanceof BacklightPortAction) {
                                result =
                                    new NumberWithLabelRenderer(
                                        Resources.getString(MacroContentPanel.class, "brightness") + ":", "%");
                            }
                            else if (function instanceof MotorPortAction) {
                                result =
                                    new NumberWithLabelRenderer(
                                        Resources.getString(MacroContentPanel.class, "speed") + ":", null);
                            }
                            break;
                    }
                }
                return result;
            }
        };

        table.adjustRowHeight();

        table.getInputMap(JComponent.WHEN_ANCESTOR_OF_FOCUSED_COMPONENT).put(MacroTableMenu.KEYSTROKE_CUT, "cut");
        table.getActionMap().put("cut", new AbstractAction() {
            private static final long serialVersionUID = 1L;

            @Override
            public void actionPerformed(ActionEvent e) {
                macroTableMenu.fireCut();
            }
        });
        table.getInputMap(JComponent.WHEN_ANCESTOR_OF_FOCUSED_COMPONENT).put(MacroTableMenu.KEYSTROKE_COPY, "copy");
        table.getActionMap().put("copy", new AbstractAction() {
            private static final long serialVersionUID = 1L;

            @Override
            public void actionPerformed(ActionEvent e) {
                macroTableMenu.fireCopy();
            }
        });
        table.getInputMap(JComponent.WHEN_ANCESTOR_OF_FOCUSED_COMPONENT).put(MacroTableMenu.KEYSTROKE_PASTE, "paste");
        table.getActionMap().put("paste", new AbstractAction() {
            private static final long serialVersionUID = 1L;

            @Override
            public void actionPerformed(ActionEvent e) {
                macroTableMenu.firePasteAfter();
            }
        });
        table
            .getInputMap(JComponent.WHEN_ANCESTOR_OF_FOCUSED_COMPONENT)
            .put(AccessoryTableMenu.KEYSTROKE_DELETE, "delete");
        table.getActionMap().put("delete", new AbstractAction() {
            private static final long serialVersionUID = 1L;

            @Override
            public void actionPerformed(ActionEvent e) {
                macroTableMenu.fireDelete();
            }
        });
        table.putClientProperty("terminateEditOnFocusLost", Boolean.TRUE);
        table.addMouseListener(new MouseAdapter() {
            @Override
            public void mousePressed(MouseEvent e) {
                handleMouseEvent(e, macroTableMenu);
            }

            @Override
            public void mouseReleased(MouseEvent e) {
                handleMouseEvent(e, macroTableMenu);
            }
        });
        // table.setAutoResizeMode(JTable.AUTO_RESIZE_SUBSEQUENT_COLUMNS);
        table.setAutoResizeMode(JTable.AUTO_RESIZE_OFF);
        table.setSortable(false);

        // enable drag and drop
        table.setDragEnabled(true);
        table.setSelectionMode(ListSelectionModel.SINGLE_INTERVAL_SELECTION);
        table.setDropMode(DropMode.INSERT_ROWS);
        table.setTransferHandler(new MacroTableRowTransferHandler(table));

        for (int i = 0; i < table.getColumnModel().getColumnCount(); i++) {
            TableColumn column = table.getColumnModel().getColumn(i);
            switch (i) {
                case MacroTableModel.COLUMN_STEP:
                    column.setPreferredWidth(40);
                    break;
                case MacroTableModel.COLUMN_DELAY:
                    column.setPreferredWidth(120);
                    break;
                case MacroTableModel.COLUMN_EXTRA:
                    column.setPreferredWidth(120);
                    break;
                default:
                    column.setPreferredWidth(200);
                    break;
            }
        }

        setMinimumSize(new Dimension(400, 100));
        setPreferredSize(new Dimension(600, 200));

        final DefaultOverlayable overlayTable = new DefaultOverlayable(new JScrollPane(table));
        tableModel.addTableModelListener(new TableModelListener() {
            @Override
            public void tableChanged(TableModelEvent e) {
                overlayTable.setOverlayVisible(tableModel.getRowCount() == 0);
            }
        });

        overlayTable
            .addOverlayComponent(StyledLabelBuilder.createStyledLabel("{" + table.getEmptyTableText() + ":f:gray}"));

        add(overlayTable, BorderLayout.CENTER);

        model.addMacroSelectionListener(new MacroSelectionListener() {
            @Override
            public void macroChanged() {
                Macro macro = model.getSelectedMacro();
                LOGGER.info("The macro has changed: {}", macro);

                tableModel.setMacro(macro);
            }
        });
    }

    private Function<? extends BidibStatus>[] getFunctions(int[] rows) {
        Function<? extends BidibStatus>[] result = new Function<?>[rows.length];

        for (int index = 0; index < rows.length; index++) {
            result[index] = model.getSelectedMacro().getFunction(rows[index]);
        }
        return result;
    }

    private int getRow(Point point) {
        return table.rowAtPoint(point);
    }

    private void handleMouseEvent(MouseEvent e, JPopupMenu popupMenu) {
        if (e.isPopupTrigger()) {
            int row = getRow(e.getPoint());

            if (table.getSelectedRowCount() == 0 && table.getRowCount() > 0 && row >= 0 && row < table.getRowCount()) {
                table.setRowSelectionInterval(row, row);
            }
            table.grabFocus();
            popupMenu.show(e.getComponent(), e.getX(), e.getY());
        }
    }

    private void setFunctionsToClipboard(Function<?>[] functions) {
        if (functions != null) {
            try {
                this.functionsClipBoard = new Function[functions.length];
                for (int index = 0; index < functions.length; index++) {
                    if (functions[index] != null) {
                        this.functionsClipBoard[index] = ((Function<?>) functions[index].clone());
                    }
                }
            }
            catch (CloneNotSupportedException e) {
                throw new RuntimeException(e);
            }
        }
        else {
            this.functionsClipBoard = null;
        }
    }

    private Function<?>[] getFunctionsFromClipboard() {
        Function<?>[] result = null;

        if (functionsClipBoard != null) {
            try {
                result = new Function[functionsClipBoard.length];
                for (int index = 0; index < functionsClipBoard.length; index++) {
                    if (functionsClipBoard[index] != null) {
                        result[index] = ((Function<?>) functionsClipBoard[index].clone());
                    }
                }
            }
            catch (CloneNotSupportedException e) {
                throw new RuntimeException(e);
            }
        }
        return result;
    }

    private void fireCopy(int[] rows) {

        Function<? extends BidibStatus>[] functions = getFunctions(rows);
        setFunctionsToClipboard(functions);
    }

    private void fireCut(int[] rows) {
        Function<? extends BidibStatus>[] functions = getFunctions(rows);

        setFunctionsToClipboard(functions);
        for (int index = rows.length - 1; index >= 0; index--) {
            model.getSelectedMacro().removeFunction(rows[index]);
        }
    }

    private void fireDelete(int[] rows) {
        for (int index = rows.length - 1; index >= 0; index--) {
            model.getSelectedMacro().removeFunction(rows[index]);
        }
    }

    private void fireInsertEmptyAfter(int row) {
        model.getSelectedMacro().addFunctionsAfter(row, null);
    }

    private void fireInsertEmptyBefore(int row) {
        model.getSelectedMacro().addFunctionsBefore(row >= 0 ? row : 0, null);
    }

    private void firePasteAfter(int row) {
        model.getSelectedMacro().addFunctionsAfter(row, getFunctionsFromClipboard());
    }

    private void firePasteBefore(int row) {
        model.getSelectedMacro().addFunctionsBefore(row >= 0 ? row : 0, getFunctionsFromClipboard());
    }

    private void firePasteInvertedAfter(int row) {
        model.getSelectedMacro().addFunctionsInvertedAfter(row, getFunctionsFromClipboard());
    }

    public void refreshView() {
        LOGGER.info("Refresh the macro panel.");

        Macro macro = model.getSelectedMacro();
        LOGGER.info("The macro has changed: {}", macro);

        tableModel.setMacro(macro);
    }
}
