package org.bidib.wizard.mvc.ping.view;

import java.awt.Component;

import javax.swing.JTable;
import javax.swing.table.DefaultTableCellRenderer;

public class PingIntervalRenderer extends DefaultTableCellRenderer {

    private static final long serialVersionUID = 1L;

    public PingIntervalRenderer() {
    }

    @Override
    public Component getTableCellRendererComponent(
        JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
        super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);

        if (value instanceof Integer) {
            int val = ((Integer) value).intValue();
            setText(String.format("%dms", val));
        }
        else {
            setText(null);
        }

        return this;
    }

}
