/*
 * Decompiled with CFR 0.152.
 */
package org.bidib.wizard.mvc.accessory.view.panel;

import com.jgoodies.binding.value.BindingConverter;
import com.jgoodies.binding.value.ValueModel;
import com.jgoodies.common.base.Preconditions;
import java.text.Format;
import org.apache.commons.lang3.StringUtils;
import org.bidib.jbidibc.messages.enums.AccessoryAddressingEnum;
import org.bidib.jbidibc.messages.utils.ByteUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class RCN213Converter
implements BindingConverter<Number, String> {
    private static final Logger LOGGER = LoggerFactory.getLogger(RCN213Converter.class);
    private final Format format;
    private final ValueModel addressingModel;

    public RCN213Converter(ValueModel addressingModel, Format format) {
        this.format = (Format)Preconditions.checkNotNull((Object)format, (String)"The format must not be null.");
        this.addressingModel = addressingModel;
    }

    public String targetValue(Number sourceValue) {
        if (sourceValue != null) {
            if (sourceValue instanceof Byte) {
                Byte byteValue = (Byte)sourceValue;
                sourceValue = ByteUtils.getInt((byte)byteValue);
            }
            LOGGER.info("Converting sourceValue: {}, addressingModel.value: {}", (Object)sourceValue, this.addressingModel.getValue());
            if (AccessoryAddressingEnum.RCN_213 == this.addressingModel.getValue()) {
                int value = sourceValue.intValue() + 3;
                LOGGER.info("RCN-213 is active, added 3 to get the direct address: {}", (Object)value);
                return this.format.format(value);
            }
            return this.format.format(sourceValue);
        }
        return null;
    }

    public Number sourceValue(String targetValue) {
        try {
            if (StringUtils.isNotBlank((CharSequence)targetValue)) {
                return Integer.valueOf(targetValue);
            }
        }
        catch (NumberFormatException e) {
            LOGGER.warn("Cannot parse the target value {}", (Object)targetValue);
        }
        return null;
    }
}

