/*
 * Decompiled with CFR 0.152.
 */
package org.bidib.wizard.mvc.loco.view;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Window;
import java.awt.event.WindowListener;
import javax.swing.JDialog;
import javax.swing.JFrame;
import org.bidib.wizard.api.locale.Resources;
import org.bidib.wizard.common.service.SettingsService;
import org.bidib.wizard.model.loco.LocoModel;
import org.bidib.wizard.mvc.common.view.RegisteredDialog;
import org.bidib.wizard.mvc.common.view.ViewCloseListener;
import org.bidib.wizard.mvc.loco.view.LocoView;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * Exception performing whole class analysis ignored.
 */
public class LocoDialog
extends JDialog
implements RegisteredDialog {
    private static final Logger LOGGER = LoggerFactory.getLogger(LocoDialog.class);
    private static final long serialVersionUID = 1L;
    private LocoView locoView;
    private final LocoModel locoModel;

    public LocoDialog(JFrame parent, LocoModel locoModel, SettingsService settingsService) {
        super(parent);
        this.locoModel = locoModel;
        this.setDefaultCloseOperation(2);
        if (locoModel.isCarControlEnabled()) {
            this.setTitle(Resources.getString(LocoView.class, (String)"title.car"));
        } else {
            this.setTitle(Resources.getString(LocoView.class, (String)"title.loco"));
        }
        this.addContentPanel(locoModel, settingsService);
        this.setLocationRelativeTo((Component)parent);
    }

    public static String prepareKey(Integer address) {
        if (address != null) {
            return LocoDialog.class.getSimpleName() + "-" + address;
        }
        return LocoDialog.class.getSimpleName() + "-";
    }

    public String getKey() {
        LOGGER.info("Prepare the key: {}", (Object)this.locoModel);
        Integer address = this.locoModel.getAddress();
        return LocoDialog.prepareKey((Integer)address);
    }

    public Window getWindow() {
        return this;
    }

    private void addContentPanel(LocoModel locoModel, SettingsService settingsService) {
        this.locoView = new LocoView(locoModel, settingsService);
        this.addWindowListener((WindowListener)new /* Unavailable Anonymous Inner Class!! */);
        this.getContentPane().setLayout(new BorderLayout());
        this.getContentPane().add((Component)this.locoView.getComponent(), "Center");
        this.pack();
        this.setMinimumSize(new Dimension(this.locoView.getComponent().getPreferredSize().width + 20, this.locoView.getComponent().getPreferredSize().height + 20));
        this.setVisible(true);
    }

    public void addViewCloseListener(ViewCloseListener listener) {
        this.locoView.addViewCloseListener(listener);
    }

    public void close(SettingsService settingsService) {
        LOGGER.info("The LocoView should be closed.");
        this.cleanup(settingsService);
        LOGGER.info("Cleanup has passed, set visible false.");
        this.setVisible(false);
    }

    private void cleanup(SettingsService settingsService) {
        LOGGER.info("The LocoDialog is disposed.");
        if (this.locoView != null) {
            this.locoView.cleanup(settingsService);
        }
    }
}

