/*
 * Decompiled with CFR 0.152.
 */
package org.bidib.wizard.mvc.stepcontrol.view;

import com.jgoodies.binding.value.ValueHolder;
import com.jgoodies.binding.value.ValueModel;
import com.jgoodies.forms.builder.FormBuilder;
import java.awt.Component;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeListener;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.LinkedList;
import java.util.List;
import java.util.Scanner;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import javax.swing.filechooser.FileFilter;
import javax.swing.filechooser.FileNameExtensionFilter;
import org.apache.commons.lang3.StringUtils;
import org.bidib.wizard.api.context.ApplicationContext;
import org.bidib.wizard.api.locale.Resources;
import org.bidib.wizard.api.script.ScriptCommand;
import org.bidib.wizard.api.script.ScriptEngineListener;
import org.bidib.wizard.api.script.ScriptStatus;
import org.bidib.wizard.api.script.Scripting;
import org.bidib.wizard.client.common.text.WizardComponentFactory;
import org.bidib.wizard.common.script.DefaultScriptContext;
import org.bidib.wizard.common.script.engine.ScriptEngine;
import org.bidib.wizard.common.script.switching.AccessoryScripting;
import org.bidib.wizard.common.service.SettingsService;
import org.bidib.wizard.nodescript.script.stepcontrol.StepControlScriptCommandFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ScriptPanel
implements ScriptEngineListener<AccessoryScripting> {
    private static final Logger LOGGER = LoggerFactory.getLogger(ScriptPanel.class);
    private static String scriptDescription;
    private static final String WORKING_DIR_STEP_CONTROL_KEY = "stepControl";
    private static final String SCRIPT_EXTENSION = "bidibt";
    private static FileFilter scriptFilter;
    private ValueModel selectedScriptModel = new ValueHolder();
    private ValueModel currentCommandModel = new ValueHolder();
    private JButton startScript;
    private JButton stopScript;
    private AccessoryScripting scripting;
    private ScriptEngine<AccessoryScripting> scriptEngine;
    private ValueModel checkRepeatingModel = new ValueHolder();
    private AtomicBoolean scriptRepeating = new AtomicBoolean(false);
    private JPanel contentPanel;
    private final SettingsService settingsService;
    private static final Charset ENCODING;

    public ScriptPanel(AccessoryScripting scripting, SettingsService settingsService) {
        this.scripting = scripting;
        this.settingsService = settingsService;
        scriptDescription = Resources.getString(ScriptPanel.class, (String)"scriptDescription");
        scriptFilter = new FileNameExtensionFilter(scriptDescription, SCRIPT_EXTENSION);
    }

    public JPanel createPanel() {
        this.scriptEngine = new ScriptEngine((Scripting)this.scripting, (ApplicationContext)new DefaultScriptContext());
        this.scriptEngine.addScriptEngineListener((ScriptEngineListener)this);
        this.checkRepeatingModel.setValue((Object)this.scriptRepeating.get());
        FormBuilder formBuilder = FormBuilder.create().columns("60dlu, 3dlu, 60dlu, 3dlu, 0dlu:grow", new Object[0]).rows("p, 3dlu, p, 3dlu, p", new Object[0]);
        JButton selectScript = new JButton(Resources.getString(ScriptPanel.class, (String)"selectScript"));
        selectScript.addActionListener((ActionListener)new /* Unavailable Anonymous Inner Class!! */);
        formBuilder.add((Component)selectScript).xy(1, 1);
        JLabel scriptLabel = WizardComponentFactory.createLabel((ValueModel)this.selectedScriptModel);
        formBuilder.add((Component)scriptLabel).xyw(3, 1, 3);
        JCheckBox repeatingCheck = WizardComponentFactory.createCheckBox((ValueModel)this.checkRepeatingModel, (String)Resources.getString(ScriptPanel.class, (String)"repeating"));
        formBuilder.add((Component)repeatingCheck).xyw(1, 3, 3);
        this.startScript = new JButton(Resources.getString(ScriptPanel.class, (String)"startScript"));
        this.startScript.setEnabled(false);
        this.startScript.addActionListener((ActionListener)new /* Unavailable Anonymous Inner Class!! */);
        formBuilder.add((Component)this.startScript).xy(1, 5);
        this.stopScript = new JButton(Resources.getString(ScriptPanel.class, (String)"stopScript"));
        this.stopScript.setEnabled(false);
        this.stopScript.addActionListener((ActionListener)new /* Unavailable Anonymous Inner Class!! */);
        formBuilder.add((Component)this.stopScript).xy(3, 5);
        JLabel currentCommandLabel = WizardComponentFactory.createLabel((ValueModel)this.currentCommandModel);
        formBuilder.add((Component)currentCommandLabel).xy(5, 5);
        this.checkRepeatingModel.addValueChangeListener((PropertyChangeListener)new /* Unavailable Anonymous Inner Class!! */);
        this.contentPanel = formBuilder.build();
        return this.contentPanel;
    }

    public void currentCommandChanged(ScriptCommand<AccessoryScripting> command) {
        if (SwingUtilities.isEventDispatchThread()) {
            this.currentCommandModel.setValue((Object)(command != null ? command.toString() : null));
        } else {
            try {
                SwingUtilities.invokeAndWait((Runnable)new /* Unavailable Anonymous Inner Class!! */);
            }
            catch (InterruptedException | InvocationTargetException e) {
                LOGGER.warn("Update current command failed.", (Throwable)e);
            }
        }
    }

    private void stopScript() {
        LOGGER.info("Stop the script.");
        this.scriptEngine.stopScript();
    }

    public void scriptStatusChanged(ScriptStatus scriptStatus) {
        LOGGER.info("The script status has changed: {}", (Object)scriptStatus);
        SwingUtilities.invokeLater((Runnable)new /* Unavailable Anonymous Inner Class!! */);
    }

    private void prepareScript(String fileName) throws IOException {
        Path fFilePath = Paths.get(fileName, new String[0]);
        StepControlScriptCommandFactory factory = new StepControlScriptCommandFactory();
        factory.registerCommands();
        LinkedList scriptCommands = new LinkedList();
        try (Scanner scanner = new Scanner(fFilePath, ENCODING.name());){
            while (scanner.hasNextLine()) {
                this.processLine(scanner.nextLine().trim(), factory, scriptCommands);
            }
        }
        LOGGER.info("Prepared list of commands: {}", scriptCommands);
        this.scriptEngine.setScriptCommands(scriptCommands);
    }

    private void processLine(String line, StepControlScriptCommandFactory factory, List<ScriptCommand<AccessoryScripting>> scriptCommands) {
        LOGGER.info("Process line: {}", (Object)line);
        if (line.startsWith("#") || StringUtils.isBlank((CharSequence)line)) {
            LOGGER.info("Skip comment or empty line.");
        } else {
            LOGGER.info("Current line: {}", (Object)line);
            ScriptCommand command = factory.parse(line);
            if (command != null) {
                scriptCommands.add((ScriptCommand<AccessoryScripting>)command);
            }
        }
    }

    public void close() {
        if (this.scriptEngine != null) {
            LOGGER.info("Release the scriptEngine.");
            this.scriptEngine.removeScriptEngineListener((ScriptEngineListener)this);
            this.scriptEngine = null;
        }
    }

    static {
        ENCODING = StandardCharsets.UTF_8;
    }
}

