package org.bidib.wizard.mvc.common.exception;

import org.bidib.wizard.api.model.NodeInterface;

/**
 * Thrown to signal that the requested node was not selected.
 */
public class NodeSelectionChangeException extends RuntimeException {

    private static final long serialVersionUID = 1L;

    private final NodeInterface node;

    public NodeSelectionChangeException(String message, final NodeInterface node) {
        super(message);
        this.node = node;
    }

    /**
     * @return the node that was not selected
     */
    public NodeInterface getNode() {
        return node;
    }
}
