package org.bidib.wizard.mvc.main.dockable;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Dimension;

import javax.swing.JFrame;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import javax.swing.UIManager;

import com.formdev.flatlaf.FlatDarkLaf;
import com.vlsolutions.swing.docking.DockingConstants;
import com.vlsolutions.swing.docking.DockingDesktop;
import com.vlsolutions.swing.toolbars.ToolBarContainer;

public class FrameTest extends JFrame {
    private MyTextEditor editorPanel;

    private MyTextEditor editorPanel2;

    // MyTree treePanel = new MyTree();
    //
    // MyGridOfButtons buttonGrid = new MyGridOfButtons();
    //
    // MyJTable tablePanel = new MyJTable();

    DockingDesktop desktop = new DockingDesktop();

    public FrameTest() {
        setDefaultCloseOperation(DISPOSE_ON_CLOSE);

        ToolBarContainer container = ToolBarContainer.createDefaultContainer(true, false, false, false);

        container.add(desktop, BorderLayout.CENTER);

        // toolbar container becomes the only one component
        getContentPane().add(container);

        // getContentPane().add(desktop); // desk becomes the only one component

        editorPanel = new MyTextEditor(1);

        desktop.addDockable(editorPanel);

        editorPanel2 = new MyTextEditor(2);
        desktop.split(editorPanel, editorPanel2, DockingConstants.SPLIT_LEFT);
        // desktop.addDockable(editorPanel2);
        // getContentPane().add(editorPanel, BorderLayout.CENTER);
        // getContentPane().add(treePanel, BorderLayout.WEST);
        // getContentPane().add(buttonGrid, BorderLayout.NORTH);
        // getContentPane().add(tablePanel, BorderLayout.EAST);

        final Timer t = new Timer(2000, evt -> {
            editorPanel.getDockKey().setNotification(true);
        });
        t.setRepeats(false);
        t.start();
    }

    public static void main(String[] args) {

        SwingUtilities.invokeLater(() -> {

            FlatDarkLaf.setup();

            UIManager.put("DockingDesktop.notificationColor", Color.red);
            // UIManager.put("DockViewTitleBar.disableCustomPaint", Boolean.TRUE);

            final FrameTest f = new FrameTest();
            f.pack();
            f.setPreferredSize(new Dimension(200, 200));
            f.setLocationRelativeTo(null);
            f.setVisible(true);
        });
    }

}
