package org.bidib.wizard.mvc.stepcontrol.view.excel;

import static org.assertj.core.api.Assertions.assertThat;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;

import org.apache.commons.io.FileUtils;
import org.bidib.jbidibc.messages.Node;
import org.bidib.wizard.api.model.NodeInterface;
import org.bidib.wizard.mvc.stepcontrol.view.excel.ExcelAspectReader.MotorData;
import org.junit.jupiter.api.Test;
import org.mockito.Mockito;

class ExcelAspectReaderTest {

    private static final String OUTPUT_TARGET_DIR = "target/excel-test/bidib";

    @Test
    void readAspects() {
        final InputStream excelFile =
            ExcelAspectReaderTest.class
                .getResourceAsStream(
                    "/org/bidib/wizard/mvc/stepcontrol/view/excel/Fleischmann_N-Drehscheibe_Thomas.xlsx");

        final ExcelAspectReader reader = new ExcelAspectReader();

        final List<ImportAspect> aspects = reader.readAspects(excelFile);

        assertThat(aspects).isNotEmpty();
        assertThat(aspects).hasSize(22);
    }

    @Test
    void writeAspects() throws IOException {

        final File exportFile = new File(OUTPUT_TARGET_DIR, "turntable-export.xlsx");
        FileUtils.createParentDirectories(exportFile);

        final Node coreNode = Mockito.mock(Node.class);
        Mockito.when(coreNode.hasStoredStrings()).thenReturn(false);

        NodeInterface node = Mockito.mock(NodeInterface.class);
        Mockito.when(node.getNode()).thenReturn(coreNode);
        Mockito.when(node.toString()).thenReturn("Test Node A");

        final List<ImportAspect> aspects = new ArrayList<>();
        aspects.add(new ImportAspect(0, 285, false));
        aspects.add(new ImportAspect(1, 818, true));
        aspects.add(new ImportAspect(2, 7218, false));
        aspects.add(new ImportAspect(3, 7752, false));

        final MotorData motorData = new MotorData(400, 64, 25600);

        final ExcelAspectReader reader = new ExcelAspectReader();
        reader.writeAspects(node, exportFile, aspects, motorData);
    }
}